/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.View;

public class PatternView
extends View
implements DocumentListener {
    protected AnimationPanel ja;
    protected JSplitPane jsp;
    protected JRadioButton rb_bp;
    protected JLabel bp_edited_icon;
    protected JRadioButton rb_jml;
    protected JTextArea ta;
    protected JButton compile;
    protected JButton revert;
    protected JLabel lab;
    protected boolean text_edited = false;

    public PatternView(Dimension dim) {
        this.makePanel(dim);
        this.updateButtons();
    }

    protected void makePanel(Dimension dim) {
        ImageIcon edited_icon;
        this.setLayout(new BorderLayout());
        this.ja = new AnimationPanel();
        this.ja.setPreferredSize(dim);
        this.ja.setMinimumSize(new Dimension(10, 10));
        JPanel controls = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        controls.setLayout(gb);
        JLabel lab_view = new JLabel(guistrings.getString("PatternView_heading"));
        gb.setConstraints(lab_view, JLFunc.constraints(21, 0, 0, new Insets(15, 4, 10, 0)));
        controls.add(lab_view);
        ButtonGroup bg = new ButtonGroup();
        JPanel bppanel = new JPanel();
        bppanel.setLayout(new FlowLayout(0, 0, 0));
        this.rb_bp = new JRadioButton(guistrings.getString("PatternView_rb1_default"));
        bg.add(this.rb_bp);
        bppanel.add(this.rb_bp);
        URL url = PatternView.class.getResource("/alert.png");
        if (url != null && (edited_icon = new ImageIcon(url)) != null) {
            ImageIcon edited_icon_scaled = new ImageIcon(edited_icon.getImage().getScaledInstance(22, 22, 4));
            this.bp_edited_icon = new JLabel(edited_icon_scaled);
            this.bp_edited_icon.setToolTipText(guistrings.getString("PatternView_alert"));
            bppanel.add(Box.createHorizontalStrut(10));
            bppanel.add(this.bp_edited_icon);
        }
        controls.add(bppanel);
        gb.setConstraints(bppanel, JLFunc.constraints(21, 0, 1, new Insets(0, 4, 0, 0)));
        this.rb_jml = new JRadioButton(guistrings.getString("PatternView_rb2"));
        bg.add(this.rb_jml);
        controls.add(this.rb_jml);
        gb.setConstraints(this.rb_jml, JLFunc.constraints(21, 0, 2, new Insets(0, 4, 0, 0)));
        this.ta = new JTextArea();
        JScrollPane jscroll = new JScrollPane(this.ta);
        jscroll.setPreferredSize(new Dimension(400, 1));
        jscroll.setVerticalScrollBarPolicy(22);
        jscroll.setHorizontalScrollBarPolicy(32);
        controls.add(jscroll);
        GridBagConstraints gbc = JLFunc.constraints(21, 0, 3, new Insets(15, 0, 0, 0));
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gb.setConstraints(jscroll, gbc);
        this.jsp = new JSplitPane(1, true, this.ja, controls);
        this.jsp.setResizeWeight(0.75);
        this.add((Component)this.jsp, "Center");
        JPanel lower = new JPanel();
        GridBagLayout gb2 = new GridBagLayout();
        lower.setLayout(gb2);
        this.compile = new JButton(guistrings.getString("PatternView_compile_button"));
        gb2.setConstraints(this.compile, JLFunc.constraints(21, 0, 0, new Insets(8, 8, 8, 0)));
        lower.add(this.compile);
        this.revert = new JButton(guistrings.getString("PatternView_revert_button"));
        gb2.setConstraints(this.revert, JLFunc.constraints(21, 1, 0, new Insets(8, 5, 8, 12)));
        lower.add(this.revert);
        this.lab = new JLabel(" ");
        GridBagConstraints gbc2 = JLFunc.constraints(21, 2, 0);
        gbc2.fill = 2;
        gbc2.weightx = 1.0;
        gb2.setConstraints(this.lab, gbc2);
        lower.add(this.lab);
        this.add((Component)lower, "Last");
        this.ta.getDocument().addDocumentListener(this);
        this.rb_bp.addActionListener(new ActionListener(this){
            final /* synthetic */ PatternView this$0;
            {
                PatternView patternView = this$0;
                Objects.requireNonNull(patternView);
                this.this$0 = patternView;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.this$0.reloadTextArea();
            }
        });
        this.rb_jml.addActionListener(new ActionListener(this){
            final /* synthetic */ PatternView this$0;
            {
                PatternView patternView = this$0;
                Objects.requireNonNull(patternView);
                this.this$0 = patternView;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.this$0.reloadTextArea();
            }
        });
        this.compile.addActionListener(new ActionListener(this){
            final /* synthetic */ PatternView this$0;
            {
                PatternView patternView = this$0;
                Objects.requireNonNull(patternView);
                this.this$0 = patternView;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.this$0.compilePattern();
            }
        });
        this.revert.addActionListener(new ActionListener(this){
            final /* synthetic */ PatternView this$0;
            {
                PatternView patternView = this$0;
                Objects.requireNonNull(patternView);
                this.this$0 = patternView;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.this$0.revertPattern();
            }
        });
    }

    protected void updateButtons() {
        if (this.ja != null && this.ja.writingGIF) {
            this.rb_bp.setEnabled(false);
            this.rb_jml.setEnabled(false);
            this.compile.setEnabled(false);
            this.revert.setEnabled(false);
            return;
        }
        JMLPattern pat = this.getPattern();
        if (pat == null) {
            this.rb_bp.setEnabled(false);
            if (this.bp_edited_icon != null) {
                this.bp_edited_icon.setVisible(false);
            }
            this.rb_jml.setEnabled(false);
        } else if (pat.getBasePatternNotation() == null || pat.getBasePatternConfig() == null) {
            this.rb_bp.setEnabled(false);
            if (this.bp_edited_icon != null) {
                this.bp_edited_icon.setVisible(false);
            }
            this.rb_jml.setEnabled(true);
            this.rb_jml.setSelected(true);
        } else {
            this.rb_bp.setEnabled(true);
            if (this.bp_edited_icon != null) {
                this.bp_edited_icon.setVisible(pat.isBasePatternEdited());
            }
            this.rb_jml.setEnabled(true);
        }
        if (this.rb_bp.isSelected()) {
            this.compile.setEnabled(pat != null && (pat.isBasePatternEdited() || this.text_edited));
            this.revert.setEnabled(this.text_edited);
        } else if (this.rb_jml.isSelected()) {
            this.compile.setEnabled(this.text_edited);
            this.revert.setEnabled(this.text_edited);
        }
    }

    protected void reloadTextArea() {
        if (this.rb_bp.isSelected()) {
            this.ta.setText(this.getPattern().getBasePatternConfig().replace(";", ";\n"));
        } else if (this.rb_jml.isSelected()) {
            this.ta.setText(this.getPattern().toString());
        }
        this.ta.setCaretPosition(0);
        this.lab.setText(" ");
        this.setTextEdited(false);
    }

    protected void setTextEdited(boolean edited) {
        if (this.text_edited != edited) {
            this.text_edited = edited;
            this.updateButtons();
        }
    }

    protected void compilePattern() {
        try {
            if (this.rb_bp.isSelected()) {
                String notation = this.getPattern().getBasePatternNotation();
                String config = this.ta.getText().replace("\n", "").trim();
                JMLPattern newpat = JMLPattern.fromBasePattern(notation, config);
                this.restartView(newpat, null);
                this.addToUndoList(newpat);
            } else if (this.rb_jml.isSelected()) {
                JMLPattern newpat = new JMLPattern(new StringReader(this.ta.getText()));
                this.restartView(newpat, null);
                this.addToUndoList(newpat);
            }
        }
        catch (JuggleExceptionUser jeu) {
            this.lab.setText(jeu.getMessage());
            this.setTextEdited(true);
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.handleFatalException(jei);
            this.setTextEdited(true);
        }
    }

    protected void revertPattern() {
        this.reloadTextArea();
    }

    @Override
    public void restartView(JMLPattern p, AnimationPrefs c) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.ja.restartJuggle(p, c);
        this.setAnimationPanelPreferredSize(this.getAnimationPrefs().getSize());
        if (p != null) {
            String notation = p.getBasePatternNotation();
            String template = guistrings.getString("PatternView_rb1");
            Object[] arg = new Object[]{notation == null ? "none set" : notation};
            this.rb_bp.setText(MessageFormat.format(template, arg));
            if (!this.rb_bp.isSelected() && !this.rb_jml.isSelected()) {
                if (notation == null) {
                    this.rb_jml.setSelected(true);
                } else {
                    this.rb_bp.setSelected(true);
                }
            }
            this.updateButtons();
            this.reloadTextArea();
            this.parent.setTitle(p.getTitle());
        }
    }

    @Override
    public void restartView() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.ja.restartJuggle();
    }

    @Override
    public Dimension getAnimationPanelSize() {
        return this.ja.getSize(new Dimension());
    }

    @Override
    public void setAnimationPanelPreferredSize(Dimension d) {
        this.ja.setPreferredSize(d);
        this.jsp.resetToPreferredSizes();
    }

    @Override
    public JMLPattern getPattern() {
        return this.ja.getPattern();
    }

    @Override
    public AnimationPrefs getAnimationPrefs() {
        return this.ja.getAnimationPrefs();
    }

    @Override
    public double getZoomLevel() {
        return this.ja.getZoomLevel();
    }

    @Override
    public void setZoomLevel(double z) {
        this.ja.setZoomLevel(z);
    }

    @Override
    public boolean isPaused() {
        return this.ja.isPaused();
    }

    @Override
    public void setPaused(boolean pause) {
        if (this.ja.message == null) {
            this.ja.setPaused(pause);
        }
    }

    @Override
    public void disposeView() {
        this.ja.disposeAnimation();
    }

    @Override
    public void writeGIF(File f) {
        this.ja.writingGIF = true;
        this.updateButtons();
        final boolean origpause = this.isPaused();
        this.setPaused(true);
        this.jsp.setEnabled(false);
        if (this.parent != null) {
            this.parent.setResizable(false);
        }
        Runnable cleanup = new Runnable(){
            final /* synthetic */ PatternView this$0;
            {
                PatternView patternView = this$0;
                Objects.requireNonNull(patternView);
                this.this$0 = patternView;
            }

            @Override
            public void run() {
                this.this$0.ja.writingGIF = false;
                this.this$0.setPaused(origpause);
                this.this$0.updateButtons();
                this.this$0.jsp.setEnabled(true);
                if (this.this$0.parent != null) {
                    this.this$0.parent.setResizable(true);
                }
            }
        };
        new View.GIFWriter(this, this.ja, f, cleanup);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setTextEdited(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setTextEdited(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setTextEdited(true);
    }
}

