/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.Objects;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.Mutator;
import jugglinglab.view.View;

public class SelectionView
extends View {
    protected static final int ROWS = 3;
    protected static final int COLUMNS = 3;
    protected static final int COUNT = 9;
    protected static final int CENTER = 4;
    protected AnimationPanel[] ja = new AnimationPanel[9];
    protected JLayeredPane layered;
    protected Mutator mutator;
    protected AnimationPrefs saved_prefs;

    public SelectionView(Dimension dim) {
        for (int i = 0; i < 9; ++i) {
            this.ja[i] = new AnimationPanel();
        }
        this.layered = this.makeLayeredPane(dim, this.makeAnimationGrid(), this.makeOverlay());
        this.mutator = new Mutator();
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        this.add(this.layered);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gb.setConstraints(this.layered, gbc);
        JPanel controls = this.mutator.getControlPanel();
        this.add(controls);
        gbc = new GridBagConstraints();
        gbc.anchor = 23;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gb.setConstraints(controls, gbc);
    }

    protected JPanel makeAnimationGrid() {
        JPanel grid = new JPanel(new GridLayout(3, 3));
        for (int i = 0; i < 9; ++i) {
            grid.add(this.ja[i]);
        }
        grid.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ SelectionView this$0;
            {
                SelectionView selectionView = this$0;
                Objects.requireNonNull(selectionView);
                this.this$0 = selectionView;
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                int num;
                Component c = me.getComponent();
                for (num = 0; num < 9 && c != this.this$0.ja[num]; ++num) {
                }
                if (num == 9) {
                    return;
                }
                try {
                    this.this$0.restartView(this.this$0.ja[num].getPattern(), null);
                    if (num != 4) {
                        this.this$0.addToUndoList(this.this$0.ja[4].getPattern());
                    }
                }
                catch (JuggleExceptionUser jeu) {
                    new ErrorDialog(this.this$0.parent, jeu.getMessage());
                }
                catch (JuggleExceptionInternal jei) {
                    ErrorDialog.handleFatalException(jei);
                }
            }
        });
        grid.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ SelectionView this$0;
            {
                SelectionView selectionView = this$0;
                Objects.requireNonNull(selectionView);
                this.this$0 = selectionView;
            }

            @Override
            public void mouseDragged(MouseEvent me) {
                int num;
                Component c = me.getComponent();
                for (num = 0; num < 9 && c != this.this$0.ja[num]; ++num) {
                }
                if (num == 9) {
                    return;
                }
                double[] ca = this.this$0.ja[num].getCameraAngle();
                for (int i = 0; i < 9; ++i) {
                    if (i == num) continue;
                    this.this$0.ja[i].setCameraAngle(ca);
                }
            }
        });
        grid.setOpaque(true);
        return grid;
    }

    protected JPanel makeOverlay() {
        JPanel overlay = new JPanel(this){
            final /* synthetic */ SelectionView this$0;
            {
                SelectionView selectionView = this$0;
                Objects.requireNonNull(selectionView);
                this.this$0 = selectionView;
            }

            @Override
            public void paintComponent(Graphics g) {
                Dimension d = this.getSize();
                int xleft = d.width * 1 / 3;
                int ytop = d.height * 1 / 3;
                int width = d.width / 3;
                int height = d.height / 3;
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f));
                g2.setColor(Color.lightGray);
                g2.drawRect(xleft, ytop, width, height);
                g2.dispose();
            }
        };
        overlay.setOpaque(false);
        return overlay;
    }

    protected JLayeredPane makeLayeredPane(Dimension d, final JPanel grid, final JPanel overlay) {
        final JLayeredPane layered = new JLayeredPane();
        layered.setLayout(null);
        layered.add((Component)grid, JLayeredPane.DEFAULT_LAYER);
        layered.add((Component)overlay, JLayeredPane.PALETTE_LAYER);
        layered.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ SelectionView this$0;
            {
                SelectionView selectionView = this$0;
                Objects.requireNonNull(selectionView);
                this.this$0 = selectionView;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension d = layered.getSize();
                grid.setBounds(0, 0, d.width, d.height);
                overlay.setBounds(0, 0, d.width, d.height);
                this.this$0.validate();
            }
        });
        int pref_width = 3 * d.width;
        int pref_height = 3 * d.height;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int max_width = screenSize.width - 300;
        int max_height = screenSize.height - 120;
        if (pref_width > max_width || pref_height > max_height) {
            double scale = Math.min((double)max_width / (double)pref_width, (double)max_height / (double)pref_height);
            pref_width = (int)(scale * (double)pref_width);
            pref_height = (int)(scale * (double)pref_height);
        }
        layered.setPreferredSize(new Dimension(pref_width, pref_height));
        grid.setBounds(0, 0, pref_width, pref_height);
        overlay.setBounds(0, 0, pref_width, pref_height);
        return layered;
    }

    @Override
    public void restartView(JMLPattern p, AnimationPrefs c) throws JuggleExceptionUser, JuggleExceptionInternal {
        AnimationPrefs newjc = null;
        if (c != null) {
            this.saved_prefs = c;
            newjc = new AnimationPrefs(c);
            newjc.startPause = false;
        }
        this.ja[4].restartJuggle(p, newjc);
        for (int i = 0; i < 9; ++i) {
            if (i == 4) continue;
            JMLPattern newp = p == null ? null : this.mutator.mutatePattern(p);
            this.ja[i].restartJuggle(newp, newjc);
        }
        this.setAnimationPanelPreferredSize(this.getAnimationPrefs().getSize());
        if (p != null) {
            this.parent.setTitle(p.getTitle());
        }
    }

    @Override
    public void restartView() throws JuggleExceptionUser, JuggleExceptionInternal {
        for (int i = 0; i < 9; ++i) {
            this.ja[i].restartJuggle();
        }
    }

    @Override
    public Dimension getAnimationPanelSize() {
        return this.ja[4].getSize(new Dimension());
    }

    @Override
    public void setAnimationPanelPreferredSize(Dimension d) {
        int width = 3 * d.width;
        int height = 3 * d.height;
        this.layered.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public JMLPattern getPattern() {
        return this.ja[4].getPattern();
    }

    @Override
    public AnimationPrefs getAnimationPrefs() {
        return this.saved_prefs;
    }

    @Override
    public double getZoomLevel() {
        return this.ja[4].getZoomLevel();
    }

    @Override
    public void setZoomLevel(double z) {
        for (int i = 0; i < 9; ++i) {
            this.ja[i].setZoomLevel(z);
        }
    }

    @Override
    public boolean isPaused() {
        return this.ja[4].isPaused();
    }

    @Override
    public void setPaused(boolean pause) {
        if (this.ja[4].message == null) {
            for (int i = 0; i < 9; ++i) {
                this.ja[i].setPaused(pause);
            }
        }
    }

    @Override
    public void disposeView() {
        for (int i = 0; i < 9; ++i) {
            this.ja[i].disposeAnimation();
        }
    }

    @Override
    public void writeGIF(File f) {
        for (int i = 0; i < 9; ++i) {
            this.ja[i].writingGIF = true;
        }
        final boolean origpause = this.isPaused();
        this.setPaused(true);
        if (this.parent != null) {
            this.parent.setResizable(false);
        }
        Runnable cleanup = new Runnable(){
            final /* synthetic */ SelectionView this$0;
            {
                SelectionView selectionView = this$0;
                Objects.requireNonNull(selectionView);
                this.this$0 = selectionView;
            }

            @Override
            public void run() {
                for (int i = 0; i < 9; ++i) {
                    this.this$0.ja[i].writingGIF = false;
                }
                this.this$0.setPaused(origpause);
                if (this.this$0.parent != null) {
                    this.this$0.parent.setResizable(true);
                }
            }
        };
        new View.GIFWriter(this, this.ja[4], f, cleanup);
    }
}

