/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.Animator;
import jugglinglab.core.PatternWindow;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public abstract class View
extends JPanel {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    public static final int VIEW_NONE = 0;
    public static final int VIEW_SIMPLE = 1;
    public static final int VIEW_EDIT = 2;
    public static final int VIEW_PATTERN = 3;
    public static final int VIEW_SELECTION = 4;
    public static final String[] viewNames = new String[]{"simple", "visual_editor", "pattern_editor", "selection_editor"};
    protected PatternWindow parent;
    protected ArrayList<JMLPattern> undo;
    protected int undo_index;

    public void setParent(PatternWindow p) {
        this.parent = p;
    }

    public int getHashCode() {
        JMLPattern pat = this.getPattern();
        return pat == null ? 0 : pat.getHashCode();
    }

    public void setUndoList(ArrayList<JMLPattern> u, int u_index) {
        this.undo = u;
        this.undo_index = u_index;
    }

    public void addToUndoList(JMLPattern p) {
        try {
            JMLPattern pcopy = new JMLPattern(p);
            ++this.undo_index;
            this.undo.add(this.undo_index, pcopy);
            while (this.undo_index + 1 < this.undo.size()) {
                this.undo.remove(this.undo_index + 1);
            }
            if (this.parent != null) {
                this.parent.updateUndoMenu();
            }
        }
        catch (JuggleExceptionUser jeu) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal(jeu.getMessage()));
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.handleFatalException(jei);
        }
    }

    public void undoEdit() throws JuggleExceptionInternal {
        if (this.undo_index > 0) {
            try {
                --this.undo_index;
                JMLPattern pcopy = new JMLPattern(this.undo.get(this.undo_index));
                this.restartView(pcopy, null);
                if ((this.undo_index == 0 || this.undo_index == this.undo.size() - 2) && this.parent != null) {
                    this.parent.updateUndoMenu();
                }
            }
            catch (JuggleExceptionUser jeu) {
                throw new JuggleExceptionInternal(jeu.getMessage());
            }
        }
    }

    public void redoEdit() throws JuggleExceptionInternal {
        if (this.undo_index < this.undo.size() - 1) {
            try {
                ++this.undo_index;
                JMLPattern pcopy = new JMLPattern(this.undo.get(this.undo_index));
                this.restartView(pcopy, null);
                if ((this.undo_index == 1 || this.undo_index == this.undo.size() - 1) && this.parent != null) {
                    this.parent.updateUndoMenu();
                }
            }
            catch (JuggleExceptionUser jeu) {
                throw new JuggleExceptionInternal(jeu.getMessage());
            }
        }
    }

    public int getUndoIndex() {
        return this.undo_index;
    }

    public abstract void restartView(JMLPattern var1, AnimationPrefs var2) throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract void restartView() throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract Dimension getAnimationPanelSize();

    public abstract void setAnimationPanelPreferredSize(Dimension var1);

    public abstract JMLPattern getPattern();

    public abstract AnimationPrefs getAnimationPrefs();

    public abstract double getZoomLevel();

    public abstract void setZoomLevel(double var1);

    public abstract boolean isPaused();

    public abstract void setPaused(boolean var1);

    public abstract void disposeView();

    public abstract void writeGIF(File var1);

    protected class GIFWriter
    extends Thread {
        private AnimationPanel ap;
        private Runnable cleanup;
        private File file;
        private ProgressMonitor pm;
        private Animator.WriteGIFMonitor wgm;
        private double fps;
        final /* synthetic */ View this$0;

        public GIFWriter(View this$0, AnimationPanel animpanel, File f, Runnable cleanup_routine) {
            View view = this$0;
            Objects.requireNonNull(view);
            this.this$0 = view;
            this.ap = animpanel;
            this.file = f;
            this.cleanup = cleanup_routine;
            this.pm = new ProgressMonitor(this$0.parent, guistrings.getString("Saving_animated_GIF"), "", 0, 1);
            this.pm.setMillisToPopup(200);
            this.wgm = new Animator.WriteGIFMonitor(this){
                final /* synthetic */ GIFWriter this$1;
                {
                    GIFWriter gIFWriter = this$1;
                    Objects.requireNonNull(gIFWriter);
                    this.this$1 = gIFWriter;
                }

                @Override
                public void update(final int step, final int steps_total) {
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 1 this$2;
                        {
                            1 v0 = this$2;
                            Objects.requireNonNull(v0);
                            this.this$2 = v0;
                        }

                        @Override
                        public void run() {
                            this.this$2.this$1.pm.setMaximum(steps_total);
                            this.this$2.this$1.pm.setProgress(step);
                        }
                    });
                }

                @Override
                public boolean isCanceled() {
                    return this.this$1.pm.isCanceled() || GIFWriter.interrupted();
                }
            };
            AnimationPrefs jc = this.ap.getAnimationPrefs();
            this.fps = jc.fps == AnimationPrefs.FPS_DEF ? 33.3 : jc.fps;
            this.setPriority(1);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.ap.getAnimator().writeGIF(new FileOutputStream(this.file), this.wgm, this.fps);
            }
            catch (IOException ioe) {
                if (this.file != null) {
                    String template = errorstrings.getString("Error_writing_file");
                    Object[] arg = new Object[]{this.file.toString()};
                    new ErrorDialog(this.this$0.parent, MessageFormat.format(template, arg));
                } else {
                    ErrorDialog.handleFatalException(ioe);
                }
            }
            catch (JuggleExceptionInternal jei) {
                ErrorDialog.handleFatalException(jei);
            }
            finally {
                if (this.cleanup != null) {
                    SwingUtilities.invokeLater(this.cleanup);
                }
            }
        }
    }
}

