/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.linearsolver;

import com.google.ortools.linearsolver.mainJNI;

public class MPSolverParameters {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MPSolverParameters(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MPSolverParameters obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_MPSolverParameters(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static double getKDefaultRelativeMipGap() {
        return mainJNI.MPSolverParameters_kDefaultRelativeMipGap_get();
    }

    public static double getKDefaultPrimalTolerance() {
        return mainJNI.MPSolverParameters_kDefaultPrimalTolerance_get();
    }

    public static double getKDefaultDualTolerance() {
        return mainJNI.MPSolverParameters_kDefaultDualTolerance_get();
    }

    public static PresolveValues getKDefaultPresolve() {
        return PresolveValues.swigToEnum(mainJNI.MPSolverParameters_kDefaultPresolve_get());
    }

    public static IncrementalityValues getKDefaultIncrementality() {
        return IncrementalityValues.swigToEnum(mainJNI.MPSolverParameters_kDefaultIncrementality_get());
    }

    public MPSolverParameters() {
        this(mainJNI.new_MPSolverParameters(), true);
    }

    public void setDoubleParam(DoubleParam param, double value) {
        mainJNI.MPSolverParameters_setDoubleParam(this.swigCPtr, this, param.swigValue(), value);
    }

    public void setIntegerParam(IntegerParam param, int value) {
        mainJNI.MPSolverParameters_setIntegerParam(this.swigCPtr, this, param.swigValue(), value);
    }

    public double getDoubleParam(DoubleParam param) {
        return mainJNI.MPSolverParameters_getDoubleParam(this.swigCPtr, this, param.swigValue());
    }

    public int getIntegerParam(IntegerParam param) {
        return mainJNI.MPSolverParameters_getIntegerParam(this.swigCPtr, this, param.swigValue());
    }

    public static enum PresolveValues {
        PRESOLVE_OFF(mainJNI.MPSolverParameters_PRESOLVE_OFF_get()),
        PRESOLVE_ON(mainJNI.MPSolverParameters_PRESOLVE_ON_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static PresolveValues swigToEnum(int swigValue) {
            PresolveValues[] swigValues = (PresolveValues[])PresolveValues.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (PresolveValues swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + PresolveValues.class + " with value " + swigValue);
        }

        private PresolveValues() {
            this.swigValue = SwigNext.next++;
        }

        private PresolveValues(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private PresolveValues(PresolveValues swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum IncrementalityValues {
        INCREMENTALITY_OFF(mainJNI.MPSolverParameters_INCREMENTALITY_OFF_get()),
        INCREMENTALITY_ON(mainJNI.MPSolverParameters_INCREMENTALITY_ON_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static IncrementalityValues swigToEnum(int swigValue) {
            IncrementalityValues[] swigValues = (IncrementalityValues[])IncrementalityValues.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (IncrementalityValues swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + IncrementalityValues.class + " with value " + swigValue);
        }

        private IncrementalityValues() {
            this.swigValue = SwigNext.next++;
        }

        private IncrementalityValues(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private IncrementalityValues(IncrementalityValues swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum DoubleParam {
        RELATIVE_MIP_GAP(mainJNI.MPSolverParameters_RELATIVE_MIP_GAP_get()),
        PRIMAL_TOLERANCE(mainJNI.MPSolverParameters_PRIMAL_TOLERANCE_get()),
        DUAL_TOLERANCE(mainJNI.MPSolverParameters_DUAL_TOLERANCE_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static DoubleParam swigToEnum(int swigValue) {
            DoubleParam[] swigValues = (DoubleParam[])DoubleParam.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (DoubleParam swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + DoubleParam.class + " with value " + swigValue);
        }

        private DoubleParam() {
            this.swigValue = SwigNext.next++;
        }

        private DoubleParam(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private DoubleParam(DoubleParam swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum IntegerParam {
        PRESOLVE(mainJNI.MPSolverParameters_PRESOLVE_get()),
        LP_ALGORITHM(mainJNI.MPSolverParameters_LP_ALGORITHM_get()),
        INCREMENTALITY(mainJNI.MPSolverParameters_INCREMENTALITY_get()),
        SCALING(mainJNI.MPSolverParameters_SCALING_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static IntegerParam swigToEnum(int swigValue) {
            IntegerParam[] swigValues = (IntegerParam[])IntegerParam.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (IntegerParam swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + IntegerParam.class + " with value " + swigValue);
        }

        private IntegerParam() {
            this.swigValue = SwigNext.next++;
        }

        private IntegerParam(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private IntegerParam(IntegerParam swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum ScalingValues {
        SCALING_OFF(mainJNI.MPSolverParameters_SCALING_OFF_get()),
        SCALING_ON(mainJNI.MPSolverParameters_SCALING_ON_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ScalingValues swigToEnum(int swigValue) {
            ScalingValues[] swigValues = (ScalingValues[])ScalingValues.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (ScalingValues swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + ScalingValues.class + " with value " + swigValue);
        }

        private ScalingValues() {
            this.swigValue = SwigNext.next++;
        }

        private ScalingValues(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private ScalingValues(ScalingValues swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum LpAlgorithmValues {
        DUAL(mainJNI.MPSolverParameters_DUAL_get()),
        PRIMAL(mainJNI.MPSolverParameters_PRIMAL_get()),
        BARRIER(mainJNI.MPSolverParameters_BARRIER_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static LpAlgorithmValues swigToEnum(int swigValue) {
            LpAlgorithmValues[] swigValues = (LpAlgorithmValues[])LpAlgorithmValues.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (LpAlgorithmValues swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + LpAlgorithmValues.class + " with value " + swigValue);
        }

        private LpAlgorithmValues() {
            this.swigValue = SwigNext.next++;
        }

        private LpAlgorithmValues(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private LpAlgorithmValues(LpAlgorithmValues swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

