/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.modelbuilder;

import com.google.ortools.modelbuilder.AffineExpression;
import com.google.ortools.modelbuilder.ConstantExpression;
import com.google.ortools.modelbuilder.LinearArgument;
import com.google.ortools.modelbuilder.LinearExpr;
import com.google.ortools.modelbuilder.WeightedSumExpression;
import java.util.Map;
import java.util.TreeMap;

public final class LinearExprBuilder
implements LinearArgument {
    private final TreeMap<Integer, Double> coefficients = new TreeMap();
    private double offset = 0.0;

    LinearExprBuilder() {
    }

    public LinearExprBuilder add(LinearArgument expr) {
        this.addTerm(expr, 1.0);
        return this;
    }

    public LinearExprBuilder add(double constant) {
        this.offset += constant;
        return this;
    }

    public LinearExprBuilder addTerm(LinearArgument expr, double coeff) {
        LinearExpr e = expr.build();
        int numElements = e.numElements();
        for (int i2 = 0; i2 < numElements; ++i2) {
            this.coefficients.merge(e.getVariableIndex(i2), e.getCoefficient(i2) * coeff, Double::sum);
        }
        this.offset += e.getOffset() * coeff;
        return this;
    }

    public LinearExprBuilder addSum(LinearArgument[] exprs) {
        for (LinearArgument expr : exprs) {
            this.addTerm(expr, 1.0);
        }
        return this;
    }

    public LinearExprBuilder addWeightedSum(LinearArgument[] exprs, double[] coeffs) {
        for (int i2 = 0; i2 < exprs.length; ++i2) {
            this.addTerm(exprs[i2], coeffs[i2]);
        }
        return this;
    }

    public LinearExprBuilder addWeightedSum(LinearArgument[] exprs, int[] coeffs) {
        for (int i2 = 0; i2 < exprs.length; ++i2) {
            this.addTerm(exprs[i2], coeffs[i2]);
        }
        return this;
    }

    public LinearExprBuilder addWeightedSum(LinearArgument[] exprs, long[] coeffs) {
        for (int i2 = 0; i2 < exprs.length; ++i2) {
            this.addTerm(exprs[i2], coeffs[i2]);
        }
        return this;
    }

    @Override
    public LinearExpr build() {
        int numElements = 0;
        int lastVarIndex = -1;
        double lastCoeff = 0.0;
        for (Map.Entry<Integer, Double> entry : this.coefficients.entrySet()) {
            if (entry.getValue() == 0.0) continue;
            ++numElements;
            lastVarIndex = entry.getKey();
            lastCoeff = entry.getValue();
        }
        if (numElements == 0) {
            return new ConstantExpression(this.offset);
        }
        if (numElements == 1) {
            return new AffineExpression(lastVarIndex, lastCoeff, this.offset);
        }
        int[] varIndices = new int[numElements];
        double[] coeffs = new double[numElements];
        int index = 0;
        for (Map.Entry<Integer, Double> entry : this.coefficients.entrySet()) {
            if (entry.getValue() == 0.0) continue;
            varIndices[index] = entry.getKey();
            coeffs[index] = entry.getValue();
            ++index;
        }
        return new WeightedSumExpression(varIndices, coeffs, this.offset);
    }
}

