/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.modelbuilder;

import com.google.ortools.modelbuilder.LinearConstraint;
import com.google.ortools.modelbuilder.ModelBuilder;
import com.google.ortools.modelbuilder.ModelSolverHelper;
import com.google.ortools.modelbuilder.SolveStatus;
import com.google.ortools.modelbuilder.Variable;
import java.time.Duration;
import java.util.function.Consumer;

public final class ModelSolver {
    private final ModelSolverHelper helper;
    private Consumer<String> logCallback;

    public ModelSolver(String solverName) {
        this.helper = new ModelSolverHelper(solverName);
        this.logCallback = null;
    }

    public SolveStatus solve(ModelBuilder model) {
        if (this.logCallback == null) {
            this.helper.clearLogCallback();
        } else {
            this.helper.setLogCallback(this.logCallback);
        }
        this.helper.solve(model.getHelper());
        if (!this.helper.hasResponse()) {
            return SolveStatus.UNKNOWN_STATUS;
        }
        return this.helper.getStatus();
    }

    public void enableOutput(boolean enable) {
        this.helper.enableOutput(enable);
    }

    public void setTimeLimit(Duration limit) {
        this.helper.setTimeLimitInSeconds((double)limit.toMillis() / 1000.0);
    }

    public void setSolverSpecificParameters(String parameters) {
        this.helper.setSolverSpecificParameters(parameters);
    }

    public boolean solverIsSupported() {
        return this.helper.solverIsSupported();
    }

    public boolean interruptSolve() {
        return this.helper.interruptSolve();
    }

    public boolean hasResponse() {
        return this.helper.hasResponse();
    }

    public boolean hasSolution() {
        return this.helper.hasSolution();
    }

    public double getObjectiveValue() {
        if (!this.helper.hasSolution()) {
            throw new ModelSolverException("ModelSolver.getObjectiveValue()", "solve() was not called or no solution was found");
        }
        return this.helper.getObjectiveValue();
    }

    public double getBestObjectiveBound() {
        if (!this.helper.hasSolution()) {
            throw new ModelSolverException("ModelSolver.getBestObjectiveBound()", "solve() was not called or no solution was found");
        }
        return this.helper.getBestObjectiveBound();
    }

    public double getValue(Variable var) {
        if (!this.helper.hasSolution()) {
            throw new ModelSolverException("ModelSolver.getValue())", "solve() was not called or no solution was found");
        }
        return this.helper.getVariableValue(var.getIndex());
    }

    public double getReducedCost(Variable var) {
        if (!this.helper.hasSolution()) {
            throw new ModelSolverException("ModelSolver.getReducedCost())", "solve() was not called or no solution was found");
        }
        return this.helper.getReducedCost(var.getIndex());
    }

    public double getDualValue(LinearConstraint ct) {
        if (!this.helper.hasSolution()) {
            throw new ModelSolverException("ModelSolver.getDualValue())", "solve() was not called or no solution was found");
        }
        return this.helper.getDualValue(ct.getIndex());
    }

    public void setLogCallback(Consumer<String> cb) {
        this.logCallback = cb;
    }

    public double getWallTime() {
        return this.helper.getWallTime();
    }

    public double getUserTime() {
        return this.helper.getUserTime();
    }

    static class ModelSolverException
    extends RuntimeException {
        public ModelSolverException(String methodName, String msg) {
            super(methodName + ": " + msg);
        }
    }
}

