/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.Constraint;
import com.google.ortools.sat.CpModel;
import com.google.ortools.sat.CumulativeConstraintProto;
import com.google.ortools.sat.IntervalVar;
import com.google.ortools.sat.LinearArgument;

public class CumulativeConstraint
extends Constraint {
    private final CpModel model;

    public CumulativeConstraint(CpModel model) {
        super(model.getBuilder());
        this.model = model;
    }

    public CumulativeConstraint addDemand(IntervalVar interval, LinearArgument demand) {
        CumulativeConstraintProto.Builder cumul = this.getBuilder().getCumulativeBuilder();
        cumul.addIntervals(interval.getIndex());
        cumul.addDemands(this.model.getLinearExpressionProtoBuilderFromLinearArgument(demand, false));
        return this;
    }

    public CumulativeConstraint addDemand(IntervalVar interval, long demand) {
        CumulativeConstraintProto.Builder cumul = this.getBuilder().getCumulativeBuilder();
        cumul.addIntervals(interval.getIndex());
        cumul.addDemands(this.model.getLinearExpressionProtoBuilderFromLong(demand));
        return this;
    }

    public CumulativeConstraint addDemands(IntervalVar[] intervals, LinearArgument[] demands) {
        if (intervals.length != demands.length) {
            throw new CpModel.MismatchedArrayLengths("CumulativeConstraint.addDemands", "intervals", "demands");
        }
        for (int i2 = 0; i2 < intervals.length; ++i2) {
            this.addDemand(intervals[i2], demands[i2]);
        }
        return this;
    }

    public CumulativeConstraint addDemands(IntervalVar[] intervals, long[] demands) {
        if (intervals.length != demands.length) {
            throw new CpModel.MismatchedArrayLengths("CumulativeConstraint.addDemands", "intervals", "demands");
        }
        for (int i2 = 0; i2 < intervals.length; ++i2) {
            this.addDemand(intervals[i2], demands[i2]);
        }
        return this;
    }

    public CumulativeConstraint addDemands(IntervalVar[] intervals, int[] demands) {
        if (intervals.length != demands.length) {
            throw new CpModel.MismatchedArrayLengths("CumulativeConstraint.addDemands", "intervals", "demands");
        }
        for (int i2 = 0; i2 < intervals.length; ++i2) {
            this.addDemand(intervals[i2], demands[i2]);
        }
        return this;
    }
}

