/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.AffineExpression;
import com.google.ortools.sat.ConstantExpression;
import com.google.ortools.sat.LinearArgument;
import com.google.ortools.sat.LinearExprBuilder;
import com.google.ortools.sat.LinearExpressionProto;
import com.google.ortools.sat.WeightedSumExpression;

public interface LinearExpr
extends LinearArgument {
    public int numElements();

    public int getVariableIndex(int var1);

    public long getCoefficient(int var1);

    public long getOffset();

    public static LinearExprBuilder newBuilder() {
        return new LinearExprBuilder();
    }

    public static LinearExpr constant(long value) {
        return LinearExpr.newBuilder().add(value).build();
    }

    public static LinearExpr term(LinearArgument expr, long coeff) {
        return LinearExpr.newBuilder().addTerm(expr, coeff).build();
    }

    public static LinearExpr affine(LinearArgument expr, long coeff, long offset) {
        return LinearExpr.newBuilder().addTerm(expr, coeff).add(offset).build();
    }

    public static LinearExpr sum(LinearArgument[] exprs) {
        return LinearExpr.newBuilder().addSum(exprs).build();
    }

    public static LinearExpr weightedSum(LinearArgument[] exprs, long[] coeffs) {
        return LinearExpr.newBuilder().addWeightedSum(exprs, coeffs).build();
    }

    public static LinearExpr rebuildFromLinearExpressionProto(LinearExpressionProto proto) {
        int numElements = proto.getVarsCount();
        if (numElements == 0) {
            return new ConstantExpression(proto.getOffset());
        }
        if (numElements == 1) {
            return new AffineExpression(proto.getVars(0), proto.getCoeffs(0), proto.getOffset());
        }
        int[] varsIndices = new int[numElements];
        long[] coeffs = new long[numElements];
        long offset = proto.getOffset();
        for (int i2 = 0; i2 < numElements; ++i2) {
            varsIndices[i2] = proto.getVars(i2);
            coeffs[i2] = proto.getCoeffs(i2);
        }
        return new WeightedSumExpression(varsIndices, coeffs, offset);
    }
}

