/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.Constraint;
import com.google.ortools.sat.CpModel;
import com.google.ortools.sat.LinearArgument;
import com.google.ortools.sat.LinearExpr;
import com.google.ortools.sat.Literal;
import com.google.ortools.sat.ReservoirConstraintProto;

public class ReservoirConstraint
extends Constraint {
    private final CpModel model;

    public ReservoirConstraint(CpModel model) {
        super(model.getBuilder());
        this.model = model;
    }

    public ReservoirConstraint addEvent(LinearArgument time, long levelChange) {
        ReservoirConstraintProto.Builder reservoir = this.getBuilder().getReservoirBuilder();
        reservoir.addTimeExprs(this.model.getLinearExpressionProtoBuilderFromLinearArgument(time, false));
        reservoir.addLevelChanges(levelChange);
        reservoir.addActiveLiterals(this.model.trueLiteral().getIndex());
        return this;
    }

    public ReservoirConstraint addEvent(long time, long levelChange) {
        ReservoirConstraintProto.Builder reservoir = this.getBuilder().getReservoirBuilder();
        reservoir.addTimeExprs(this.model.getLinearExpressionProtoBuilderFromLong(time));
        reservoir.addLevelChanges(levelChange);
        reservoir.addActiveLiterals(this.model.trueLiteral().getIndex());
        return this;
    }

    public ReservoirConstraint addOptionalEvent(LinearExpr time, long levelChange, Literal isActive) {
        ReservoirConstraintProto.Builder reservoir = this.getBuilder().getReservoirBuilder();
        reservoir.addTimeExprs(this.model.getLinearExpressionProtoBuilderFromLinearArgument(time, false));
        reservoir.addLevelChanges(levelChange);
        reservoir.addActiveLiterals(isActive.getIndex());
        return this;
    }

    public ReservoirConstraint addOptionalEvent(long time, long levelChange, Literal isActive) {
        ReservoirConstraintProto.Builder reservoir = this.getBuilder().getReservoirBuilder();
        reservoir.addTimeExprs(this.model.getLinearExpressionProtoBuilderFromLong(time));
        reservoir.addLevelChanges(levelChange);
        reservoir.addActiveLiterals(isActive.getIndex());
        return this;
    }
}

