/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.desktop.AboutEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.Animator;
import jugglinglab.core.ApplicationWindow;
import jugglinglab.core.PatternWindow;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.SiteswapGenerator;
import jugglinglab.generator.SiteswapTransitioner;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLParser;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPatternList;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.OpenFilesServer;
import jugglinglab.util.ParameterList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0015H\u0002J\u0012\u0010 \u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\u0016H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u0011H\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u001c\u0010%\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\u00112\b\u0010'\u001a\u0004\u0018\u00010$H\u0002J\u001c\u0010(\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\u00112\b\u0010'\u001a\u0004\u0018\u00010$H\u0002J\u001c\u0010)\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\u00112\b\u0010'\u001a\u0004\u0018\u00010$H\u0002J\n\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u001a\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020+2\b\u0010'\u001a\u0004\u0018\u00010$H\u0002J&\u0010.\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010+2\b\u0010&\u001a\u0004\u0018\u00010\u00112\b\u0010'\u001a\u0004\u0018\u00010$H\u0002J$\u0010/\u001a\u00020\u00182\u0006\u0010-\u001a\u00020+2\b\u0010&\u001a\u0004\u0018\u00010\u00112\b\u0010'\u001a\u0004\u0018\u00010$H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ljugglinglab/JugglingLab;", "", "<init>", "()V", "guistrings", "Ljava/util/ResourceBundle;", "getGuistrings", "()Ljava/util/ResourceBundle;", "errorstrings", "getErrorstrings", "isMacOS", "", "()Z", "isWindows", "isLinux", "isCLI", "baseDir", "Ljava/nio/file/Path;", "getBaseDir", "()Ljava/nio/file/Path;", "jlargs", "Ljava/util/ArrayList;", "", "main", "", "args", "", "([Ljava/lang/String;)V", "registerAboutHandler", "doOpen", "parseFilelist", "Ljava/io/File;", "doHelp", "firstarg", "parseOutpath", "parseAnimprefs", "Ljugglinglab/core/AnimationPrefs;", "doGen", "outpath", "jc", "doTrans", "doVerify", "parsePattern", "Ljugglinglab/jml/JMLPattern;", "doAnim", "pat", "doTogif", "doTojml", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nJugglingLab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JugglingLab.kt\njugglinglab/JugglingLab\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,660:1\n37#2:661\n36#2,3:662\n37#2:665\n36#2,3:666\n*S KotlinDebug\n*F\n+ 1 JugglingLab.kt\njugglinglab/JugglingLab\n*L\n394#1:661\n394#1:662,3\n415#1:665\n415#1:666,3\n*E\n"})
public final class JugglingLab {
    @NotNull
    public static final JugglingLab INSTANCE = new JugglingLab();
    @NotNull
    private static final ResourceBundle guistrings;
    @NotNull
    private static final ResourceBundle errorstrings;
    private static final boolean isMacOS;
    private static final boolean isWindows;
    private static final boolean isLinux;
    private static final boolean isCLI;
    @NotNull
    private static final Path baseDir;
    @NotNull
    private static ArrayList<String> jlargs;

    private JugglingLab() {
    }

    @NotNull
    public final ResourceBundle getGuistrings() {
        return guistrings;
    }

    @NotNull
    public final ResourceBundle getErrorstrings() {
        return errorstrings;
    }

    public final boolean isMacOS() {
        return isMacOS;
    }

    public final boolean isWindows() {
        return isWindows;
    }

    public final boolean isLinux() {
        return isLinux;
    }

    public final boolean isCLI() {
        return isCLI;
    }

    @NotNull
    public final Path getBaseDir() {
        return baseDir;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        boolean showHelp;
        boolean runApplication;
        Intrinsics.checkNotNullParameter(args, "args");
        if (isMacOS) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        jlargs.addAll((Collection<String>)CollectionsKt.mutableListOf(Arrays.copyOf(args, args.length)));
        boolean bl = runApplication = !((Collection)jlargs).isEmpty() ? Intrinsics.areEqual(jlargs.get(0), "start") : true;
        if (runApplication) {
            SwingUtilities.invokeLater(JugglingLab::main$lambda$0);
            return;
        }
        String string = jlargs.removeFirst();
        Intrinsics.checkNotNullExpressionValue(string, "removeFirst(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        String firstarg = string3;
        if (Intrinsics.areEqual(firstarg, "open")) {
            INSTANCE.doOpen();
            return;
        }
        if (!isCLI) {
            return;
        }
        String[] stringArray = new String[]{"gen", "trans", "verify", "anim", "togif", "tojml"};
        List<String> modes = CollectionsKt.mutableListOf(stringArray);
        boolean bl2 = showHelp = !modes.contains(firstarg);
        if (showHelp) {
            INSTANCE.doHelp(firstarg);
            return;
        }
        Path outpath = INSTANCE.parseOutpath();
        AnimationPrefs jc = INSTANCE.parseAnimprefs();
        if (Intrinsics.areEqual(firstarg, "gen")) {
            INSTANCE.doGen(outpath, jc);
            return;
        }
        if (Intrinsics.areEqual(firstarg, "trans")) {
            INSTANCE.doTrans(outpath, jc);
            return;
        }
        if (Intrinsics.areEqual(firstarg, "verify")) {
            INSTANCE.doVerify(outpath, jc);
            return;
        }
        JMLPattern jMLPattern = INSTANCE.parsePattern();
        if (jMLPattern == null) {
            return;
        }
        JMLPattern pat = jMLPattern;
        if (!((Collection)jlargs).isEmpty()) {
            System.setProperty("java.awt.headless", "true");
            String arglist = CollectionsKt.joinToString$default(jlargs, ", ", null, null, 0, null, null, 62, null);
            System.out.println((Object)("Error: Unrecognized input: " + arglist));
            return;
        }
        if (Intrinsics.areEqual(firstarg, "anim")) {
            INSTANCE.doAnim(pat, jc);
            return;
        }
        System.setProperty("java.awt.headless", "true");
        if (Intrinsics.areEqual(firstarg, "togif")) {
            INSTANCE.doTogif(pat, outpath, jc);
            return;
        }
        if (Intrinsics.areEqual(firstarg, "tojml")) {
            INSTANCE.doTojml(pat, outpath, jc);
            return;
        }
    }

    private final void registerAboutHandler() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        if (!Desktop.getDesktop().isSupported(Desktop.Action.APP_ABOUT)) {
            return;
        }
        Desktop.getDesktop().setAboutHandler(JugglingLab::registerAboutHandler$lambda$1);
    }

    private final void doOpen() {
        boolean noOpenFilesHandler;
        ArrayList<File> files = this.parseFilelist();
        if (files.isEmpty()) {
            return;
        }
        boolean bl = noOpenFilesHandler = !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.APP_OPEN_FILE);
        if (noOpenFilesHandler) {
            files.removeIf(arg_0 -> JugglingLab.doOpen$lambda$3(JugglingLab::doOpen$lambda$2, arg_0));
            if (files.isEmpty()) {
                System.setProperty("java.awt.headless", "true");
                return;
            }
        }
        SwingUtilities.invokeLater(() -> JugglingLab.doOpen$lambda$4(files));
    }

    private final ArrayList<File> parseFilelist() {
        ArrayList<File> files = new ArrayList<File>();
        Iterator<String> iterator2 = jlargs.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<String> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Path filepath;
            String filestr;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            String filestr2 = filestr;
            if (StringsKt.startsWith$default(filestr2, "\"", false, 2, null)) {
                String string = filestr2;
                int n = 1;
                int n2 = filestr2.length() - 1;
                String string2 = string.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                filestr2 = string2;
            }
            if (!(filepath = Paths.get(filestr2, new String[0])).isAbsolute()) {
                String[] stringArray = new String[]{filestr2};
                filepath = Paths.get(((Object)baseDir).toString(), stringArray);
            }
            files.add(filepath.toFile());
        }
        if (files.isEmpty()) {
            String output = "Error: Expected file path(s), none provided";
            if (isCLI) {
                System.setProperty("java.awt.headless", "true");
                System.out.println((Object)output);
            } else {
                ErrorDialog.INSTANCE.handleUserException(null, output);
            }
        }
        return files;
    }

    private final void doHelp(String firstarg) {
        System.setProperty("java.awt.headless", "true");
        String template = guistrings.getString("Version");
        Object[] objectArray = new Object[]{"1.6.7"};
        Object[] arg1 = objectArray;
        String string = MessageFormat.format(template, Arrays.copyOf(arg1, arg1.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        String output = "Juggling Lab " + string3 + "\n";
        template = guistrings.getString("Copyright_message");
        Object[] objectArray2 = new Object[]{"2025"};
        Object[] arg2 = objectArray2;
        output = output + MessageFormat.format(template, Arrays.copyOf(arg2, arg2.length)) + "\n";
        output = output + guistrings.getString("GPL_message") + "\n\n";
        output = output + guistrings.getString("CLI_help1");
        String examples = guistrings.getString("CLI_help2");
        if (isWindows) {
            CharSequence charSequence = examples;
            Intrinsics.checkNotNull(charSequence);
            charSequence = charSequence;
            Object object = "'";
            object = new Regex((String)object);
            String string4 = "\"";
            examples = ((Regex)object).replace(charSequence, string4);
        }
        output = output + examples;
        System.out.println((Object)output);
        if (firstarg != null && !Intrinsics.areEqual(firstarg, "help")) {
            System.out.println((Object)("\nUnrecognized option: " + firstarg));
        }
    }

    private final Path parseOutpath() {
        int n = ((Collection)jlargs).size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!StringsKt.equals(jlargs.get(i2), "-out", true)) continue;
            jlargs.remove(i2);
            if (i2 == jlargs.size()) {
                System.out.println((Object)"Warning: No output path specified after -out flag; ignoring");
                return null;
            }
            String string = jlargs.remove(i2);
            Intrinsics.checkNotNullExpressionValue(string, "removeAt(...)");
            String outpathString = string;
            Path outpath = Paths.get(outpathString, new String[0]);
            if (!outpath.isAbsolute()) {
                String[] stringArray = new String[]{outpathString};
                outpath = Paths.get(((Object)baseDir).toString(), stringArray);
            }
            return outpath;
        }
        return null;
    }

    private final AnimationPrefs parseAnimprefs() {
        int n = ((Collection)jlargs).size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!StringsKt.equals(jlargs.get(i2), "-prefs", true)) continue;
            jlargs.remove(i2);
            if (i2 == jlargs.size()) {
                System.out.println((Object)"Warning: Nothing specified after -prefs flag; ignoring");
                return null;
            }
            try {
                ParameterList pl = new ParameterList(jlargs.remove(i2));
                AnimationPrefs jc = new AnimationPrefs().fromParameters(pl);
                pl.errorIfParametersLeft();
                return jc;
            }
            catch (JuggleExceptionUser jeu) {
                System.out.println((Object)("Error in animator prefs: " + jeu.getMessage() + "; ignoring"));
                return null;
            }
        }
        return null;
    }

    private final void doGen(Path outpath, AnimationPrefs jc) {
        System.setProperty("java.awt.headless", "true");
        Collection $this$toTypedArray$iv = jlargs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] genargs = thisCollection$iv.toArray(new String[0]);
        try {
            PrintStream ps = System.out;
            if (outpath != null) {
                ps = new PrintStream(outpath.toFile());
            }
            PrintStream printStream = ps;
            Intrinsics.checkNotNull(printStream);
            SiteswapGenerator.Companion.runGeneratorCLI(genargs, new GeneratorTarget(printStream));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println((Object)("Error: Problem writing to file path " + outpath));
        }
        if (jc != null) {
            System.out.println((Object)"Note: Animator prefs not used in generator mode; ignored");
        }
    }

    private final void doTrans(Path outpath, AnimationPrefs jc) {
        System.setProperty("java.awt.headless", "true");
        Collection $this$toTypedArray$iv = jlargs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] transargs = thisCollection$iv.toArray(new String[0]);
        try {
            PrintStream ps = System.out;
            if (outpath != null) {
                ps = new PrintStream(outpath.toFile());
            }
            PrintStream printStream = ps;
            Intrinsics.checkNotNull(printStream);
            SiteswapTransitioner.Companion.runTransitionerCLI(transargs, new GeneratorTarget(printStream));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println((Object)("Error: Problem writing to file path " + outpath));
        }
        if (jc != null) {
            System.out.println((Object)"Note: Animator prefs not used in transitions mode; ignored");
        }
    }

    private final void doVerify(Path outpath, AnimationPrefs jc) {
        System.setProperty("java.awt.headless", "true");
        ArrayList<File> files = this.parseFilelist();
        if (files.isEmpty()) {
            return;
        }
        if (jc != null) {
            System.out.println((Object)"Note: Animator prefs not used in verify mode; ignored\n");
        }
        PrintStream ps = System.out;
        try {
            if (outpath != null) {
                ps = new PrintStream(outpath.toFile());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println((Object)("Error: Problem writing to file path " + outpath));
            return;
        }
        int errorCount = 0;
        int filesWithErrorsCount = 0;
        int filesCount = 0;
        int patternsCount = 0;
        Iterator<File> iterator2 = files.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<File> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            File file;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            ps.println("Verifying " + file.getAbsolutePath());
            ++filesCount;
            int errorCountCurrentFile = 0;
            JMLParser parser = new JMLParser();
            try {
                parser.parse(new FileReader(file));
            }
            catch (SAXException sAXException) {
                ps.println("   Error: Formatting error in JML file");
                ++errorCountCurrentFile;
            }
            catch (IOException iOException) {
                ps.println("   Error: Problem reading JML file");
                ++errorCountCurrentFile;
            }
            if (errorCountCurrentFile > 0) {
                errorCount += errorCountCurrentFile;
                ++filesWithErrorsCount;
                continue;
            }
            if (parser.getFileType() == 1) {
                Object pat;
                try {
                    ++patternsCount;
                    JMLNode jMLNode = parser.getTree();
                    Intrinsics.checkNotNull(jMLNode);
                    pat = new JMLPattern(jMLNode);
                    ((JMLPattern)pat).layoutPattern();
                    ps.println("   OK");
                    pat = Unit.INSTANCE;
                }
                catch (JuggleException je) {
                    ps.println("   Error creating pattern: " + je.getMessage());
                    pat = ++errorCountCurrentFile;
                }
            } else if (parser.getFileType() == 2) {
                JMLPatternList pl = null;
                try {
                    JMLNode jMLNode = parser.getTree();
                    Intrinsics.checkNotNull(jMLNode);
                    pl = new JMLPatternList(jMLNode);
                }
                catch (JuggleExceptionUser jeu) {
                    ps.println("   Error creating pattern list: " + jeu.getMessage());
                    ++errorCountCurrentFile;
                }
                if (errorCountCurrentFile > 0) {
                    errorCount += errorCountCurrentFile;
                    ++filesWithErrorsCount;
                    continue;
                }
                JMLPatternList jMLPatternList = pl;
                Intrinsics.checkNotNull(jMLPatternList);
                int n = jMLPatternList.getSize();
                for (int i2 = 0; i2 < n; ++i2) {
                    try {
                        JMLPattern pat = pl.getPatternForLine(i2);
                        if (pat == null) continue;
                        ++patternsCount;
                        pat.layoutPattern();
                        pl.getAnimationPrefsForLine(i2);
                        ps.println("   Pattern line " + (i2 + 1) + ": OK");
                        continue;
                    }
                    catch (JuggleException je) {
                        ps.println("   Pattern line " + (i2 + 1) + ": Error: " + je.getMessage());
                        ++errorCountCurrentFile;
                    }
                }
            } else {
                ps.println("   Error: File is not valid JML");
                ++errorCountCurrentFile;
            }
            if (errorCountCurrentFile <= 0) continue;
            errorCount += errorCountCurrentFile;
            ++filesWithErrorsCount;
        }
        ps.println();
        ps.println("Processed " + patternsCount + " patterns in " + filesCount + " files");
        if (errorCount == 0) {
            ps.println("   All files OK");
        } else {
            ps.println("   Files with errors: " + filesWithErrorsCount);
            ps.println("   Total errors found: " + errorCount);
        }
    }

    private final JMLPattern parsePattern() {
        if (jlargs.isEmpty()) {
            System.out.println((Object)"Error: Expected pattern input, none found");
            return null;
        }
        if (StringsKt.equals(jlargs.get(0), "-jml", true)) {
            jlargs.removeFirst();
            if (jlargs.isEmpty()) {
                System.out.println((Object)"Error: No input path specified after -jml flag");
                return null;
            }
            String string = jlargs.removeFirst();
            Intrinsics.checkNotNullExpressionValue(string, "removeFirst(...)");
            String inpathString = string;
            Path inpath = Paths.get(inpathString, new String[0]);
            if (!inpath.isAbsolute()) {
                String[] stringArray = new String[]{inpathString};
                inpath = Paths.get(((Object)baseDir).toString(), stringArray);
            }
            try {
                JMLParser parser = new JMLParser();
                parser.parse(new FileReader(inpath.toFile()));
                switch (parser.getFileType()) {
                    case 1: {
                        JMLNode jMLNode = parser.getTree();
                        Intrinsics.checkNotNull(jMLNode);
                        return new JMLPattern(jMLNode);
                    }
                    case 2: {
                        System.out.println((Object)"Error: JML file cannot be a pattern list");
                        break;
                    }
                    default: {
                        System.out.println((Object)"Error: File is not valid JML");
                        break;
                    }
                }
            }
            catch (JuggleExceptionUser jeu) {
                System.out.println((Object)("Error parsing JML: " + jeu.getMessage()));
            }
            catch (SAXException sAXException) {
                System.out.println((Object)"Error: Formatting error in JML file");
            }
            catch (IOException iOException) {
                System.out.println((Object)("Error: Problem reading JML file from path " + inpath));
            }
            return null;
        }
        try {
            String string = jlargs.removeFirst();
            Intrinsics.checkNotNullExpressionValue(string, "removeFirst(...)");
            String config = string;
            return JMLPattern.Companion.fromBasePattern("siteswap", config);
        }
        catch (JuggleExceptionUser jeu) {
            System.out.println((Object)("Error: " + jeu.getMessage()));
        }
        catch (JuggleExceptionInternal jei) {
            System.out.println((Object)("Internal Error: " + jei.getMessage()));
        }
        return null;
    }

    private final void doAnim(JMLPattern pat, AnimationPrefs jc) {
        SwingUtilities.invokeLater(() -> JugglingLab.doAnim$lambda$5(pat, jc));
    }

    private final void doTogif(JMLPattern pat, Path outpath, AnimationPrefs jc) {
        AnimationPrefs jc2 = jc;
        if (outpath == null) {
            System.out.println((Object)"Error: No output path specified for animated GIF");
            return;
        }
        try {
            Animator anim = new Animator();
            if (jc2 == null) {
                jc2 = anim.getAnimationPrefs();
                jc2.setFps(33.3);
            }
            anim.setDimension(new Dimension(jc2.getWidth(), jc2.getHeight()));
            anim.restartAnimator(pat, jc2);
            anim.writeGIF(new FileOutputStream(outpath.toFile()), null, jc2.getFps());
        }
        catch (JuggleExceptionUser jeu) {
            System.out.println((Object)("Error: " + jeu.getMessage()));
        }
        catch (JuggleExceptionInternal jei) {
            System.out.println((Object)("Internal Error: " + jei.getMessage()));
        }
        catch (IOException iOException) {
            System.out.println((Object)("Error: Problem writing GIF to path " + outpath));
        }
    }

    private final void doTojml(JMLPattern pat, Path outpath, AnimationPrefs jc) {
        if (outpath == null) {
            System.out.print((Object)pat.toString());
        } else {
            try {
                FileWriter fw = new FileWriter(outpath.toFile());
                pat.writeJML(fw, true, true);
                fw.close();
            }
            catch (IOException iOException) {
                System.out.println((Object)("Error: Problem writing JML to path " + outpath));
            }
        }
        if (jc != null) {
            System.out.println((Object)"Note: Animator prefs not used in jml output mode; ignored");
        }
    }

    private static final void main$lambda$0() {
        try {
            INSTANCE.registerAboutHandler();
            new ApplicationWindow("Juggling Lab");
        }
        catch (JuggleExceptionUser jeu) {
            ErrorDialog.INSTANCE.handleUserException(null, jeu.getMessage());
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.INSTANCE.handleFatalException(jei);
        }
    }

    private static final void registerAboutHandler$lambda$1(AboutEvent aboutEvent) {
        ApplicationWindow.Companion.showAboutBox();
    }

    private static final boolean doOpen$lambda$2(File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return OpenFilesServer.tryOpenFile(it);
    }

    private static final boolean doOpen$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void doOpen$lambda$4(ArrayList $files) {
        try {
            INSTANCE.registerAboutHandler();
            new ApplicationWindow("Juggling Lab");
            Iterator iterator2 = $files.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                File file = (File)e;
                try {
                    ApplicationWindow.Companion.openJMLFile(file);
                }
                catch (JuggleExceptionUser jeu) {
                    String template = errorstrings.getString("Error_reading_file");
                    Object[] objectArray = new Object[]{file.getName()};
                    Object[] arguments = objectArray;
                    String msg = MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)) + ":\n" + jeu.getMessage();
                    ErrorDialog.INSTANCE.handleUserException(null, msg);
                }
            }
        }
        catch (JuggleExceptionUser jeu) {
            ErrorDialog.INSTANCE.handleUserException(null, jeu.getMessage());
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.INSTANCE.handleFatalException(jei);
        }
    }

    private static final void doAnim$lambda$5(JMLPattern $pat, AnimationPrefs $jc) {
        INSTANCE.registerAboutHandler();
        new PatternWindow($pat.getTitle(), $pat, $jc);
        PatternWindow.Companion.setExitOnLastClose(true);
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("GUIStrings");
        Intrinsics.checkNotNullExpressionValue(resourceBundle, "getBundle(...)");
        guistrings = resourceBundle;
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("ErrorStrings");
        Intrinsics.checkNotNullExpressionValue(resourceBundle2, "getBundle(...)");
        errorstrings = resourceBundle2;
        jlargs = new ArrayList();
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        Locale locale2 = locale;
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        String osname = string3;
        isMacOS = StringsKt.startsWith$default(osname, "mac os x", false, 2, null);
        isWindows = StringsKt.startsWith$default(osname, "windows", false, 2, null);
        isLinux = StringsKt.startsWith$default(osname, "linux", false, 2, null);
        String workingDir = System.getenv("JL_WORKING_DIR");
        boolean bl = isCLI = workingDir != null;
        if (workingDir == null) {
            try {
                workingDir = Preferences.userRoot().node("Juggling Lab").get("base_dir", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (workingDir == null) {
            String isBundle = System.getProperty("JL_run_as_bundle");
            workingDir = isBundle != null && Intrinsics.areEqual(isBundle, "true") ? System.getProperty("user.home") : System.getProperty("user.dir");
        }
        Path path = Paths.get(workingDir, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        baseDir = path;
    }
}

