/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.Animator;
import jugglinglab.core.PatternWindow;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u0000 \u0087\u00012\u00020\u00012\u00020\u0002:\u0004\u0086\u0001\u0087\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010a\u001a\u00020bH\u0004J\b\u0010c\u001a\u00020bH\u0014J\u0006\u0010d\u001a\u00020bJ\u000e\u0010e\u001a\u00020\u00162\u0006\u0010f\u001a\u00020\\J\u0010\u0010g\u001a\u00020U2\u0006\u0010h\u001a\u00020UH\u0014J\u001c\u0010i\u001a\u00020b2\b\u0010j\u001a\u0004\u0018\u00010k2\b\u0010l\u001a\u0004\u0018\u00010\nH\u0016J\u0006\u0010i\u001a\u00020bJ\b\u0010m\u001a\u00020bH\u0016J\b\u0010n\u001a\u00020bH\u0004J\u0018\u0010x\u001a\u00020b2\u0006\u0010*\u001a\u00020+2\u0006\u0010y\u001a\u00020zH\u0004J\u0007\u0010\u0084\u0001\u001a\u00020bJ\u0011\u0010\u0085\u0001\u001a\u00020b2\u0006\u0010y\u001a\u00020zH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u001a\u0010\u001e\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u001a\u0010!\u001a\u00020\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0018\"\u0004\b)\u0010\u001aR\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u00100\u001a\u0004\u0018\u000101X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001c\u00106\u001a\u0004\u0018\u000101X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00103\"\u0004\b8\u00105R\u001a\u00109\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0018\"\u0004\b;\u0010\u001aR\u001a\u0010<\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0018\"\u0004\b>\u0010\u001aR\u001a\u0010?\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u0018\"\u0004\bA\u0010\u001aR\u001a\u0010B\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0018\"\u0004\bD\u0010\u001aR\u001a\u0010E\u001a\u00020FX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u001a\u0010K\u001a\u00020FX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010H\"\u0004\bM\u0010JR\u001a\u0010N\u001a\u00020FX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010H\"\u0004\bP\u0010JR\u001a\u0010Q\u001a\u00020FX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010H\"\u0004\bS\u0010JR\u001c\u0010T\u001a\u0004\u0018\u00010UX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR \u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R$\u0010p\u001a\u00020\u00162\u0006\u0010o\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bp\u0010\u0018\"\u0004\bq\u0010\u001aR$\u0010r\u001a\u00020\"2\u0006\u0010r\u001a\u00020\"8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bs\u0010$\"\u0004\bt\u0010&R$\u0010u\u001a\u00020U2\u0006\u0010h\u001a\u00020U8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bv\u0010W\"\u0004\bw\u0010YR\u0013\u0010{\u001a\u0004\u0018\u00010k8F\u00a2\u0006\u0006\u001a\u0004\b|\u0010}R\u0011\u0010~\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u007f\u0010\fR(\u0010\u0081\u0001\u001a\u00020\"2\u0007\u0010\u0080\u0001\u001a\u00020\"8V@VX\u0096\u000e\u00a2\u0006\u000e\u001a\u0005\b\u0082\u0001\u0010$\"\u0005\b\u0083\u0001\u0010&\u00a8\u0006\u0088\u0001"}, d2={"Ljugglinglab/core/AnimationPanel;", "Ljavax/swing/JPanel;", "Ljava/lang/Runnable;", "<init>", "()V", "animator", "Ljugglinglab/core/Animator;", "getAnimator", "()Ljugglinglab/core/Animator;", "jc", "Ljugglinglab/core/AnimationPrefs;", "getJc", "()Ljugglinglab/core/AnimationPrefs;", "setJc", "(Ljugglinglab/core/AnimationPrefs;)V", "engine", "Ljava/lang/Thread;", "getEngine", "()Ljava/lang/Thread;", "setEngine", "(Ljava/lang/Thread;)V", "engineRunning", "", "getEngineRunning", "()Z", "setEngineRunning", "(Z)V", "enginePaused", "getEnginePaused", "setEnginePaused", "engineAnimating", "getEngineAnimating", "setEngineAnimating", "simTime", "", "getSimTime", "()D", "setSimTime", "(D)V", "writingGIF", "getWritingGIF", "setWritingGIF", "message", "", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "catchclip", "Ljavax/sound/sampled/Clip;", "getCatchclip", "()Ljavax/sound/sampled/Clip;", "setCatchclip", "(Ljavax/sound/sampled/Clip;)V", "bounceclip", "getBounceclip", "setBounceclip", "waspaused", "getWaspaused", "setWaspaused", "outside", "getOutside", "setOutside", "outsideValid", "getOutsideValid", "setOutsideValid", "draggingCamera", "getDraggingCamera", "setDraggingCamera", "startx", "", "getStartx", "()I", "setStartx", "(I)V", "starty", "getStarty", "setStarty", "lastx", "getLastx", "setLastx", "lasty", "getLasty", "setLasty", "dragcamangle", "", "getDragcamangle", "()[D", "setDragcamangle", "([D)V", "attachments", "Ljava/util/ArrayList;", "Ljugglinglab/core/AnimationPanel$AnimationAttachment;", "getAttachments", "()Ljava/util/ArrayList;", "setAttachments", "(Ljava/util/ArrayList;)V", "loadAudioClips", "", "initHandlers", "removeAllAttachments", "addAnimationAttachment", "att", "snapCamera", "ca", "restartJuggle", "pat", "Ljugglinglab/jml/JMLPattern;", "newjc", "run", "killAnimationThread", "wanttopause", "isPaused", "setPaused", "time", "getTime", "setTime", "cameraAngle", "getCameraAngle", "setCameraAngle", "drawString", "g", "Ljava/awt/Graphics;", "pattern", "getPattern", "()Ljugglinglab/jml/JMLPattern;", "animationPrefs", "getAnimationPrefs", "z", "zoomLevel", "getZoomLevel", "setZoomLevel", "disposeAnimation", "paintComponent", "AnimationAttachment", "Companion", "jugglinglab"})
public class AnimationPanel
extends JPanel
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Animator animator = new Animator();
    @NotNull
    private AnimationPrefs jc = new AnimationPrefs();
    @Nullable
    private Thread engine;
    private boolean engineRunning;
    private boolean enginePaused;
    private boolean engineAnimating;
    private double simTime;
    private boolean writingGIF;
    @Nullable
    private String message;
    @Nullable
    private Clip catchclip;
    @Nullable
    private Clip bounceclip;
    private boolean waspaused;
    private boolean outside;
    private boolean outsideValid;
    private boolean draggingCamera;
    private int startx;
    private int starty;
    private int lastx;
    private int lasty;
    @Nullable
    private double[] dragcamangle;
    @NotNull
    private ArrayList<AnimationAttachment> attachments = new ArrayList();
    private static final double SNAPANGLE = Math.toRadians(8.0);

    public AnimationPanel() {
        this.setOpaque(true);
        this.loadAudioClips();
        this.initHandlers();
    }

    @NotNull
    public final Animator getAnimator() {
        return this.animator;
    }

    @NotNull
    protected final AnimationPrefs getJc() {
        return this.jc;
    }

    protected final void setJc(@NotNull AnimationPrefs animationPrefs) {
        Intrinsics.checkNotNullParameter(animationPrefs, "<set-?>");
        this.jc = animationPrefs;
    }

    @Nullable
    protected final Thread getEngine() {
        return this.engine;
    }

    protected final void setEngine(@Nullable Thread thread2) {
        this.engine = thread2;
    }

    protected final boolean getEngineRunning() {
        return this.engineRunning;
    }

    protected final void setEngineRunning(boolean bl) {
        this.engineRunning = bl;
    }

    protected final boolean getEnginePaused() {
        return this.enginePaused;
    }

    protected final void setEnginePaused(boolean bl) {
        this.enginePaused = bl;
    }

    public final boolean getEngineAnimating() {
        return this.engineAnimating;
    }

    public final void setEngineAnimating(boolean bl) {
        this.engineAnimating = bl;
    }

    protected final double getSimTime() {
        return this.simTime;
    }

    protected final void setSimTime(double d) {
        this.simTime = d;
    }

    public final boolean getWritingGIF() {
        return this.writingGIF;
    }

    public final void setWritingGIF(boolean bl) {
        this.writingGIF = bl;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(@Nullable String string) {
        this.message = string;
    }

    @Nullable
    protected final Clip getCatchclip() {
        return this.catchclip;
    }

    protected final void setCatchclip(@Nullable Clip clip) {
        this.catchclip = clip;
    }

    @Nullable
    protected final Clip getBounceclip() {
        return this.bounceclip;
    }

    protected final void setBounceclip(@Nullable Clip clip) {
        this.bounceclip = clip;
    }

    protected final boolean getWaspaused() {
        return this.waspaused;
    }

    protected final void setWaspaused(boolean bl) {
        this.waspaused = bl;
    }

    protected final boolean getOutside() {
        return this.outside;
    }

    protected final void setOutside(boolean bl) {
        this.outside = bl;
    }

    protected final boolean getOutsideValid() {
        return this.outsideValid;
    }

    protected final void setOutsideValid(boolean bl) {
        this.outsideValid = bl;
    }

    protected final boolean getDraggingCamera() {
        return this.draggingCamera;
    }

    protected final void setDraggingCamera(boolean bl) {
        this.draggingCamera = bl;
    }

    protected final int getStartx() {
        return this.startx;
    }

    protected final void setStartx(int n) {
        this.startx = n;
    }

    protected final int getStarty() {
        return this.starty;
    }

    protected final void setStarty(int n) {
        this.starty = n;
    }

    protected final int getLastx() {
        return this.lastx;
    }

    protected final void setLastx(int n) {
        this.lastx = n;
    }

    protected final int getLasty() {
        return this.lasty;
    }

    protected final void setLasty(int n) {
        this.lasty = n;
    }

    @Nullable
    protected final double[] getDragcamangle() {
        return this.dragcamangle;
    }

    protected final void setDragcamangle(@Nullable double[] dArray) {
        this.dragcamangle = dArray;
    }

    @NotNull
    protected final ArrayList<AnimationAttachment> getAttachments() {
        return this.attachments;
    }

    protected final void setAttachments(@NotNull ArrayList<AnimationAttachment> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.attachments = arrayList;
    }

    protected final void loadAudioClips() {
        DataLine.Info info;
        try {
            URL catchurl = AnimationPanel.class.getResource("/catch.au");
            AudioInputStream catchAudioIn = AudioSystem.getAudioInputStream(catchurl);
            info = new DataLine.Info(Clip.class, catchAudioIn.getFormat());
            Clip clip = this.catchclip = (Clip)AudioSystem.getLine(info);
            Intrinsics.checkNotNull(clip);
            clip.open(catchAudioIn);
        }
        catch (Exception exception) {
            this.catchclip = null;
        }
        try {
            URL bounceurl = AnimationPanel.class.getResource("/bounce.au");
            AudioInputStream bounceAudioIn = AudioSystem.getAudioInputStream(bounceurl);
            info = new DataLine.Info(Clip.class, bounceAudioIn.getFormat());
            Clip clip = this.bounceclip = (Clip)AudioSystem.getLine(info);
            Intrinsics.checkNotNull(clip);
            clip.open(bounceAudioIn);
        }
        catch (Exception exception) {
            this.bounceclip = null;
        }
    }

    protected void initHandlers() {
        this.addMouseListener(new MouseAdapter(this){
            private long lastpress;
            private long lastenter;
            final /* synthetic */ AnimationPanel this$0;
            {
                this.this$0 = $receiver;
                this.lastenter = 1L;
            }

            public final long getLastpress() {
                return this.lastpress;
            }

            public final void setLastpress(long l) {
                this.lastpress = l;
            }

            public final long getLastenter() {
                return this.lastenter;
            }

            public final void setLastenter(long l) {
                this.lastenter = l;
            }

            public void mousePressed(MouseEvent me) {
                Intrinsics.checkNotNullParameter(me, "me");
                this.lastpress = me.getWhen();
                if (this.this$0.getJc().getMousePause() && this.lastpress == this.lastenter) {
                    return;
                }
                if (!this.this$0.getEngineAnimating()) {
                    return;
                }
                if (this.this$0.getWritingGIF()) {
                    return;
                }
                this.this$0.setStartx(me.getX());
                this.this$0.setStarty(me.getY());
            }

            public void mouseReleased(MouseEvent me) {
                Intrinsics.checkNotNullParameter(me, "me");
                if (this.this$0.getJc().getMousePause() && this.lastpress == this.lastenter) {
                    return;
                }
                if (this.this$0.getWritingGIF()) {
                    return;
                }
                this.this$0.setDraggingCamera(false);
                if (!this.this$0.getEngineAnimating() && this.this$0.getEngine() != null) {
                    Thread thread2 = this.this$0.getEngine();
                    Intrinsics.checkNotNull(thread2);
                    if (thread2.isAlive()) {
                        this.this$0.setPaused(!this.this$0.getEnginePaused());
                        return;
                    }
                }
                if (me.getX() == this.this$0.getStartx() && me.getY() == this.this$0.getStarty() && this.this$0.getEngine() != null) {
                    Thread thread3 = this.this$0.getEngine();
                    Intrinsics.checkNotNull(thread3);
                    if (thread3.isAlive()) {
                        this.this$0.setPaused(!this.this$0.getEnginePaused());
                        this.this$0.getParent().dispatchEvent(me);
                    }
                }
                if (this.this$0.isPaused()) {
                    this.this$0.repaint();
                }
            }

            public void mouseEntered(MouseEvent me) {
                Intrinsics.checkNotNullParameter(me, "me");
                this.lastenter = me.getWhen();
                if (this.this$0.getJc().getMousePause() && !this.this$0.getWritingGIF()) {
                    this.this$0.setPaused(this.this$0.getWaspaused());
                }
                this.this$0.setOutside(false);
                this.this$0.setOutsideValid(true);
            }

            public void mouseExited(MouseEvent me) {
                if (this.this$0.getJc().getMousePause() && !this.this$0.getWritingGIF()) {
                    this.this$0.setWaspaused(this.this$0.isPaused());
                    this.this$0.setPaused(true);
                }
                this.this$0.setOutside(true);
                this.this$0.setOutsideValid(true);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ AnimationPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseDragged(MouseEvent me) {
                Intrinsics.checkNotNullParameter(me, "me");
                if (!this.this$0.getEngineAnimating()) {
                    return;
                }
                if (this.this$0.getWritingGIF()) {
                    return;
                }
                if (!this.this$0.getDraggingCamera()) {
                    this.this$0.setDraggingCamera(true);
                    this.this$0.setLastx(this.this$0.getStartx());
                    this.this$0.setLasty(this.this$0.getStarty());
                    this.this$0.setDragcamangle(this.this$0.getCameraAngle());
                }
                int xdelta = me.getX() - this.this$0.getLastx();
                int ydelta = me.getY() - this.this$0.getLasty();
                this.this$0.setLastx(me.getX());
                this.this$0.setLasty(me.getY());
                double[] dArray = this.this$0.getDragcamangle();
                Intrinsics.checkNotNull(dArray);
                double[] ca = dArray;
                ca[0] = ca[0] + (double)xdelta * 0.02;
                ca[1] = ca[1] - (double)ydelta * 0.02;
                if (ca[1] < Math.toRadians(1.0E-4)) {
                    ca[1] = Math.toRadians(1.0E-4);
                }
                if (ca[1] > Math.toRadians(179.9999)) {
                    ca[1] = Math.toRadians(179.9999);
                }
                while (ca[0] < 0.0) {
                    ca[0] = ca[0] + Math.toRadians(360.0);
                }
                while (ca[0] >= Math.toRadians(360.0)) {
                    ca[0] = ca[0] - Math.toRadians(360.0);
                }
                double[] snappedcamangle = this.this$0.snapCamera(ca);
                this.this$0.setCameraAngle(snappedcamangle);
                this.this$0.getParent().dispatchEvent(me);
                if (this.this$0.isPaused()) {
                    this.this$0.repaint();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(this){
            private boolean hasResized;
            final /* synthetic */ AnimationPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public final boolean getHasResized() {
                return this.hasResized;
            }

            public final void setHasResized(boolean bl) {
                this.hasResized = bl;
            }

            public void componentResized(ComponentEvent e) {
                if (!this.this$0.getEngineAnimating()) {
                    return;
                }
                if (this.this$0.getWritingGIF()) {
                    return;
                }
                Animator animator = this.this$0.getAnimator();
                Dimension dimension = this.this$0.getSize();
                Intrinsics.checkNotNullExpressionValue(dimension, "getSize(...)");
                animator.setDimension(dimension);
                this.this$0.repaint();
                Component comp2 = SwingUtilities.getRoot(this.this$0);
                if (comp2 instanceof PatternWindow && ((PatternWindow)comp2).isWindowMaximized()) {
                    return;
                }
                if (this.hasResized) {
                    AnimationPrefs animationPrefs = this.this$0.getJc();
                    Dimension dimension2 = this.this$0.getSize();
                    Intrinsics.checkNotNullExpressionValue(dimension2, "getSize(...)");
                    animationPrefs.setSize(dimension2);
                }
                this.hasResized = true;
            }
        });
    }

    public final void removeAllAttachments() {
        this.attachments.clear();
    }

    public final boolean addAnimationAttachment(@NotNull AnimationAttachment att) {
        Intrinsics.checkNotNullParameter(att, "att");
        return this.attachments.add(att);
    }

    @NotNull
    protected double[] snapCamera(@NotNull double[] ca) {
        Intrinsics.checkNotNullParameter(ca, "ca");
        double[] result = new double[]{ca[0], ca[1]};
        if (result[1] < SNAPANGLE) {
            result[1] = Math.toRadians(1.0E-4);
        } else if (AnimationPanel.anglediff(Math.toRadians(90.0) - result[1]) < SNAPANGLE) {
            result[1] = Math.toRadians(90.0);
        } else if (result[1] > Math.toRadians(180.0) - SNAPANGLE) {
            result[1] = Math.toRadians(179.9999);
        }
        JMLPattern jMLPattern = this.animator.getPat();
        Intrinsics.checkNotNull(jMLPattern);
        if (jMLPattern.getNumberOfJugglers() == 1) {
            double a;
            Intrinsics.checkNotNull(this.animator.getPat());
            for (a = -Math.toRadians((v24024).getJugglerAngle(1, this.getTime())); a < 0.0; a += Math.toRadians(360.0)) {
            }
            while (a >= Math.toRadians(360.0)) {
                a -= Math.toRadians(360.0);
            }
            if (AnimationPanel.anglediff(a - result[0]) < SNAPANGLE) {
                result[0] = a;
            } else if (AnimationPanel.anglediff(a + 1.5707963267948966 - result[0]) < SNAPANGLE) {
                result[0] = a + 1.5707963267948966;
            } else if (AnimationPanel.anglediff(a + Math.PI - result[0]) < SNAPANGLE) {
                result[0] = a + Math.PI;
            } else if (AnimationPanel.anglediff(a + 4.71238898038469 - result[0]) < SNAPANGLE) {
                result[0] = a + 4.71238898038469;
            }
        }
        return result;
    }

    public void restartJuggle(@Nullable JMLPattern pat, @Nullable AnimationPrefs newjc) throws JuggleExceptionUser, JuggleExceptionInternal {
        JMLPattern jMLPattern = pat;
        if (jMLPattern != null) {
            jMLPattern.layoutPattern();
        }
        this.killAnimationThread();
        if (newjc != null) {
            this.jc = newjc;
        }
        Dimension dimension = this.getSize();
        Intrinsics.checkNotNullExpressionValue(dimension, "getSize(...)");
        this.animator.setDimension(dimension);
        this.animator.restartAnimator(pat, newjc);
        this.setBackground(this.animator.getBackground());
        Thread thread2 = this.engine = new Thread(this);
        Intrinsics.checkNotNull(thread2);
        thread2.start();
    }

    public final void restartJuggle() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.restartJuggle(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setPriority(1);
        this.engineRunning = true;
        this.engineAnimating = false;
        if (this.jc.getMousePause()) {
            this.waspaused = this.jc.getStartPause();
        }
        try {
            if (this.jc.getStartPause()) {
                this.message = JugglingLab.INSTANCE.getGuistrings().getString("Message_click_to_start");
                this.repaint();
                this.enginePaused = true;
                while (this.enginePaused) {
                    AnimationPanel animationPanel = this;
                    synchronized (animationPanel) {
                        boolean bl = false;
                        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type java.lang.Object");
                        ((Object)this).wait();
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
            this.message = null;
            long realTimeStart = System.currentTimeMillis();
            long realTimeWait = 0L;
            double oldtime = 0.0;
            double newtime = 0.0;
            if (this.jc.getMousePause()) {
                if (this.outsideValid) {
                    this.setPaused(this.outside);
                } else {
                    this.setPaused(true);
                }
                this.waspaused = false;
            }
            this.engineAnimating = true;
            while (true) {
                JMLPattern jMLPattern = this.animator.getPat();
                Intrinsics.checkNotNull(jMLPattern);
                this.setTime(jMLPattern.getLoopStartTime());
                while (true) {
                    int n;
                    int path;
                    JMLPattern pattemp;
                    Object object;
                    double d = this.getTime();
                    JMLPattern jMLPattern2 = this.animator.getPat();
                    Intrinsics.checkNotNull(jMLPattern2);
                    if (!(d < jMLPattern2.getLoopEndTime() - 0.5 * this.animator.getSimIntervalSecs())) break;
                    this.repaint();
                    realTimeWait = this.animator.getRealIntervalMillis() - (System.currentTimeMillis() - realTimeStart);
                    if (realTimeWait > 0L) {
                        Thread.sleep(realTimeWait);
                    } else if (this.engine == null || Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    realTimeStart = System.currentTimeMillis();
                    while (this.enginePaused) {
                        AnimationPanel animationPanel = this;
                        synchronized (animationPanel) {
                            boolean bl = false;
                            Intrinsics.checkNotNull(this, "null cannot be cast to non-null type java.lang.Object");
                            ((Object)this).wait();
                            object = Unit.INSTANCE;
                        }
                    }
                    oldtime = this.getTime();
                    this.setTime(this.getTime() + this.animator.getSimIntervalSecs());
                    newtime = this.getTime();
                    if (this.jc.getCatchSound() && this.catchclip != null) {
                        Intrinsics.checkNotNull(this.animator.getPat());
                        object = pattemp;
                        synchronized (object) {
                            boolean $i$a$-synchronized-AnimationPanel$run$52 = false;
                            path = 1;
                            n = pattemp.getNumberOfPaths();
                            if (path <= n) {
                                while (true) {
                                    if (pattemp.getPathCatchVolume(path, oldtime, newtime) > 0.0) {
                                        SwingUtilities.invokeLater(() -> AnimationPanel.run$lambda$3$lambda$2(this));
                                    }
                                    if (path == n) break;
                                    ++path;
                                }
                            }
                            Unit $i$a$-synchronized-AnimationPanel$run$52 = Unit.INSTANCE;
                        }
                    }
                    if (!this.jc.getBounceSound() || this.bounceclip == null) continue;
                    Intrinsics.checkNotNull(this.animator.getPat());
                    object = pattemp;
                    synchronized (object) {
                        boolean bl = false;
                        path = 1;
                        n = pattemp.getNumberOfPaths();
                        if (path <= n) {
                            while (true) {
                                if (pattemp.getPathBounceVolume(path, oldtime, newtime) > 0.0) {
                                    SwingUtilities.invokeLater(() -> AnimationPanel.run$lambda$5$lambda$4(this));
                                }
                                if (path == n) break;
                                ++path;
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
                this.animator.advanceProps();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void killAnimationThread() {
        try {
            if (this.engine != null) {
                Thread thread2 = this.engine;
                Intrinsics.checkNotNull(thread2);
                if (thread2.isAlive()) {
                    Thread thread3 = this.engine;
                    Intrinsics.checkNotNull(thread3);
                    thread3.interrupt();
                    Thread thread4 = this.engine;
                    Intrinsics.checkNotNull(thread4);
                    thread4.join();
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.engine = null;
            this.engineRunning = false;
            this.enginePaused = false;
            this.engineAnimating = false;
            this.message = null;
        }
    }

    public final boolean isPaused() {
        return this.enginePaused;
    }

    public final synchronized void setPaused(boolean wanttopause) {
        if (this.enginePaused && !wanttopause) {
            Intrinsics.checkNotNull(this, "null cannot be cast to non-null type java.lang.Object");
            ((Object)this).notify();
        }
        this.enginePaused = wanttopause;
    }

    public final double getTime() {
        return this.simTime;
    }

    public final void setTime(double time) {
        this.simTime = time;
        Iterator<AnimationAttachment> iterator2 = this.attachments.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<AnimationAttachment> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            AnimationAttachment att;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            att.setTime(time);
        }
    }

    @NotNull
    public final double[] getCameraAngle() {
        return this.animator.getCameraAngle();
    }

    public final void setCameraAngle(@NotNull double[] ca) {
        Intrinsics.checkNotNullParameter(ca, "ca");
        this.animator.setCameraAngle(ca);
    }

    protected final void drawString(@NotNull String message, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(g, "g");
        FontMetrics fm = g.getFontMetrics();
        int messageWidth = fm.stringWidth(message);
        Dimension dim = this.getSize();
        int x = dim.width > messageWidth ? (dim.width - messageWidth) / 2 : 0;
        int y = (dim.height + fm.getHeight()) / 2;
        g.setColor(Color.white);
        g.fillRect(0, 0, dim.width, dim.height);
        g.setColor(Color.black);
        g.drawString(message, x, y);
    }

    @Nullable
    public final JMLPattern getPattern() {
        return this.animator.getPat();
    }

    @NotNull
    public final AnimationPrefs getAnimationPrefs() {
        return this.jc;
    }

    public double getZoomLevel() {
        return this.animator.getZoomLevel();
    }

    public void setZoomLevel(double z) {
        if (!this.writingGIF) {
            this.animator.setZoomLevel(z);
            this.repaint();
        }
    }

    public final void disposeAnimation() {
        this.killAnimationThread();
    }

    @Override
    public void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter(g, "g");
        if (this.message != null) {
            String string = this.message;
            Intrinsics.checkNotNull(string);
            this.drawString(string, g);
        } else if (this.engineRunning && !this.writingGIF) {
            try {
                this.animator.drawFrame(this.getTime(), g, this.draggingCamera, true);
            }
            catch (JuggleExceptionInternal jei) {
                this.killAnimationThread();
                ErrorDialog.INSTANCE.handleFatalException(jei);
            }
        }
    }

    private static final void run$lambda$3$lambda$2(AnimationPanel this$0) {
        Clip clip = this$0.catchclip;
        Intrinsics.checkNotNull(clip);
        if (clip.isActive()) {
            Clip clip2 = this$0.catchclip;
            Intrinsics.checkNotNull(clip2);
            clip2.stop();
        }
        Clip clip3 = this$0.catchclip;
        Intrinsics.checkNotNull(clip3);
        clip3.setFramePosition(0);
        Clip clip4 = this$0.catchclip;
        Intrinsics.checkNotNull(clip4);
        clip4.start();
    }

    private static final void run$lambda$5$lambda$4(AnimationPanel this$0) {
        Clip clip = this$0.bounceclip;
        Intrinsics.checkNotNull(clip);
        if (clip.isActive()) {
            Clip clip2 = this$0.bounceclip;
            Intrinsics.checkNotNull(clip2);
            clip2.stop();
        }
        Clip clip3 = this$0.bounceclip;
        Intrinsics.checkNotNull(clip3);
        clip3.setFramePosition(0);
        Clip clip4 = this$0.bounceclip;
        Intrinsics.checkNotNull(clip4);
        clip4.start();
    }

    @JvmStatic
    protected static final double anglediff(double delta) {
        return Companion.anglediff(delta);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\u0003H&\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Ljugglinglab/core/AnimationPanel$AnimationAttachment;", "", "setAnimationPanel", "", "animPanel", "Ljugglinglab/core/AnimationPanel;", "setTime", "t", "", "repaintAttachment", "jugglinglab"})
    public static interface AnimationAttachment {
        public void setAnimationPanel(@Nullable AnimationPanel var1);

        public void setTime(double var1);

        public void repaintAttachment();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ljugglinglab/core/AnimationPanel$Companion;", "", "<init>", "()V", "SNAPANGLE", "", "getSNAPANGLE", "()D", "anglediff", "delta", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public final double getSNAPANGLE() {
            return SNAPANGLE;
        }

        @JvmStatic
        protected final double anglediff(double delta) {
            double delta2;
            for (delta2 = delta; delta2 > Math.PI; delta2 -= Math.PI * 2) {
            }
            while (delta2 <= -Math.PI) {
                delta2 += Math.PI * 2;
            }
            return Math.abs(delta2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

