/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.jml.JMLPattern;
import jugglinglab.prop.Prop;
import jugglinglab.renderer.Renderer;
import jugglinglab.renderer.Renderer2D;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ]2\u00020\u0001:\u0002\\]B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u00052\b\u00102\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010?\u001a\u0002002\u0006\u0010@\u001a\u00020AJ&\u0010B\u001a\u0002002\u0006\u0010C\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020A2\u0006\u0010D\u001a\u00020E2\u0006\u0010?\u001a\u00020EJ\u0006\u0010F\u001a\u000200J\u0006\u0010G\u001a\u000200J\b\u0010M\u001a\u000200H\u0002J\b\u0010N\u001a\u000200H\u0002J \u0010V\u001a\u0002002\u0006\u0010W\u001a\u00020X2\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020\u001bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\"\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\u001a\u001a\u0004\u0018\u00010#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\u00020.2\u0006\u00103\u001a\u00020.8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u00106\"\u0004\b7\u00108R$\u0010:\u001a\u00020*2\u0006\u00109\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R$\u0010I\u001a\u00020\u001b2\u0006\u0010H\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bJ\u0010\u001e\"\u0004\bK\u0010LR\u0011\u0010O\u001a\u00020P8F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u0011\u0010S\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bT\u0010U\u00a8\u0006^"}, d2={"Ljugglinglab/core/Animator;", "", "<init>", "()V", "pat", "Ljugglinglab/jml/JMLPattern;", "getPat", "()Ljugglinglab/jml/JMLPattern;", "setPat", "(Ljugglinglab/jml/JMLPattern;)V", "jc", "Ljugglinglab/core/AnimationPrefs;", "ren1", "Ljugglinglab/renderer/Renderer;", "getRen1", "()Ljugglinglab/renderer/Renderer;", "setRen1", "(Ljugglinglab/renderer/Renderer;)V", "ren2", "getRen2", "setRen2", "overallMax", "Ljugglinglab/util/Coordinate;", "overallMin", "numFrames", "", "value", "", "simIntervalSecs", "getSimIntervalSecs", "()D", "", "realIntervalMillis", "getRealIntervalMillis", "()J", "", "animPropNum", "getAnimPropNum", "()[I", "invPathPerm", "Ljugglinglab/util/Permutation;", "camangle", "", "camangle1", "camangle2", "dim", "Ljava/awt/Dimension;", "restartAnimator", "", "newpat", "newjc", "d", "dimension", "getDimension", "()Ljava/awt/Dimension;", "setDimension", "(Ljava/awt/Dimension;)V", "ca", "cameraAngle", "getCameraAngle", "()[D", "setCameraAngle", "([D)V", "drawBackground", "g", "Ljava/awt/Graphics;", "drawFrame", "simTime", "drawAxes", "", "advanceProps", "initAnimator", "z", "zoomLevel", "getZoomLevel", "setZoomLevel", "(D)V", "findMaxMin", "syncRenderersToSize", "background", "Ljava/awt/Color;", "getBackground", "()Ljava/awt/Color;", "animationPrefs", "getAnimationPrefs", "()Ljugglinglab/core/AnimationPrefs;", "writeGIF", "os", "Ljava/io/OutputStream;", "wgm", "Ljugglinglab/core/Animator$WriteGIFMonitor;", "fps", "WriteGIFMonitor", "Companion", "jugglinglab"})
public final class Animator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private JMLPattern pat;
    @NotNull
    private AnimationPrefs jc = new AnimationPrefs();
    @Nullable
    private Renderer ren1;
    @Nullable
    private Renderer ren2;
    @Nullable
    private Coordinate overallMax;
    @Nullable
    private Coordinate overallMin;
    private int numFrames;
    private double simIntervalSecs;
    private long realIntervalMillis;
    @Nullable
    private int[] animPropNum;
    @Nullable
    private Permutation invPathPerm;
    @NotNull
    private double[] camangle = new double[2];
    @NotNull
    private double[] camangle1 = new double[2];
    @NotNull
    private double[] camangle2 = new double[2];
    @Nullable
    private Dimension dim;
    private static final double STEREO_SEPARATION_RADIANS = 0.1;

    @Nullable
    public final JMLPattern getPat() {
        return this.pat;
    }

    public final void setPat(@Nullable JMLPattern jMLPattern) {
        this.pat = jMLPattern;
    }

    @Nullable
    public final Renderer getRen1() {
        return this.ren1;
    }

    public final void setRen1(@Nullable Renderer renderer) {
        this.ren1 = renderer;
    }

    @Nullable
    public final Renderer getRen2() {
        return this.ren2;
    }

    public final void setRen2(@Nullable Renderer renderer) {
        this.ren2 = renderer;
    }

    public final double getSimIntervalSecs() {
        return this.simIntervalSecs;
    }

    public final long getRealIntervalMillis() {
        return this.realIntervalMillis;
    }

    @Nullable
    public final int[] getAnimPropNum() {
        return this.animPropNum;
    }

    public final void restartAnimator(@Nullable JMLPattern newpat, @Nullable AnimationPrefs newjc) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (newpat != null) {
            newpat.layoutPattern();
            this.pat = newpat;
        }
        if (newjc != null) {
            this.jc = newjc;
        }
        if (this.pat == null) {
            return;
        }
        Renderer renderer = this.ren1 = (Renderer)new Renderer2D();
        Intrinsics.checkNotNull(renderer);
        JMLPattern jMLPattern = this.pat;
        Intrinsics.checkNotNull(jMLPattern);
        renderer.setPattern(jMLPattern);
        if (this.jc.getStereo()) {
            Renderer renderer2 = this.ren2 = (Renderer)new Renderer2D();
            Intrinsics.checkNotNull(renderer2);
            JMLPattern jMLPattern2 = this.pat;
            Intrinsics.checkNotNull(jMLPattern2);
            renderer2.setPattern(jMLPattern2);
        } else {
            this.ren2 = null;
        }
        this.initAnimator();
        double[] ca = new double[2];
        if (this.jc.getCamangle() != null) {
            double[] dArray = this.jc.getCamangle();
            Intrinsics.checkNotNull(dArray);
            ca[0] = Math.toRadians(dArray[0]);
            double[] dArray2 = this.jc.getCamangle();
            Intrinsics.checkNotNull(dArray2);
            double theta = Math.min(179.9999, Math.max(1.0E-4, dArray2[1]));
            ca[1] = Math.toRadians(theta);
        } else {
            JMLPattern jMLPattern3 = this.pat;
            Intrinsics.checkNotNull(jMLPattern3);
            if (jMLPattern3.getNumberOfJugglers() == 1) {
                ca[0] = Math.toRadians(0.0);
                ca[1] = Math.toRadians(90.0);
            } else {
                ca[0] = Math.toRadians(340.0);
                ca[1] = Math.toRadians(70.0);
            }
        }
        this.setCameraAngle(ca);
    }

    @NotNull
    public final Dimension getDimension() {
        return new Dimension(this.dim);
    }

    public final void setDimension(@NotNull Dimension d) {
        Intrinsics.checkNotNullParameter(d, "d");
        this.dim = new Dimension(d);
        if (this.ren1 != null) {
            this.syncRenderersToSize();
        }
    }

    @NotNull
    public final double[] getCameraAngle() {
        double[] dArray = new double[]{this.camangle[0], this.camangle[1]};
        return dArray;
    }

    public final void setCameraAngle(@NotNull double[] ca) {
        Intrinsics.checkNotNullParameter(ca, "ca");
        while (ca[0] < 0.0) {
            ca[0] = ca[0] + Math.PI * 2;
        }
        while (ca[0] >= Math.PI * 2) {
            ca[0] = ca[0] - Math.PI * 2;
        }
        this.camangle[0] = ca[0];
        this.camangle[1] = ca[1];
        if (this.jc.getStereo()) {
            this.camangle1[0] = ca[0] - 0.05;
            this.camangle1[1] = ca[1];
            Renderer renderer = this.ren1;
            Intrinsics.checkNotNull(renderer);
            renderer.setCameraAngle(this.camangle1);
            this.camangle2[0] = ca[0] + 0.05;
            this.camangle2[1] = ca[1];
            Renderer renderer2 = this.ren2;
            Intrinsics.checkNotNull(renderer2);
            renderer2.setCameraAngle(this.camangle2);
        } else {
            this.camangle1[0] = ca[0];
            this.camangle1[1] = ca[1];
            Renderer renderer = this.ren1;
            Intrinsics.checkNotNull(renderer);
            renderer.setCameraAngle(this.camangle1);
        }
    }

    public final void drawBackground(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter(g, "g");
        Dimension dimension = this.dim;
        Intrinsics.checkNotNull(dimension);
        Dimension dimen = dimension;
        Renderer renderer = this.ren1;
        Intrinsics.checkNotNull(renderer);
        g.setColor(renderer.getBackground());
        g.fillRect(0, 0, dimen.width, dimen.height);
    }

    public final void drawFrame(double simTime, @NotNull Graphics g, boolean drawAxes, boolean drawBackground) throws JuggleExceptionInternal {
        Intrinsics.checkNotNullParameter(g, "g");
        if (drawBackground) {
            this.drawBackground(g);
        }
        if (this.jc.getStereo()) {
            Intrinsics.checkNotNull(this.animPropNum);
            int[] apn = this.animPropNum;
            Dimension dimension = this.dim;
            Intrinsics.checkNotNull(dimension);
            Dimension dimen = dimension;
            Renderer renderer = this.ren1;
            Intrinsics.checkNotNull(renderer);
            int[] nArray = this.jc.getHideJugglers();
            Graphics graphics = g.create(0, 0, dimen.width / 2, dimen.height);
            Intrinsics.checkNotNullExpressionValue(graphics, "create(...)");
            renderer.drawFrame(simTime, apn, nArray, graphics);
            Renderer renderer2 = this.ren2;
            Intrinsics.checkNotNull(renderer2);
            int[] nArray2 = this.jc.getHideJugglers();
            Graphics graphics2 = g.create(dimen.width / 2, 0, dimen.width / 2, dimen.height);
            Intrinsics.checkNotNullExpressionValue(graphics2, "create(...)");
            renderer2.drawFrame(simTime, apn, nArray2, graphics2);
        } else {
            Renderer renderer = this.ren1;
            Intrinsics.checkNotNull(renderer);
            Intrinsics.checkNotNull(this.animPropNum);
            renderer.drawFrame(simTime, this.animPropNum, this.jc.getHideJugglers(), g);
        }
        if (drawAxes) {
            int n;
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            int n2 = n = this.jc.getStereo() ? 2 : 1;
            for (int i2 = 0; i2 < n; ++i2) {
                Renderer ren;
                Intrinsics.checkNotNull(i2 == 0 ? this.ren1 : this.ren2);
                ren = ren;
                double[] ca = ren.getCameraAngle();
                double theta = ca[0];
                double phi = ca[1];
                double xya = 30.0;
                double xyb = xya * Math.cos(phi);
                double zlen = xya * Math.sin(phi);
                Dimension dimension = this.dim;
                Intrinsics.checkNotNull(dimension);
                int cx = 38 + i2 * (dimension.width / 2);
                int cy = 45;
                int xx = cx + (int)(0.5 - xya * Math.cos(theta));
                int xy = cy + (int)(0.5 + xyb * Math.sin(theta));
                int yx = cx + (int)(0.5 + xya * Math.sin(theta));
                int yy = cy + (int)(0.5 + xyb * Math.cos(theta));
                int zx = cx;
                int zy = cy - (int)(0.5 + zlen);
                g.setColor(Color.green);
                g.drawLine(cx, cy, xx, xy);
                g.drawLine(cx, cy, yx, yy);
                g.drawLine(cx, cy, zx, zy);
                g.fillOval(xx - 2, xy - 2, 5, 5);
                g.fillOval(yx - 2, yy - 2, 5, 5);
                g.fillOval(zx - 2, zy - 2, 5, 5);
                g.drawString("x", xx - 2, xy - 4);
                g.drawString("y", yx - 2, yy - 4);
                g.drawString("z", zx - 2, zy - 4);
            }
        }
    }

    public final void advanceProps() {
        JMLPattern jMLPattern = this.pat;
        Intrinsics.checkNotNull(jMLPattern);
        int paths = jMLPattern.getNumberOfPaths();
        int[] temppropnum = new int[paths];
        for (int i2 = 0; i2 < paths; ++i2) {
            Permutation permutation = this.invPathPerm;
            Intrinsics.checkNotNull(permutation);
            int n = permutation.getMapping(i2 + 1) - 1;
            Intrinsics.checkNotNull(this.animPropNum);
            temppropnum[n] = this.animPropNum[i2];
        }
        Intrinsics.checkNotNull(this.animPropNum);
        System.arraycopy(temppropnum, 0, this.animPropNum, 0, paths);
    }

    public final void initAnimator() {
        JMLPattern jMLPattern = this.pat;
        Intrinsics.checkNotNull(jMLPattern);
        JMLPattern pattern = jMLPattern;
        boolean sg = this.jc.getShowGround() == 1 || this.jc.getShowGround() == 0 && pattern.isBouncePattern();
        Renderer renderer = this.ren1;
        Intrinsics.checkNotNull(renderer);
        renderer.setGround(sg);
        if (this.jc.getStereo()) {
            Renderer renderer2 = this.ren2;
            Intrinsics.checkNotNull(renderer2);
            renderer2.setGround(sg);
        }
        this.findMaxMin();
        this.syncRenderersToSize();
        this.numFrames = (int)(0.5 + (pattern.getLoopEndTime() - pattern.getLoopStartTime()) * this.jc.getSlowdown() * this.jc.getFps());
        this.simIntervalSecs = (pattern.getLoopEndTime() - pattern.getLoopStartTime()) / (double)this.numFrames;
        this.realIntervalMillis = (long)(1000.0 * this.simIntervalSecs * this.jc.getSlowdown());
        this.animPropNum = new int[pattern.getNumberOfPaths()];
        int n = pattern.getNumberOfPaths();
        for (int i2 = 0; i2 < n; ++i2) {
            Intrinsics.checkNotNull(this.animPropNum);
            this.animPropNum[i2] = pattern.getPropAssignment(i2 + 1);
        }
        Permutation permutation = pattern.getPathPermutation();
        Intrinsics.checkNotNull(permutation);
        this.invPathPerm = permutation.getInverse();
    }

    public final double getZoomLevel() {
        Renderer renderer = this.ren1;
        return renderer != null ? renderer.getZoomLevel() : 1.0;
    }

    public final void setZoomLevel(double z) {
        block1: {
            Renderer renderer = this.ren1;
            if (renderer != null) {
                renderer.setZoomLevel(z);
            }
            Renderer renderer2 = this.ren2;
            if (renderer2 == null) break block1;
            renderer2.setZoomLevel(z);
        }
    }

    private final void findMaxMin() {
        JMLPattern jMLPattern = this.pat;
        Intrinsics.checkNotNull(jMLPattern);
        JMLPattern pattern = jMLPattern;
        Coordinate patternmax = null;
        Coordinate patternmin = null;
        int i2 = 1;
        int n = pattern.getNumberOfPaths();
        if (i2 <= n) {
            while (true) {
                patternmax = Coordinate.Companion.max(patternmax, pattern.getPathMax(i2));
                patternmin = Coordinate.Companion.min(patternmin, pattern.getPathMin(i2));
                if (i2 == n) break;
                ++i2;
            }
        }
        Coordinate propmax = null;
        Coordinate propmin = null;
        int i3 = 1;
        int n2 = pattern.getNumberOfProps();
        if (i3 <= n2) {
            while (true) {
                Prop prop = pattern.getProp(i3);
                Intrinsics.checkNotNull(prop);
                propmax = Coordinate.Companion.max(propmax, prop.getMax());
                Prop prop2 = pattern.getProp(i3);
                Intrinsics.checkNotNull(prop2);
                propmin = Coordinate.Companion.min(propmin, prop2.getMin());
                if (i3 == n2) break;
                ++i3;
            }
        }
        patternmax = Coordinate.Companion.add(patternmax, propmax);
        patternmin = Coordinate.Companion.add(patternmin, propmin);
        Coordinate handmax = null;
        Coordinate handmin = null;
        int i4 = 1;
        int n3 = pattern.getNumberOfJugglers();
        if (i4 <= n3) {
            while (true) {
                handmax = Coordinate.Companion.max(handmax, pattern.getHandMax(i4, 1));
                handmin = Coordinate.Companion.min(handmin, pattern.getHandMin(i4, 1));
                handmax = Coordinate.Companion.max(handmax, pattern.getHandMax(i4, 2));
                handmin = Coordinate.Companion.min(handmin, pattern.getHandMin(i4, 2));
                if (i4 == n3) break;
                ++i4;
            }
        }
        Renderer renderer = this.ren1;
        Intrinsics.checkNotNull(renderer);
        Coordinate hwmax = renderer.getHandWindowMax();
        Renderer renderer2 = this.ren1;
        Intrinsics.checkNotNull(renderer2);
        Coordinate hwmin = renderer2.getHandWindowMin();
        hwmax.setX(Math.max(Math.max(Math.abs(hwmax.getX()), Math.abs(hwmin.getX())), Math.max(Math.abs(hwmax.getY()), Math.abs(hwmin.getY()))));
        hwmin.setX(-hwmax.getX());
        hwmax.setY(hwmax.getX());
        hwmin.setY(hwmin.getX());
        handmax = Coordinate.Companion.add(handmax, hwmax);
        handmin = Coordinate.Companion.add(handmin, hwmin);
        Renderer renderer3 = this.ren1;
        Intrinsics.checkNotNull(renderer3);
        Coordinate jwmax = renderer3.getJugglerWindowMax();
        Renderer renderer4 = this.ren1;
        Intrinsics.checkNotNull(renderer4);
        Coordinate jwmin = renderer4.getJugglerWindowMin();
        this.overallMax = Coordinate.Companion.max(patternmax, Coordinate.Companion.max(handmax, jwmax));
        this.overallMin = Coordinate.Companion.min(patternmin, Coordinate.Companion.min(handmin, jwmin));
    }

    private final void syncRenderersToSize() {
        Dimension d = new Dimension(this.dim);
        if (this.jc.getStereo()) {
            d.width /= 2;
            Renderer renderer = this.ren1;
            Intrinsics.checkNotNull(renderer);
            int n = this.jc.getBorder();
            Coordinate coordinate = this.overallMax;
            Intrinsics.checkNotNull(coordinate);
            Coordinate coordinate2 = this.overallMin;
            Intrinsics.checkNotNull(coordinate2);
            renderer.initDisplay(d, n, coordinate, coordinate2);
            Renderer renderer2 = this.ren2;
            Intrinsics.checkNotNull(renderer2);
            int n2 = this.jc.getBorder();
            Coordinate coordinate3 = this.overallMax;
            Intrinsics.checkNotNull(coordinate3);
            Coordinate coordinate4 = this.overallMin;
            Intrinsics.checkNotNull(coordinate4);
            renderer2.initDisplay(d, n2, coordinate3, coordinate4);
        } else {
            Renderer renderer = this.ren1;
            Intrinsics.checkNotNull(renderer);
            int n = this.jc.getBorder();
            Coordinate coordinate = this.overallMax;
            Intrinsics.checkNotNull(coordinate);
            Coordinate coordinate5 = this.overallMin;
            Intrinsics.checkNotNull(coordinate5);
            renderer.initDisplay(d, n, coordinate, coordinate5);
        }
    }

    @NotNull
    public final Color getBackground() {
        Renderer renderer = this.ren1;
        Intrinsics.checkNotNull(renderer);
        return renderer.getBackground();
    }

    @NotNull
    public final AnimationPrefs getAnimationPrefs() {
        return this.jc;
    }

    public final void writeGIF(@NotNull OutputStream os, @Nullable WriteGIFMonitor wgm, double fps) throws IOException, JuggleExceptionInternal {
        Intrinsics.checkNotNullParameter(os, "os");
        JMLPattern jMLPattern = this.pat;
        Intrinsics.checkNotNull(jMLPattern);
        JMLPattern pattern = jMLPattern;
        Dimension dimension = this.dim;
        Intrinsics.checkNotNull(dimension);
        Dimension dimen = dimension;
        ImageWriter iw = ImageIO.getImageWritersByFormatName("gif").next();
        ImageOutputStream ios = new MemoryCacheImageOutputStream(os);
        iw.setOutput(ios);
        iw.prepareWriteSequence(null);
        BufferedImage image = new BufferedImage(dimen.width, dimen.height, 1);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int n = pattern.getNumberOfPaths();
        for (int i2 = 0; i2 < n; ++i2) {
            Intrinsics.checkNotNull(this.animPropNum);
            this.animPropNum[i2] = pattern.getPropAssignment(i2 + 1);
        }
        int gifNumFrames = (int)(0.5 + (pattern.getLoopEndTime() - pattern.getLoopStartTime()) * this.jc.getSlowdown() * fps);
        double gifSimIntervalSecs = (pattern.getLoopEndTime() - pattern.getLoopStartTime()) / (double)gifNumFrames;
        double gifRealIntervalMillis = (long)(1000.0 * gifSimIntervalSecs * this.jc.getSlowdown());
        int totalframes = pattern.getPeriodWithProps() * gifNumFrames;
        int framecount = 0;
        String delayTime = String.valueOf((int)(0.5 + gifRealIntervalMillis / (double)10));
        ImageWriteParam iwp = iw.getDefaultWriteParam();
        IIOMetadata metadata = null;
        int n2 = pattern.getPeriodWithProps();
        for (int j = 0; j < n2; ++j) {
            int it = j;
            boolean bl = false;
            double time = 0.0;
            time = pattern.getLoopStartTime();
            for (int k = 0; k < gifNumFrames; ++k) {
                int it2 = k;
                boolean bl2 = false;
                Intrinsics.checkNotNull(g);
                this.drawFrame(time, g, false, true);
                if (framecount < 2) {
                    IIOMetadata iIOMetadata = metadata = iw.getDefaultImageMetadata(new ImageTypeSpecifier(image), iwp);
                    Intrinsics.checkNotNullExpressionValue(iIOMetadata, "element");
                    Animator.Companion.configureGIFMetadata(iIOMetadata, delayTime, framecount);
                }
                IIOImage ii = new IIOImage(image, null, metadata);
                iw.writeToSequence(ii, null);
                time += gifSimIntervalSecs;
                ++framecount;
                if (wgm == null) continue;
                wgm.update(framecount, totalframes);
                if (!wgm.isCanceled()) continue;
                ios.close();
                os.close();
                return;
            }
            this.advanceProps();
        }
        g.dispose();
        iw.endWriteSequence();
        ios.close();
        os.close();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljugglinglab/core/Animator$Companion;", "", "<init>", "()V", "STEREO_SEPARATION_RADIANS", "", "configureGIFMetadata", "", "meta", "Ljavax/imageio/metadata/IIOMetadata;", "delayTime", "", "imageIndex", "", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        private final void configureGIFMetadata(IIOMetadata meta, String delayTime, int imageIndex) {
            Node child;
            String metaFormat = meta.getNativeMetadataFormatName();
            if (!Intrinsics.areEqual("javax_imageio_gif_image_1.0", metaFormat)) {
                boolean $i$a$-require-Animator$Companion$configureGIFMetadata$22 = false;
                String $i$a$-require-Animator$Companion$configureGIFMetadata$22 = "Unfamiliar gif metadata format: " + metaFormat;
                throw new IllegalArgumentException($i$a$-require-Animator$Companion$configureGIFMetadata$22.toString());
            }
            Node root = meta.getAsTree(metaFormat);
            for (child = root.getFirstChild(); child != null && !Intrinsics.areEqual("GraphicControlExtension", child.getNodeName()); child = child.getNextSibling()) {
            }
            Node node = child;
            Intrinsics.checkNotNull(node, "null cannot be cast to non-null type javax.imageio.metadata.IIOMetadataNode");
            IIOMetadataNode gce = (IIOMetadataNode)node;
            gce.setAttribute("userInputFlag", "FALSE");
            gce.setAttribute("delayTime", delayTime);
            if (imageIndex == 0) {
                IIOMetadataNode aes = new IIOMetadataNode("ApplicationExtensions");
                IIOMetadataNode ae = new IIOMetadataNode("ApplicationExtension");
                ae.setAttribute("applicationID", "NETSCAPE");
                ae.setAttribute("authenticationCode", "2.0");
                byte[] byArray = new byte[]{1, 0, 0};
                byte[] uo = byArray;
                ae.setUserObject(uo);
                aes.appendChild(ae);
                root.appendChild(aes);
            }
            try {
                meta.setFromTree(metaFormat, root);
            }
            catch (IIOInvalidTreeException e) {
                throw new Error(e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Ljugglinglab/core/Animator$WriteGIFMonitor;", "", "update", "", "step", "", "stepsTotal", "isCanceled", "", "()Z", "jugglinglab"})
    public static interface WriteGIFMonitor {
        public void update(int var1, int var2);

        public boolean isCanceled();
    }
}

