/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.PatternListPanel;
import jugglinglab.core.PatternListWindow;
import jugglinglab.core.PatternWindow;
import jugglinglab.generator.Generator;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.Transitioner;
import jugglinglab.jml.JMLPattern;
import jugglinglab.notation.NotationControl;
import jugglinglab.notation.Pattern;
import jugglinglab.notation.SiteswapNotationControl;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionDone;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionInterrupted;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.LabelDialog;
import jugglinglab.util.ParameterList;
import jugglinglab.view.View;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B%\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nB\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0011J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\b\u0010$\u001a\u0004\u0018\u00010\bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\u0004\u0018\u00010\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006,"}, d2={"Ljugglinglab/core/ApplicationPanel;", "Ljavax/swing/JPanel;", "Ljava/awt/event/ActionListener;", "parentFrame", "Ljavax/swing/JFrame;", "animtarget", "Ljugglinglab/view/View;", "patlist", "Ljugglinglab/core/PatternListPanel;", "<init>", "(Ljavax/swing/JFrame;Ljugglinglab/view/View;Ljugglinglab/core/PatternListPanel;)V", "(Ljavax/swing/JFrame;)V", "jtp", "Ljavax/swing/JTabbedPane;", "patlisttab", "", "currentnum", "", "juggleButton", "Ljavax/swing/JButton;", "transButton", "genButton", "genBusy", "Ljavax/swing/JLabel;", "actionPerformed", "", "ae", "Ljava/awt/event/ActionEvent;", "setNotation", "num", "addPatternEntryControl", "control", "Ljugglinglab/notation/NotationControl;", "addTransitionerControl", "trans", "Ljugglinglab/generator/Transitioner;", "plp", "addGeneratorControl", "gen", "Ljugglinglab/generator/Generator;", "defaultButton", "getDefaultButton", "()Ljavax/swing/JButton;", "Companion", "jugglinglab"})
public final class ApplicationPanel
extends JPanel
implements ActionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final JFrame parentFrame;
    @Nullable
    private final View animtarget;
    @Nullable
    private final PatternListPanel patlist;
    @Nullable
    private JTabbedPane jtp;
    private boolean patlisttab;
    private int currentnum;
    @Nullable
    private JButton juggleButton;
    @Nullable
    private JButton transButton;
    @Nullable
    private JButton genButton;
    @Nullable
    private JLabel genBusy;
    private static final int MAX_PATTERNS = 1000;
    private static final double MAX_TIME = 15.0;

    public ApplicationPanel(@Nullable JFrame parentFrame, @Nullable View animtarget, @Nullable PatternListPanel patlist) {
        this.parentFrame = parentFrame;
        this.animtarget = animtarget;
        this.patlist = patlist;
        this.currentnum = -1;
    }

    public ApplicationPanel(@Nullable JFrame parentFrame) {
        this(parentFrame, null, null);
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent ae) {
        block6: {
            Intrinsics.checkNotNullParameter(ae, "ae");
            String command = ae.getActionCommand();
            try {
                Intrinsics.checkNotNull(command);
                if (!StringsKt.startsWith$default(command, "notation", false, 2, null)) break block6;
                try {
                    String string = command.substring(8);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    int num = Integer.parseInt(string);
                    if (num != this.currentnum) {
                        this.setNotation(num);
                        JFrame jFrame = this.parentFrame;
                        if (jFrame != null) {
                            jFrame.pack();
                        }
                        this.currentnum = num;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JuggleExceptionInternal("Error in notation number coding");
                }
            }
            catch (Exception e) {
                ErrorDialog.INSTANCE.handleFatalException(e);
            }
        }
    }

    public final void setNotation(int num) {
        block8: {
            Generator gen;
            Transitioner trans;
            PatternListPanel pl;
            if (num > Pattern.Companion.getBuiltinNotations().size()) {
                return;
            }
            if (this.jtp != null) {
                this.remove(this.jtp);
            }
            this.jtp = new JTabbedPane();
            if (num == 1) {
                this.addPatternEntryControl(new SiteswapNotationControl());
            }
            if ((pl = this.patlist) == null && this.patlisttab) {
                pl = new PatternListPanel(this.animtarget);
            }
            if ((trans = Transitioner.Companion.newTransitioner(Pattern.Companion.getBuiltinNotations().get(num - 1))) != null) {
                this.addTransitionerControl(trans, pl);
            }
            if ((gen = Generator.Companion.newGenerator(Pattern.Companion.getBuiltinNotations().get(num - 1))) != null) {
                this.addGeneratorControl(gen, pl);
            }
            if (pl != null) {
                JTabbedPane jTabbedPane = this.jtp;
                Intrinsics.checkNotNull(jTabbedPane);
                jTabbedPane.addTab(JugglingLab.INSTANCE.getGuistrings().getString("Pattern_list_tab"), pl);
                if (this.patlist != null) {
                    JTabbedPane jTabbedPane2 = this.jtp;
                    Intrinsics.checkNotNull(jTabbedPane2);
                    jTabbedPane2.setSelectedComponent(pl);
                }
            }
            JTabbedPane jTabbedPane = this.jtp;
            Intrinsics.checkNotNull(jTabbedPane);
            jTabbedPane.addChangeListener(arg_0 -> ApplicationPanel.setNotation$lambda$0(this, arg_0));
            this.setLayout(new BorderLayout());
            JTabbedPane jTabbedPane3 = this.jtp;
            Intrinsics.checkNotNull(jTabbedPane3);
            this.add((Component)jTabbedPane3, "Center");
            Container container = this.parentFrame;
            if (container == null || (container = ((JFrame)container).getRootPane()) == null) break block8;
            ((JRootPane)container).setDefaultButton(this.getDefaultButton());
        }
    }

    private final void addPatternEntryControl(NotationControl control) {
        JPanel jPanel;
        JPanel $this$addPatternEntryControl_u24lambda_u244;
        JButton jButton;
        JButton $this$addPatternEntryControl_u24lambda_u242 = jButton = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("Defaults"));
        boolean bl = false;
        $this$addPatternEntryControl_u24lambda_u242.addActionListener(arg_0 -> ApplicationPanel.addPatternEntryControl$lambda$2$lambda$1(control, arg_0));
        JButton nbut1 = jButton;
        $this$addPatternEntryControl_u24lambda_u242 = jButton = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("Juggle"));
        ApplicationPanel applicationPanel = this;
        boolean bl2 = false;
        ((JButton)((Object)$this$addPatternEntryControl_u24lambda_u244)).setDefaultCapable(true);
        ((AbstractButton)((Object)$this$addPatternEntryControl_u24lambda_u244)).addActionListener(arg_0 -> ApplicationPanel.addPatternEntryControl$lambda$4$lambda$3(control, this, arg_0));
        applicationPanel.juggleButton = jButton;
        JPanel $this$addPatternEntryControl_u24lambda_u245 = $this$addPatternEntryControl_u24lambda_u244 = new JPanel();
        boolean bl3 = false;
        $this$addPatternEntryControl_u24lambda_u245.setLayout(new FlowLayout(4));
        $this$addPatternEntryControl_u24lambda_u245.add(nbut1);
        $this$addPatternEntryControl_u24lambda_u245.add(this.juggleButton);
        JPanel np2 = $this$addPatternEntryControl_u24lambda_u244;
        JPanel $this$addPatternEntryControl_u24lambda_u246 = jPanel = new JPanel();
        boolean bl4 = false;
        $this$addPatternEntryControl_u24lambda_u246.setLayout(new BorderLayout());
        $this$addPatternEntryControl_u24lambda_u246.add((Component)control, "First");
        $this$addPatternEntryControl_u24lambda_u246.add((Component)np2, "Last");
        JPanel np1 = jPanel;
        JTabbedPane jTabbedPane = this.jtp;
        Intrinsics.checkNotNull(jTabbedPane);
        jTabbedPane.addTab(JugglingLab.INSTANCE.getGuistrings().getString("Pattern_entry"), np1);
    }

    private final void addTransitionerControl(Transitioner trans, PatternListPanel plp) {
        JPanel jPanel;
        JPanel $this$addTransitionerControl_u24lambda_u2410;
        JButton jButton;
        JButton $this$addTransitionerControl_u24lambda_u248 = jButton = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("Defaults"));
        boolean bl = false;
        $this$addTransitionerControl_u24lambda_u248.addActionListener(arg_0 -> ApplicationPanel.addTransitionerControl$lambda$8$lambda$7(trans, arg_0));
        JButton but1 = jButton;
        $this$addTransitionerControl_u24lambda_u248 = jButton = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("Run"));
        ApplicationPanel applicationPanel = this;
        boolean bl2 = false;
        ((JButton)((Object)$this$addTransitionerControl_u24lambda_u2410)).setDefaultCapable(true);
        ((AbstractButton)((Object)$this$addTransitionerControl_u24lambda_u2410)).addActionListener(arg_0 -> ApplicationPanel.addTransitionerControl$lambda$10$lambda$9(this, trans, plp, arg_0));
        applicationPanel.transButton = jButton;
        JPanel $this$addTransitionerControl_u24lambda_u2411 = $this$addTransitionerControl_u24lambda_u2410 = new JPanel();
        boolean bl3 = false;
        $this$addTransitionerControl_u24lambda_u2411.setLayout(new FlowLayout(4));
        $this$addTransitionerControl_u24lambda_u2411.add(but1);
        $this$addTransitionerControl_u24lambda_u2411.add(this.transButton);
        JPanel p2 = $this$addTransitionerControl_u24lambda_u2410;
        JPanel $this$addTransitionerControl_u24lambda_u2412 = $this$addTransitionerControl_u24lambda_u2411 = new JPanel();
        boolean bl4 = false;
        $this$addTransitionerControl_u24lambda_u2412.setLayout(new BorderLayout());
        $this$addTransitionerControl_u24lambda_u2412.add((Component)p2, "After");
        JPanel p3 = $this$addTransitionerControl_u24lambda_u2411;
        JPanel $this$addTransitionerControl_u24lambda_u2413 = jPanel = new JPanel();
        boolean bl5 = false;
        $this$addTransitionerControl_u24lambda_u2413.setLayout(new BorderLayout());
        $this$addTransitionerControl_u24lambda_u2413.add((Component)trans.getTransitionerControl(), "First");
        $this$addTransitionerControl_u24lambda_u2413.add((Component)p3, "Last");
        JPanel p1 = jPanel;
        JTabbedPane jTabbedPane = this.jtp;
        Intrinsics.checkNotNull(jTabbedPane);
        jTabbedPane.addTab(JugglingLab.INSTANCE.getGuistrings().getString("Transitions"), p1);
    }

    private final void addGeneratorControl(Generator gen, PatternListPanel plp) {
        JPanel jPanel;
        GridBagLayout $this$addGeneratorControl_u24lambda_u2418;
        JComponent $this$addGeneratorControl_u24lambda_u2417;
        JComponent jComponent;
        JButton $this$addGeneratorControl_u24lambda_u2415 = jComponent = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("Defaults"));
        boolean bl = false;
        $this$addGeneratorControl_u24lambda_u2415.addActionListener(arg_0 -> ApplicationPanel.addGeneratorControl$lambda$15$lambda$14(gen, arg_0));
        JButton but1 = jComponent;
        $this$addGeneratorControl_u24lambda_u2415 = jComponent = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("Run"));
        ApplicationPanel applicationPanel = this;
        boolean bl2 = false;
        $this$addGeneratorControl_u24lambda_u2417.addActionListener(arg_0 -> ApplicationPanel.addGeneratorControl$lambda$17$lambda$16(this, gen, plp, arg_0));
        applicationPanel.genButton = jComponent;
        $this$addGeneratorControl_u24lambda_u2417 = jComponent = new JLabel(JugglingLab.INSTANCE.getGuistrings().getString("Processing"));
        applicationPanel = this;
        boolean bl3 = false;
        ((JComponent)((Object)$this$addGeneratorControl_u24lambda_u2418)).setVisible(false);
        applicationPanel.genBusy = jComponent;
        $this$addGeneratorControl_u24lambda_u2418 = new GridBagLayout();
        Serializable $this$addGeneratorControl_u24lambda_u2419 = $this$addGeneratorControl_u24lambda_u2418;
        boolean bl4 = false;
        ((GridBagLayout)$this$addGeneratorControl_u24lambda_u2419).setConstraints(this.genBusy, JLFunc.constraints(21, 0, 0, new Insets(0, 10, 0, 0)));
        GridBagLayout gb = $this$addGeneratorControl_u24lambda_u2418;
        Serializable $this$addGeneratorControl_u24lambda_u2420 = $this$addGeneratorControl_u24lambda_u2419 = new JPanel();
        boolean bl5 = false;
        ((Container)$this$addGeneratorControl_u24lambda_u2420).setLayout(gb);
        ((Container)$this$addGeneratorControl_u24lambda_u2420).add(this.genBusy);
        Serializable p4 = $this$addGeneratorControl_u24lambda_u2419;
        Serializable $this$addGeneratorControl_u24lambda_u2421 = $this$addGeneratorControl_u24lambda_u2420 = new JPanel();
        boolean bl6 = false;
        ((Container)$this$addGeneratorControl_u24lambda_u2421).setLayout(new FlowLayout(4));
        ((Container)$this$addGeneratorControl_u24lambda_u2421).add(but1);
        ((Container)$this$addGeneratorControl_u24lambda_u2421).add(this.genButton);
        Serializable p2 = $this$addGeneratorControl_u24lambda_u2420;
        Serializable $this$addGeneratorControl_u24lambda_u2422 = $this$addGeneratorControl_u24lambda_u2421 = new JPanel();
        boolean bl7 = false;
        ((Container)$this$addGeneratorControl_u24lambda_u2422).setLayout(new BorderLayout());
        ((Container)$this$addGeneratorControl_u24lambda_u2422).add((Component)p4, "Before");
        ((Container)$this$addGeneratorControl_u24lambda_u2422).add((Component)p2, "After");
        Serializable p3 = $this$addGeneratorControl_u24lambda_u2421;
        JPanel $this$addGeneratorControl_u24lambda_u2423 = jPanel = new JPanel();
        boolean bl8 = false;
        $this$addGeneratorControl_u24lambda_u2423.setLayout(new BorderLayout());
        $this$addGeneratorControl_u24lambda_u2423.add((Component)gen.getGeneratorControl(), "First");
        $this$addGeneratorControl_u24lambda_u2423.add((Component)p3, "Last");
        JPanel p1 = jPanel;
        JTabbedPane jTabbedPane = this.jtp;
        Intrinsics.checkNotNull(jTabbedPane);
        jTabbedPane.addTab(JugglingLab.INSTANCE.getGuistrings().getString("Generator"), p1);
    }

    private final JButton getDefaultButton() {
        if (this.jtp == null) {
            return null;
        }
        JTabbedPane jTabbedPane = this.jtp;
        Intrinsics.checkNotNull(jTabbedPane);
        return switch (jTabbedPane.getSelectedIndex()) {
            case 0 -> this.juggleButton;
            case 1 -> this.transButton;
            default -> this.genButton;
        };
    }

    private static final void setNotation$lambda$0(ApplicationPanel this$0, ChangeEvent changeEvent) {
        this$0.getRootPane().setDefaultButton(this$0.getDefaultButton());
    }

    private static final void addPatternEntryControl$lambda$2$lambda$1(NotationControl $control, ActionEvent actionEvent) {
        try {
            $control.resetControl();
        }
        catch (Exception e) {
            ErrorDialog.INSTANCE.handleFatalException(e);
        }
    }

    private static final void addPatternEntryControl$lambda$4$lambda$3(NotationControl $control, ApplicationPanel this$0, ActionEvent actionEvent) {
        try {
            ParameterList pl = $control.getParameterList();
            Pattern p = $control.newPattern().fromParameters(pl);
            AnimationPrefs jc = new AnimationPrefs().fromParameters(pl);
            pl.errorIfParametersLeft();
            String notation = p.getNotationName();
            String config = p.toString();
            JMLPattern pat = JMLPattern.Companion.fromBasePattern(notation, config);
            pat.layoutPattern();
            if (PatternWindow.Companion.bringToFront(pat.getHashCode())) {
                return;
            }
            if (this$0.animtarget != null) {
                this$0.animtarget.restartView(pat, jc);
                v0 = Unit.INSTANCE;
            } else {
                v0 = new PatternWindow(pat.getTitle(), pat, jc);
            }
        }
        catch (JuggleExceptionUser je) {
            ErrorDialog.INSTANCE.handleUserException(this$0, je.getMessage());
        }
        catch (Exception e) {
            ErrorDialog.INSTANCE.handleFatalException(e);
        }
    }

    private static final void addTransitionerControl$lambda$8$lambda$7(Transitioner $trans, ActionEvent actionEvent) {
        $trans.resetTransitionerControl();
    }

    private static final void addTransitionerControl$lambda$10$lambda$9(ApplicationPanel this$0, Transitioner $trans, PatternListPanel $plp, ActionEvent it) {
        Thread t2 = new Thread(this$0, $trans, $plp){
            final /* synthetic */ ApplicationPanel this$0;
            final /* synthetic */ Transitioner $trans;
            final /* synthetic */ PatternListPanel $plp;
            {
                this.this$0 = $receiver;
                this.$trans = $trans;
                this.$plp = $plp;
            }

            public void run() {
                JButton jButton = ApplicationPanel.access$getTransButton$p(this.this$0);
                Intrinsics.checkNotNull(jButton);
                jButton.setEnabled(false);
                PatternListWindow pw = null;
                try {
                    this.$trans.initTransitioner();
                    GeneratorTarget pwot = null;
                    if (this.$plp != null) {
                        this.$plp.clearList();
                        pwot = new GeneratorTarget(this.$plp);
                    } else {
                        String title = this.$trans.getNotationName() + " " + JugglingLab.INSTANCE.getGuistrings().getString("Patterns");
                        pw = new PatternListWindow(title, this);
                        pwot = new GeneratorTarget(pw.getPatternListPanel());
                    }
                    this.$trans.runTransitioner(pwot, 1000, 15.0);
                    if (this.$plp != null) {
                        JTabbedPane jTabbedPane = ApplicationPanel.access$getJtp$p(this.this$0);
                        Intrinsics.checkNotNull(jTabbedPane);
                        jTabbedPane.setSelectedComponent(this.$plp);
                    }
                }
                catch (JuggleExceptionDone ex) {
                    Container container;
                    if (this.$plp != null) {
                        JTabbedPane jTabbedPane = ApplicationPanel.access$getJtp$p(this.this$0);
                        Intrinsics.checkNotNull(jTabbedPane);
                        jTabbedPane.setSelectedComponent(this.$plp);
                    }
                    if ((container = pw) == null) {
                        container = this.$plp;
                    }
                    PatternListWindow parentComponent = container;
                    new LabelDialog(parentComponent, JugglingLab.INSTANCE.getGuistrings().getString("Generator_stopped_title"), ex.getMessage());
                }
                catch (JuggleExceptionInterrupted ex) {
                }
                catch (JuggleExceptionUser ex) {
                    PatternListWindow patternListWindow = pw;
                    if (patternListWindow != null) {
                        patternListWindow.dispose();
                    }
                    ErrorDialog.INSTANCE.handleUserException(this.this$0, ex.getMessage());
                }
                catch (Exception e) {
                    PatternListWindow patternListWindow = pw;
                    if (patternListWindow != null) {
                        patternListWindow.dispose();
                    }
                    ErrorDialog.INSTANCE.handleFatalException(e);
                }
                JButton jButton2 = ApplicationPanel.access$getTransButton$p(this.this$0);
                Intrinsics.checkNotNull(jButton2);
                jButton2.setEnabled(true);
            }
        };
        t2.start();
    }

    private static final void addGeneratorControl$lambda$15$lambda$14(Generator $gen, ActionEvent actionEvent) {
        $gen.resetGeneratorControl();
    }

    private static final void addGeneratorControl$lambda$17$lambda$16(ApplicationPanel this$0, Generator $gen, PatternListPanel $plp, ActionEvent it) {
        Thread t2 = new Thread(this$0, $gen, $plp){
            final /* synthetic */ ApplicationPanel this$0;
            final /* synthetic */ Generator $gen;
            final /* synthetic */ PatternListPanel $plp;
            {
                this.this$0 = $receiver;
                this.$gen = $gen;
                this.$plp = $plp;
            }

            public void run() {
                JLabel jLabel = ApplicationPanel.access$getGenBusy$p(this.this$0);
                Intrinsics.checkNotNull(jLabel);
                jLabel.setVisible(true);
                JButton jButton = ApplicationPanel.access$getGenButton$p(this.this$0);
                Intrinsics.checkNotNull(jButton);
                jButton.setEnabled(false);
                PatternListWindow pw = null;
                try {
                    this.$gen.initGenerator();
                    GeneratorTarget pwot = null;
                    if (this.$plp != null) {
                        this.$plp.clearList();
                        pwot = new GeneratorTarget(this.$plp);
                    } else {
                        String title = this.$gen.getNotationName() + " " + JugglingLab.INSTANCE.getGuistrings().getString("Patterns");
                        pw = new PatternListWindow(title, this);
                        pwot = new GeneratorTarget(pw.getPatternListPanel());
                    }
                    this.$gen.runGenerator(pwot, 1000, 15.0);
                    if (this.$plp != null) {
                        JTabbedPane jTabbedPane = ApplicationPanel.access$getJtp$p(this.this$0);
                        Intrinsics.checkNotNull(jTabbedPane);
                        jTabbedPane.setSelectedComponent(this.$plp);
                    }
                }
                catch (JuggleExceptionDone ex) {
                    Container container;
                    if (this.$plp != null) {
                        JTabbedPane jTabbedPane = ApplicationPanel.access$getJtp$p(this.this$0);
                        Intrinsics.checkNotNull(jTabbedPane);
                        jTabbedPane.setSelectedComponent(this.$plp);
                    }
                    if ((container = pw) == null) {
                        container = this.$plp;
                    }
                    PatternListWindow parentComponent = container;
                    new LabelDialog(parentComponent, JugglingLab.INSTANCE.getGuistrings().getString("Generator_stopped_title"), ex.getMessage());
                }
                catch (JuggleExceptionInterrupted ex) {
                }
                catch (JuggleExceptionUser ex) {
                    PatternListWindow patternListWindow = pw;
                    if (patternListWindow != null) {
                        patternListWindow.dispose();
                    }
                    ErrorDialog.INSTANCE.handleUserException(this.this$0, ex.getMessage());
                }
                catch (Exception e) {
                    PatternListWindow patternListWindow = pw;
                    if (patternListWindow != null) {
                        patternListWindow.dispose();
                    }
                    ErrorDialog.INSTANCE.handleFatalException(e);
                }
                JLabel jLabel2 = ApplicationPanel.access$getGenBusy$p(this.this$0);
                Intrinsics.checkNotNull(jLabel2);
                jLabel2.setVisible(false);
                JButton jButton2 = ApplicationPanel.access$getGenButton$p(this.this$0);
                Intrinsics.checkNotNull(jButton2);
                jButton2.setEnabled(true);
            }
        };
        t2.start();
    }

    public static final /* synthetic */ JButton access$getTransButton$p(ApplicationPanel $this) {
        return $this.transButton;
    }

    public static final /* synthetic */ JTabbedPane access$getJtp$p(ApplicationPanel $this) {
        return $this.jtp;
    }

    public static final /* synthetic */ JLabel access$getGenBusy$p(ApplicationPanel $this) {
        return $this.genBusy;
    }

    public static final /* synthetic */ JButton access$getGenButton$p(ApplicationPanel $this) {
        return $this.genButton;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljugglinglab/core/ApplicationPanel$Companion;", "", "<init>", "()V", "MAX_PATTERNS", "", "MAX_TIME", "", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

