/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.ApplicationPanel;
import jugglinglab.core.PatternListWindow;
import jugglinglab.core.PatternWindow;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLParser;
import jugglinglab.jml.JMLPattern;
import jugglinglab.notation.Pattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.LabelDialog;
import jugglinglab.util.OpenFilesServer;
import jugglinglab.util.UpdateChecker;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0018\u0019B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Ljugglinglab/core/ApplicationWindow;", "Ljavax/swing/JFrame;", "Ljava/awt/event/ActionListener;", "title", "", "<init>", "(Ljava/lang/String;)V", "value", "Ljavax/swing/JMenu;", "windowMenu", "getWindowMenu", "()Ljavax/swing/JMenu;", "createContents", "", "createMenus", "createFileMenu", "createNotationMenu", "createHelpMenu", "actionPerformed", "ae", "Ljava/awt/event/ActionEvent;", "doMenuCommand", "action", "Ljugglinglab/core/ApplicationWindow$MenuCommand;", "MenuCommand", "Companion", "jugglinglab"})
public final class ApplicationWindow
extends JFrame
implements ActionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private JMenu windowMenu;
    @NotNull
    private static final List<String> fileItems;
    @NotNull
    private static final List<String> fileCommands;
    @NotNull
    private static final char[] fileShortcuts;
    @NotNull
    private static final List<String> helpItems;
    @NotNull
    private static final List<String> helpCommands;

    public ApplicationWindow(@Nullable String title) {
        super(title);
        this.createMenus();
        this.createContents();
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        int locx = Math.max(0, center.x - 600);
        this.setLocation(locx, 50);
        this.setResizable(false);
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    this.doMenuCommand(MenuCommand.FILE_EXIT);
                }
                catch (Exception exception) {
                    System.exit(0);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
            }
        });
        if (!ApplicationWindow.Companion.registerOpenFilesHandler()) {
            OpenFilesServer.INSTANCE.startOpenFilesServer();
        }
        new UpdateChecker();
        SwingUtilities.invokeLater(ApplicationWindow::_init_$lambda$0);
    }

    @Nullable
    public final JMenu getWindowMenu() {
        return this.windowMenu;
    }

    private final void createContents() {
        ApplicationPanel ap = new ApplicationPanel(this);
        ap.setDoubleBuffered(true);
        this.setContentPane(ap);
        ap.setNotation(1);
        Locale loc = Locale.getDefault();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        this.setBackground(new Color(0.9f, 0.9f, 0.9f));
        this.pack();
    }

    private final void createMenus() {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu());
        if (Pattern.Companion.getBuiltinNotations().size() > 1) {
            JMenu notationmenu = this.createNotationMenu();
            mb.add(notationmenu);
            notationmenu.getItem(0).setSelected(true);
        }
        this.windowMenu = new JMenu(JugglingLab.INSTANCE.getGuistrings().getString("Window"));
        mb.add(this.windowMenu);
        mb.add(this.createHelpMenu());
        this.setJMenuBar(mb);
    }

    private final JMenu createFileMenu() {
        int n;
        boolean quitHandler;
        boolean bl = quitHandler = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_QUIT_HANDLER);
        if (quitHandler) {
            Desktop.getDesktop().setQuitHandler((arg_0, arg_1) -> ApplicationWindow.createFileMenu$lambda$1(this, arg_0, arg_1));
        }
        JMenu filemenu = new JMenu(JugglingLab.INSTANCE.getGuistrings().getString("File"));
        int n2 = n = quitHandler ? fileItems.size() - 2 : fileItems.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (fileItems.get(i2) == null) {
                filemenu.addSeparator();
                continue;
            }
            ResourceBundle resourceBundle = JugglingLab.INSTANCE.getGuistrings();
            String string = fileItems.get(i2);
            Intrinsics.checkNotNull(string);
            JMenuItem fileitem = new JMenuItem(resourceBundle.getString(StringsKt.replace$default(string, ' ', '_', false, 4, null)));
            if (fileShortcuts[i2] != ' ') {
                fileitem.setAccelerator(KeyStroke.getKeyStroke((int)fileShortcuts[i2], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
            }
            fileitem.setActionCommand(fileCommands.get(i2));
            fileitem.addActionListener(this);
            filemenu.add(fileitem);
        }
        return filemenu;
    }

    private final JMenu createNotationMenu() {
        JMenu notationmenu = new JMenu(JugglingLab.INSTANCE.getGuistrings().getString("Notation"));
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = ((Collection)Pattern.Companion.getBuiltinNotations()).size();
        for (int i2 = 0; i2 < n; ++i2) {
            JRadioButtonMenuItem notationitem = new JRadioButtonMenuItem(Pattern.Companion.getBuiltinNotations().get(i2));
            notationitem.setActionCommand("notation" + (i2 + 1));
            notationitem.addActionListener(this);
            notationmenu.add(notationitem);
            buttonGroup.add(notationitem);
        }
        return notationmenu;
    }

    private final JMenu createHelpMenu() {
        boolean includeAbout = !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.APP_ABOUT);
        JMenu helpmenu = new JMenu(JugglingLab.INSTANCE.getGuistrings().getString("Help"));
        int n = helpItems.size();
        for (int i2 = includeAbout ? 0 : 1; i2 < n; ++i2) {
            if (helpItems.get(i2) == null) {
                helpmenu.addSeparator();
                continue;
            }
            ResourceBundle resourceBundle = JugglingLab.INSTANCE.getGuistrings();
            String string = helpItems.get(i2);
            Intrinsics.checkNotNull(string);
            JMenuItem helpitem = new JMenuItem(resourceBundle.getString(StringsKt.replace$default(string, ' ', '_', false, 4, null)));
            helpitem.setActionCommand(helpCommands.get(i2));
            helpitem.addActionListener(this);
            helpmenu.add(helpitem);
        }
        return helpmenu;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(@NotNull ActionEvent ae) {
        Intrinsics.checkNotNullParameter(ae, "ae");
        try {
            block17: {
                block16: {
                    block15: {
                        block18: {
                            String string = ae.getActionCommand();
                            if (string == null) return;
                            switch (string.hashCode()) {
                                case 104714140: {
                                    if (string.equals("newpl")) break;
                                    return;
                                }
                                case 3127582: {
                                    if (!string.equals("exit")) {
                                        return;
                                    }
                                    break block15;
                                }
                                case 92611469: {
                                    if (!string.equals("about")) {
                                        return;
                                    }
                                    break block16;
                                }
                                case -1012222381: {
                                    if (!string.equals("online")) {
                                        return;
                                    }
                                    break block17;
                                }
                                case 3417674: {
                                    if (!string.equals("open")) {
                                        return;
                                    }
                                    break block18;
                                }
                                case -1048829181: {
                                    if (!string.equals("newpat")) return;
                                    this.doMenuCommand(MenuCommand.FILE_NEWPAT);
                                    return;
                                }
                            }
                            this.doMenuCommand(MenuCommand.FILE_NEWPL);
                            return;
                        }
                        this.doMenuCommand(MenuCommand.FILE_OPEN);
                        return;
                    }
                    this.doMenuCommand(MenuCommand.FILE_EXIT);
                    return;
                }
                this.doMenuCommand(MenuCommand.HELP_ABOUT);
                return;
            }
            this.doMenuCommand(MenuCommand.HELP_ONLINE);
            return;
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.INSTANCE.handleFatalException(jei);
        }
    }

    private final void doMenuCommand(MenuCommand action) throws JuggleExceptionInternal {
        switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Companion.newPattern();
                break;
            }
            case 3: {
                new PatternListWindow("").setTitle(null);
                break;
            }
            case 4: {
                Companion.openJMLFile();
                break;
            }
            case 5: {
                boolean noOpenFilesHandler;
                boolean bl = noOpenFilesHandler = !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.APP_OPEN_FILE);
                if (noOpenFilesHandler) {
                    OpenFilesServer.cleanup();
                }
                System.exit(0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            case 6: {
                Companion.showAboutBox();
                break;
            }
            case 7: {
                Companion.showOnlineHelp();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void _init_$lambda$0() {
        Companion.updateWindowMenus();
    }

    private static final void createFileMenu$lambda$1(ApplicationWindow this$0, QuitEvent quitEvent, QuitResponse response) {
        try {
            this$0.doMenuCommand(MenuCommand.FILE_EXIT);
        }
        catch (JuggleExceptionInternal juggleExceptionInternal) {
            QuitResponse quitResponse = response;
            Intrinsics.checkNotNull(quitResponse);
            quitResponse.performQuit();
        }
    }

    static {
        Object[] objectArray = new String[]{"New Pattern", "New Pattern List", "Open JML...", null, "Quit"};
        fileItems = CollectionsKt.listOf(objectArray);
        objectArray = new String[]{"newpat", "newpl", "open", null, "exit"};
        fileCommands = CollectionsKt.listOf(objectArray);
        objectArray = new char[5];
        objectArray[0] = (String)78;
        objectArray[1] = (String)76;
        objectArray[2] = (String)79;
        objectArray[3] = (String)32;
        objectArray[4] = (String)81;
        fileShortcuts = (char[])objectArray;
        objectArray = new String[]{"About Juggling Lab", "Juggling Lab Online Help"};
        helpItems = CollectionsKt.listOf(objectArray);
        objectArray = new String[]{"about", "online"};
        helpCommands = CollectionsKt.listOf(objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u0007R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljugglinglab/core/ApplicationWindow$Companion;", "", "<init>", "()V", "registerOpenFilesHandler", "", "updateWindowMenus", "", "newPattern", "openJMLFile", "jmlf", "Ljava/io/File;", "showAboutBox", "showOnlineHelp", "fileItems", "", "", "fileCommands", "fileShortcuts", "", "helpItems", "helpCommands", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean registerOpenFilesHandler() {
            if (!Desktop.isDesktopSupported()) {
                return false;
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.APP_OPEN_FILE)) {
                return false;
            }
            Desktop.getDesktop().setOpenFileHandler(Companion::registerOpenFilesHandler$lambda$0);
            return true;
        }

        public final void updateWindowMenus() {
            ArrayList<Frame> apps = new ArrayList<Frame>();
            ArrayList<Frame> pls = new ArrayList<Frame>();
            ArrayList<Frame> anims = new ArrayList<Frame>();
            ArrayList<JMenu> menus = new ArrayList<JMenu>();
            Iterator<Frame> iterator2 = ArrayIteratorKt.iterator(JFrame.getFrames());
            while (iterator2.hasNext()) {
                Frame fr = iterator2.next();
                if (!fr.isVisible()) continue;
                Frame frame = fr;
                if (frame instanceof ApplicationWindow) {
                    apps.add(fr);
                    JMenu jMenu = ((ApplicationWindow)fr).getWindowMenu();
                    Intrinsics.checkNotNull(jMenu);
                    menus.add(jMenu);
                    continue;
                }
                if (frame instanceof PatternListWindow) {
                    pls.add(fr);
                    JMenu jMenu = ((PatternListWindow)fr).getWindowMenu();
                    Intrinsics.checkNotNull(jMenu);
                    menus.add(jMenu);
                    continue;
                }
                if (!(frame instanceof PatternWindow)) continue;
                anims.add(fr);
                menus.add(((PatternWindow)fr).getWindowMenu());
            }
            ActionListener al = arg_0 -> Companion.updateWindowMenus$lambda$1(apps, pls, anims, arg_0);
            Iterator iterator3 = menus.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
            Iterator iterator4 = iterator3;
            while (iterator4.hasNext()) {
                Object e = iterator4.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                JMenu wm = (JMenu)e;
                wm.removeAll();
                JMenuItem alltofront = new JMenuItem(JugglingLab.INSTANCE.getGuistrings().getString("Bring_All_To_Front"));
                alltofront.setActionCommand("front");
                alltofront.addActionListener(al);
                wm.add(alltofront);
                wm.addSeparator();
                int windownum = 0;
                Iterator iterator5 = apps.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator5, "iterator(...)");
                Iterator iterator6 = iterator5;
                while (iterator6.hasNext()) {
                    Object e2 = iterator6.next();
                    Intrinsics.checkNotNullExpressionValue(e2, "next(...)");
                    ApplicationWindow aw = (ApplicationWindow)e2;
                    JMenuItem awitem = new JMenuItem(aw.getTitle());
                    awitem.setActionCommand(String.valueOf(windownum++));
                    awitem.addActionListener(al);
                    wm.add(awitem);
                }
                Iterator iterator7 = pls.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator7, "iterator(...)");
                iterator6 = iterator7;
                while (iterator6.hasNext()) {
                    Object e3 = iterator6.next();
                    Intrinsics.checkNotNullExpressionValue(e3, "next(...)");
                    PatternListWindow pl = (PatternListWindow)e3;
                    JMenuItem plitem = new JMenuItem(pl.getTitle());
                    plitem.setActionCommand(String.valueOf(windownum++));
                    plitem.addActionListener(al);
                    wm.add(plitem);
                }
                Iterator iterator8 = anims.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator8, "iterator(...)");
                iterator6 = iterator8;
                while (iterator6.hasNext()) {
                    Object e4 = iterator6.next();
                    Intrinsics.checkNotNullExpressionValue(e4, "next(...)");
                    PatternWindow anim = (PatternWindow)e4;
                    JMenuItem animitem = new JMenuItem(anim.getTitle());
                    animitem.setActionCommand(String.valueOf(windownum++));
                    animitem.addActionListener(al);
                    wm.add(animitem);
                }
            }
        }

        public final void newPattern() throws JuggleExceptionInternal {
            try {
                JMLPattern pat = JMLPattern.Companion.fromBasePattern("Siteswap", "pattern=3");
                PatternWindow pw = new PatternWindow("3", pat, new AnimationPrefs());
                pw.setViewMode(3);
            }
            catch (JuggleExceptionUser jeu) {
                throw new JuggleExceptionInternal(jeu.getMessage());
            }
        }

        public final void openJMLFile() throws JuggleExceptionInternal {
            String[] stringArray = new String[]{"jml"};
            JLFunc.getJfc().setFileFilter(new FileNameExtensionFilter("JML file", stringArray));
            if (JLFunc.getJfc().showOpenDialog(null) != 0) {
                return;
            }
            File file = JLFunc.getJfc().getSelectedFile();
            if (file != null) {
                try {
                    this.openJMLFile(file);
                }
                catch (JuggleExceptionUser jeu) {
                    String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_reading_file");
                    Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                    String template = string;
                    Object[] objectArray = new Object[]{file.getName()};
                    Object[] arguments = objectArray;
                    String msg = MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)) + ":\n" + jeu.getMessage();
                    ErrorDialog.INSTANCE.handleUserException(null, msg);
                }
            }
        }

        public final void openJMLFile(@NotNull File jmlf) throws JuggleExceptionUser, JuggleExceptionInternal {
            Intrinsics.checkNotNullParameter(jmlf, "jmlf");
            try {
                JMLParser parser = new JMLParser();
                parser.parse(new FileReader(jmlf));
                switch (parser.getFileType()) {
                    case 1: {
                        JMLNode jMLNode = parser.getTree();
                        Intrinsics.checkNotNull(jMLNode);
                        JMLPattern pat = new JMLPattern(jMLNode);
                        pat.layoutPattern();
                        if (!PatternWindow.Companion.bringToFront(pat.getHashCode())) {
                            PatternWindow pw = new PatternWindow(pat.getTitle(), pat, new AnimationPrefs());
                            pw.setJMLFilename(jmlf.getName());
                        }
                        break;
                    }
                    case 2: {
                        PatternListWindow plw = new PatternListWindow(parser.getTree());
                        plw.setJmlFilename(jmlf.getName());
                        break;
                    }
                    default: {
                        throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_invalid_JML"));
                    }
                }
            }
            catch (FileNotFoundException fnfe) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_file_not_found") + ": " + fnfe.getMessage());
            }
            catch (IOException ioe) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_IO") + ": " + ioe.getMessage());
            }
            catch (SAXParseException spe) {
                String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_JML_parsing");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String template = string;
                Object[] objectArray = new Object[2];
                objectArray[0] = spe.getLineNumber();
                String string2 = spe.getMessage();
                Intrinsics.checkNotNull(string2);
                objectArray[1] = !(((CharSequence)string2).length() == 0) ? ":\n" + spe.getMessage() : "";
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
            }
            catch (SAXException se) {
                throw new JuggleExceptionUser(se.getMessage());
            }
        }

        public final void showAboutBox() {
            JFrame aboutBox = new JFrame(JugglingLab.INSTANCE.getGuistrings().getString("About_Juggling_Lab"));
            aboutBox.setDefaultCloseOperation(2);
            JPanel aboutPanel = new JPanel(new BorderLayout());
            aboutPanel.setOpaque(true);
            URL url = ApplicationWindow.class.getResource("/about.png");
            if (url != null) {
                ImageIcon aboutPicture = new ImageIcon(url, "A lab");
                JLabel aboutLabel = new JLabel(aboutPicture);
                aboutPanel.add((Component)aboutLabel, "Before");
            }
            JPanel textPanel = new JPanel();
            aboutPanel.add((Component)textPanel, "After");
            GridBagLayout gb = new GridBagLayout();
            textPanel.setLayout(gb);
            JLabel abouttext1 = new JLabel("Juggling Lab");
            abouttext1.setFont(new Font("SansSerif", 1, 18));
            textPanel.add(abouttext1);
            gb.setConstraints(abouttext1, JLFunc.constraints(21, 0, 0, new Insets(15, 15, 0, 15)));
            String string = JugglingLab.INSTANCE.getGuistrings().getString("Version");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String template = string;
            Object[] objectArray = new Object[]{"1.6.7"};
            Object[] arguments = objectArray;
            JLabel abouttext5 = new JLabel(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
            abouttext5.setFont(new Font("SansSerif", 0, 16));
            textPanel.add(abouttext5);
            gb.setConstraints(abouttext5, JLFunc.constraints(21, 0, 1, new Insets(0, 15, 0, 15)));
            String string2 = JugglingLab.INSTANCE.getGuistrings().getString("Copyright_message");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            String template2 = string2;
            Object[] objectArray2 = new Object[]{"2025"};
            Object[] arguments2 = objectArray2;
            JLabel abouttext6 = new JLabel(MessageFormat.format(template2, Arrays.copyOf(arguments2, arguments2.length)));
            abouttext6.setFont(new Font("SansSerif", 0, 14));
            textPanel.add(abouttext6);
            gb.setConstraints(abouttext6, JLFunc.constraints(21, 0, 2, new Insets(15, 15, 15, 15)));
            JLabel abouttext3 = new JLabel(JugglingLab.INSTANCE.getGuistrings().getString("GPL_message"));
            abouttext3.setFont(new Font("SansSerif", 0, 12));
            textPanel.add(abouttext3);
            gb.setConstraints(abouttext3, JLFunc.constraints(21, 0, 3, new Insets(0, 15, 15, 15)));
            String javaversion = System.getProperty("java.version");
            String javavmname = System.getProperty("java.vm.name");
            String javavmversion = System.getProperty("java.vm.version");
            int gridrow = 4;
            if (javaversion != null) {
                JLabel java1 = new JLabel("Java version " + javaversion);
                java1.setFont(new Font("SansSerif", 0, 12));
                textPanel.add(java1);
                gb.setConstraints(java1, JLFunc.constraints(21, 0, gridrow++, new Insets(0, 15, 0, 15)));
            }
            if (javavmname != null && javavmversion != null) {
                JLabel java2 = new JLabel(javavmname + " (" + javavmversion + ")");
                java2.setFont(new Font("SansSerif", 0, 12));
                textPanel.add(java2);
                gb.setConstraints(java2, JLFunc.constraints(21, 0, gridrow++, new Insets(0, 15, 0, 15)));
            }
            JButton okbutton = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("OK"));
            textPanel.add(okbutton);
            gb.setConstraints(okbutton, JLFunc.constraints(22, 0, gridrow++, new Insets(15, 15, 15, 15)));
            okbutton.addActionListener(arg_0 -> Companion.showAboutBox$lambda$2(aboutBox, arg_0));
            aboutBox.setContentPane(aboutPanel);
            Locale loc = Locale.getDefault();
            aboutBox.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
            aboutBox.pack();
            aboutBox.setResizable(false);
            aboutBox.setLocationRelativeTo(null);
            aboutBox.setVisible(true);
        }

        public final void showOnlineHelp() {
            boolean browseSupported = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
            boolean browseProblem = false;
            if (browseSupported) {
                try {
                    Desktop.getDesktop().browse(new URI("https://jugglinglab.org/#help"));
                }
                catch (Exception exception) {
                    browseProblem = true;
                }
            }
            if (!browseSupported || browseProblem) {
                new LabelDialog(null, "Help", "Find online help at https://jugglinglab.org/#help");
            }
        }

        private static final void registerOpenFilesHandler$lambda$0(OpenFilesEvent ofe) {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_REQUEST_FOREGROUND)) {
                Desktop.getDesktop().requestForeground(true);
            }
            try {
                OpenFilesEvent openFilesEvent = ofe;
                Intrinsics.checkNotNull(openFilesEvent);
                for (File file : openFilesEvent.getFiles()) {
                    try {
                        Intrinsics.checkNotNull(file);
                        Companion.openJMLFile(file);
                    }
                    catch (JuggleExceptionUser jeu) {
                        String template;
                        Intrinsics.checkNotNullExpressionValue(JugglingLab.INSTANCE.getErrorstrings().getString("Error_reading_file"), "getString(...)");
                        Object[] objectArray = new Object[]{file.getName()};
                        Object[] arguments = objectArray;
                        String msg = MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)) + ":\n" + jeu.getMessage();
                        ErrorDialog.INSTANCE.handleUserException(null, msg);
                    }
                }
            }
            catch (JuggleExceptionInternal jei) {
                ErrorDialog.INSTANCE.handleFatalException(jei);
            }
        }

        private static final void updateWindowMenus$lambda$1(ArrayList $apps, ArrayList $pls, ArrayList $anims, ActionEvent ae) {
            ActionEvent actionEvent = ae;
            Intrinsics.checkNotNull(actionEvent);
            String command = actionEvent.getActionCommand();
            if (Intrinsics.areEqual(command, "front")) {
                boolean foregroundSupported;
                boolean bl = foregroundSupported = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_REQUEST_FOREGROUND);
                if (foregroundSupported) {
                    Desktop.getDesktop().requestForeground(true);
                } else {
                    JFrame fr;
                    Iterator iterator2 = $apps.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                    Iterator iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        Object e = iterator3.next();
                        Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                        fr = (ApplicationWindow)e;
                        fr.toFront();
                    }
                    Iterator iterator4 = $pls.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
                    iterator3 = iterator4;
                    while (iterator3.hasNext()) {
                        Object e = iterator3.next();
                        Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                        fr = (PatternListWindow)e;
                        fr.toFront();
                    }
                    Iterator iterator5 = $anims.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator5, "iterator(...)");
                    iterator3 = iterator5;
                    while (iterator3.hasNext()) {
                        Object e = iterator3.next();
                        Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                        fr = (PatternWindow)e;
                        fr.toFront();
                    }
                }
                return;
            }
            Intrinsics.checkNotNull(command);
            int windownum = Integer.parseInt(command);
            if (windownum < $apps.size()) {
                ((ApplicationWindow)$apps.get(windownum)).toFront();
                return;
            }
            if ((windownum -= $apps.size()) < $pls.size()) {
                ((PatternListWindow)$pls.get(windownum)).toFront();
                return;
            }
            if ((windownum -= $pls.size()) < $anims.size()) {
                ((PatternWindow)$anims.get(windownum)).toFront();
                return;
            }
            ErrorDialog.INSTANCE.handleFatalException(new JuggleExceptionInternal("Window number out of range: " + command));
        }

        private static final void showAboutBox$lambda$2(JFrame $aboutBox, ActionEvent actionEvent) {
            $aboutBox.setVisible(false);
            $aboutBox.dispose();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Ljugglinglab/core/ApplicationWindow$MenuCommand;", "", "<init>", "(Ljava/lang/String;I)V", "FILE_NONE", "FILE_NEWPAT", "FILE_NEWPL", "FILE_OPEN", "FILE_EXIT", "HELP_ABOUT", "HELP_ONLINE", "jugglinglab"})
    private static final class MenuCommand
    extends Enum<MenuCommand> {
        public static final /* enum */ MenuCommand FILE_NONE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_NEWPAT = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_NEWPL = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_OPEN = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_EXIT = new MenuCommand();
        public static final /* enum */ MenuCommand HELP_ABOUT = new MenuCommand();
        public static final /* enum */ MenuCommand HELP_ONLINE = new MenuCommand();
        private static final /* synthetic */ MenuCommand[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MenuCommand[] values() {
            return (MenuCommand[])$VALUES.clone();
        }

        public static MenuCommand valueOf(String value) {
            return Enum.valueOf(MenuCommand.class, value);
        }

        @NotNull
        public static EnumEntries<MenuCommand> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = menuCommandArray = new MenuCommand[]{MenuCommand.FILE_NONE, MenuCommand.FILE_NEWPAT, MenuCommand.FILE_NEWPL, MenuCommand.FILE_OPEN, MenuCommand.FILE_EXIT, MenuCommand.HELP_ABOUT, MenuCommand.HELP_ONLINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MenuCommand.values().length];
            try {
                nArray[MenuCommand.FILE_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_NEWPAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_NEWPL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_OPEN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_EXIT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.HELP_ABOUT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.HELP_ONLINE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

