/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JPanel;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPanel;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PathLink;
import jugglinglab.util.JLFunc;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 x2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0005tuvwxB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0012\u0010[\u001a\u00020X2\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0016J\u0012\u0010\\\u001a\u00020X2\b\u0010]\u001a\u0004\u0018\u00010ZH\u0016J\u0012\u0010^\u001a\u00020X2\b\u0010]\u001a\u0004\u0018\u00010ZH\u0016J\u0012\u0010_\u001a\u00020X2\b\u0010]\u001a\u0004\u0018\u00010ZH\u0016J\u0010\u0010`\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0012\u0010a\u001a\u00020X2\b\u0010]\u001a\u0004\u0018\u00010ZH\u0016J\u001a\u0010b\u001a\u0004\u0018\u00010;2\u0006\u0010c\u001a\u00020\u00132\u0006\u0010d\u001a\u00020\u0013H\u0004J\u001a\u0010e\u001a\u0004\u0018\u00010E2\u0006\u0010c\u001a\u00020\u00132\u0006\u0010d\u001a\u00020\u0013H\u0004J\"\u0010f\u001a\u0004\u0018\u00010A2\u0006\u0010c\u001a\u00020\u00132\u0006\u0010d\u001a\u00020\u00132\u0006\u0010g\u001a\u00020\u0013H\u0004J\b\u0010h\u001a\u00020XH\u0004J\b\u0010i\u001a\u00020XH\u0004J\b\u0010j\u001a\u00020XH\u0004J\u0010\u0010k\u001a\u0002012\u0006\u0010l\u001a\u00020mH\u0004J\u0012\u0010n\u001a\u00020X2\b\u0010o\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010p\u001a\u00020X2\u0006\u0010q\u001a\u00020(H\u0016J\b\u0010r\u001a\u00020XH\u0016J\u0010\u0010s\u001a\u00020X2\u0006\u0010l\u001a\u00020mH\u0014R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001a\u0010\u001e\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017R\u001a\u0010!\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010\u0017R\u001a\u0010$\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0015\"\u0004\b&\u0010\u0017R\u001a\u0010'\u001a\u00020(X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0015\"\u0004\b/\u0010\u0017R\u001a\u00100\u001a\u000201X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u000201X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00103\"\u0004\b8\u00105R\"\u00109\u001a\n\u0012\u0004\u0012\u00020;\u0018\u00010:X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\"\u0010@\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010:X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010=\"\u0004\bC\u0010?R\"\u0010D\u001a\n\u0012\u0004\u0012\u00020E\u0018\u00010:X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010=\"\u0004\bG\u0010?R\u001c\u0010H\u001a\u0004\u0018\u00010IX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u001a\u0010N\u001a\u000201X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u00103\"\u0004\bP\u00105R\u001a\u0010Q\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010\u0015\"\u0004\bS\u0010\u0017R\u001a\u0010T\u001a\u000201X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u00103\"\u0004\bV\u00105\u00a8\u0006y"}, d2={"Ljugglinglab/core/LadderDiagram;", "Ljavax/swing/JPanel;", "Ljugglinglab/core/AnimationPanel$AnimationAttachment;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "p", "Ljugglinglab/jml/JMLPattern;", "<init>", "(Ljugglinglab/jml/JMLPattern;)V", "ap", "Ljugglinglab/core/AnimationPanel;", "getAp", "()Ljugglinglab/core/AnimationPanel;", "setAp", "(Ljugglinglab/core/AnimationPanel;)V", "pat", "getPat", "()Ljugglinglab/jml/JMLPattern;", "ladderWidth", "", "getLadderWidth", "()I", "setLadderWidth", "(I)V", "ladderHeight", "getLadderHeight", "setLadderHeight", "rightX", "getRightX", "setRightX", "leftX", "getLeftX", "setLeftX", "jugglerDeltaX", "getJugglerDeltaX", "setJugglerDeltaX", "guiState", "getGuiState", "setGuiState", "simTime", "", "getSimTime", "()D", "setSimTime", "(D)V", "trackerY", "getTrackerY", "setTrackerY", "hasSwitchSymmetry", "", "getHasSwitchSymmetry", "()Z", "setHasSwitchSymmetry", "(Z)V", "hasSwitchdelaySymmetry", "getHasSwitchdelaySymmetry", "setHasSwitchdelaySymmetry", "ladderEventItems", "Ljava/util/ArrayList;", "Ljugglinglab/core/LadderDiagram$LadderEventItem;", "getLadderEventItems", "()Ljava/util/ArrayList;", "setLadderEventItems", "(Ljava/util/ArrayList;)V", "ladderPathItems", "Ljugglinglab/core/LadderDiagram$LadderPathItem;", "getLadderPathItems", "setLadderPathItems", "ladderPositionItems", "Ljugglinglab/core/LadderDiagram$LadderPositionItem;", "getLadderPositionItems", "setLadderPositionItems", "im", "Ljava/awt/image/BufferedImage;", "getIm", "()Ljava/awt/image/BufferedImage;", "setIm", "(Ljava/awt/image/BufferedImage;)V", "imageValid", "getImageValid", "setImageValid", "framesUntilImageDraw", "getFramesUntilImageDraw", "setFramesUntilImageDraw", "animPaused", "getAnimPaused", "setAnimPaused", "mousePressed", "", "me", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseClicked", "e", "mouseEntered", "mouseExited", "mouseDragged", "mouseMoved", "getSelectedLadderEvent", "x", "y", "getSelectedLadderPosition", "getSelectedLadderPath", "slop", "updateTrackerPosition", "createView", "updateView", "paintLadder", "gr", "Ljava/awt/Graphics;", "setAnimationPanel", "animPanel", "setTime", "t", "repaintAttachment", "paintComponent", "LadderItem", "LadderEventItem", "LadderPathItem", "LadderPositionItem", "Companion", "jugglinglab"})
public class LadderDiagram
extends JPanel
implements AnimationPanel.AnimationAttachment,
MouseListener,
MouseMotionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AnimationPanel ap;
    @NotNull
    private final JMLPattern pat;
    private int ladderWidth;
    private int ladderHeight;
    private int rightX;
    private int leftX;
    private int jugglerDeltaX;
    private int guiState;
    private double simTime;
    private int trackerY;
    private boolean hasSwitchSymmetry;
    private boolean hasSwitchdelaySymmetry;
    @Nullable
    private ArrayList<LadderEventItem> ladderEventItems;
    @Nullable
    private ArrayList<LadderPathItem> ladderPathItems;
    @Nullable
    private ArrayList<LadderPositionItem> ladderPositionItems;
    @Nullable
    private BufferedImage im;
    private boolean imageValid;
    private int framesUntilImageDraw;
    private boolean animPaused;
    public static final int MAX_JUGGLERS = 8;
    protected static final int LADDER_WIDTH_PER_JUGGLER = 150;
    protected static final int LADDER_MIN_WIDTH_PER_JUGGLER = 60;
    @NotNull
    private static final Font MSGFONT = new Font("SansSerif", 0, 12);
    protected static final int BORDER_TOP = 25;
    protected static final int TRANSITION_RADIUS = 5;
    protected static final int PATH_SLOP = 5;
    protected static final int POSITION_RADIUS = 5;
    protected static final double BORDER_SIDES = 0.15;
    protected static final double JUGGLER_SEPARATION = 0.45;
    protected static final double SELFTHROW_WIDTH = 0.25;
    @Nullable
    private static final Color COLOR_BACKGROUND = Color.white;
    @Nullable
    private static final Color COLOR_HANDS = Color.black;
    @Nullable
    private static final Color COLOR_POSITIONS = Color.black;
    @Nullable
    private static final Color COLOR_SYMMETRIES = Color.lightGray;
    @Nullable
    private static final Color COLOR_TRACKER = Color.red;
    protected static final int IMAGE_DRAW_WAIT = 5;
    protected static final int STATE_INACTIVE = 0;
    protected static final int STATE_MOVING_TRACKER = 1;

    public LadderDiagram(@NotNull JMLPattern p) {
        Intrinsics.checkNotNullParameter(p, "p");
        this.trackerY = 25;
        this.setBackground(COLOR_BACKGROUND);
        this.setOpaque(false);
        this.pat = p;
        int jugglers = this.pat.getNumberOfJugglers();
        if (jugglers > 8) {
            String string = JugglingLab.INSTANCE.getGuistrings().getString("Too_many_jugglers");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String template = string;
            Object[] objectArray = new Object[]{8};
            Object[] arguments = objectArray;
            String message = MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length));
            int mwidth = 20 + this.getFontMetrics(MSGFONT).stringWidth(message);
            this.setPreferredSize(new Dimension(mwidth, 1));
            this.setMinimumSize(new Dimension(mwidth, 1));
        } else {
            int prefWidth = 150 * jugglers;
            int minWidth = 60 * jugglers;
            double[] dArray = new double[]{1.0, 1.0, 0.85, 0.72, 0.65, 0.55};
            double[] widthMult = dArray;
            prefWidth = (int)((double)prefWidth * (jugglers >= widthMult.length ? 0.5 : widthMult[jugglers]));
            prefWidth = Math.max(prefWidth, minWidth);
            this.setPreferredSize(new Dimension(prefWidth, 1));
            this.setMinimumSize(new Dimension(minWidth, 1));
            this.pat.layoutPattern();
            this.createView();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    @Nullable
    protected final AnimationPanel getAp() {
        return this.ap;
    }

    protected final void setAp(@Nullable AnimationPanel animationPanel) {
        this.ap = animationPanel;
    }

    @NotNull
    protected final JMLPattern getPat() {
        return this.pat;
    }

    protected final int getLadderWidth() {
        return this.ladderWidth;
    }

    protected final void setLadderWidth(int n) {
        this.ladderWidth = n;
    }

    protected final int getLadderHeight() {
        return this.ladderHeight;
    }

    protected final void setLadderHeight(int n) {
        this.ladderHeight = n;
    }

    protected final int getRightX() {
        return this.rightX;
    }

    protected final void setRightX(int n) {
        this.rightX = n;
    }

    protected final int getLeftX() {
        return this.leftX;
    }

    protected final void setLeftX(int n) {
        this.leftX = n;
    }

    protected final int getJugglerDeltaX() {
        return this.jugglerDeltaX;
    }

    protected final void setJugglerDeltaX(int n) {
        this.jugglerDeltaX = n;
    }

    protected final int getGuiState() {
        return this.guiState;
    }

    protected final void setGuiState(int n) {
        this.guiState = n;
    }

    protected final double getSimTime() {
        return this.simTime;
    }

    protected final void setSimTime(double d) {
        this.simTime = d;
    }

    protected final int getTrackerY() {
        return this.trackerY;
    }

    protected final void setTrackerY(int n) {
        this.trackerY = n;
    }

    protected final boolean getHasSwitchSymmetry() {
        return this.hasSwitchSymmetry;
    }

    protected final void setHasSwitchSymmetry(boolean bl) {
        this.hasSwitchSymmetry = bl;
    }

    protected final boolean getHasSwitchdelaySymmetry() {
        return this.hasSwitchdelaySymmetry;
    }

    protected final void setHasSwitchdelaySymmetry(boolean bl) {
        this.hasSwitchdelaySymmetry = bl;
    }

    @Nullable
    protected final ArrayList<LadderEventItem> getLadderEventItems() {
        return this.ladderEventItems;
    }

    protected final void setLadderEventItems(@Nullable ArrayList<LadderEventItem> arrayList) {
        this.ladderEventItems = arrayList;
    }

    @Nullable
    protected final ArrayList<LadderPathItem> getLadderPathItems() {
        return this.ladderPathItems;
    }

    protected final void setLadderPathItems(@Nullable ArrayList<LadderPathItem> arrayList) {
        this.ladderPathItems = arrayList;
    }

    @Nullable
    protected final ArrayList<LadderPositionItem> getLadderPositionItems() {
        return this.ladderPositionItems;
    }

    protected final void setLadderPositionItems(@Nullable ArrayList<LadderPositionItem> arrayList) {
        this.ladderPositionItems = arrayList;
    }

    @Nullable
    protected final BufferedImage getIm() {
        return this.im;
    }

    protected final void setIm(@Nullable BufferedImage bufferedImage) {
        this.im = bufferedImage;
    }

    protected final boolean getImageValid() {
        return this.imageValid;
    }

    protected final void setImageValid(boolean bl) {
        this.imageValid = bl;
    }

    protected final int getFramesUntilImageDraw() {
        return this.framesUntilImageDraw;
    }

    protected final void setFramesUntilImageDraw(int n) {
        this.framesUntilImageDraw = n;
    }

    protected final boolean getAnimPaused() {
        return this.animPaused;
    }

    protected final void setAnimPaused(boolean bl) {
        this.animPaused = bl;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent me) {
        block5: {
            block6: {
                Intrinsics.checkNotNullParameter(me, "me");
                if (this.ap == null) break block5;
                AnimationPanel animationPanel = this.ap;
                Intrinsics.checkNotNull(animationPanel);
                if (animationPanel.getWritingGIF()) break block6;
                AnimationPanel animationPanel2 = this.ap;
                Intrinsics.checkNotNull(animationPanel2);
                if (animationPanel2.getEngineAnimating()) break block5;
            }
            return;
        }
        int my = me.getY();
        my = Math.min(Math.max(my, 25), this.ladderHeight - 25);
        this.guiState = 1;
        this.trackerY = my;
        if (this.ap != null) {
            double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.ladderHeight - 50);
            double newtime = (double)(my - 25) * scale;
            AnimationPanel animationPanel = this.ap;
            Intrinsics.checkNotNull(animationPanel);
            this.animPaused = animationPanel.isPaused();
            AnimationPanel animationPanel3 = this.ap;
            Intrinsics.checkNotNull(animationPanel3);
            animationPanel3.setPaused(true);
            AnimationPanel animationPanel4 = this.ap;
            Intrinsics.checkNotNull(animationPanel4);
            animationPanel4.setTime(newtime);
        }
        this.repaint();
        if (this.ap != null) {
            AnimationPanel animationPanel = this.ap;
            Intrinsics.checkNotNull(animationPanel);
            animationPanel.repaint();
        }
    }

    @Override
    public void mouseReleased(@Nullable MouseEvent me) {
        block4: {
            block5: {
                if (this.ap == null) break block4;
                AnimationPanel animationPanel = this.ap;
                Intrinsics.checkNotNull(animationPanel);
                if (animationPanel.getWritingGIF()) break block5;
                AnimationPanel animationPanel2 = this.ap;
                Intrinsics.checkNotNull(animationPanel2);
                if (animationPanel2.getEngineAnimating()) break block4;
            }
            return;
        }
        this.guiState = 0;
        if (this.ap != null) {
            AnimationPanel animationPanel = this.ap;
            Intrinsics.checkNotNull(animationPanel);
            animationPanel.setPaused(this.animPaused);
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(@Nullable MouseEvent e) {
    }

    @Override
    public void mouseEntered(@Nullable MouseEvent e) {
    }

    @Override
    public void mouseExited(@Nullable MouseEvent e) {
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent me) {
        block4: {
            block5: {
                Intrinsics.checkNotNullParameter(me, "me");
                if (this.ap == null) break block4;
                AnimationPanel animationPanel = this.ap;
                Intrinsics.checkNotNull(animationPanel);
                if (animationPanel.getWritingGIF()) break block5;
                AnimationPanel animationPanel2 = this.ap;
                Intrinsics.checkNotNull(animationPanel2);
                if (animationPanel2.getEngineAnimating()) break block4;
            }
            return;
        }
        int my = me.getY();
        this.trackerY = my = Math.min(Math.max(my, 25), this.ladderHeight - 25);
        this.repaint();
        if (this.ap != null) {
            double scale = (this.pat.getLoopEndTime() - this.pat.getLoopStartTime()) / (double)(this.ladderHeight - 50);
            double newtime = (double)(my - 25) * scale;
            AnimationPanel animationPanel = this.ap;
            Intrinsics.checkNotNull(animationPanel);
            animationPanel.setTime(newtime);
            AnimationPanel animationPanel3 = this.ap;
            Intrinsics.checkNotNull(animationPanel3);
            animationPanel3.repaint();
        }
    }

    @Override
    public void mouseMoved(@Nullable MouseEvent e) {
    }

    @Nullable
    protected final LadderEventItem getSelectedLadderEvent(int x, int y) {
        ArrayList<LadderEventItem> arrayList = this.ladderEventItems;
        Intrinsics.checkNotNull(arrayList);
        Iterator<LadderEventItem> iterator2 = arrayList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<LadderEventItem> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            LadderEventItem item;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (x < item.getXlow() || x > item.getXhigh() || y < item.getYlow() || y > item.getYhigh()) continue;
            return item;
        }
        return null;
    }

    @Nullable
    protected final LadderPositionItem getSelectedLadderPosition(int x, int y) {
        ArrayList<LadderPositionItem> arrayList = this.ladderPositionItems;
        Intrinsics.checkNotNull(arrayList);
        Iterator<LadderPositionItem> iterator2 = arrayList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<LadderPositionItem> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            LadderPositionItem item;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (x < item.getXLow() || x > item.getXHigh() || y < item.getYLow() || y > item.getYHigh()) continue;
            return item;
        }
        return null;
    }

    @Nullable
    protected final LadderPathItem getSelectedLadderPath(int x, int y, int slop) {
        LadderPathItem result = null;
        double dmin = 0.0;
        if (y < 25 - slop || y > this.ladderHeight - 25 + slop) {
            return null;
        }
        ArrayList<LadderPathItem> arrayList = this.ladderPathItems;
        Intrinsics.checkNotNull(arrayList);
        Iterator<LadderPathItem> iterator2 = arrayList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<LadderPathItem> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            LadderPathItem item;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            double d = 0.0;
            if (item.getType() == 3) {
                if (y < item.getYStart() - slop || y > item.getYEnd() + slop) continue;
                d = (x - item.getXCenter()) * (x - item.getXCenter()) + (y - item.getYCenter()) * (y - item.getYCenter());
                d = Math.abs(Math.sqrt(d) - (double)item.getRadius());
            } else {
                int xmin = Math.min(item.getXStart(), item.getXEnd());
                int xmax = Math.max(item.getXStart(), item.getXEnd());
                if (x < xmin - slop || x > xmax + slop || y < item.getYStart() - slop || y > item.getYEnd() + slop) continue;
                d = (item.getXEnd() - item.getXStart()) * (y - item.getYStart()) - (x - item.getXStart()) * (item.getYEnd() - item.getYStart());
                d = Math.abs(d) / Math.sqrt((item.getXEnd() - item.getXStart()) * (item.getXEnd() - item.getXStart()) + (item.getYEnd() - item.getYStart()) * (item.getYEnd() - item.getYStart()));
            }
            if ((int)d >= slop || result != null && !(d < dmin)) continue;
            result = item;
            dmin = d;
        }
        return result;
    }

    protected final void updateTrackerPosition() {
        double loopStart = this.pat.getLoopStartTime();
        double loopEnd = this.pat.getLoopEndTime();
        this.trackerY = (int)(0.5 + (double)(this.ladderHeight - 50) * (this.simTime - loopStart) / (loopEnd - loopStart)) + 25;
    }

    protected final void createView() {
        JMLPosition pos;
        int i2;
        JMLEvent eventlist;
        this.hasSwitchdelaySymmetry = false;
        this.hasSwitchSymmetry = false;
        Iterator<JMLSymmetry> iterator2 = this.pat.getSymmetries().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<JMLSymmetry> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            JMLSymmetry sym;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            switch (sym.getType()) {
                case 2: {
                    this.hasSwitchSymmetry = true;
                    break;
                }
                case 3: {
                    this.hasSwitchdelaySymmetry = true;
                }
            }
        }
        double loopStart = this.pat.getLoopStartTime();
        double loopEnd = this.pat.getLoopEndTime();
        this.ladderEventItems = new ArrayList();
        JMLEvent ev = eventlist = this.pat.getEventList();
        while (true) {
            JMLEvent jMLEvent = ev;
            Intrinsics.checkNotNull(jMLEvent);
            if (!(jMLEvent.getT() < loopStart)) break;
            ev = ev.getNext();
        }
        while (true) {
            JMLEvent jMLEvent = ev;
            Intrinsics.checkNotNull(jMLEvent);
            if (!(jMLEvent.getT() < loopEnd)) break;
            LadderEventItem item = new LadderEventItem();
            item.setType(1);
            item.setEventitem(item);
            item.setEvent(ev);
            ArrayList<LadderEventItem> arrayList = this.ladderEventItems;
            Intrinsics.checkNotNull(arrayList);
            arrayList.add(item);
            int n = ev.getNumberOfTransitions();
            for (i2 = 0; i2 < n; ++i2) {
                LadderEventItem item2 = new LadderEventItem();
                item2.setType(2);
                item2.setEventitem(item);
                item2.setEvent(ev);
                item2.setTransnum(i2);
                ArrayList<LadderEventItem> arrayList2 = this.ladderEventItems;
                Intrinsics.checkNotNull(arrayList2);
                arrayList2.add(item2);
            }
            ev = ev.getNext();
        }
        this.ladderPathItems = new ArrayList();
        ev = eventlist;
        while (true) {
            JMLEvent jMLEvent = ev;
            Intrinsics.checkNotNull(jMLEvent);
            if (!(jMLEvent.getT() <= loopEnd)) break;
            i2 = ev.getNumberOfTransitions();
            for (int i3 = 0; i3 < i2; ++i3) {
                JMLTransition tr = ev.getTransition(i3);
                PathLink opl = tr.getOutgoingPathLink();
                if (opl == null) continue;
                LadderPathItem item = new LadderPathItem();
                item.setTransnumStart(i3);
                item.setStartEvent(opl.getStartEvent());
                item.setEndEvent(opl.getEndEvent());
                if (opl.isInHand()) {
                    item.setType(5);
                } else {
                    JMLEvent jMLEvent2 = item.getStartEvent();
                    Intrinsics.checkNotNull(jMLEvent2);
                    int n = jMLEvent2.getJuggler();
                    JMLEvent jMLEvent3 = item.getEndEvent();
                    Intrinsics.checkNotNull(jMLEvent3);
                    if (n != jMLEvent3.getJuggler()) {
                        item.setType(6);
                    } else {
                        JMLEvent jMLEvent4 = item.getStartEvent();
                        Intrinsics.checkNotNull(jMLEvent4);
                        int n2 = jMLEvent4.getHand();
                        JMLEvent jMLEvent5 = item.getEndEvent();
                        Intrinsics.checkNotNull(jMLEvent5);
                        item.setType(n2 == jMLEvent5.getHand() ? 3 : 4);
                    }
                }
                item.setPathNum(opl.getPathNum());
                item.setColor(Color.black);
                ArrayList<LadderPathItem> arrayList = this.ladderPathItems;
                Intrinsics.checkNotNull(arrayList);
                arrayList.add(item);
            }
            ev = ev.getNext();
        }
        this.ladderPositionItems = new ArrayList();
        for (pos = this.pat.getPositionList(); pos != null && pos.getT() < loopStart; pos = pos.getNext()) {
        }
        while (pos != null && pos.getT() < loopEnd) {
            LadderPositionItem item = new LadderPositionItem();
            item.setType(7);
            item.setPosition(pos);
            ArrayList<LadderPositionItem> arrayList = this.ladderPositionItems;
            Intrinsics.checkNotNull(arrayList);
            arrayList.add(item);
            pos = pos.getNext();
        }
        this.updateView();
    }

    protected final void updateView() {
        int eventY;
        LadderItem item;
        Dimension dim = this.getSize();
        this.ladderWidth = dim.width;
        this.ladderHeight = dim.height;
        double scale = (double)this.ladderWidth / (0.3 + 0.45 * (double)(this.pat.getNumberOfJugglers() - 1) + (double)this.pat.getNumberOfJugglers());
        this.leftX = (int)(scale * 0.15 + 0.5);
        this.rightX = (int)(scale * 1.15 + 0.5);
        this.jugglerDeltaX = (int)(scale * 1.45 + 0.5);
        this.imageValid = false;
        this.im = null;
        this.framesUntilImageDraw = 5;
        double loopStart = this.pat.getLoopStartTime();
        double loopEnd = this.pat.getLoopEndTime();
        ArrayList<LadderEventItem> arrayList = this.ladderEventItems;
        Intrinsics.checkNotNull(arrayList);
        Iterator<LadderEventItem> iterator2 = arrayList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<LadderItem> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            JMLEvent ev;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            JMLEvent jMLEvent = ev = ((LadderEventItem)item).getEvent();
            Intrinsics.checkNotNull(jMLEvent);
            int eventX = (jMLEvent.getHand() == 1 ? this.leftX : this.rightX) + (ev.getJuggler() - 1) * this.jugglerDeltaX - 5;
            eventY = (int)(0.5 + (double)(this.ladderHeight - 50) * (ev.getT() - loopStart) / (loopEnd - loopStart)) + 25 - 5;
            if (item.getType() != 1) {
                eventX = ev.getHand() == 1 ? (eventX += 10 * (((LadderEventItem)item).getTransnum() + 1)) : (eventX -= 10 * (((LadderEventItem)item).getTransnum() + 1));
            }
            ((LadderEventItem)item).setXlow(eventX);
            ((LadderEventItem)item).setXhigh(eventX + 10);
            ((LadderEventItem)item).setYlow(eventY);
            ((LadderEventItem)item).setYhigh(eventY + 10);
        }
        ArrayList<LadderPathItem> arrayList2 = this.ladderPathItems;
        Intrinsics.checkNotNull(arrayList2);
        Iterator<LadderPathItem> iterator4 = arrayList2.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
        iterator3 = iterator4;
        while (iterator3.hasNext()) {
            LadderItem ladderItem = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(ladderItem, "next(...)");
            item = (LadderPathItem)ladderItem;
            JMLEvent jMLEvent = ((LadderPathItem)item).getStartEvent();
            Intrinsics.checkNotNull(jMLEvent);
            int n = jMLEvent.getHand() == 1 ? this.leftX + (((LadderPathItem)item).getTransnumStart() + 1) * 2 * 5 : this.rightX - (((LadderPathItem)item).getTransnumStart() + 1) * 2 * 5;
            JMLEvent jMLEvent2 = ((LadderPathItem)item).getStartEvent();
            Intrinsics.checkNotNull(jMLEvent2);
            ((LadderPathItem)item).setXStart(n + (jMLEvent2.getJuggler() - 1) * this.jugglerDeltaX);
            double d = this.ladderHeight - 50;
            JMLEvent jMLEvent3 = ((LadderPathItem)item).getStartEvent();
            Intrinsics.checkNotNull(jMLEvent3);
            ((LadderPathItem)item).setYStart((int)(0.5 + d * (jMLEvent3.getT() - loopStart) / (loopEnd - loopStart)) + 25);
            double d2 = this.ladderHeight - 50;
            JMLEvent jMLEvent4 = ((LadderPathItem)item).getEndEvent();
            Intrinsics.checkNotNull(jMLEvent4);
            ((LadderPathItem)item).setYEnd((int)(0.5 + d2 * (jMLEvent4.getT() - loopStart) / (loopEnd - loopStart)) + 25);
            int slot = 0;
            JMLEvent jMLEvent5 = ((LadderPathItem)item).getEndEvent();
            Intrinsics.checkNotNull(jMLEvent5);
            eventY = jMLEvent5.getNumberOfTransitions();
            for (int j = 0; j < eventY; ++j) {
                JMLEvent jMLEvent6 = ((LadderPathItem)item).getEndEvent();
                Intrinsics.checkNotNull(jMLEvent6);
                JMLTransition temp = jMLEvent6.getTransition(j);
                if (temp.getPath() != ((LadderPathItem)item).getPathNum()) continue;
                slot = j;
                break;
            }
            JMLEvent jMLEvent7 = ((LadderPathItem)item).getEndEvent();
            Intrinsics.checkNotNull(jMLEvent7);
            int n2 = jMLEvent7.getHand() == 1 ? this.leftX + (slot + 1) * 2 * 5 : this.rightX - (slot + 1) * 2 * 5;
            JMLEvent jMLEvent8 = ((LadderPathItem)item).getEndEvent();
            Intrinsics.checkNotNull(jMLEvent8);
            ((LadderPathItem)item).setXEnd(n2 + (jMLEvent8.getJuggler() - 1) * this.jugglerDeltaX);
            if (item.getType() != 3) continue;
            double a = 0.5 * Math.sqrt((double)((((LadderPathItem)item).getXStart() - ((LadderPathItem)item).getXEnd()) * (((LadderPathItem)item).getXStart() - ((LadderPathItem)item).getXEnd())) + (double)((((LadderPathItem)item).getYStart() - ((LadderPathItem)item).getYEnd()) * (((LadderPathItem)item).getYStart() - ((LadderPathItem)item).getYEnd())));
            double xt = 0.5 * (double)(((LadderPathItem)item).getXStart() + ((LadderPathItem)item).getXEnd());
            double yt = 0.5 * (double)(((LadderPathItem)item).getYStart() + ((LadderPathItem)item).getYEnd());
            double b = 0.25 * ((double)this.ladderWidth / (double)this.pat.getNumberOfJugglers());
            double d3 = 0.5 * (a * a / b - b);
            if (d3 < 0.5 * b) {
                d3 = 0.5 * b;
            }
            JMLEvent jMLEvent9 = ((LadderPathItem)item).getEndEvent();
            Intrinsics.checkNotNull(jMLEvent9);
            double mult = jMLEvent9.getHand() == 1 ? -1.0 : 1.0;
            double xc = xt + mult * d3 * (yt - (double)((LadderPathItem)item).getYStart()) / a;
            double yc = yt + mult * d3 * ((double)((LadderPathItem)item).getXStart() - xt) / a;
            double rad = Math.sqrt(((double)((LadderPathItem)item).getXStart() - xc) * ((double)((LadderPathItem)item).getXStart() - xc) + ((double)((LadderPathItem)item).getYStart() - yc) * ((double)((LadderPathItem)item).getYStart() - yc));
            ((LadderPathItem)item).setXCenter((int)(0.5 + xc));
            ((LadderPathItem)item).setYCenter((int)(0.5 + yc));
            ((LadderPathItem)item).setRadius((int)(0.5 + rad));
        }
        ArrayList<LadderPositionItem> arrayList3 = this.ladderPositionItems;
        Intrinsics.checkNotNull(arrayList3);
        Iterator<LadderPositionItem> iterator5 = arrayList3.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator5, "iterator(...)");
        iterator3 = iterator5;
        while (iterator3.hasNext()) {
            LadderItem ladderItem = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(ladderItem, "next(...)");
            item = (LadderPositionItem)ladderItem;
            JMLPosition pos = ((LadderPositionItem)item).getPosition();
            int n = (this.leftX + this.rightX) / 2;
            JMLPosition jMLPosition = pos;
            Intrinsics.checkNotNull(jMLPosition);
            int positionX = n + (jMLPosition.getJuggler() - 1) * this.jugglerDeltaX - 5;
            int positionY = (int)(0.5 + (double)(this.ladderHeight - 50) * (pos.getT() - loopStart) / (loopEnd - loopStart)) + 25 - 5;
            ((LadderPositionItem)item).setXLow(positionX);
            ((LadderPositionItem)item).setXHigh(positionX + 10);
            ((LadderPositionItem)item).setYLow(positionY);
            ((LadderPositionItem)item).setYHigh(positionY + 10);
        }
        this.updateTrackerPosition();
    }

    /*
     * Unable to fully structure code
     */
    protected final boolean paintLadder(@NotNull Graphics gr) {
        Intrinsics.checkNotNullParameter(gr, "gr");
        if (this.pat.getNumberOfJugglers() > 8) {
            dim = this.getSize();
            gr.setFont(LadderDiagram.MSGFONT);
            fm = gr.getFontMetrics();
            v0 = JugglingLab.INSTANCE.getGuistrings().getString("Too_many_jugglers");
            Intrinsics.checkNotNullExpressionValue(v0, "getString(...)");
            template = v0;
            var6_8 = new Object[]{8};
            arguments = var6_8;
            message = MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length));
            mwidth = fm.stringWidth(message);
            x = Math.max((dim.width - mwidth) / 2, 0);
            y = (dim.height + fm.getHeight()) / 2;
            gr.setColor(LadderDiagram.COLOR_BACKGROUND);
            gr.fillRect(0, 0, dim.width, dim.height);
            gr.setColor(Color.black);
            gr.drawString(message, x, y);
            return false;
        }
        g = gr;
        dim = this.getSize();
        if (dim.width != this.ladderWidth || dim.height != this.ladderHeight) {
            this.updateView();
        }
        if (this.imageValid) ** GOTO lbl-1000
        this.framesUntilImageDraw += -1;
        if (this.framesUntilImageDraw <= 0) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = rebuildLadderImage = false;
        }
        if (rebuildLadderImage) {
            v2 = this.im = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.ladderWidth, this.ladderHeight, 1);
            Intrinsics.checkNotNull(v2);
            v3 = v2.getGraphics();
            Intrinsics.checkNotNullExpressionValue(v3, "getGraphics(...)");
            g = v3;
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        }
        if (!this.imageValid) {
            g.setColor(LadderDiagram.COLOR_BACKGROUND);
            g.fillRect(0, 0, this.ladderWidth, this.ladderHeight);
            g.setColor(LadderDiagram.COLOR_SYMMETRIES);
            g.drawLine(0, 25, this.ladderWidth, 25);
            g.drawLine(0, this.ladderHeight - 25, this.ladderWidth, this.ladderHeight - 25);
            if (this.hasSwitchSymmetry) {
                g.drawLine(this.leftX, this.ladderHeight - 12, this.ladderWidth - this.leftX, this.ladderHeight - 12);
                g.drawLine(this.leftX, this.ladderHeight - 12, this.leftX + this.leftX, this.ladderHeight - 18);
                g.drawLine(this.leftX, this.ladderHeight - 12, this.leftX + this.leftX, this.ladderHeight - 6);
                g.drawLine(this.ladderWidth - this.leftX, this.ladderHeight - 12, this.ladderWidth - 2 * this.leftX, this.ladderHeight - 18);
                g.drawLine(this.ladderWidth - this.leftX, this.ladderHeight - 12, this.ladderWidth - 2 * this.leftX, this.ladderHeight - 6);
            }
            if (this.hasSwitchdelaySymmetry) {
                g.drawLine(0, this.ladderHeight / 2, this.ladderWidth, this.ladderHeight / 2);
            }
            g.setColor(LadderDiagram.COLOR_HANDS);
            message = this.pat.getNumberOfJugglers();
            for (j = 0; j < message; ++j) {
                for (i = -1; i < 2; ++i) {
                    g.drawLine(this.leftX + i + j * this.jugglerDeltaX, 25, this.leftX + i + j * this.jugglerDeltaX, this.ladderHeight - 25);
                    g.drawLine(this.rightX + i + j * this.jugglerDeltaX, 25, this.rightX + i + j * this.jugglerDeltaX, this.ladderHeight - 25);
                }
            }
            clip = g.getClip();
            v4 = this.ladderPathItems;
            Intrinsics.checkNotNull(v4);
            v5 = v4.iterator();
            Intrinsics.checkNotNullExpressionValue(v5, "iterator(...)");
            message = v5;
            while (message.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(message.next(), "next(...)");
                g.setColor(item.getColor());
                if (item.getType() != 6) {
                    v6 = item.getStartEvent();
                    Intrinsics.checkNotNull(v6);
                    v7 = this.leftX + (v6.getJuggler() - 1) * this.jugglerDeltaX;
                    v8 = item.getStartEvent();
                    Intrinsics.checkNotNull(v8);
                    g.clipRect(v7, 25, this.rightX - this.leftX + (v8.getJuggler() - 1) * this.jugglerDeltaX, this.ladderHeight - 50);
                }
                if (item.getType() == 4) {
                    g.drawLine(item.getXStart(), item.getYStart(), item.getXEnd(), item.getYEnd());
                } else if (item.getType() == 5) {
                    g.drawLine(item.getXStart(), item.getYStart(), item.getXEnd(), item.getYEnd());
                } else if (item.getType() == 6) {
                    v9 = g.create();
                    Intrinsics.checkNotNull(v9, "null cannot be cast to non-null type java.awt.Graphics2D");
                    gdash = (Graphics2D)v9;
                    var10_23 = new float[]{7.0f, 3.0f};
                    dashed = new BasicStroke(2.0f, 0, 2, 1.0f, var10_23, 0.0f);
                    gdash.setStroke(dashed);
                    gdash.clipRect(this.leftX, 25, this.ladderWidth - this.leftX, this.ladderHeight - 50);
                    gdash.drawLine(item.getXStart(), item.getYStart(), item.getXEnd(), item.getYEnd());
                    gdash.dispose();
                } else if (item.getType() == 3 && item.getYEnd() >= 25) {
                    v10 = item.getStartEvent();
                    Intrinsics.checkNotNull(v10);
                    v11 = this.leftX + (v10.getJuggler() - 1) * this.jugglerDeltaX;
                    v12 = item.getYStart();
                    v13 = item.getStartEvent();
                    Intrinsics.checkNotNull(v13);
                    g.clipRect(v11, v12, this.rightX - this.leftX + (v13.getJuggler() - 1) * this.jugglerDeltaX, item.getYEnd() - item.getYStart());
                    g.drawOval(item.getXCenter() - item.getRadius(), item.getYCenter() - item.getRadius(), 2 * item.getRadius(), 2 * item.getRadius());
                }
                g.setClip((Shape)clip);
            }
        }
        if (rebuildLadderImage) {
            this.imageValid = true;
        }
        if (this.imageValid) {
            gr.drawImage(this.im, 0, 0, this);
        }
        v14 = this.ladderPositionItems;
        Intrinsics.checkNotNull(v14);
        v15 = v14.iterator();
        Intrinsics.checkNotNullExpressionValue(v15, "iterator(...)");
        clip = v15;
        while (clip.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(clip.next(), "next(...)");
            if (item.getYLow() < 25 && item.getYHigh() > this.ladderHeight + 25) continue;
            gr.setColor(LadderDiagram.COLOR_BACKGROUND);
            gr.fillRect(item.getXLow(), item.getYLow(), item.getXHigh() - item.getXLow(), item.getYHigh() - item.getYLow());
            gr.setColor(LadderDiagram.COLOR_POSITIONS);
            gr.drawRect(item.getXLow(), item.getYLow(), item.getXHigh() - item.getXLow(), item.getYHigh() - item.getYLow());
        }
        v16 = this.ap;
        animpropnum = v16 != null && (v16 = v16.getAnimator()) != null ? v16.getAnimPropNum() : null;
        v17 = this.ladderEventItems;
        Intrinsics.checkNotNull(v17);
        v18 = v17.iterator();
        Intrinsics.checkNotNullExpressionValue(v18, "iterator(...)");
        var6_10 = v18;
        while (var6_10.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(var6_10.next(), "next(...)");
            if (item.getType() == 1) {
                gr.setColor(LadderDiagram.COLOR_HANDS);
                gr.fillOval(item.getXlow(), item.getYlow(), item.getXhigh() - item.getXlow(), item.getYhigh() - item.getYlow());
                continue;
            }
            if (item.getYlow() < 25 && item.getYhigh() > this.ladderHeight + 25) continue;
            if (animpropnum == null) {
                gr.setColor(LadderDiagram.COLOR_BACKGROUND);
            } else {
                v19 = item.getEvent();
                Intrinsics.checkNotNull(v19);
                tr = v19.getTransition(item.getTransnum());
                propnum = animpropnum[tr.getPath() - 1];
                v20 = this.pat.getProp(propnum);
                Intrinsics.checkNotNull(v20);
                gr.setColor(v20.getEditorColor());
            }
            gr.fillOval(item.getXlow(), item.getYlow(), item.getXhigh() - item.getXlow(), item.getYhigh() - item.getYlow());
            gr.setColor(LadderDiagram.COLOR_HANDS);
            gr.drawOval(item.getXlow(), item.getYlow(), item.getXhigh() - item.getXlow(), item.getYhigh() - item.getYlow());
        }
        gr.setColor(LadderDiagram.COLOR_TRACKER);
        gr.drawLine(0, this.trackerY, this.ladderWidth, this.trackerY);
        return true;
    }

    @Override
    public void setAnimationPanel(@Nullable AnimationPanel animPanel) {
        this.ap = animPanel;
    }

    @Override
    public void setTime(double t2) {
        if (this.simTime == t2) {
            return;
        }
        this.simTime = t2;
        this.updateTrackerPosition();
        this.repaint();
    }

    @Override
    public void repaintAttachment() {
        this.repaint();
    }

    @Override
    protected void paintComponent(@NotNull Graphics gr) {
        Intrinsics.checkNotNullParameter(gr, "gr");
        if (gr instanceof Graphics2D) {
            ((Graphics2D)gr).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.paintLadder(gr);
        if (this.guiState == 1) {
            gr.setColor(COLOR_TRACKER);
            gr.drawString(JLFunc.jlToStringRounded(this.simTime, 2) + " s", this.ladderWidth / 2 - 18, this.trackerY - 5);
        }
    }

    @Nullable
    protected static final Color getCOLOR_TRACKER() {
        return Companion.getCOLOR_TRACKER();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0084T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u00158\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u0003\u001a\u0004\b \u0010\u0017R\u000e\u0010!\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ljugglinglab/core/LadderDiagram$Companion;", "", "<init>", "()V", "MAX_JUGGLERS", "", "LADDER_WIDTH_PER_JUGGLER", "LADDER_MIN_WIDTH_PER_JUGGLER", "MSGFONT", "Ljava/awt/Font;", "getMSGFONT", "()Ljava/awt/Font;", "BORDER_TOP", "TRANSITION_RADIUS", "PATH_SLOP", "POSITION_RADIUS", "BORDER_SIDES", "", "JUGGLER_SEPARATION", "SELFTHROW_WIDTH", "COLOR_BACKGROUND", "Ljava/awt/Color;", "getCOLOR_BACKGROUND", "()Ljava/awt/Color;", "COLOR_HANDS", "getCOLOR_HANDS", "COLOR_POSITIONS", "getCOLOR_POSITIONS", "COLOR_SYMMETRIES", "getCOLOR_SYMMETRIES", "COLOR_TRACKER", "getCOLOR_TRACKER$annotations", "getCOLOR_TRACKER", "IMAGE_DRAW_WAIT", "STATE_INACTIVE", "STATE_MOVING_TRACKER", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Font getMSGFONT() {
            return MSGFONT;
        }

        @Nullable
        protected final Color getCOLOR_BACKGROUND() {
            return COLOR_BACKGROUND;
        }

        @Nullable
        protected final Color getCOLOR_HANDS() {
            return COLOR_HANDS;
        }

        @Nullable
        protected final Color getCOLOR_POSITIONS() {
            return COLOR_POSITIONS;
        }

        @Nullable
        protected final Color getCOLOR_SYMMETRIES() {
            return COLOR_SYMMETRIES;
        }

        @Nullable
        protected final Color getCOLOR_TRACKER() {
            return COLOR_TRACKER;
        }

        @JvmStatic
        protected static /* synthetic */ void getCOLOR_TRACKER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0007\"\u0004\b \u0010\tR\u0011\u0010!\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007\u00a8\u0006#"}, d2={"Ljugglinglab/core/LadderDiagram$LadderEventItem;", "Ljugglinglab/core/LadderDiagram$LadderItem;", "<init>", "()V", "xlow", "", "getXlow", "()I", "setXlow", "(I)V", "xhigh", "getXhigh", "setXhigh", "ylow", "getYlow", "setYlow", "yhigh", "getYhigh", "setYhigh", "eventitem", "getEventitem", "()Ljugglinglab/core/LadderDiagram$LadderEventItem;", "setEventitem", "(Ljugglinglab/core/LadderDiagram$LadderEventItem;)V", "event", "Ljugglinglab/jml/JMLEvent;", "getEvent", "()Ljugglinglab/jml/JMLEvent;", "setEvent", "(Ljugglinglab/jml/JMLEvent;)V", "transnum", "getTransnum", "setTransnum", "hashCode", "getHashCode", "jugglinglab"})
    public static final class LadderEventItem
    extends LadderItem {
        private int xlow;
        private int xhigh;
        private int ylow;
        private int yhigh;
        @Nullable
        private LadderEventItem eventitem;
        @Nullable
        private JMLEvent event;
        private int transnum;

        public final int getXlow() {
            return this.xlow;
        }

        public final void setXlow(int n) {
            this.xlow = n;
        }

        public final int getXhigh() {
            return this.xhigh;
        }

        public final void setXhigh(int n) {
            this.xhigh = n;
        }

        public final int getYlow() {
            return this.ylow;
        }

        public final void setYlow(int n) {
            this.ylow = n;
        }

        public final int getYhigh() {
            return this.yhigh;
        }

        public final void setYhigh(int n) {
            this.yhigh = n;
        }

        @Nullable
        public final LadderEventItem getEventitem() {
            return this.eventitem;
        }

        public final void setEventitem(@Nullable LadderEventItem ladderEventItem) {
            this.eventitem = ladderEventItem;
        }

        @Nullable
        public final JMLEvent getEvent() {
            return this.event;
        }

        public final void setEvent(@Nullable JMLEvent jMLEvent) {
            this.event = jMLEvent;
        }

        public final int getTransnum() {
            return this.transnum;
        }

        public final void setTransnum(int n) {
            this.transnum = n;
        }

        public final int getHashCode() {
            JMLEvent jMLEvent = this.event;
            Intrinsics.checkNotNull(jMLEvent);
            return jMLEvent.getHashCode() * 17 + this.getType() * 23 + this.transnum * 27;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Ljugglinglab/core/LadderDiagram$LadderItem;", "", "<init>", "()V", "type", "", "getType", "()I", "setType", "(I)V", "Companion", "jugglinglab"})
    public static class LadderItem {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int type;
        public static final int TYPE_EVENT = 1;
        public static final int TYPE_TRANSITION = 2;
        public static final int TYPE_SELF = 3;
        public static final int TYPE_CROSS = 4;
        public static final int TYPE_HOLD = 5;
        public static final int TYPE_PASS = 6;
        public static final int TYPE_POSITION = 7;

        public final int getType() {
            return this.type;
        }

        public final void setType(int n) {
            this.type = n;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljugglinglab/core/LadderDiagram$LadderItem$Companion;", "", "<init>", "()V", "TYPE_EVENT", "", "TYPE_TRANSITION", "TYPE_SELF", "TYPE_CROSS", "TYPE_HOLD", "TYPE_PASS", "TYPE_POSITION", "jugglinglab"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001a\u0010\u0019\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001a\u0010+\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0007\"\u0004\b-\u0010\tR\u001a\u0010.\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0007\"\u0004\b0\u0010\t\u00a8\u00061"}, d2={"Ljugglinglab/core/LadderDiagram$LadderPathItem;", "Ljugglinglab/core/LadderDiagram$LadderItem;", "<init>", "()V", "xStart", "", "getXStart", "()I", "setXStart", "(I)V", "yStart", "getYStart", "setYStart", "xEnd", "getXEnd", "setXEnd", "yEnd", "getYEnd", "setYEnd", "xCenter", "getXCenter", "setXCenter", "yCenter", "getYCenter", "setYCenter", "radius", "getRadius", "setRadius", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "startEvent", "Ljugglinglab/jml/JMLEvent;", "getStartEvent", "()Ljugglinglab/jml/JMLEvent;", "setStartEvent", "(Ljugglinglab/jml/JMLEvent;)V", "endEvent", "getEndEvent", "setEndEvent", "transnumStart", "getTransnumStart", "setTransnumStart", "pathNum", "getPathNum", "setPathNum", "jugglinglab"})
    public static final class LadderPathItem
    extends LadderItem {
        private int xStart;
        private int yStart;
        private int xEnd;
        private int yEnd;
        private int xCenter;
        private int yCenter;
        private int radius;
        @Nullable
        private Color color;
        @Nullable
        private JMLEvent startEvent;
        @Nullable
        private JMLEvent endEvent;
        private int transnumStart;
        private int pathNum;

        public final int getXStart() {
            return this.xStart;
        }

        public final void setXStart(int n) {
            this.xStart = n;
        }

        public final int getYStart() {
            return this.yStart;
        }

        public final void setYStart(int n) {
            this.yStart = n;
        }

        public final int getXEnd() {
            return this.xEnd;
        }

        public final void setXEnd(int n) {
            this.xEnd = n;
        }

        public final int getYEnd() {
            return this.yEnd;
        }

        public final void setYEnd(int n) {
            this.yEnd = n;
        }

        public final int getXCenter() {
            return this.xCenter;
        }

        public final void setXCenter(int n) {
            this.xCenter = n;
        }

        public final int getYCenter() {
            return this.yCenter;
        }

        public final void setYCenter(int n) {
            this.yCenter = n;
        }

        public final int getRadius() {
            return this.radius;
        }

        public final void setRadius(int n) {
            this.radius = n;
        }

        @Nullable
        public final Color getColor() {
            return this.color;
        }

        public final void setColor(@Nullable Color color) {
            this.color = color;
        }

        @Nullable
        public final JMLEvent getStartEvent() {
            return this.startEvent;
        }

        public final void setStartEvent(@Nullable JMLEvent jMLEvent) {
            this.startEvent = jMLEvent;
        }

        @Nullable
        public final JMLEvent getEndEvent() {
            return this.endEvent;
        }

        public final void setEndEvent(@Nullable JMLEvent jMLEvent) {
            this.endEvent = jMLEvent;
        }

        public final int getTransnumStart() {
            return this.transnumStart;
        }

        public final void setTransnumStart(int n) {
            this.transnumStart = n;
        }

        public final int getPathNum() {
            return this.pathNum;
        }

        public final void setPathNum(int n) {
            this.pathNum = n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007\u00a8\u0006\u001b"}, d2={"Ljugglinglab/core/LadderDiagram$LadderPositionItem;", "Ljugglinglab/core/LadderDiagram$LadderItem;", "<init>", "()V", "xLow", "", "getXLow", "()I", "setXLow", "(I)V", "xHigh", "getXHigh", "setXHigh", "yLow", "getYLow", "setYLow", "yHigh", "getYHigh", "setYHigh", "position", "Ljugglinglab/jml/JMLPosition;", "getPosition", "()Ljugglinglab/jml/JMLPosition;", "setPosition", "(Ljugglinglab/jml/JMLPosition;)V", "hashCode", "getHashCode", "jugglinglab"})
    public static final class LadderPositionItem
    extends LadderItem {
        private int xLow;
        private int xHigh;
        private int yLow;
        private int yHigh;
        @Nullable
        private JMLPosition position;

        public final int getXLow() {
            return this.xLow;
        }

        public final void setXLow(int n) {
            this.xLow = n;
        }

        public final int getXHigh() {
            return this.xHigh;
        }

        public final void setXHigh(int n) {
            this.xHigh = n;
        }

        public final int getYLow() {
            return this.yLow;
        }

        public final void setYLow(int n) {
            this.yLow = n;
        }

        public final int getYHigh() {
            return this.yHigh;
        }

        public final void setYHigh(int n) {
            this.yHigh = n;
        }

        @Nullable
        public final JMLPosition getPosition() {
            return this.position;
        }

        public final void setPosition(@Nullable JMLPosition jMLPosition) {
            this.position = jMLPosition;
        }

        public final int getHashCode() {
            JMLPosition jMLPosition = this.position;
            Intrinsics.checkNotNull(jMLPosition);
            return jMLPosition.getHashCode();
        }
    }
}

