/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.PatternWindow;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPatternList;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.View;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\u0018\u0000 >2\u00020\u0001:\u0004;<=>B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0013\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\u0006\u0010'\u001a\u00020%J\u0010\u0010(\u001a\u00020%2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ.\u0010)\u001a\u00020%2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010+2\b\u0010-\u001a\u0004\u0018\u00010+2\b\u0010.\u001a\u0004\u0018\u00010+J\b\u0010/\u001a\u000200H\u0002J\u0018\u00101\u001a\u00020%2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001bH\u0002J\u0010\u00105\u001a\u00020%2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00106\u001a\u00020%2\u0006\u00102\u001a\u000203H\u0002J\u001c\u00107\u001a\u00020\u001e2\b\u00108\u001a\u0004\u0018\u00010+2\b\u00109\u001a\u0004\u0018\u00010+H\u0002J\b\u0010:\u001a\u00020%H\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0019\u001a\u0016\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aj\n\u0012\u0004\u0012\u00020\u001b\u0018\u0001`\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Ljugglinglab/core/PatternListPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "parentFrame", "Ljavax/swing/JFrame;", "(Ljavax/swing/JFrame;)V", "target", "Ljugglinglab/view/View;", "(Ljugglinglab/view/View;)V", "patternList", "Ljugglinglab/jml/JMLPatternList;", "getPatternList", "()Ljugglinglab/jml/JMLPatternList;", "animTarget", "list", "Ljavax/swing/JList;", "Ljugglinglab/jml/JMLPatternList$PatternRecord;", "hasUnsavedChanges", "", "getHasUnsavedChanges", "()Z", "setHasUnsavedChanges", "(Z)V", "didPopup", "popupPatterns", "Ljava/util/ArrayList;", "Ljugglinglab/core/PatternWindow;", "Lkotlin/collections/ArrayList;", "dialog", "Ljavax/swing/JDialog;", "tf", "Ljavax/swing/JTextField;", "okButton", "Ljavax/swing/JButton;", "draggingOut", "makePanel", "", "launchAnimation", "clearList", "setTargetView", "addPattern", "display", "", "animprefs", "notation", "anim", "makePopupMenu", "Ljavax/swing/JPopupMenu;", "insertPattern", "row", "", "pw", "insertText", "changeDisplayText", "makeDialog", "title", "defaultText", "checkSelection", "PatternTransferHandler", "PatternTransferable", "PatternCellRenderer", "Companion", "jugglinglab"})
public final class PatternListPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JMLPatternList patternList = new JMLPatternList();
    @Nullable
    private JFrame parentFrame;
    @Nullable
    private View animTarget;
    private JList<JMLPatternList.PatternRecord> list;
    private boolean hasUnsavedChanges;
    private boolean didPopup;
    @Nullable
    private ArrayList<PatternWindow> popupPatterns;
    @Nullable
    private JDialog dialog;
    @Nullable
    private JTextField tf;
    @Nullable
    private JButton okButton;
    private boolean draggingOut;
    @NotNull
    private static final Font FONT_NOPATTERN = new Font("SanSerif", 3, 14);
    @NotNull
    private static final Font FONT_PATTERN = new Font("Monospaced", 0, 14);
    @NotNull
    private static final Font FONT_PATTERN_POPUP = new Font("Monospaced", 2, 14);
    @NotNull
    private static final DataFlavor PATTERN_FLAVOR = new DataFlavor(JMLPatternList.PatternRecord.class, "Juggling Lab pattern record");
    @NotNull
    private static final List<String> popupItems;
    @NotNull
    private static final List<String> popupCommands;

    private PatternListPanel() {
        this.makePanel();
        this.setOpaque(false);
    }

    @NotNull
    public final JMLPatternList getPatternList() {
        return this.patternList;
    }

    public final boolean getHasUnsavedChanges() {
        return this.hasUnsavedChanges;
    }

    public final void setHasUnsavedChanges(boolean bl) {
        this.hasUnsavedChanges = bl;
    }

    public PatternListPanel(@Nullable JFrame parentFrame) {
        this();
        this.parentFrame = parentFrame;
    }

    public PatternListPanel(@Nullable View target) {
        this();
        this.setTargetView(target);
    }

    private final void makePanel() {
        this.list = new JList(this.patternList.getModel());
        JList<JMLPatternList.PatternRecord> jList = this.list;
        if (jList == null) {
            Intrinsics.throwUninitializedPropertyAccessException("list");
            jList = null;
        }
        jList.getSelectionModel().setSelectionMode(0);
        JList<JMLPatternList.PatternRecord> jList2 = this.list;
        if (jList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("list");
            jList2 = null;
        }
        jList2.setCellRenderer(new PatternCellRenderer());
        JList<JMLPatternList.PatternRecord> jList3 = this.list;
        if (jList3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("list");
            jList3 = null;
        }
        jList3.setDragEnabled(true);
        JList<JMLPatternList.PatternRecord> jList4 = this.list;
        if (jList4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("list");
            jList4 = null;
        }
        jList4.setTransferHandler(new PatternTransferHandler());
        JList<JMLPatternList.PatternRecord> jList5 = this.list;
        if (jList5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("list");
            jList5 = null;
        }
        JScrollPane pane = new JScrollPane(jList5);
        JList<JMLPatternList.PatternRecord> jList6 = this.list;
        if (jList6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("list");
            jList6 = null;
        }
        jList6.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ PatternListPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent me) {
                int row;
                Intrinsics.checkNotNullParameter(me, "me");
                JList jList = PatternListPanel.access$getList$p(this.this$0);
                if (jList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("list");
                    jList = null;
                }
                if ((row = jList.locationToIndex(me.getPoint())) >= 0) {
                    JList jList2 = PatternListPanel.access$getList$p(this.this$0);
                    if (jList2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("list");
                        jList2 = null;
                    }
                    jList2.setSelectedIndex(row);
                }
                PatternListPanel.access$setDidPopup$p(this.this$0, false);
                if (me.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = PatternListPanel.access$makePopupMenu(this.this$0);
                    JList jList3 = PatternListPanel.access$getList$p(this.this$0);
                    if (jList3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("list");
                        jList3 = null;
                    }
                    jPopupMenu.show(jList3, me.getX(), me.getY());
                    PatternListPanel.access$setDidPopup$p(this.this$0, true);
                }
            }

            public void mouseReleased(MouseEvent me) {
                Intrinsics.checkNotNullParameter(me, "me");
                if (me.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = PatternListPanel.access$makePopupMenu(this.this$0);
                    JList jList = PatternListPanel.access$getList$p(this.this$0);
                    if (jList == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("list");
                        jList = null;
                    }
                    jPopupMenu.show(jList, me.getX(), me.getY());
                    PatternListPanel.access$setDidPopup$p(this.this$0, true);
                }
                if (!PatternListPanel.access$getDidPopup$p(this.this$0)) {
                    PatternListPanel.access$launchAnimation(this.this$0);
                    PatternListPanel.access$checkSelection(this.this$0);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
    }

    private final void launchAnimation() {
        try {
            int row;
            JList<JMLPatternList.PatternRecord> jList = this.list;
            if (jList == null) {
                Intrinsics.throwUninitializedPropertyAccessException("list");
                jList = null;
            }
            if ((row = jList.getSelectedIndex()) < 0 || row == this.patternList.getModel().size() - 1) {
                return;
            }
            JMLPattern jMLPattern = this.patternList.getPatternForLine(row);
            if (jMLPattern == null) {
                return;
            }
            JMLPattern pat = jMLPattern;
            pat.layoutPattern();
            if (PatternWindow.Companion.bringToFront(pat.getHashCode())) {
                return;
            }
            AnimationPrefs ap = this.patternList.getAnimationPrefsForLine(row);
            if (this.animTarget != null) {
                View view = this.animTarget;
                Intrinsics.checkNotNull(view);
                view.restartView(pat, ap);
                v3 = Unit.INSTANCE;
            } else {
                v3 = new PatternWindow(pat.getTitle(), pat, ap);
            }
        }
        catch (JuggleExceptionUser jeu) {
            ErrorDialog.INSTANCE.handleUserException(this, jeu.getMessage());
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.INSTANCE.handleFatalException(jei);
        }
    }

    public final void clearList() {
        if (this.patternList.getModel().size() > 1) {
            this.hasUnsavedChanges = true;
        }
        this.patternList.clearModel();
    }

    public final void setTargetView(@Nullable View target) {
        this.animTarget = target;
    }

    public final void addPattern(@Nullable String display, @Nullable String animprefs, @Nullable String notation, @Nullable String anim) {
        this.patternList.addLine(-1, display, animprefs, notation, anim, null, null);
    }

    private final JPopupMenu makePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JList<JMLPatternList.PatternRecord> jList = this.list;
        if (jList == null) {
            Intrinsics.throwUninitializedPropertyAccessException("list");
            jList = null;
        }
        int row = jList.getSelectedIndex();
        ArrayList<Frame> pupatterns = new ArrayList<Frame>();
        this.popupPatterns = pupatterns;
        Iterator<Frame> iterator2 = ArrayIteratorKt.iterator(Frame.getFrames());
        while (iterator2.hasNext()) {
            Frame fr = iterator2.next();
            if (!fr.isVisible() || !(fr instanceof PatternWindow)) continue;
            pupatterns.add(fr);
        }
        ActionListener al = arg_0 -> PatternListPanel.makePopupMenu$lambda$0(this, pupatterns, arg_0);
        int n = ((Collection)popupItems).size();
        for (int i2 = 0; i2 < n; ++i2) {
            Iterator iterator3;
            String name = popupItems.get(i2);
            if (name == null) {
                popup.addSeparator();
                continue;
            }
            JMenuItem item = new JMenuItem(JugglingLab.INSTANCE.getGuistrings().getString(StringsKt.replace$default(name, ' ', '_', false, 4, null)));
            item.setActionCommand(popupCommands.get(i2));
            item.addActionListener(al);
            if ((Intrinsics.areEqual(popupCommands.get(i2), "displaytext") || Intrinsics.areEqual(popupCommands.get(i2), "remove")) && row < 0) {
                item.setEnabled(false);
            }
            if ((Intrinsics.areEqual(popupCommands.get(i2), "displaytext") || Intrinsics.areEqual(popupCommands.get(i2), "remove")) && row == this.patternList.getModel().size() - 1) {
                item.setEnabled(false);
            }
            if (Intrinsics.areEqual(popupCommands.get(i2), "insertpattern") && pupatterns.isEmpty()) {
                item.setEnabled(false);
            }
            popup.add(item);
            if (!Intrinsics.areEqual(popupCommands.get(i2), "insertpattern")) continue;
            int patnum = 0;
            Intrinsics.checkNotNullExpressionValue(pupatterns.iterator(), "iterator(...)");
            while (iterator3.hasNext()) {
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                PatternWindow pw = (PatternWindow)e;
                JMenuItem pitem = new JMenuItem("   " + pw.getTitle());
                pitem.setActionCommand("pat" + patnum);
                pitem.addActionListener(al);
                pitem.setFont(FONT_PATTERN_POPUP);
                popup.add(pitem);
                ++patnum;
            }
        }
        popup.setBorder(new BevelBorder(0));
        popup.addPopupMenuListener(new PopupMenuListener(this){
            final /* synthetic */ PatternListPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                PatternListPanel.access$checkSelection(this.this$0);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        return popup;
    }

    private final void insertPattern(int row, PatternWindow pw) {
        String animprefs;
        String display = pw.getTitle();
        String string = animprefs = pw.getAnimationPrefs().toString();
        Intrinsics.checkNotNull(string);
        if (((CharSequence)string).length() == 0) {
            animprefs = null;
        }
        String notation = "jml";
        String anim = null;
        JMLPattern jMLPattern = pw.getPattern();
        Intrinsics.checkNotNull(jMLPattern);
        JMLPattern pattern = jMLPattern;
        JMLNode patnode = null;
        try {
            JMLNode jMLNode = pattern.getRootNode();
            Intrinsics.checkNotNull(jMLNode);
            patnode = jMLNode.findNode("pattern");
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.INSTANCE.handleFatalException(jei);
            return;
        }
        JMLNode jMLNode = patnode;
        Intrinsics.checkNotNull(jMLNode);
        JMLNode infonode = jMLNode.findNode("info");
        if (pattern.getHasBasePattern() && !pattern.isBasePatternEdited()) {
            notation = pattern.getBasePatternNotation();
            anim = pattern.getBasePatternConfig();
            patnode = null;
        }
        this.patternList.addLine(row, display, animprefs, notation, anim, patnode, infonode);
        if (row < 0) {
            JList<JMLPatternList.PatternRecord> jList = this.list;
            if (jList == null) {
                Intrinsics.throwUninitializedPropertyAccessException("list");
                jList = null;
            }
            jList.setSelectedIndex(this.patternList.getModel().size() - 2);
        } else {
            JList<JMLPatternList.PatternRecord> jList = this.list;
            if (jList == null) {
                Intrinsics.throwUninitializedPropertyAccessException("list");
                jList = null;
            }
            jList.setSelectedIndex(row);
        }
        this.hasUnsavedChanges = true;
    }

    private final void insertText(int row) {
        this.makeDialog(JugglingLab.INSTANCE.getGuistrings().getString("PLDIALOG_Insert_text"), "");
        JButton jButton = this.okButton;
        Intrinsics.checkNotNull(jButton);
        jButton.addActionListener(arg_0 -> PatternListPanel.insertText$lambda$1(this, row, arg_0));
        JDialog jDialog = this.dialog;
        Intrinsics.checkNotNull(jDialog);
        jDialog.setVisible(true);
    }

    private final void changeDisplayText(int row) {
        JMLPatternList.PatternRecord rec = this.patternList.getModel().get(row);
        this.makeDialog(JugglingLab.INSTANCE.getGuistrings().getString("PLDIALOG_Change_display_text"), rec.getDisplay());
        JButton jButton = this.okButton;
        Intrinsics.checkNotNull(jButton);
        jButton.addActionListener(arg_0 -> PatternListPanel.changeDisplayText$lambda$2(rec, this, row, arg_0));
        JDialog jDialog = this.dialog;
        Intrinsics.checkNotNull(jDialog);
        jDialog.setVisible(true);
    }

    private final JDialog makeDialog(String title, String defaultText) {
        JDialog jDialog = this.dialog = new JDialog(this.parentFrame, title, true);
        Intrinsics.checkNotNull(jDialog);
        JDialog d = jDialog;
        GridBagLayout gb = new GridBagLayout();
        d.getContentPane().setLayout(gb);
        JTextField jTextField = this.tf = new JTextField(20);
        Intrinsics.checkNotNull(jTextField);
        jTextField.setText(defaultText);
        this.okButton = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("OK"));
        d.getContentPane().add(this.tf);
        gb.setConstraints(this.tf, JLFunc.constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        d.getContentPane().add(this.okButton);
        gb.setConstraints(this.okButton, JLFunc.constraints(22, 0, 1, new Insets(10, 10, 10, 10)));
        d.getRootPane().setDefaultButton(this.okButton);
        d.pack();
        d.setResizable(false);
        d.setLocationRelativeTo(this);
        d.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ PatternListPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowClosing(WindowEvent e) {
                PatternListPanel.access$checkSelection(this.this$0);
            }
        });
        return d;
    }

    private final void checkSelection() {
        JList<JMLPatternList.PatternRecord> jList = this.list;
        if (jList == null) {
            Intrinsics.throwUninitializedPropertyAccessException("list");
            jList = null;
        }
        if (jList.getSelectedIndex() == this.patternList.getModel().size() - 1) {
            JList<JMLPatternList.PatternRecord> jList2 = this.list;
            if (jList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("list");
                jList2 = null;
            }
            jList2.clearSelection();
        }
        this.popupPatterns = null;
        this.dialog = null;
        this.tf = null;
        this.okButton = null;
    }

    /*
     * Unable to fully structure code
     */
    private static final void makePopupMenu$lambda$0(PatternListPanel this$0, ArrayList $pupatterns, ActionEvent ae) {
        v0 = ae;
        Intrinsics.checkNotNull(v0);
        command = v0.getActionCommand();
        v1 = this$0.list;
        if (v1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("list");
            v1 = null;
        }
        row1 = v1.getSelectedIndex();
        var5_5 = command;
        if (var5_5 == null) ** GOTO lbl48
        tmp = -1;
        switch (var5_5.hashCode()) {
            case 1715285231: {
                if (var5_5.equals("displaytext")) {
                    tmp = 1;
                }
                break;
            }
            case 967115622: {
                if (var5_5.equals("inserttext")) {
                    tmp = 2;
                }
                break;
            }
            case 1327716023: {
                if (var5_5.equals("insertpattern")) {
                    tmp = 3;
                }
                break;
            }
            case -934610812: {
                if (var5_5.equals("remove")) {
                    tmp = 4;
                }
                break;
            }
        }
        switch (tmp) {
            case 2: {
                this$0.insertText(row1);
                break;
            }
            case 1: {
                this$0.changeDisplayText(row1);
                break;
            }
            case 4: {
                this$0.patternList.getModel().remove(row1);
                break;
            }
            default: {
lbl48:
                // 2 sources

                Intrinsics.checkNotNull(command);
                v2 = command.substring(3);
                Intrinsics.checkNotNullExpressionValue(v2, "substring(...)");
                patnum = Integer.parseInt(v2);
                v3 = $pupatterns.get(patnum);
                Intrinsics.checkNotNullExpressionValue(v3, "get(...)");
                pw = (PatternWindow)v3;
                this$0.insertPattern(row1, pw);
            }
            case 3: 
        }
    }

    private static final void insertText$lambda$1(PatternListPanel this$0, int $row, ActionEvent actionEvent) {
        JTextField jTextField = this$0.tf;
        Intrinsics.checkNotNull(jTextField);
        String display = jTextField.getText();
        JDialog jDialog = this$0.dialog;
        Intrinsics.checkNotNull(jDialog);
        jDialog.dispose();
        this$0.patternList.addLine($row, display, null, null, null, null, null);
        if ($row < 0) {
            JList<JMLPatternList.PatternRecord> jList = this$0.list;
            if (jList == null) {
                Intrinsics.throwUninitializedPropertyAccessException("list");
                jList = null;
            }
            jList.setSelectedIndex(this$0.patternList.getSize() - 1);
        } else {
            JList<JMLPatternList.PatternRecord> jList = this$0.list;
            if (jList == null) {
                Intrinsics.throwUninitializedPropertyAccessException("list");
                jList = null;
            }
            jList.setSelectedIndex($row);
        }
        this$0.hasUnsavedChanges = true;
    }

    private static final void changeDisplayText$lambda$2(JMLPatternList.PatternRecord $rec, PatternListPanel this$0, int $row, ActionEvent actionEvent) {
        JTextField jTextField = this$0.tf;
        Intrinsics.checkNotNull(jTextField);
        String string = jTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        $rec.setDisplay(string);
        JDialog jDialog = this$0.dialog;
        Intrinsics.checkNotNull(jDialog);
        jDialog.dispose();
        this$0.patternList.getModel().set($row, $rec);
        this$0.hasUnsavedChanges = true;
    }

    public static final /* synthetic */ void access$setDidPopup$p(PatternListPanel $this, boolean bl) {
        $this.didPopup = bl;
    }

    public static final /* synthetic */ JPopupMenu access$makePopupMenu(PatternListPanel $this) {
        return $this.makePopupMenu();
    }

    public static final /* synthetic */ boolean access$getDidPopup$p(PatternListPanel $this) {
        return $this.didPopup;
    }

    public static final /* synthetic */ void access$launchAnimation(PatternListPanel $this) {
        $this.launchAnimation();
    }

    public static final /* synthetic */ void access$checkSelection(PatternListPanel $this) {
        $this.checkSelection();
    }

    static {
        String[] stringArray = new String[]{"PLPOPUP Insert text...", null, "PLPOPUP Insert pattern", null, "PLPOPUP Change display text...", null, "PLPOPUP Remove line"};
        popupItems = CollectionsKt.listOf(stringArray);
        stringArray = new String[]{"inserttext", null, "insertpattern", null, "displaytext", null, "remove"};
        popupCommands = CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljugglinglab/core/PatternListPanel$Companion;", "", "<init>", "()V", "FONT_NOPATTERN", "Ljava/awt/Font;", "getFONT_NOPATTERN", "()Ljava/awt/Font;", "FONT_PATTERN", "getFONT_PATTERN", "FONT_PATTERN_POPUP", "getFONT_PATTERN_POPUP", "PATTERN_FLAVOR", "Ljava/awt/datatransfer/DataFlavor;", "getPATTERN_FLAVOR", "()Ljava/awt/datatransfer/DataFlavor;", "popupItems", "", "", "popupCommands", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Font getFONT_NOPATTERN() {
            return FONT_NOPATTERN;
        }

        @NotNull
        public final Font getFONT_PATTERN() {
            return FONT_PATTERN;
        }

        @NotNull
        public final Font getFONT_PATTERN_POPUP() {
            return FONT_PATTERN_POPUP;
        }

        @NotNull
        public final DataFlavor getPATTERN_FLAVOR() {
            return PATTERN_FLAVOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Ljugglinglab/core/PatternListPanel$PatternCellRenderer;", "Ljavax/swing/JLabel;", "Ljavax/swing/ListCellRenderer;", "Ljugglinglab/jml/JMLPatternList$PatternRecord;", "<init>", "()V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "rec", "index", "", "isSelected", "", "cellHasFocus", "jugglinglab"})
    public static final class PatternCellRenderer
    extends JLabel
    implements ListCellRenderer<JMLPatternList.PatternRecord> {
        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends JMLPatternList.PatternRecord> list, @Nullable JMLPatternList.PatternRecord rec, int index, boolean isSelected, boolean cellHasFocus) {
            Intrinsics.checkNotNullParameter(list, "list");
            if (rec == null) {
                return this;
            }
            this.setFont(rec.getAnim() == null && rec.getPatnode() == null ? Companion.getFONT_NOPATTERN() : Companion.getFONT_PATTERN());
            this.setText(!(((CharSequence)rec.getDisplay()).length() == 0) ? rec.getDisplay() : " ");
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setOpaque(true);
            return this;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000f\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0005H\u0014\u00a8\u0006\u0013"}, d2={"Ljugglinglab/core/PatternListPanel$PatternTransferHandler;", "Ljavax/swing/TransferHandler;", "<init>", "(Ljugglinglab/core/PatternListPanel;)V", "getSourceActions", "", "c", "Ljavax/swing/JComponent;", "createTransferable", "Ljava/awt/datatransfer/Transferable;", "canImport", "", "info", "Ljavax/swing/TransferHandler$TransferSupport;", "importData", "exportDone", "", "data", "action", "jugglinglab"})
    @SourceDebugExtension(value={"SMAP\nPatternListPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatternListPanel.kt\njugglinglab/core/PatternListPanel$PatternTransferHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,563:1\n739#2,9:564\n37#3:573\n36#3,3:574\n*S KotlinDebug\n*F\n+ 1 PatternListPanel.kt\njugglinglab/core/PatternListPanel$PatternTransferHandler\n*L\n437#1:564,9\n437#1:573\n437#1:574,3\n*E\n"})
    public final class PatternTransferHandler
    extends TransferHandler {
        @Override
        public int getSourceActions(@Nullable JComponent c) {
            return 3;
        }

        @Override
        @Nullable
        protected Transferable createTransferable(@Nullable JComponent c) {
            int row;
            JList jList = PatternListPanel.this.list;
            if (jList == null) {
                Intrinsics.throwUninitializedPropertyAccessException("list");
                jList = null;
            }
            if ((row = jList.getSelectedIndex()) < 0 || row == PatternListPanel.this.getPatternList().getModel().size() - 1) {
                return null;
            }
            PatternListPanel.this.draggingOut = true;
            JMLPatternList.PatternRecord rec = PatternListPanel.this.getPatternList().getModel().get(row);
            Intrinsics.checkNotNull(rec);
            return new PatternTransferable(rec);
        }

        @Override
        public boolean canImport(@NotNull TransferHandler.TransferSupport info) {
            Intrinsics.checkNotNullParameter(info, "info");
            if (!info.isDrop()) {
                return false;
            }
            if (PatternListPanel.this.draggingOut) {
                info.setDropAction(2);
            } else {
                info.setDropAction(1);
            }
            if (info.isDataFlavorSupported(Companion.getPATTERN_FLAVOR())) {
                return true;
            }
            return info.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean importData(@NotNull TransferHandler.TransferSupport info) {
            Intrinsics.checkNotNullParameter(info, "info");
            if (!info.isDrop()) {
                return false;
            }
            TransferHandler.DropLocation dropLocation = info.getDropLocation();
            Intrinsics.checkNotNull(dropLocation, "null cannot be cast to non-null type javax.swing.JList.DropLocation");
            JList.DropLocation dl = (JList.DropLocation)dropLocation;
            int index = dl.getIndex();
            if (index < 0) {
                index = PatternListPanel.this.getPatternList().getModel().size() - 1;
            }
            Transferable t2 = info.getTransferable();
            try {
                if (t2.isDataFlavorSupported(Companion.getPATTERN_FLAVOR())) {
                    Object object = t2.getTransferData(Companion.getPATTERN_FLAVOR());
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type jugglinglab.jml.JMLPatternList.PatternRecord");
                    JMLPatternList.PatternRecord rec = (JMLPatternList.PatternRecord)object;
                    PatternListPanel.this.getPatternList().getModel().add(index, new JMLPatternList.PatternRecord(rec));
                    JList jList = PatternListPanel.this.list;
                    if (jList == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("list");
                        jList = null;
                    }
                    jList.setSelectedIndex(index);
                    PatternListPanel.this.setHasUnsavedChanges(true);
                    return true;
                }
                if (t2.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    JList jList;
                    void $this$toTypedArray$iv;
                    List list;
                    Collection $this$dropLastWhile$iv;
                    Object object = t2.getTransferData(DataFlavor.stringFlavor);
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
                    String s = (String)object;
                    Object object2 = ((Object)StringsKt.trimEnd((CharSequence)s)).toString();
                    Regex regex = new Regex("\n");
                    int n = 0;
                    object2 = regex.split((CharSequence)object2, n);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] lines = thisCollection$iv.toArray(new String[0]);
                    int n2 = lines.length + -1;
                    if (0 <= n2) {
                        do {
                            int i2 = n2--;
                            String string = lines[i2];
                            Intrinsics.checkNotNull(string);
                            JMLPatternList.PatternRecord rec = new JMLPatternList.PatternRecord(string, null, null, null, null, null, null);
                            PatternListPanel.this.getPatternList().getModel().add(index, rec);
                        } while (0 <= n2);
                    }
                    if ((jList = PatternListPanel.this.list) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("list");
                        jList = null;
                    }
                    jList.setSelectedIndex(index);
                    PatternListPanel.this.setHasUnsavedChanges(true);
                    return true;
                }
            }
            catch (Exception e) {
                ErrorDialog.INSTANCE.handleFatalException(e);
            }
            return false;
        }

        @Override
        protected void exportDone(@Nullable JComponent c, @Nullable Transferable data, int action) {
            if (action == 2) {
                if (!(data instanceof PatternTransferable)) {
                    return;
                }
                if (!PatternListPanel.this.getPatternList().getModel().removeElement(((PatternTransferable)data).getRec())) {
                    ErrorDialog.INSTANCE.handleFatalException(new JuggleExceptionInternal("PLP: exportDone()"));
                }
                PatternListPanel.this.setHasUnsavedChanges(true);
            }
            PatternListPanel.this.draggingOut = false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0015\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0012"}, d2={"Ljugglinglab/core/PatternListPanel$PatternTransferable;", "Ljava/awt/datatransfer/Transferable;", "rec", "Ljugglinglab/jml/JMLPatternList$PatternRecord;", "<init>", "(Ljugglinglab/jml/JMLPatternList$PatternRecord;)V", "getRec", "()Ljugglinglab/jml/JMLPatternList$PatternRecord;", "setRec", "getTransferData", "", "flavor", "Ljava/awt/datatransfer/DataFlavor;", "getTransferDataFlavors", "", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "jugglinglab"})
    public static final class PatternTransferable
    implements Transferable {
        @NotNull
        private JMLPatternList.PatternRecord rec;

        public PatternTransferable(@NotNull JMLPatternList.PatternRecord rec) {
            Intrinsics.checkNotNullParameter(rec, "rec");
            this.rec = rec;
        }

        @NotNull
        public final JMLPatternList.PatternRecord getRec() {
            return this.rec;
        }

        public final void setRec(@NotNull JMLPatternList.PatternRecord patternRecord) {
            Intrinsics.checkNotNullParameter(patternRecord, "<set-?>");
            this.rec = patternRecord;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Object getTransferData(@NotNull DataFlavor flavor) {
            String string;
            Intrinsics.checkNotNullParameter(flavor, "flavor");
            if (flavor.equals(Companion.getPATTERN_FLAVOR())) {
                return this.rec;
            }
            if (!flavor.equals(DataFlavor.stringFlavor)) return this.rec;
            if (this.rec.getAnim() != null) {
                String string2 = this.rec.getAnim();
                Intrinsics.checkNotNull(string2);
                if (!(((CharSequence)string2).length() == 0)) {
                    String string3 = this.rec.getAnim();
                    string = string3;
                    Intrinsics.checkNotNull(string3);
                    return string;
                }
            }
            string = this.rec.getDisplay();
            return string;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{Companion.getPATTERN_FLAVOR(), DataFlavor.stringFlavor};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter(flavor, "flavor");
            return flavor.equals(Companion.getPATTERN_FLAVOR()) || flavor.equals(DataFlavor.stringFlavor);
        }
    }
}

