/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import jugglinglab.JugglingLab;
import jugglinglab.core.ApplicationWindow;
import jugglinglab.core.PatternListPanel;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLParser;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0002()B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0013\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u001d\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0018H\u0002J\u0012\u0010%\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010'\u001a\u00020\u0018H\u0016R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ljugglinglab/core/PatternListWindow;", "Ljavax/swing/JFrame;", "Ljava/awt/event/ActionListener;", "title", "", "<init>", "(Ljava/lang/String;)V", "root", "Ljugglinglab/jml/JMLNode;", "(Ljugglinglab/jml/JMLNode;)V", "gen", "Ljava/lang/Thread;", "(Ljava/lang/String;Ljava/lang/Thread;)V", "value", "Ljugglinglab/core/PatternListPanel;", "patternListPanel", "getPatternListPanel", "()Ljugglinglab/core/PatternListPanel;", "Ljavax/swing/JMenu;", "windowMenu", "getWindowMenu", "()Ljavax/swing/JMenu;", "lastJmlFilename", "createContents", "", "setJmlFilename", "fname", "createMenus", "createFileMenu", "createHelpMenu", "actionPerformed", "ae", "Ljava/awt/event/ActionEvent;", "doMenuCommand", "action", "Ljugglinglab/core/PatternListWindow$MenuCommand;", "changeTitle", "setTitle", "newTitle", "dispose", "MenuCommand", "Companion", "jugglinglab"})
public final class PatternListWindow
extends JFrame
implements ActionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private PatternListPanel patternListPanel;
    @Nullable
    private JMenu windowMenu;
    @Nullable
    private String lastJmlFilename;
    private static final int NUM_TILES = 8;
    @NotNull
    private static final Point TILE_START = new Point(0, 620);
    @NotNull
    private static final Point TILE_OFFSET = new Point(25, 25);
    @NotNull
    private static ArrayList<Point> tileLocations = new ArrayList();
    private static int nextTileNum;
    @NotNull
    private static final List<String> fileItems;
    @NotNull
    private static final List<String> fileCommands;
    @NotNull
    private static final char[] fileShortcuts;
    @NotNull
    private static final List<String> helpItems;
    @NotNull
    private static final List<String> helpCommands;

    public PatternListWindow(@Nullable String title) {
        this.createMenus();
        this.createContents();
        this.getPatternListPanel().getPatternList().setTitle(title);
        this.setTitle(title);
        this.setLocation(PatternListWindow.Companion.getNextScreenLocation());
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    this.doMenuCommand(MenuCommand.FILE_CLOSE);
                }
                catch (JuggleException je) {
                    ErrorDialog.INSTANCE.handleFatalException(je);
                }
            }
        });
        SwingUtilities.invokeLater(PatternListWindow::_init_$lambda$0);
    }

    @NotNull
    public final PatternListPanel getPatternListPanel() {
        PatternListPanel patternListPanel = this.patternListPanel;
        if (patternListPanel != null) {
            return patternListPanel;
        }
        Intrinsics.throwUninitializedPropertyAccessException("patternListPanel");
        return null;
    }

    @Nullable
    public final JMenu getWindowMenu() {
        return this.windowMenu;
    }

    public PatternListWindow(@Nullable JMLNode root) {
        this("");
        if (root != null) {
            this.getPatternListPanel().getPatternList().readJML(root);
            this.setTitle(this.getPatternListPanel().getPatternList().getTitle());
        }
    }

    public PatternListWindow(@Nullable String title, @Nullable Thread gen) {
        this(title);
        if (gen != null) {
            final Thread generator = gen;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    try {
                        generator.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private final void createContents() {
        this.patternListPanel = new PatternListPanel(this);
        this.getPatternListPanel().setDoubleBuffered(true);
        this.setContentPane(this.getPatternListPanel());
        Locale loc = Locale.getDefault();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        this.setBackground(Color.white);
        this.setSize(300, 450);
    }

    public final void setJmlFilename(@Nullable String fname) {
        this.lastJmlFilename = fname;
    }

    private final void createMenus() {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu());
        this.windowMenu = new JMenu(JugglingLab.INSTANCE.getGuistrings().getString("Window"));
        mb.add(this.windowMenu);
        mb.add(this.createHelpMenu());
        this.setJMenuBar(mb);
    }

    private final JMenu createFileMenu() {
        JMenu filemenu = new JMenu(JugglingLab.INSTANCE.getGuistrings().getString("File"));
        int n = ((Collection)fileItems).size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (fileItems.get(i2) == null) {
                filemenu.addSeparator();
                continue;
            }
            ResourceBundle resourceBundle = JugglingLab.INSTANCE.getGuistrings();
            String string = fileItems.get(i2);
            Intrinsics.checkNotNull(string);
            JMenuItem fileitem = new JMenuItem(resourceBundle.getString(StringsKt.replace$default(string, ' ', '_', false, 4, null)));
            if (fileShortcuts[i2] != ' ') {
                fileitem.setAccelerator(KeyStroke.getKeyStroke((int)fileShortcuts[i2], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
            }
            fileitem.setActionCommand(fileCommands.get(i2));
            fileitem.addActionListener(this);
            filemenu.add(fileitem);
        }
        return filemenu;
    }

    private final JMenu createHelpMenu() {
        boolean includeAbout = !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.APP_ABOUT);
        String string = JugglingLab.INSTANCE.getGuistrings().getString("Help");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        Object menuname = string;
        if (JugglingLab.INSTANCE.isMacOS()) {
            menuname = (String)menuname + " ";
        }
        JMenu helpmenu = new JMenu((String)menuname);
        int n = helpItems.size();
        for (int i2 = includeAbout ? 0 : 1; i2 < n; ++i2) {
            if (helpItems.get(i2) == null) {
                helpmenu.addSeparator();
                continue;
            }
            ResourceBundle resourceBundle = JugglingLab.INSTANCE.getGuistrings();
            String string2 = helpItems.get(i2);
            Intrinsics.checkNotNull(string2);
            JMenuItem helpitem = new JMenuItem(resourceBundle.getString(StringsKt.replace$default(string2, ' ', '_', false, 4, null)));
            helpitem.setActionCommand(helpCommands.get(i2));
            helpitem.addActionListener(this);
            helpmenu.add(helpitem);
        }
        return helpmenu;
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent ae) {
        block37: {
            Intrinsics.checkNotNullParameter(ae, "ae");
            try {
                String string = ae.getActionCommand();
                if (string == null) break block37;
                int n = -1;
                switch (string.hashCode()) {
                    case 104714140: {
                        if (string.equals("newpl")) {
                            n = 1;
                        }
                        break;
                    }
                    case -909417873: {
                        if (string.equals("saveas")) {
                            n = 2;
                        }
                        break;
                    }
                    case 92611469: {
                        if (string.equals("about")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1012222381: {
                        if (string.equals("online")) {
                            n = 4;
                        }
                        break;
                    }
                    case 1201687819: {
                        if (string.equals("duplicate")) {
                            n = 5;
                        }
                        break;
                    }
                    case -1635394392: {
                        if (string.equals("changetitle")) {
                            n = 6;
                        }
                        break;
                    }
                    case 94756344: {
                        if (string.equals("close")) {
                            n = 7;
                        }
                        break;
                    }
                    case 3417674: {
                        if (string.equals("open")) {
                            n = 8;
                        }
                        break;
                    }
                    case -1048829181: {
                        if (string.equals("newpat")) {
                            n = 9;
                        }
                        break;
                    }
                    case -2071658454: {
                        if (string.equals("savetext")) {
                            n = 10;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 9: {
                        this.doMenuCommand(MenuCommand.FILE_NEWPAT);
                        break;
                    }
                    case 1: {
                        this.doMenuCommand(MenuCommand.FILE_NEWPL);
                        break;
                    }
                    case 8: {
                        this.doMenuCommand(MenuCommand.FILE_OPEN);
                        break;
                    }
                    case 2: {
                        this.doMenuCommand(MenuCommand.FILE_SAVE);
                        break;
                    }
                    case 10: {
                        this.doMenuCommand(MenuCommand.FILE_SAVETEXT);
                        break;
                    }
                    case 5: {
                        this.doMenuCommand(MenuCommand.FILE_DUPLICATE);
                        break;
                    }
                    case 6: {
                        this.doMenuCommand(MenuCommand.FILE_TITLE);
                        break;
                    }
                    case 7: {
                        this.doMenuCommand(MenuCommand.FILE_CLOSE);
                        break;
                    }
                    case 3: {
                        this.doMenuCommand(MenuCommand.HELP_ABOUT);
                        break;
                    }
                    case 4: {
                        this.doMenuCommand(MenuCommand.HELP_ONLINE);
                    }
                }
            }
            catch (JuggleExceptionUser je) {
                ErrorDialog.INSTANCE.handleUserException(this, je.getMessage());
            }
            catch (JuggleExceptionInternal jei) {
                ErrorDialog.INSTANCE.handleFatalException(jei);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doMenuCommand(MenuCommand action) throws JuggleExceptionUser, JuggleExceptionInternal {
        switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                ApplicationWindow.Companion.newPattern();
                break;
            }
            case 3: {
                new PatternListWindow("").setTitle(null);
                break;
            }
            case 4: {
                ApplicationWindow.Companion.openJMLFile();
                break;
            }
            case 5: {
                try {
                    File file;
                    Object object = this.lastJmlFilename;
                    if (object == null) {
                        object = this.getTitle() + ".jml";
                    }
                    String fname = object;
                    fname = JLFunc.jlSanitizeFilename(fname);
                    JLFunc.getJfc().setSelectedFile(new File(fname));
                    String[] stringArray = new String[]{"jml"};
                    JLFunc.getJfc().setFileFilter(new FileNameExtensionFilter("JML file", stringArray));
                    if (JLFunc.getJfc().showSaveDialog(this) != 0) {
                        return;
                    }
                    if (JLFunc.getJfc().getSelectedFile() == null) {
                        return;
                    }
                    File f = file;
                    String string = f.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
                    if (!StringsKt.endsWith$default(string, ".jml", false, 2, null)) {
                        f = new File(f.getAbsolutePath() + ".jml");
                    }
                    String string2 = f.getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    JLFunc.jlErrorIfNotSanitized(string2);
                    this.lastJmlFilename = f.getName();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    FileWriter fw = new FileWriter(f);
                    this.getPatternListPanel().getPatternList().writeJML(fw);
                    fw.close();
                    this.getPatternListPanel().setHasUnsavedChanges(false);
                    break;
                }
                catch (FileNotFoundException fnfe) {
                    throw new JuggleExceptionInternal("File not found on save: " + fnfe.getMessage());
                }
                catch (IOException ioe) {
                    throw new JuggleExceptionInternal("IOException on save: " + ioe.getMessage());
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            case 6: {
                try {
                    String string;
                    File file;
                    Object fname = this.lastJmlFilename;
                    if (fname != null) {
                        int index = StringsKt.lastIndexOf$default((CharSequence)fname, ".", 0, false, 6, null);
                        Object base = index >= 0 ? StringsKt.take((String)fname, index) : fname;
                        fname = (String)base + ".txt";
                    } else {
                        fname = this.getTitle() + ".txt";
                    }
                    fname = JLFunc.jlSanitizeFilename((String)fname);
                    JLFunc.getJfc().setSelectedFile(new File((String)fname));
                    String[] index = new String[]{"txt"};
                    JLFunc.getJfc().setFileFilter(new FileNameExtensionFilter("Text file", index));
                    if (JLFunc.getJfc().showSaveDialog(this) != 0) {
                        return;
                    }
                    if (JLFunc.getJfc().getSelectedFile() == null) {
                        return;
                    }
                    File f = file;
                    String string3 = f.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue(string3, "getAbsolutePath(...)");
                    if (!StringsKt.endsWith$default(string3, ".txt", false, 2, null)) {
                        f = new File(f.getAbsolutePath() + ".txt");
                    }
                    String string4 = f.getName();
                    Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
                    JLFunc.jlErrorIfNotSanitized(string4);
                    String string5 = f.getName();
                    Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
                    int index2 = StringsKt.lastIndexOf$default((CharSequence)string5, ".", 0, false, 6, null);
                    if (index2 >= 0) {
                        String string6 = f.getName();
                        Intrinsics.checkNotNullExpressionValue(string6, "getName(...)");
                        String string7 = string6;
                        int n = 0;
                        String string8 = string7.substring(n, index2);
                        string = string8;
                        Intrinsics.checkNotNullExpressionValue(string8, "substring(...)");
                    } else {
                        string = f.getName();
                    }
                    String base = string;
                    this.lastJmlFilename = base + ".jml";
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    FileWriter fw = new FileWriter(f);
                    this.getPatternListPanel().getPatternList().writeText(fw);
                    fw.close();
                    break;
                }
                catch (FileNotFoundException fnfe) {
                    throw new JuggleExceptionInternal("File not found on save: " + fnfe.getMessage());
                }
                catch (IOException ioe) {
                    throw new JuggleExceptionInternal("IOException on save: " + ioe.getMessage());
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            case 7: {
                StringWriter sw = new StringWriter();
                this.getPatternListPanel().getPatternList().writeJML(sw);
                JMLParser parser = new JMLParser();
                parser.parse(new StringReader(sw.toString()));
                JMLNode jMLNode = parser.getTree();
                Intrinsics.checkNotNull(jMLNode);
                PatternListWindow newplw = new PatternListWindow(jMLNode);
                newplw.getPatternListPanel().getPatternList().setTitle(this.getTitle() + " copy");
                newplw.setTitle(this.getTitle() + " copy");
                break;
            }
            case 8: {
                this.changeTitle();
                break;
            }
            case 9: {
                this.dispose();
                break;
            }
            case 10: {
                ApplicationWindow.Companion.showAboutBox();
                break;
            }
            case 11: {
                ApplicationWindow.Companion.showOnlineHelp();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void changeTitle() {
        JDialog jd = new JDialog(this, JugglingLab.INSTANCE.getGuistrings().getString("Change_title"), true);
        GridBagLayout gb = new GridBagLayout();
        jd.getContentPane().setLayout(gb);
        JTextField tf = new JTextField(20);
        tf.setText(this.getPatternListPanel().getPatternList().getTitle());
        JButton okbutton = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("OK"));
        okbutton.addActionListener(arg_0 -> PatternListWindow.changeTitle$lambda$1(tf, this, jd, arg_0));
        jd.getContentPane().add(tf);
        gb.setConstraints(tf, JLFunc.constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        jd.getContentPane().add(okbutton);
        gb.setConstraints(okbutton, JLFunc.constraints(22, 0, 1, new Insets(10, 10, 10, 10)));
        jd.getRootPane().setDefaultButton(okbutton);
        jd.pack();
        jd.setResizable(false);
        jd.setLocationRelativeTo(this);
        jd.setVisible(true);
    }

    @Override
    public void setTitle(@Nullable String newTitle) {
        String title = newTitle;
        if (title == null || ((CharSequence)title).length() == 0) {
            title = JugglingLab.INSTANCE.getGuistrings().getString("PLWINDOW_Default_window_title");
        }
        super.setTitle(title);
        ApplicationWindow.Companion.updateWindowMenus();
    }

    @Override
    public void dispose() {
        if (this.getPatternListPanel().getHasUnsavedChanges()) {
            String string = JugglingLab.INSTANCE.getGuistrings().getString("PLWINDOW_Unsaved_changes_message");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String template = string;
            Object[] objectArray = new Object[]{this.getTitle()};
            Object[] arguments = objectArray;
            String message = MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length));
            String string2 = JugglingLab.INSTANCE.getGuistrings().getString("PLWINDOW_Unsaved_changes_title");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            String title = string2;
            int res = JOptionPane.showConfirmDialog(this.getPatternListPanel(), message, title, 1, -1);
            switch (res) {
                case 2: {
                    return;
                }
                case 0: {
                    try {
                        this.doMenuCommand(MenuCommand.FILE_SAVE);
                    }
                    catch (JuggleException je) {
                        ErrorDialog.INSTANCE.handleFatalException(je);
                        return;
                    }
                    if (!this.getPatternListPanel().getHasUnsavedChanges()) break;
                    return;
                }
            }
        }
        super.dispose();
        SwingUtilities.invokeLater(PatternListWindow::dispose$lambda$2);
    }

    private static final void _init_$lambda$0() {
        ApplicationWindow.Companion.updateWindowMenus();
    }

    private static final void changeTitle$lambda$1(JTextField $tf, PatternListWindow this$0, JDialog $jd, ActionEvent actionEvent) {
        String newtitle = $tf.getText();
        this$0.getPatternListPanel().getPatternList().setTitle(newtitle);
        this$0.setTitle(newtitle);
        $jd.dispose();
    }

    private static final void dispose$lambda$2() {
        ApplicationWindow.Companion.updateWindowMenus();
    }

    static {
        Object[] objectArray = new String[]{"New Pattern", "New Pattern List", "Open JML...", "Save JML As...", "Save Text As...", null, "Duplicate", null, "Change Title...", null, "Close"};
        fileItems = CollectionsKt.listOf(objectArray);
        objectArray = new String[]{"newpat", "newpl", "open", "saveas", "savetext", null, "duplicate", null, "changetitle", null, "close"};
        fileCommands = CollectionsKt.listOf(objectArray);
        objectArray = new char[11];
        objectArray[0] = (String)78;
        objectArray[1] = (String)76;
        objectArray[2] = (String)79;
        objectArray[3] = (String)83;
        objectArray[4] = (String)84;
        objectArray[5] = (String)32;
        objectArray[6] = (String)68;
        objectArray[7] = (String)32;
        objectArray[8] = (String)32;
        objectArray[9] = (String)32;
        objectArray[10] = (String)87;
        fileShortcuts = (char[])objectArray;
        objectArray = new String[]{"About Juggling Lab", "Juggling Lab Online Help"};
        helpItems = CollectionsKt.listOf(objectArray);
        objectArray = new String[]{"about", "online"};
        helpCommands = CollectionsKt.listOf(objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00070\nj\b\u0012\u0004\u0012\u00020\u0007`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljugglinglab/core/PatternListWindow$Companion;", "", "<init>", "()V", "NUM_TILES", "", "TILE_START", "Ljava/awt/Point;", "TILE_OFFSET", "tileLocations", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "nextTileNum", "nextScreenLocation", "getNextScreenLocation", "()Ljava/awt/Point;", "fileItems", "", "", "fileCommands", "fileShortcuts", "", "helpItems", "helpCommands", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        private final Point getNextScreenLocation() {
            if (tileLocations.isEmpty()) {
                Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
                int locx = Math.max(0, center.x - 600);
                for (int i2 = 0; i2 < 9; ++i2) {
                    int locX = locx + TILE_START.x + i2 * TILE_OFFSET.x;
                    int locY = TILE_START.y + i2 * TILE_OFFSET.y;
                    tileLocations.add(new Point(locX, locY));
                }
                nextTileNum = 0;
            }
            Object e = tileLocations.get(nextTileNum);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            Point loc = (Point)e;
            nextTileNum = nextTileNum + 1;
            if (nextTileNum == 8) {
                nextTileNum = 0;
            }
            return loc;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000e\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Ljugglinglab/core/PatternListWindow$MenuCommand;", "", "<init>", "(Ljava/lang/String;I)V", "FILE_NONE", "FILE_NEWPAT", "FILE_NEWPL", "FILE_OPEN", "FILE_SAVE", "FILE_SAVETEXT", "FILE_DUPLICATE", "FILE_TITLE", "FILE_CLOSE", "HELP_ABOUT", "HELP_ONLINE", "jugglinglab"})
    private static final class MenuCommand
    extends Enum<MenuCommand> {
        public static final /* enum */ MenuCommand FILE_NONE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_NEWPAT = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_NEWPL = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_OPEN = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_SAVE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_SAVETEXT = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_DUPLICATE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_TITLE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_CLOSE = new MenuCommand();
        public static final /* enum */ MenuCommand HELP_ABOUT = new MenuCommand();
        public static final /* enum */ MenuCommand HELP_ONLINE = new MenuCommand();
        private static final /* synthetic */ MenuCommand[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MenuCommand[] values() {
            return (MenuCommand[])$VALUES.clone();
        }

        public static MenuCommand valueOf(String value) {
            return Enum.valueOf(MenuCommand.class, value);
        }

        @NotNull
        public static EnumEntries<MenuCommand> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = menuCommandArray = new MenuCommand[]{MenuCommand.FILE_NONE, MenuCommand.FILE_NEWPAT, MenuCommand.FILE_NEWPL, MenuCommand.FILE_OPEN, MenuCommand.FILE_SAVE, MenuCommand.FILE_SAVETEXT, MenuCommand.FILE_DUPLICATE, MenuCommand.FILE_TITLE, MenuCommand.FILE_CLOSE, MenuCommand.HELP_ABOUT, MenuCommand.HELP_ONLINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MenuCommand.values().length];
            try {
                nArray[MenuCommand.FILE_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_NEWPAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_NEWPL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_OPEN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_SAVE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_SAVETEXT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_DUPLICATE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_TITLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_CLOSE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.HELP_ABOUT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.HELP_ONLINE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

