/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.AnimationPrefsDialog;
import jugglinglab.core.ApplicationWindow;
import jugglinglab.core.PatternListWindow;
import jugglinglab.jml.JMLPattern;
import jugglinglab.prop.Prop;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.EditView;
import jugglinglab.view.PatternView;
import jugglinglab.view.SelectionView;
import jugglinglab.view.SimpleView;
import jugglinglab.view.View;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0002?@B#\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0012\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\fJ\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010-\u001a\u00020\u001a2\b\u0010.\u001a\u0004\u0018\u00010\u0004J\b\u0010/\u001a\u00020\u001aH\u0002J\b\u00100\u001a\u00020\u0010H\u0002J\u0006\u00101\u001a\u00020\u001aJ\b\u00102\u001a\u00020\u0010H\u0002J\u0006\u00103\u001a\u00020\u001aJ\b\u00104\u001a\u00020\u0010H\u0002J\u0010\u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u001a2\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020\u001aH\u0002J\b\u0010<\u001a\u00020\u001aH\u0002J\u0012\u0010=\u001a\u00020\u001a2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010>\u001a\u00020\u001aH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001fR\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010,\u00a8\u0006A"}, d2={"Ljugglinglab/core/PatternWindow;", "Ljavax/swing/JFrame;", "Ljava/awt/event/ActionListener;", "title", "", "pat", "Ljugglinglab/jml/JMLPattern;", "jc", "Ljugglinglab/core/AnimationPrefs;", "<init>", "(Ljava/lang/String;Ljugglinglab/jml/JMLPattern;Ljugglinglab/core/AnimationPrefs;)V", "pw", "(Ljugglinglab/core/PatternWindow;)V", "view", "Ljugglinglab/view/View;", "colorsMenu", "Ljavax/swing/JMenu;", "viewMenu", "value", "windowMenu", "getWindowMenu", "()Ljavax/swing/JMenu;", "undo", "Ljava/util/ArrayList;", "lastJmlFilename", "createInitialView", "", "mode", "", "viewMode", "getViewMode", "()I", "setViewMode", "(I)V", "pattern", "getPattern", "()Ljugglinglab/jml/JMLPattern;", "animationPrefs", "getAnimationPrefs", "()Ljugglinglab/core/AnimationPrefs;", "hashCode", "getHashCode", "isWindowMaximized", "", "()Z", "setJMLFilename", "fname", "createMenus", "createFileMenu", "updateColorsMenu", "createViewMenu", "updateUndoMenu", "createHelpMenu", "actionPerformed", "ae", "Ljava/awt/event/ActionEvent;", "doMenuCommand", "action", "Ljugglinglab/core/PatternWindow$MenuCommand;", "changeTitle", "changeTiming", "setTitle", "dispose", "MenuCommand", "Companion", "jugglinglab"})
public final class PatternWindow
extends JFrame
implements ActionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private View view;
    private JMenu colorsMenu;
    private JMenu viewMenu;
    private JMenu windowMenu;
    @NotNull
    private ArrayList<JMLPattern> undo;
    @Nullable
    private String lastJmlFilename;
    private static final double MAX_ZOOM = 3.0;
    private static final double MIN_ZOOM = 0.25;
    private static final double ZOOM_PER_STEP = 1.1;
    private static boolean exitOnLastClose;
    private static final int NUM_TILES = 8;
    @NotNull
    private static final Point TILE_START;
    @NotNull
    private static final Point TILE_OFFSET;
    @NotNull
    private static ArrayList<Point> tileLocations;
    private static int nextTileNum;
    @Nullable
    private static Class<?> optimizer;
    private static boolean optimizerLoaded;
    @NotNull
    private static final List<String> fileItems;
    @NotNull
    private static final List<String> fileCommands;
    @NotNull
    private static final char[] fileShortcuts;
    @NotNull
    private static final List<String> viewItems;
    @NotNull
    private static final List<String> viewCommands;
    @NotNull
    private static final char[] viewShortcuts;
    @NotNull
    private static final List<String> helpItems;
    @NotNull
    private static final List<String> helpCommands;

    public PatternWindow(@Nullable String title, @NotNull JMLPattern pat, @Nullable AnimationPrefs jc) {
        Intrinsics.checkNotNullParameter(pat, "pat");
        super(title);
        this.undo = new ArrayList();
        PatternWindow.Companion.loadOptimizer();
        this.createMenus();
        this.createInitialView(pat, jc);
        View view = this.view;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        view.addToUndoList(pat);
        this.setLocation(PatternWindow.Companion.getNextScreenLocation());
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    this.doMenuCommand(MenuCommand.FILE_CLOSE);
                }
                catch (JuggleException je) {
                    ErrorDialog.INSTANCE.handleFatalException(je);
                }
            }
        });
        this.addMouseWheelListener(arg_0 -> PatternWindow._init_$lambda$0(this, arg_0));
        SwingUtilities.invokeLater(PatternWindow::_init_$lambda$1);
    }

    @NotNull
    public final JMenu getWindowMenu() {
        JMenu jMenu = this.windowMenu;
        if (jMenu != null) {
            return jMenu;
        }
        Intrinsics.throwUninitializedPropertyAccessException("windowMenu");
        return null;
    }

    private PatternWindow(PatternWindow pw) throws JuggleExceptionUser, JuggleExceptionInternal {
        String string = pw.getTitle();
        View view = pw.view;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        JMLPattern jMLPattern = view.getPattern();
        Intrinsics.checkNotNull(jMLPattern);
        JMLPattern jMLPattern2 = new JMLPattern(jMLPattern);
        View view2 = pw.view;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view2 = null;
        }
        this(string, jMLPattern2, new AnimationPrefs(view2.getAnimationPrefs()));
    }

    private final void createInitialView(JMLPattern pat, AnimationPrefs jc) throws JuggleExceptionUser, JuggleExceptionInternal {
        View view;
        int mode;
        AnimationPrefs animationPrefs = jc;
        if (animationPrefs == null) {
            animationPrefs = new AnimationPrefs();
        }
        AnimationPrefs jc2 = animationPrefs;
        int n = mode = jc2.getView() != 0 ? jc2.getView() : (pat.getNumberOfJugglers() > 8 ? 1 : 2);
        JMenu jMenu = this.viewMenu;
        if (jMenu == null) {
            Intrinsics.throwUninitializedPropertyAccessException("viewMenu");
            jMenu = null;
        }
        jMenu.getItem(mode - 1).setSelected(true);
        Dimension animsize = new Dimension(jc2.getWidth(), jc2.getHeight());
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                this.view = new SimpleView(animsize);
                break;
            }
            case 2: {
                this.view = new EditView(animsize, pat);
                break;
            }
            case 3: {
                this.view = new PatternView(animsize);
                break;
            }
            case 4: {
                this.view = new SelectionView(animsize);
            }
        }
        if ((view = this.view) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        view.setPatternWindow(this);
        View view2 = this.view;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view2 = null;
        }
        view2.setOpaque(true);
        View view3 = this.view;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view3 = null;
        }
        view3.setDoubleBuffered(true);
        View view4 = this.view;
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view4 = null;
        }
        this.setContentPane(view4);
        Locale loc = Locale.getDefault();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        this.setBackground(Color.white);
        this.pack();
        View view5 = this.view;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view5 = null;
        }
        view5.restartView(pat, jc2);
        View view6 = this.view;
        if (view6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view6 = null;
        }
        view6.setUndoList(this.undo, -1);
    }

    public final int getViewMode() {
        View view;
        View view2 = this.view;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view2 = null;
        }
        return (view = view2) instanceof SimpleView ? 1 : (view instanceof EditView ? 2 : (view instanceof PatternView ? 3 : (view instanceof SelectionView ? 4 : 0)));
    }

    public final void setViewMode(int mode) throws JuggleExceptionUser, JuggleExceptionInternal {
        JMenu jMenu = this.viewMenu;
        if (jMenu == null) {
            Intrinsics.throwUninitializedPropertyAccessException("viewMenu");
            jMenu = null;
        }
        jMenu.getItem(mode - 1).setSelected(true);
        View view = this.view;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        JMLPattern jMLPattern = view.getPattern();
        Intrinsics.checkNotNull(jMLPattern);
        JMLPattern pat = jMLPattern;
        View view2 = this.view;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view2 = null;
        }
        AnimationPrefs jc = view2.getAnimationPrefs();
        View view3 = this.view;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view3 = null;
        }
        boolean paused = view3.isPaused();
        View view4 = this.view;
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view4 = null;
        }
        int undoIndex = view4.getUndoIndex();
        Dimension animsize = new Dimension(jc.getWidth(), jc.getHeight());
        View newview = switch (mode) {
            case 1 -> new SimpleView(animsize);
            case 2 -> new EditView(animsize, pat);
            case 3 -> new PatternView(animsize);
            case 4 -> new SelectionView(animsize);
            default -> throw new JuggleExceptionInternal("setViewMode: problem creating view");
        };
        newview.setPatternWindow(this);
        newview.setPaused(paused);
        newview.setOpaque(true);
        newview.setDoubleBuffered(true);
        this.setContentPane(newview);
        if (this.isWindowMaximized()) {
            this.validate();
        } else {
            this.pack();
        }
        newview.restartView(pat, jc);
        newview.setUndoList(this.undo, undoIndex);
        View view5 = this.view;
        if (view5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view5 = null;
        }
        view5.disposeView();
        this.view = newview;
    }

    @Nullable
    public final JMLPattern getPattern() {
        View view = this.view;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        return view.getPattern();
    }

    @NotNull
    public final AnimationPrefs getAnimationPrefs() {
        View view = this.view;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        return view.getAnimationPrefs();
    }

    private final int getHashCode() {
        View view = this.view;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        return view.getHashCode();
    }

    public final boolean isWindowMaximized() {
        return (this.getExtendedState() & 6) != 0;
    }

    public final void setJMLFilename(@Nullable String fname) {
        this.lastJmlFilename = fname;
    }

    private final void createMenus() {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu());
        mb.add(this.createViewMenu());
        this.windowMenu = new JMenu(JugglingLab.INSTANCE.getGuistrings().getString("Window"));
        mb.add(this.getWindowMenu());
        mb.add(this.createHelpMenu());
        this.setJMenuBar(mb);
    }

    /*
     * WARNING - void declaration
     */
    private final JMenu createFileMenu() {
        JMenu fileMenu = new JMenu(JugglingLab.INSTANCE.getGuistrings().getString("File"));
        int n = ((Collection)fileItems).size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (fileItems.get(i2) == null) {
                fileMenu.addSeparator();
                continue;
            }
            if (Intrinsics.areEqual(fileCommands.get(i2), "colorprops")) {
                void $this$createFileMenu_u24lambda_u243;
                JMenuItem $this$createFileMenu_u24lambda_u242;
                ResourceBundle resourceBundle = JugglingLab.INSTANCE.getGuistrings();
                String string = fileItems.get(i2);
                Intrinsics.checkNotNull(string);
                this.colorsMenu = new JMenu(resourceBundle.getString(StringsKt.replace$default(string, ' ', '_', false, 4, null)));
                JMenu jMenu = this.colorsMenu;
                if (jMenu == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("colorsMenu");
                    jMenu = null;
                }
                Object object = new JMenuItem(JugglingLab.INSTANCE.getGuistrings().getString("PCMENU_mixed"));
                JMenuItem jMenuItem = object;
                JMenu jMenu2 = jMenu;
                boolean bl = false;
                $this$createFileMenu_u24lambda_u242.setActionCommand("colors_mixed");
                $this$createFileMenu_u24lambda_u242.addActionListener(this);
                jMenu2.add((JMenuItem)object);
                JMenu jMenu3 = this.colorsMenu;
                if (jMenu3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("colorsMenu");
                    jMenu3 = null;
                }
                object = new JMenuItem(JugglingLab.INSTANCE.getGuistrings().getString("PCMENU_orbits"));
                $this$createFileMenu_u24lambda_u242 = object;
                jMenu2 = jMenu3;
                boolean bl2 = false;
                $this$createFileMenu_u24lambda_u243.setActionCommand("colors_orbits");
                $this$createFileMenu_u24lambda_u243.addActionListener(this);
                jMenu2.add((JMenuItem)object);
                JMenu jMenu4 = this.colorsMenu;
                if (jMenu4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("colorsMenu");
                    jMenu4 = null;
                }
                jMenu4.addSeparator();
                for (String colorName : Prop.Companion.getCOLOR_NAMES()) {
                    void $this$createFileMenu_u24lambda_u244;
                    JMenuItem jMenuItem2;
                    JMenu jMenu5 = this.colorsMenu;
                    if (jMenu5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("colorsMenu");
                        jMenu5 = null;
                    }
                    JMenuItem jMenuItem3 = jMenuItem2 = new JMenuItem(JugglingLab.INSTANCE.getGuistrings().getString("PCMENU_" + colorName));
                    jMenu2 = jMenu5;
                    boolean bl3 = false;
                    $this$createFileMenu_u24lambda_u244.setActionCommand("colors_" + colorName);
                    $this$createFileMenu_u24lambda_u244.addActionListener(this);
                    jMenu2.add(jMenuItem2);
                }
                JMenu jMenu6 = this.colorsMenu;
                if (jMenu6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("colorsMenu");
                    jMenu6 = null;
                }
                fileMenu.add(jMenu6);
                continue;
            }
            ResourceBundle resourceBundle = JugglingLab.INSTANCE.getGuistrings();
            String string = fileItems.get(i2);
            Intrinsics.checkNotNull(string);
            JMenuItem fileItem = new JMenuItem(resourceBundle.getString(StringsKt.replace$default(string, ' ', '_', false, 4, null)));
            if (fileShortcuts[i2] != ' ') {
                fileItem.setAccelerator(KeyStroke.getKeyStroke((int)fileShortcuts[i2], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
            }
            fileItem.setActionCommand(fileCommands.get(i2));
            fileItem.addActionListener(this);
            fileMenu.add(fileItem);
            if (!Intrinsics.areEqual(fileCommands.get(i2), "optimize") || optimizer != null) continue;
            fileItem.setEnabled(false);
        }
        return fileMenu;
    }

    public final void updateColorsMenu() {
        View view;
        JMenu jMenu = this.colorsMenu;
        if (jMenu == null) {
            Intrinsics.throwUninitializedPropertyAccessException("colorsMenu");
            jMenu = null;
        }
        if ((view = this.view) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        JMLPattern jMLPattern = view.getPattern();
        jMenu.setEnabled(jMLPattern != null ? jMLPattern.isColorable() : false);
    }

    private final JMenu createViewMenu() {
        this.viewMenu = new JMenu(JugglingLab.INSTANCE.getGuistrings().getString("View"));
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean addingviews = true;
        int n = ((Collection)viewItems).size();
        for (int i2 = 0; i2 < n; ++i2) {
            JMenuItem viewitem;
            if (viewItems.get(i2) == null) {
                JMenu jMenu = this.viewMenu;
                if (jMenu == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("viewMenu");
                    jMenu = null;
                }
                jMenu.addSeparator();
                addingviews = false;
                continue;
            }
            if (addingviews) {
                ResourceBundle resourceBundle = JugglingLab.INSTANCE.getGuistrings();
                String string = viewItems.get(i2);
                Intrinsics.checkNotNull(string);
                viewitem = new JRadioButtonMenuItem(resourceBundle.getString(StringsKt.replace$default(string, ' ', '_', false, 4, null)));
                if (viewShortcuts[i2] != ' ') {
                    viewitem.setAccelerator(KeyStroke.getKeyStroke((int)viewShortcuts[i2], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
                }
                viewitem.setActionCommand(viewCommands.get(i2));
                viewitem.addActionListener(this);
                JMenu jMenu = this.viewMenu;
                if (jMenu == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("viewMenu");
                    jMenu = null;
                }
                jMenu.add(viewitem);
                buttonGroup.add(viewitem);
                continue;
            }
            ResourceBundle resourceBundle = JugglingLab.INSTANCE.getGuistrings();
            String string = viewItems.get(i2);
            Intrinsics.checkNotNull(string);
            viewitem = new JMenuItem(resourceBundle.getString(StringsKt.replace$default(string, ' ', '_', false, 4, null)));
            if (viewShortcuts[i2] != ' ') {
                viewitem.setAccelerator(KeyStroke.getKeyStroke((int)viewShortcuts[i2], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
            }
            viewitem.setActionCommand(viewCommands.get(i2));
            viewitem.addActionListener(this);
            JMenu jMenu = this.viewMenu;
            if (jMenu == null) {
                Intrinsics.throwUninitializedPropertyAccessException("viewMenu");
                jMenu = null;
            }
            jMenu.add(viewitem);
        }
        JMenu jMenu = this.viewMenu;
        if (jMenu == null) {
            Intrinsics.throwUninitializedPropertyAccessException("viewMenu");
            jMenu = null;
        }
        return jMenu;
    }

    public final void updateUndoMenu() {
        int undoIndex;
        View view = this.view;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        boolean undoEnabled = (undoIndex = view.getUndoIndex()) > 0;
        boolean redoEnabled = undoIndex < this.undo.size() - 1;
        int i2 = 0;
        JMenu jMenu = this.viewMenu;
        if (jMenu == null) {
            Intrinsics.throwUninitializedPropertyAccessException("viewMenu");
            jMenu = null;
        }
        int n = jMenu.getItemCount();
        while (i2 < n) {
            JMenuItem jmi;
            JMenu jMenu2 = this.viewMenu;
            if (jMenu2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("viewMenu");
                jMenu2 = null;
            }
            if ((jmi = jMenu2.getItem(i2)) != null && jmi.getActionCommand() != null) {
                if (Intrinsics.areEqual(jmi.getActionCommand(), "undo")) {
                    jmi.setEnabled(undoEnabled);
                } else if (Intrinsics.areEqual(jmi.getActionCommand(), "redo")) {
                    jmi.setEnabled(redoEnabled);
                }
            }
            ++i2;
        }
    }

    private final JMenu createHelpMenu() {
        boolean includeAbout = !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.APP_ABOUT);
        String string = JugglingLab.INSTANCE.getGuistrings().getString("Help");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        Object menuname = string;
        if (JugglingLab.INSTANCE.isMacOS()) {
            menuname = (String)menuname + " ";
        }
        JMenu helpmenu = new JMenu((String)menuname);
        int n = helpItems.size();
        for (int i2 = includeAbout ? 0 : 1; i2 < n; ++i2) {
            if (helpItems.get(i2) == null) {
                helpmenu.addSeparator();
                continue;
            }
            ResourceBundle resourceBundle = JugglingLab.INSTANCE.getGuistrings();
            String string2 = helpItems.get(i2);
            Intrinsics.checkNotNull(string2);
            JMenuItem helpitem = new JMenuItem(resourceBundle.getString(StringsKt.replace$default(string2, ' ', '_', false, 4, null)));
            helpitem.setActionCommand(helpCommands.get(i2));
            helpitem.addActionListener(this);
            helpmenu.add(helpitem);
        }
        return helpmenu;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void actionPerformed(@NotNull ActionEvent ae) {
        block63: {
            Intrinsics.checkNotNullParameter(ae, "ae");
            try {
                block64: {
                    block85: {
                        block67: {
                            block80: {
                                block86: {
                                    block69: {
                                        block68: {
                                            block77: {
                                                block65: {
                                                    block70: {
                                                        block71: {
                                                            block82: {
                                                                block76: {
                                                                    block79: {
                                                                        block84: {
                                                                            block74: {
                                                                                block72: {
                                                                                    block66: {
                                                                                        block81: {
                                                                                            block78: {
                                                                                                block83: {
                                                                                                    block75: {
                                                                                                        block73: {
                                                                                                            block87: {
                                                                                                                var2_2 = ae.getActionCommand();
                                                                                                                if (var2_2 == null) break block64;
                                                                                                                switch (var2_2.hashCode()) {
                                                                                                                    case -696285128: {
                                                                                                                        if (!var2_2.equals("zoomin")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block65;
                                                                                                                    }
                                                                                                                    case 842170362: {
                                                                                                                        if (!var2_2.equals("changetiming")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block66;
                                                                                                                    }
                                                                                                                    case 92611469: {
                                                                                                                        if (!var2_2.equals("about")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block67;
                                                                                                                    }
                                                                                                                    case -902286926: {
                                                                                                                        if (!var2_2.equals("simple")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block68;
                                                                                                                    }
                                                                                                                    case -1323096151: {
                                                                                                                        if (!var2_2.equals("visual_edit")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block69;
                                                                                                                    }
                                                                                                                    case 3496446: {
                                                                                                                        if (!var2_2.equals("redo")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block70;
                                                                                                                    }
                                                                                                                    case 3594468: {
                                                                                                                        if (!var2_2.equals("undo")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block71;
                                                                                                                    }
                                                                                                                    case -79080739: {
                                                                                                                        if (!var2_2.equals("optimize")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block72;
                                                                                                                    }
                                                                                                                    case 94756344: {
                                                                                                                        if (!var2_2.equals("close")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block73;
                                                                                                                    }
                                                                                                                    case -1263779791: {
                                                                                                                        if (!var2_2.equals("swaphands")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block74;
                                                                                                                    }
                                                                                                                    case 104714140: {
                                                                                                                        if (var2_2.equals("newpl")) break;
                                                                                                                        ** break;
                                                                                                                    }
                                                                                                                    case -909417873: {
                                                                                                                        if (!var2_2.equals("saveas")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block75;
                                                                                                                    }
                                                                                                                    case 1097506319: {
                                                                                                                        if (!var2_2.equals("restart")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block76;
                                                                                                                    }
                                                                                                                    case -109996389: {
                                                                                                                        if (!var2_2.equals("zoomout")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block77;
                                                                                                                    }
                                                                                                                    case 1201687819: {
                                                                                                                        if (!var2_2.equals("duplicate")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block78;
                                                                                                                    }
                                                                                                                    case 1900582819: {
                                                                                                                        if (!var2_2.equals("inverttime")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block79;
                                                                                                                    }
                                                                                                                    case -2127115043: {
                                                                                                                        if (!var2_2.equals("selection_edit")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block80;
                                                                                                                    }
                                                                                                                    case -1635394392: {
                                                                                                                        if (!var2_2.equals("changetitle")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block81;
                                                                                                                    }
                                                                                                                    case 106930864: {
                                                                                                                        if (!var2_2.equals("prefs")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block82;
                                                                                                                    }
                                                                                                                    case -947136584: {
                                                                                                                        if (!var2_2.equals("savegifanim")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block83;
                                                                                                                    }
                                                                                                                    case 1959910242: {
                                                                                                                        if (!var2_2.equals("invertx")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block84;
                                                                                                                    }
                                                                                                                    case -1012222381: {
                                                                                                                        if (!var2_2.equals("online")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block85;
                                                                                                                    }
                                                                                                                    case -198838951: {
                                                                                                                        if (!var2_2.equals("pattern_edit")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block86;
                                                                                                                    }
                                                                                                                    case 3417674: {
                                                                                                                        if (!var2_2.equals("open")) {
                                                                                                                            ** break;
                                                                                                                        }
                                                                                                                        break block87;
                                                                                                                    }
                                                                                                                    case -1048829181: {
                                                                                                                        if (!var2_2.equals("newpat")) ** break;
                                                                                                                        this.doMenuCommand(MenuCommand.FILE_NEWPAT);
                                                                                                                        break block63;
                                                                                                                    }
                                                                                                                }
                                                                                                                this.doMenuCommand(MenuCommand.FILE_NEWPL);
                                                                                                                break block63;
                                                                                                            }
                                                                                                            this.doMenuCommand(MenuCommand.FILE_OPEN);
                                                                                                            break block63;
                                                                                                        }
                                                                                                        this.doMenuCommand(MenuCommand.FILE_CLOSE);
                                                                                                        break block63;
                                                                                                    }
                                                                                                    this.doMenuCommand(MenuCommand.FILE_SAVE);
                                                                                                    break block63;
                                                                                                }
                                                                                                this.doMenuCommand(MenuCommand.FILE_GIFSAVE);
                                                                                                break block63;
                                                                                            }
                                                                                            this.doMenuCommand(MenuCommand.FILE_DUPLICATE);
                                                                                            break block63;
                                                                                        }
                                                                                        this.doMenuCommand(MenuCommand.FILE_TITLE);
                                                                                        break block63;
                                                                                    }
                                                                                    this.doMenuCommand(MenuCommand.FILE_RESCALE);
                                                                                    break block63;
                                                                                }
                                                                                this.doMenuCommand(MenuCommand.FILE_OPTIMIZE);
                                                                                break block63;
                                                                            }
                                                                            this.doMenuCommand(MenuCommand.FILE_SWAPHANDS);
                                                                            break block63;
                                                                        }
                                                                        this.doMenuCommand(MenuCommand.FILE_INVERTX);
                                                                        break block63;
                                                                    }
                                                                    this.doMenuCommand(MenuCommand.FILE_INVERTTIME);
                                                                    break block63;
                                                                }
                                                                this.doMenuCommand(MenuCommand.VIEW_RESTART);
                                                                break block63;
                                                            }
                                                            this.doMenuCommand(MenuCommand.VIEW_ANIMPREFS);
                                                            break block63;
                                                        }
                                                        this.doMenuCommand(MenuCommand.VIEW_UNDO);
                                                        break block63;
                                                    }
                                                    this.doMenuCommand(MenuCommand.VIEW_REDO);
                                                    break block63;
                                                }
                                                this.doMenuCommand(MenuCommand.VIEW_ZOOMIN);
                                                break block63;
                                            }
                                            this.doMenuCommand(MenuCommand.VIEW_ZOOMOUT);
                                            break block63;
                                        }
                                        if (this.getViewMode() != 1) {
                                            this.setViewMode(1);
                                        }
                                        break block63;
                                    }
                                    if (this.getViewMode() != 2) {
                                        this.setViewMode(2);
                                    }
                                    break block63;
                                }
                                if (this.getViewMode() != 3) {
                                    this.setViewMode(3);
                                }
                                break block63;
                            }
                            if (this.getViewMode() != 4) {
                                this.setViewMode(4);
                            }
                            break block63;
                        }
                        this.doMenuCommand(MenuCommand.HELP_ABOUT);
                        break block63;
                    }
                    this.doMenuCommand(MenuCommand.HELP_ONLINE);
                    break block63;
                }
                command = ae.getActionCommand();
                Intrinsics.checkNotNull(command);
                if (!StringsKt.startsWith$default(command, "colors_", false, 2, null)) {
                    return;
                }
                v0 = command.substring(7);
                Intrinsics.checkNotNullExpressionValue(v0, "substring(...)");
                colorName = v0;
                colorString = Intrinsics.areEqual(colorName, "mixed") != false ? "mixed" : (Intrinsics.areEqual(colorName, "orbits") != false ? "orbits" : "{" + colorName + "}");
                try {
                    v1 = this.view;
                    if (v1 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        v1 = null;
                    }
                    v2 = v1.getPattern();
                    Intrinsics.checkNotNull(v2);
                    newpat = new JMLPattern(v2);
                    newpat.setPropColors(colorString);
                    v3 = this.view;
                    if (v3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        v3 = null;
                    }
                    v3.restartView(newpat, null);
                    v4 = this.view;
                    if (v4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        v4 = null;
                    }
                    v4.addToUndoList(newpat);
                }
                catch (JuggleExceptionUser <unused var>) {
                    throw new JuggleExceptionInternal("Error in FILE_PROPCOLORS");
                }
            }
            catch (JuggleExceptionUser je) {
                ErrorDialog.INSTANCE.handleUserException(this, je.getMessage());
            }
            catch (JuggleExceptionInternal jei) {
                ErrorDialog.INSTANCE.handleFatalException(jei);
            }
        }
    }

    private final void doMenuCommand(MenuCommand action) throws JuggleExceptionUser, JuggleExceptionInternal {
        switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                ApplicationWindow.Companion.newPattern();
                break;
            }
            case 3: {
                new PatternListWindow("").setTitle(null);
                break;
            }
            case 4: {
                ApplicationWindow.Companion.openJMLFile();
                break;
            }
            case 5: {
                this.dispose();
                if (!exitOnLastClose) break;
                int windowCount = 0;
                Iterator<Frame> iterator2 = ArrayIteratorKt.iterator(JFrame.getFrames());
                while (iterator2.hasNext()) {
                    Frame fr = iterator2.next();
                    if (!(fr instanceof PatternWindow) || !((PatternWindow)fr).isVisible()) continue;
                    ++windowCount;
                }
                if (windowCount != 0) break;
                System.exit(0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            case 6: {
                View view = this.view;
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("view");
                    view = null;
                }
                JMLPattern jMLPattern = view.getPattern();
                Intrinsics.checkNotNull(jMLPattern);
                if (!jMLPattern.isValid()) {
                    throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_saving_invalid_pattern"));
                }
                Object fname = this.lastJmlFilename;
                if (fname == null) {
                    fname = this.getTitle() + ".jml";
                }
                fname = JLFunc.jlSanitizeFilename((String)fname);
                JLFunc.getJfc().setSelectedFile(new File((String)fname));
                String[] stringArray = new String[]{"jml"};
                JLFunc.getJfc().setFileFilter(new FileNameExtensionFilter("JML file", stringArray));
                if (JLFunc.getJfc().showSaveDialog(this) != 0) {
                    return;
                }
                File file = JLFunc.getJfc().getSelectedFile();
                if (file == null) {
                    return;
                }
                File f = file;
                String string = f.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
                if (!StringsKt.endsWith$default(string, ".jml", false, 2, null)) {
                    f = new File(f.getAbsolutePath() + ".jml");
                }
                String string2 = f.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                JLFunc.jlErrorIfNotSanitized(string2);
                this.lastJmlFilename = f.getName();
                try {
                    FileWriter fw = new FileWriter(f);
                    View view2 = this.view;
                    if (view2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view2 = null;
                    }
                    JMLPattern jMLPattern2 = view2.getPattern();
                    Intrinsics.checkNotNull(jMLPattern2);
                    jMLPattern2.writeJML(fw, true, true);
                    fw.close();
                    break;
                }
                catch (FileNotFoundException fnfe) {
                    throw new JuggleExceptionInternal("FileNotFound: " + fnfe.getMessage());
                }
                catch (IOException ioe) {
                    throw new JuggleExceptionInternal("IOException: " + ioe.getMessage());
                }
            }
            case 7: {
                String string;
                Object fname = this.lastJmlFilename;
                if (fname != null) {
                    int index = StringsKt.lastIndexOf$default((CharSequence)fname, ".", 0, false, 6, null);
                    Object base = index >= 0 ? StringsKt.take((String)fname, index) : fname;
                    fname = (String)base + ".gif";
                } else {
                    fname = this.getTitle() + ".gif";
                }
                fname = JLFunc.jlSanitizeFilename((String)fname);
                JLFunc.getJfc().setSelectedFile(new File((String)fname));
                String[] index = new String[]{"gif"};
                JLFunc.getJfc().setFileFilter(new FileNameExtensionFilter("GIF file", index));
                if (JLFunc.getJfc().showSaveDialog(this) != 0) {
                    return;
                }
                File file = JLFunc.getJfc().getSelectedFile();
                if (file == null) {
                    return;
                }
                File f = file;
                String string3 = f.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue(string3, "getAbsolutePath(...)");
                if (!StringsKt.endsWith$default(string3, ".gif", false, 2, null)) {
                    f = new File(f.getAbsolutePath() + ".gif");
                }
                String string4 = f.getName();
                Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
                JLFunc.jlErrorIfNotSanitized(string4);
                String string5 = f.getName();
                Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
                int index2 = StringsKt.lastIndexOf$default((CharSequence)string5, ".", 0, false, 6, null);
                if (index2 >= 0) {
                    String string6 = f.getName();
                    Intrinsics.checkNotNullExpressionValue(string6, "getName(...)");
                    String string7 = string6;
                    int n = 0;
                    String string8 = string7.substring(n, index2);
                    string = string8;
                    Intrinsics.checkNotNullExpressionValue(string8, "substring(...)");
                } else {
                    string = f.getName();
                }
                String base = string;
                this.lastJmlFilename = base + ".jml";
                View view = this.view;
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("view");
                    view = null;
                }
                view.writeGIF(f);
                break;
            }
            case 8: {
                PatternWindow newpw = new PatternWindow(this);
                JMLPattern jMLPattern = newpw.getPattern();
                if (jMLPattern != null) {
                    jMLPattern.setTitle(this.getTitle() + " copy");
                }
                newpw.setTitle(this.getTitle() + " copy");
                break;
            }
            case 9: {
                this.changeTitle();
                break;
            }
            case 10: {
                this.changeTiming();
                break;
            }
            case 11: {
                if (optimizer == null) {
                    return;
                }
                try {
                    Class<?> clazz = optimizer;
                    Intrinsics.checkNotNull(clazz);
                    Class[] index2 = new Class[]{JMLPattern.class};
                    Method method = clazz.getMethod("optimize", index2);
                    Intrinsics.checkNotNullExpressionValue(method, "getMethod(...)");
                    Method optimize = method;
                    View view = this.view;
                    if (view == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view = null;
                    }
                    JMLPattern pat = view.getPattern();
                    Object[] objectArray = new Object[]{pat};
                    Object object = optimize.invoke(null, objectArray);
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type jugglinglab.jml.JMLPattern");
                    JMLPattern newPat = (JMLPattern)object;
                    View view3 = this.view;
                    if (view3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view3 = null;
                    }
                    view3.restartView(newPat, null);
                    View view4 = this.view;
                    if (view4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view4 = null;
                    }
                    view4.addToUndoList(newPat);
                    break;
                }
                catch (JuggleExceptionUser jeu) {
                    throw new JuggleExceptionInternal("optimizer jeu: " + jeu.getMessage());
                }
                catch (InvocationTargetException ite) {
                    Throwable throwable = ite.getCause();
                    Intrinsics.checkNotNull(throwable);
                    Throwable ex = throwable;
                    Throwable newPat = ex;
                    if (newPat instanceof JuggleExceptionUser) {
                        throw ex;
                    }
                    if (newPat instanceof JuggleExceptionInternal) {
                        throw ex;
                    }
                    throw new JuggleExceptionInternal("optimizer unknown ite: " + ex.getMessage());
                }
                catch (NoSuchMethodException nsme) {
                    throw new JuggleExceptionInternal("optimizer nsme: " + nsme.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new JuggleExceptionInternal("optimizer iae: " + iae.getMessage());
                }
            }
            case 12: {
                try {
                    View view = this.view;
                    if (view == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view = null;
                    }
                    JMLPattern jMLPattern = view.getPattern();
                    Intrinsics.checkNotNull(jMLPattern);
                    JMLPattern newpat = new JMLPattern(jMLPattern);
                    newpat.swapHands();
                    View view5 = this.view;
                    if (view5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view5 = null;
                    }
                    view5.restartView(newpat, null);
                    View view6 = this.view;
                    if (view6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view6 = null;
                    }
                    view6.addToUndoList(newpat);
                    break;
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    throw new JuggleExceptionInternal("Error in FILE_SWAPHANDS");
                }
            }
            case 13: {
                try {
                    View view = this.view;
                    if (view == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view = null;
                    }
                    JMLPattern jMLPattern = view.getPattern();
                    Intrinsics.checkNotNull(jMLPattern);
                    JMLPattern newpat = new JMLPattern(jMLPattern);
                    newpat.invertXAxis();
                    View view7 = this.view;
                    if (view7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view7 = null;
                    }
                    view7.restartView(newpat, null);
                    View view8 = this.view;
                    if (view8 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view8 = null;
                    }
                    view8.addToUndoList(newpat);
                    break;
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    throw new JuggleExceptionInternal("Error in FILE_INVERTX");
                }
            }
            case 14: {
                try {
                    View view = this.view;
                    if (view == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view = null;
                    }
                    JMLPattern jMLPattern = view.getPattern();
                    Intrinsics.checkNotNull(jMLPattern);
                    JMLPattern newpat = new JMLPattern(jMLPattern);
                    newpat.invertTime();
                    View view9 = this.view;
                    if (view9 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view9 = null;
                    }
                    view9.restartView(newpat, null);
                    View view10 = this.view;
                    if (view10 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("view");
                        view10 = null;
                    }
                    view10.addToUndoList(newpat);
                    break;
                }
                catch (JuggleExceptionUser juggleExceptionUser) {
                    throw new JuggleExceptionInternal("Error in FILE_INVERTTIME");
                }
            }
            case 15: {
                View view = this.view;
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("view");
                    view = null;
                }
                view.restartView();
                break;
            }
            case 16: {
                AnimationPrefs jc;
                AnimationPrefsDialog japd;
                AnimationPrefs newjc;
                View view = this.view;
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("view");
                    view = null;
                }
                if (Intrinsics.areEqual(newjc = (japd = new AnimationPrefsDialog(this)).getPrefs(jc = view.getAnimationPrefs()), jc)) break;
                View view11 = this.view;
                if (view11 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("view");
                    view11 = null;
                }
                view11.restartView(null, newjc);
                if (newjc.getWidth() == jc.getWidth() && newjc.getHeight() == jc.getHeight()) break;
                if (this.isWindowMaximized()) {
                    this.validate();
                    break;
                }
                this.pack();
                break;
            }
            case 17: {
                View view = this.view;
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("view");
                    view = null;
                }
                view.undoEdit();
                break;
            }
            case 18: {
                View view = this.view;
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("view");
                    view = null;
                }
                view.redoEdit();
                break;
            }
            case 19: {
                View view = this.view;
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("view");
                    view = null;
                }
                if (!(view.getZoomLevel() < 2.727272727272727)) break;
                View view12 = this.view;
                if (view12 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("view");
                    view12 = null;
                }
                View view13 = view12;
                view13.setZoomLevel(view13.getZoomLevel() * 1.1);
                break;
            }
            case 20: {
                View view = this.view;
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("view");
                    view = null;
                }
                if (!(view.getZoomLevel() > 0.275)) break;
                View view14 = this.view;
                if (view14 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("view");
                    view14 = null;
                }
                View view15 = view14;
                view15.setZoomLevel(view15.getZoomLevel() / 1.1);
                break;
            }
            case 21: {
                ApplicationWindow.Companion.showAboutBox();
                break;
            }
            case 22: {
                ApplicationWindow.Companion.showOnlineHelp();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void changeTitle() {
        JDialog jd = new JDialog(this, JugglingLab.INSTANCE.getGuistrings().getString("Change_title"), true);
        GridBagLayout gb = new GridBagLayout();
        jd.getContentPane().setLayout(gb);
        JTextField tf = new JTextField(20);
        View view = this.view;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        JMLPattern jMLPattern = view.getPattern();
        Intrinsics.checkNotNull(jMLPattern);
        tf.setText(jMLPattern.getTitle());
        JButton okbutton = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("OK"));
        okbutton.addActionListener(arg_0 -> PatternWindow.changeTitle$lambda$5(this, tf, jd, arg_0));
        jd.getContentPane().add(tf);
        gb.setConstraints(tf, JLFunc.constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        jd.getContentPane().add(okbutton);
        gb.setConstraints(okbutton, JLFunc.constraints(22, 0, 1, new Insets(10, 10, 10, 10)));
        jd.getRootPane().setDefaultButton(okbutton);
        jd.pack();
        jd.setResizable(false);
        jd.setLocationRelativeTo(this);
        jd.setVisible(true);
        View view2 = this.view;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view2 = null;
        }
        JMLPattern jMLPattern2 = view2.getPattern();
        Intrinsics.checkNotNull(jMLPattern2);
        this.setTitle(jMLPattern2.getTitle());
    }

    private final void changeTiming() {
        JDialog jd = new JDialog(this, JugglingLab.INSTANCE.getGuistrings().getString("Change_timing"), true);
        GridBagLayout gb = new GridBagLayout();
        jd.getContentPane().setLayout(gb);
        JPanel p1 = new JPanel();
        p1.setLayout(gb);
        JLabel lab = new JLabel(JugglingLab.INSTANCE.getGuistrings().getString("Rescale_percentage"));
        p1.add(lab);
        gb.setConstraints(lab, JLFunc.constraints(22, 0, 0, new Insets(0, 0, 0, 0)));
        JTextField tf = new JTextField(7);
        tf.setText("100");
        p1.add(tf);
        gb.setConstraints(tf, JLFunc.constraints(21, 1, 0, new Insets(0, 5, 0, 0)));
        JButton okbutton = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("OK"));
        okbutton.addActionListener(arg_0 -> PatternWindow.changeTiming$lambda$6(tf, this, jd, arg_0));
        jd.getContentPane().add(p1);
        gb.setConstraints(p1, JLFunc.constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        jd.getContentPane().add(okbutton);
        gb.setConstraints(okbutton, JLFunc.constraints(22, 0, 1, new Insets(10, 10, 10, 10)));
        jd.getRootPane().setDefaultButton(okbutton);
        jd.pack();
        jd.setLocationRelativeTo(this);
        jd.setVisible(true);
    }

    @Override
    public void setTitle(@Nullable String title) {
        String newTitle = title == null || ((CharSequence)title).length() == 0 ? JugglingLab.INSTANCE.getGuistrings().getString("PWINDOW_Default_window_title") : title;
        super.setTitle(newTitle);
        ApplicationWindow.Companion.updateWindowMenus();
    }

    @Override
    public void dispose() {
        super.dispose();
        View view = this.view;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        view.disposeView();
        SwingUtilities.invokeLater(PatternWindow::dispose$lambda$7);
    }

    private static final void _init_$lambda$0(PatternWindow this$0, MouseWheelEvent mwe) {
        MouseWheelEvent mouseWheelEvent = mwe;
        Intrinsics.checkNotNull(mouseWheelEvent);
        mouseWheelEvent.consume();
        try {
            if (mwe.getWheelRotation() > 0) {
                this$0.doMenuCommand(MenuCommand.VIEW_ZOOMIN);
            } else if (mwe.getWheelRotation() < 0) {
                this$0.doMenuCommand(MenuCommand.VIEW_ZOOMOUT);
            }
        }
        catch (JuggleException je) {
            ErrorDialog.INSTANCE.handleFatalException(je);
        }
    }

    private static final void _init_$lambda$1() {
        ApplicationWindow.Companion.updateWindowMenus();
    }

    private static final void changeTitle$lambda$5(PatternWindow this$0, JTextField $tf, JDialog $jd, ActionEvent actionEvent) {
        View view = this$0.view;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view = null;
        }
        JMLPattern jMLPattern = view.getPattern();
        Intrinsics.checkNotNull(jMLPattern);
        JMLPattern newpat = new JMLPattern(jMLPattern);
        newpat.setTitle($tf.getText());
        View view2 = this$0.view;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view2 = null;
        }
        view2.restartView(newpat, null);
        View view3 = this$0.view;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("view");
            view3 = null;
        }
        view3.addToUndoList(newpat);
        $jd.dispose();
    }

    private static final void changeTiming$lambda$6(JTextField $tf, PatternWindow this$0, JDialog $jd, ActionEvent actionEvent) {
        double scale = 0.0;
        try {
            scale = JLFunc.jlParseFiniteDouble($tf.getText()) / 100.0;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorDialog.INSTANCE.handleUserException(this$0, "Number format error in rescale percentage");
            return;
        }
        if (scale > 0.0) {
            View view = this$0.view;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException("view");
                view = null;
            }
            JMLPattern jMLPattern = view.getPattern();
            Intrinsics.checkNotNull(jMLPattern);
            JMLPattern newpat = new JMLPattern(jMLPattern);
            newpat.scaleTime(scale);
            View view2 = this$0.view;
            if (view2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("view");
                view2 = null;
            }
            view2.restartView(newpat, null);
            View view3 = this$0.view;
            if (view3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("view");
                view3 = null;
            }
            view3.addToUndoList(newpat);
        }
        $jd.dispose();
    }

    private static final void dispose$lambda$7() {
        ApplicationWindow.Companion.updateWindowMenus();
    }

    static {
        TILE_START = new Point(420, 50);
        TILE_OFFSET = new Point(25, 25);
        tileLocations = new ArrayList();
        Object[] objectArray = new String[]{"New Pattern", "New Pattern List", "Open JML...", "Save JML As...", "Save Animated GIF As...", null, "Duplicate", null, "Change Title...", "Change Overall Timing...", "Color Props", "Optimize", "Swap Hands", "Flip Pattern in X", "Flip Pattern in Time", null, "Close"};
        fileItems = CollectionsKt.listOf(objectArray);
        objectArray = new String[]{"newpat", "newpl", "open", "saveas", "savegifanim", null, "duplicate", null, "changetitle", "changetiming", "colorprops", "optimize", "swaphands", "invertx", "inverttime", null, "close"};
        fileCommands = CollectionsKt.listOf(objectArray);
        objectArray = new char[17];
        objectArray[0] = (String)78;
        objectArray[1] = (String)76;
        objectArray[2] = (String)79;
        objectArray[3] = (String)83;
        objectArray[4] = (String)71;
        objectArray[5] = (String)32;
        objectArray[6] = (String)68;
        objectArray[7] = (String)32;
        objectArray[8] = (String)32;
        objectArray[9] = (String)32;
        objectArray[10] = (String)32;
        objectArray[11] = (String)74;
        objectArray[12] = (String)32;
        objectArray[13] = (String)77;
        objectArray[14] = (String)84;
        objectArray[15] = (String)32;
        objectArray[16] = (String)87;
        fileShortcuts = (char[])objectArray;
        objectArray = new String[]{"Simple", "Visual Editor", "Pattern Editor", "Selection Editor", null, "Undo", "Redo", null, "Restart", "Animation Preferences...", "Zoom In", "Zoom Out"};
        viewItems = CollectionsKt.listOf(objectArray);
        objectArray = new String[]{"simple", "visual_edit", "pattern_edit", "selection_edit", null, "undo", "redo", null, "restart", "prefs", "zoomin", "zoomout"};
        viewCommands = CollectionsKt.listOf(objectArray);
        objectArray = new char[12];
        objectArray[0] = (String)49;
        objectArray[1] = (String)50;
        objectArray[2] = (String)51;
        objectArray[3] = (String)52;
        objectArray[4] = (String)32;
        objectArray[5] = (String)90;
        objectArray[6] = (String)89;
        objectArray[7] = (String)32;
        objectArray[8] = (String)32;
        objectArray[9] = (String)80;
        objectArray[10] = (String)61;
        objectArray[11] = (String)45;
        viewShortcuts = (char[])objectArray;
        objectArray = new String[]{"About Juggling Lab", "Juggling Lab Online Help"};
        helpItems = CollectionsKt.listOf(objectArray);
        objectArray = new String[]{"about", "online"};
        helpCommands = CollectionsKt.listOf(objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u000bJ\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ljugglinglab/core/PatternWindow$Companion;", "", "<init>", "()V", "MAX_ZOOM", "", "MIN_ZOOM", "ZOOM_PER_STEP", "exitOnLastClose", "", "NUM_TILES", "", "TILE_START", "Ljava/awt/Point;", "TILE_OFFSET", "tileLocations", "Ljava/util/ArrayList;", "nextTileNum", "optimizer", "Ljava/lang/Class;", "optimizerLoaded", "loadOptimizer", "", "nextScreenLocation", "getNextScreenLocation", "()Ljava/awt/Point;", "bringToFront", "hash", "setExitOnLastClose", "value", "fileItems", "", "", "fileCommands", "fileShortcuts", "", "viewItems", "viewCommands", "viewShortcuts", "helpItems", "helpCommands", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        private final void loadOptimizer() {
            if (optimizerLoaded) {
                return;
            }
            try {
                optimizer = Class.forName("jugglinglab.optimizer.Optimizer");
                Class clazz = optimizer;
                Intrinsics.checkNotNull(clazz);
                Method method = clazz.getMethod("optimizerAvailable", new Class[0]);
                Intrinsics.checkNotNullExpressionValue(method, "getMethod(...)");
                Method optimizerAvailable = method;
                Object object = optimizerAvailable.invoke(null, new Object[0]);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
                boolean canOptimize = (Boolean)object;
                if (!canOptimize) {
                    optimizer = null;
                }
            }
            catch (Exception e) {
                optimizer = null;
            }
            optimizerLoaded = true;
        }

        private final Point getNextScreenLocation() {
            if (tileLocations.isEmpty()) {
                Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
                int locx = Math.max(0, center.x - 600);
                for (int i2 = 0; i2 < 8; ++i2) {
                    int locX = locx + TILE_START.x + i2 * TILE_OFFSET.x;
                    int locY = TILE_START.y + i2 * TILE_OFFSET.y;
                    tileLocations.add(new Point(locX, locY));
                }
                nextTileNum = 0;
            }
            Object e = tileLocations.get(nextTileNum);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            Point loc = (Point)e;
            nextTileNum = nextTileNum + 1;
            if (nextTileNum == 8) {
                nextTileNum = 0;
            }
            return loc;
        }

        public final boolean bringToFront(int hash) {
            Iterator<Frame> iterator2 = ArrayIteratorKt.iterator(JFrame.getFrames());
            while (iterator2.hasNext()) {
                Frame fr = iterator2.next();
                if (!(fr instanceof PatternWindow) || !((PatternWindow)fr).isVisible() || ((PatternWindow)fr).getHashCode() != hash) continue;
                SwingUtilities.invokeLater(() -> Companion.bringToFront$lambda$0(fr));
                return true;
            }
            return false;
        }

        public final void setExitOnLastClose(boolean value) {
            exitOnLastClose = value;
        }

        private static final void bringToFront$lambda$0(Frame $fr) {
            ((PatternWindow)$fr).toFront();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0019\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Ljugglinglab/core/PatternWindow$MenuCommand;", "", "<init>", "(Ljava/lang/String;I)V", "FILE_NONE", "FILE_NEWPAT", "FILE_NEWPL", "FILE_OPEN", "FILE_CLOSE", "FILE_SAVE", "FILE_GIFSAVE", "FILE_DUPLICATE", "FILE_TITLE", "FILE_RESCALE", "FILE_OPTIMIZE", "FILE_SWAPHANDS", "FILE_INVERTX", "FILE_INVERTTIME", "VIEW_RESTART", "VIEW_ANIMPREFS", "VIEW_UNDO", "VIEW_REDO", "VIEW_ZOOMIN", "VIEW_ZOOMOUT", "HELP_ABOUT", "HELP_ONLINE", "jugglinglab"})
    private static final class MenuCommand
    extends Enum<MenuCommand> {
        public static final /* enum */ MenuCommand FILE_NONE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_NEWPAT = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_NEWPL = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_OPEN = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_CLOSE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_SAVE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_GIFSAVE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_DUPLICATE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_TITLE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_RESCALE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_OPTIMIZE = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_SWAPHANDS = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_INVERTX = new MenuCommand();
        public static final /* enum */ MenuCommand FILE_INVERTTIME = new MenuCommand();
        public static final /* enum */ MenuCommand VIEW_RESTART = new MenuCommand();
        public static final /* enum */ MenuCommand VIEW_ANIMPREFS = new MenuCommand();
        public static final /* enum */ MenuCommand VIEW_UNDO = new MenuCommand();
        public static final /* enum */ MenuCommand VIEW_REDO = new MenuCommand();
        public static final /* enum */ MenuCommand VIEW_ZOOMIN = new MenuCommand();
        public static final /* enum */ MenuCommand VIEW_ZOOMOUT = new MenuCommand();
        public static final /* enum */ MenuCommand HELP_ABOUT = new MenuCommand();
        public static final /* enum */ MenuCommand HELP_ONLINE = new MenuCommand();
        private static final /* synthetic */ MenuCommand[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MenuCommand[] values() {
            return (MenuCommand[])$VALUES.clone();
        }

        public static MenuCommand valueOf(String value) {
            return Enum.valueOf(MenuCommand.class, value);
        }

        @NotNull
        public static EnumEntries<MenuCommand> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = menuCommandArray = new MenuCommand[]{MenuCommand.FILE_NONE, MenuCommand.FILE_NEWPAT, MenuCommand.FILE_NEWPL, MenuCommand.FILE_OPEN, MenuCommand.FILE_CLOSE, MenuCommand.FILE_SAVE, MenuCommand.FILE_GIFSAVE, MenuCommand.FILE_DUPLICATE, MenuCommand.FILE_TITLE, MenuCommand.FILE_RESCALE, MenuCommand.FILE_OPTIMIZE, MenuCommand.FILE_SWAPHANDS, MenuCommand.FILE_INVERTX, MenuCommand.FILE_INVERTTIME, MenuCommand.VIEW_RESTART, MenuCommand.VIEW_ANIMPREFS, MenuCommand.VIEW_UNDO, MenuCommand.VIEW_REDO, MenuCommand.VIEW_ZOOMIN, MenuCommand.VIEW_ZOOMOUT, MenuCommand.HELP_ABOUT, MenuCommand.HELP_ONLINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MenuCommand.values().length];
            try {
                nArray[MenuCommand.FILE_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_NEWPAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_NEWPL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_OPEN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_CLOSE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_SAVE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_GIFSAVE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_DUPLICATE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_TITLE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_RESCALE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_OPTIMIZE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_SWAPHANDS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_INVERTX.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.FILE_INVERTTIME.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.VIEW_RESTART.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.VIEW_ANIMPREFS.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.VIEW_UNDO.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.VIEW_REDO.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.VIEW_ZOOMIN.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.VIEW_ZOOMOUT.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.HELP_ABOUT.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MenuCommand.HELP_ONLINE.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

