/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.curve;

import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001cH&J\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!J\u0018\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\fH&J\u001a\u0010-\u001a\u0004\u0018\u00010\f2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020!H$J\u001a\u00100\u001a\u0004\u0018\u00010\f2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020!H$J\u0018\u00102\u001a\u0004\u0018\u00010\f2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020!J\u0018\u00105\u001a\u0004\u0018\u00010\f2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020!J\"\u00106\u001a\u00020\f2\b\u00107\u001a\u0004\u0018\u00010\f2\u0006\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020:H\u0004R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0084.\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u0013X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0084.\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u0011\u0010\"\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u0017\u0010'\u001a\u00020!8F\u00a2\u0006\f\u0012\u0004\b(\u0010\u0003\u001a\u0004\b)\u0010$R\u0013\u00101\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0013\u00104\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b5\u00103\u00a8\u0006<"}, d2={"Ljugglinglab/curve/Curve;", "", "<init>", "()V", "numpoints", "", "getNumpoints", "()I", "setNumpoints", "(I)V", "positions", "", "Ljugglinglab/util/Coordinate;", "getPositions", "()[Ljugglinglab/util/Coordinate;", "setPositions", "([Ljugglinglab/util/Coordinate;)V", "[Ljugglinglab/util/Coordinate;", "times", "", "getTimes", "()[D", "setTimes", "([D)V", "velocities", "getVelocities", "setVelocities", "setCurve", "", "([D[Ljugglinglab/util/Coordinate;[Ljugglinglab/util/Coordinate;)V", "calcCurve", "translateTime", "deltat", "", "startTime", "getStartTime", "()D", "endTime", "getEndTime", "duration", "getDuration$annotations", "getDuration", "getCoordinate", "time", "newPosition", "getMax2", "time1", "time2", "getMin2", "max", "getMax", "()Ljugglinglab/util/Coordinate;", "min", "getMin", "check", "result", "t", "findmax", "", "Companion", "jugglinglab"})
public abstract class Curve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int numpoints;
    protected Coordinate[] positions;
    protected double[] times;
    protected Coordinate[] velocities;
    public static final int CURVE_SPLINE = 1;
    public static final int CURVE_LINE = 2;

    protected final int getNumpoints() {
        return this.numpoints;
    }

    protected final void setNumpoints(int n) {
        this.numpoints = n;
    }

    @NotNull
    protected final Coordinate[] getPositions() {
        if (this.positions != null) {
            return this.positions;
        }
        Intrinsics.throwUninitializedPropertyAccessException("positions");
        return null;
    }

    protected final void setPositions(@NotNull Coordinate[] coordinateArray) {
        Intrinsics.checkNotNullParameter(coordinateArray, "<set-?>");
        this.positions = coordinateArray;
    }

    @NotNull
    protected final double[] getTimes() {
        if (this.times != null) {
            return this.times;
        }
        Intrinsics.throwUninitializedPropertyAccessException("times");
        return null;
    }

    protected final void setTimes(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter(dArray, "<set-?>");
        this.times = dArray;
    }

    @NotNull
    protected final Coordinate[] getVelocities() {
        if (this.velocities != null) {
            return this.velocities;
        }
        Intrinsics.throwUninitializedPropertyAccessException("velocities");
        return null;
    }

    protected final void setVelocities(@NotNull Coordinate[] coordinateArray) {
        Intrinsics.checkNotNullParameter(coordinateArray, "<set-?>");
        this.velocities = coordinateArray;
    }

    public final void setCurve(@NotNull double[] times, @NotNull Coordinate[] positions, @NotNull Coordinate[] velocities) throws JuggleExceptionInternal {
        Intrinsics.checkNotNullParameter(times, "times");
        Intrinsics.checkNotNullParameter(positions, "positions");
        Intrinsics.checkNotNullParameter(velocities, "velocities");
        this.numpoints = times.length;
        this.setTimes(times);
        this.setPositions(positions);
        this.setVelocities(velocities);
        if (this.numpoints != positions.length || this.numpoints != velocities.length) {
            throw new JuggleExceptionInternal("Curve error 1");
        }
    }

    public abstract void calcCurve() throws JuggleExceptionInternal;

    public final void translateTime(double deltat) {
        int i2 = 0;
        int n = this.numpoints;
        while (i2 < n) {
            double[] dArray = this.getTimes();
            int n2 = i2++;
            dArray[n2] = dArray[n2] + deltat;
        }
    }

    public final double getStartTime() {
        return this.getTimes()[0];
    }

    public final double getEndTime() {
        return this.getTimes()[this.numpoints - 1];
    }

    public final double getDuration() {
        return this.getTimes()[this.numpoints - 1] - this.getTimes()[0];
    }

    public static /* synthetic */ void getDuration$annotations() {
    }

    public abstract void getCoordinate(double var1, @NotNull Coordinate var3);

    @Nullable
    protected abstract Coordinate getMax2(double var1, double var3);

    @Nullable
    protected abstract Coordinate getMin2(double var1, double var3);

    @Nullable
    public final Coordinate getMax() {
        return this.getMax2(this.getTimes()[0], this.getTimes()[this.numpoints - 1]);
    }

    @Nullable
    public final Coordinate getMin() {
        return this.getMin2(this.getTimes()[0], this.getTimes()[this.numpoints - 1]);
    }

    @Nullable
    public final Coordinate getMax(double time1, double time2) {
        return time2 < this.getStartTime() || time1 > this.getEndTime() ? null : this.getMax2(time1, time2);
    }

    @Nullable
    public final Coordinate getMin(double time1, double time2) {
        return time2 < this.getStartTime() || time1 > this.getEndTime() ? null : this.getMin2(time1, time2);
    }

    @NotNull
    protected final Coordinate check(@Nullable Coordinate result, double t2, boolean findmax) {
        Coordinate coordinate;
        Coordinate loc = new Coordinate(0.0, 0.0, 0.0, 7, null);
        this.getCoordinate(t2, loc);
        if (result == null) {
            coordinate = loc;
        } else if (findmax) {
            Coordinate coordinate2 = Coordinate.Companion.max(result, loc);
            coordinate = coordinate2;
            Intrinsics.checkNotNull(coordinate2);
        } else {
            Coordinate coordinate3 = Coordinate.Companion.min(result, loc);
            coordinate = coordinate3;
            Intrinsics.checkNotNull(coordinate3);
        }
        return coordinate;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljugglinglab/curve/Curve$Companion;", "", "<init>", "()V", "CURVE_SPLINE", "", "getCURVE_SPLINE$annotations", "CURVE_LINE", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getCURVE_SPLINE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

