/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.curve;

import jugglinglab.curve.Curve;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0014J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u000b\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljugglinglab/curve/LineCurve;", "Ljugglinglab/curve/Curve;", "<init>", "()V", "n", "", "a", "", "", "[[D", "b", "durations", "calcCurve", "", "getCoordinate", "time", "", "newPosition", "Ljugglinglab/util/Coordinate;", "getMax2", "time1", "time2", "getMin2", "jugglinglab"})
public final class LineCurve
extends Curve {
    private int n;
    private double[][] a;
    private double[][] b;
    private double[] durations;

    @Override
    public void calcCurve() throws JuggleExceptionInternal {
        int n;
        this.n = this.getNumpoints() - 1;
        if (this.n < 1) {
            throw new JuggleExceptionInternal("LineCurve error 1");
        }
        int n2 = 0;
        int n3 = this.n;
        double[][] dArrayArray = new double[n3][];
        LineCurve lineCurve = this;
        while (n2 < n3) {
            n = n2++;
            dArrayArray[n] = new double[3];
        }
        lineCurve.a = dArrayArray;
        n2 = 0;
        n3 = this.n;
        dArrayArray = new double[n3][];
        lineCurve = this;
        while (n2 < n3) {
            n = n2++;
            dArrayArray[n] = new double[3];
        }
        lineCurve.b = dArrayArray;
        this.durations = new double[this.n];
        n3 = this.n;
        for (int i2 = 0; i2 < n3; ++i2) {
            double[] dArray = this.durations;
            if (this.durations == null) {
                Intrinsics.throwUninitializedPropertyAccessException("durations");
                dArray = null;
            }
            dArray[i2] = this.getTimes()[i2 + 1] - this.getTimes()[i2];
            double[] dArray2 = this.durations;
            if (this.durations == null) {
                Intrinsics.throwUninitializedPropertyAccessException("durations");
                dArray2 = null;
            }
            if (!(dArray2[i2] <= 0.0)) continue;
            throw new JuggleExceptionInternal("LineCurve error 2");
        }
        double[] x = new double[this.n + 1];
        for (int i3 = 0; i3 < 3; ++i3) {
            int j;
            n = this.n + 1;
            for (j = 0; j < n; ++j) {
                x[j] = this.getPositions()[j].get(i3);
            }
            n = this.n;
            for (j = 0; j < n; ++j) {
                double[][] dArray = this.a;
                if (this.a == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("a");
                    dArray = null;
                }
                dArray[j][i3] = x[j];
                double[][] dArray3 = this.b;
                if (this.b == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("b");
                    dArray3 = null;
                }
                double[] dArray4 = dArray3[j];
                double d = x[j + 1] - x[j];
                double[] dArray5 = this.durations;
                if (this.durations == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("durations");
                    dArray5 = null;
                }
                dArray4[i3] = d / dArray5[j];
            }
        }
    }

    @Override
    public void getCoordinate(double time, @NotNull Coordinate newPosition) {
        int i2;
        Intrinsics.checkNotNullParameter(newPosition, "newPosition");
        double d = this.getTimes()[0];
        if (!(time <= this.getTimes()[this.n] ? d <= time : false)) {
            return;
        }
        for (i2 = 0; i2 < this.n && !(time <= this.getTimes()[i2 + 1]); ++i2) {
        }
        i2 = Math.min(i2, this.n - 1);
        double t2 = time - this.getTimes()[i2];
        double[][] dArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException("a");
            dArray = null;
        }
        double d2 = dArray[i2][0];
        double[][] dArray2 = this.b;
        if (this.b == null) {
            Intrinsics.throwUninitializedPropertyAccessException("b");
            dArray2 = null;
        }
        double d3 = d2 + t2 * dArray2[i2][0];
        double[][] dArray3 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException("a");
            dArray3 = null;
        }
        double d4 = dArray3[i2][1];
        double[][] dArray4 = this.b;
        if (this.b == null) {
            Intrinsics.throwUninitializedPropertyAccessException("b");
            dArray4 = null;
        }
        double d5 = d4 + t2 * dArray4[i2][1];
        double[][] dArray5 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException("a");
            dArray5 = null;
        }
        double d6 = dArray5[i2][2];
        double[][] dArray6 = this.b;
        if (this.b == null) {
            Intrinsics.throwUninitializedPropertyAccessException("b");
            dArray6 = null;
        }
        newPosition.setCoordinate(d3, d5, d6 + t2 * dArray6[i2][2]);
    }

    @Override
    @Nullable
    protected Coordinate getMax2(double time1, double time2) {
        if (time2 < this.getTimes()[0] || time1 > this.getTimes()[this.n]) {
            return null;
        }
        double tlow = Math.max(this.getTimes()[0], time1);
        double thigh = Math.min(this.getTimes()[this.n], time2);
        Coordinate result = this.check(null, tlow, true);
        result = this.check(result, thigh, true);
        int i2 = 0;
        int n = this.n;
        if (i2 <= n) {
            while (true) {
                double thightemp;
                double tlowtemp;
                double d;
                boolean bl = tlow <= (d = this.getTimes()[i2]) ? d <= thigh : false;
                if (bl) {
                    result = this.check(result, this.getTimes()[i2], true);
                }
                if (i2 != this.n && (tlowtemp = Math.max(tlow, this.getTimes()[i2])) < (thightemp = Math.min(thigh, this.getTimes()[i2 + 1]))) {
                    result = this.check(result, tlowtemp, true);
                    result = this.check(result, thightemp, true);
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return result;
    }

    @Override
    @Nullable
    protected Coordinate getMin2(double time1, double time2) {
        if (time2 < this.getTimes()[0] || time1 > this.getTimes()[this.n]) {
            return null;
        }
        double tlow = Math.max(this.getTimes()[0], time1);
        double thigh = Math.min(this.getTimes()[this.n], time2);
        Coordinate result = this.check(null, tlow, false);
        result = this.check(result, thigh, false);
        int i2 = 0;
        int n = this.n;
        if (i2 <= n) {
            while (true) {
                double thightemp;
                double tlowtemp;
                double d;
                boolean bl = tlow <= (d = this.getTimes()[i2]) ? d <= thigh : false;
                if (bl) {
                    result = this.check(result, this.getTimes()[i2], false);
                }
                if (i2 != this.n && (tlowtemp = Math.max(tlow, this.getTimes()[i2])) < (thightemp = Math.min(thigh, this.getTimes()[i2 + 1]))) {
                    result = this.check(result, tlowtemp, false);
                    result = this.check(result, thightemp, false);
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return result;
    }
}

