/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.curve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jugglinglab.curve.Curve;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0014J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0019"}, d2={"Ljugglinglab/curve/SplineCurve;", "Ljugglinglab/curve/Curve;", "<init>", "()V", "n", "", "a", "", "", "[[D", "b", "c", "d", "calcCurve", "", "getCoordinate", "time", "", "newPosition", "Ljugglinglab/util/Coordinate;", "getMax2", "time1", "time2", "getMin2", "Companion", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nSplineCurve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplineCurve.kt\njugglinglab/curve/SplineCurve\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,571:1\n11228#2:572\n11563#2,3:573\n37#3:576\n36#3,3:577\n*S KotlinDebug\n*F\n+ 1 SplineCurve.kt\njugglinglab/curve/SplineCurve\n*L\n69#1:572\n69#1:573,3\n69#1:576\n69#1:577,3\n*E\n"})
public final class SplineCurve
extends Curve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int n;
    private double[][] a;
    private double[][] b;
    private double[][] c;
    private double[][] d;
    public static final int MINIMIZE_RMSACCEL = 0;
    public static final int CONTINUOUS_ACCEL = 1;
    public static final int MINIMIZE_RMSVEL = 2;

    /*
     * WARNING - void declaration
     */
    @Override
    public void calcCurve() throws JuggleExceptionInternal {
        void $this$mapTo$iv$iv;
        int n;
        this.n = this.getNumpoints() - 1;
        if (this.n < 1) {
            throw new JuggleExceptionInternal("SplineCurve error 1");
        }
        int n2 = 0;
        int n3 = this.n;
        double[][] dArrayArray = new double[n3][];
        Object object = this;
        while (n2 < n3) {
            n = n2++;
            dArrayArray[n] = new double[3];
        }
        ((SplineCurve)object).a = dArrayArray;
        n2 = 0;
        n3 = this.n;
        dArrayArray = new double[n3][];
        object = this;
        while (n2 < n3) {
            n = n2++;
            dArrayArray[n] = new double[3];
        }
        ((SplineCurve)object).b = dArrayArray;
        n2 = 0;
        n3 = this.n;
        dArrayArray = new double[n3][];
        object = this;
        while (n2 < n3) {
            n = n2++;
            dArrayArray[n] = new double[3];
        }
        ((SplineCurve)object).c = dArrayArray;
        n2 = 0;
        n3 = this.n;
        dArrayArray = new double[n3][];
        object = this;
        while (n2 < n3) {
            n = n2++;
            dArrayArray[n] = new double[3];
        }
        ((SplineCurve)object).d = dArrayArray;
        double[] durations = new double[this.n];
        int n4 = this.n;
        for (int i2 = 0; i2 < n4; ++i2) {
            durations[i2] = this.getTimes()[i2 + 1] - this.getTimes()[i2];
            if (!(durations[i2] <= 0.0)) continue;
            throw new JuggleExceptionInternal("SplineCurve error 2");
        }
        Coordinate[] $this$map$iv = this.getVelocities();
        boolean $i$f$map = false;
        Coordinate[] coordinateArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n5 = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n5; ++j) {
            void it;
            void item$iv$iv;
            void var11_20 = item$iv$iv = $this$mapTo$iv$iv[j];
            object = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            object.add(v0 != null ? Coordinate.copy$default((Coordinate)v0, 0.0, 0.0, 0.0, 7, null) : null);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Coordinate[] vel = thisCollection$iv.toArray(new Coordinate[0]);
        if (vel[0] != null && vel[this.n] != null) {
            SplineCurve.Companion.findvelsEdgesKnown(this.n, durations, this.getPositions(), vel);
        } else {
            SplineCurve.Companion.findvelsEdgesUnknown(this.n, durations, this.getPositions(), vel);
        }
        n = this.n;
        for (int i3 = 0; i3 < n; ++i3) {
            double t2 = durations[i3];
            for (int j = 0; j < 3; ++j) {
                double xi0 = this.getPositions()[i3].get(j);
                double xi1 = this.getPositions()[i3 + 1].get(j);
                Coordinate coordinate = vel[i3];
                Intrinsics.checkNotNull(coordinate);
                double vi0 = coordinate.get(j);
                Coordinate coordinate2 = vel[i3 + 1];
                Intrinsics.checkNotNull(coordinate2);
                double vi1 = coordinate2.get(j);
                double[][] dArray = this.a;
                if (this.a == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("a");
                    dArray = null;
                }
                dArray[i3][j] = xi0;
                double[][] dArray2 = this.b;
                if (this.b == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("b");
                    dArray2 = null;
                }
                dArray2[i3][j] = vi0;
                double[][] dArray3 = this.c;
                if (this.c == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("c");
                    dArray3 = null;
                }
                dArray3[i3][j] = ((double)3 * (xi1 - xi0) - (vi1 + (double)2 * vi0) * t2) / (t2 * t2);
                double[][] dArray4 = this.d;
                if (this.d == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("d");
                    dArray4 = null;
                }
                dArray4[i3][j] = ((double)-2 * (xi1 - xi0) + (vi1 + vi0) * t2) / (t2 * t2 * t2);
            }
        }
    }

    @Override
    public void getCoordinate(double time, @NotNull Coordinate newPosition) {
        int i2;
        Intrinsics.checkNotNullParameter(newPosition, "newPosition");
        double d = this.getTimes()[0];
        if (!(time <= this.getTimes()[this.n] ? d <= time : false)) {
            return;
        }
        for (i2 = 0; i2 < this.n && !(time <= this.getTimes()[i2 + 1]); ++i2) {
        }
        i2 = Math.min(i2, this.n - 1);
        double t2 = time - this.getTimes()[i2];
        double[][] dArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException("a");
            dArray = null;
        }
        double d2 = dArray[i2][0];
        double[][] dArray2 = this.b;
        if (this.b == null) {
            Intrinsics.throwUninitializedPropertyAccessException("b");
            dArray2 = null;
        }
        double d3 = dArray2[i2][0];
        double[][] dArray3 = this.c;
        if (this.c == null) {
            Intrinsics.throwUninitializedPropertyAccessException("c");
            dArray3 = null;
        }
        double d4 = dArray3[i2][0];
        double[][] dArray4 = this.d;
        if (this.d == null) {
            Intrinsics.throwUninitializedPropertyAccessException("d");
            dArray4 = null;
        }
        double d5 = d2 + t2 * (d3 + t2 * (d4 + t2 * dArray4[i2][0]));
        double[][] dArray5 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException("a");
            dArray5 = null;
        }
        double d6 = dArray5[i2][1];
        double[][] dArray6 = this.b;
        if (this.b == null) {
            Intrinsics.throwUninitializedPropertyAccessException("b");
            dArray6 = null;
        }
        double d7 = dArray6[i2][1];
        double[][] dArray7 = this.c;
        if (this.c == null) {
            Intrinsics.throwUninitializedPropertyAccessException("c");
            dArray7 = null;
        }
        double d8 = dArray7[i2][1];
        double[][] dArray8 = this.d;
        if (this.d == null) {
            Intrinsics.throwUninitializedPropertyAccessException("d");
            dArray8 = null;
        }
        double d9 = d6 + t2 * (d7 + t2 * (d8 + t2 * dArray8[i2][1]));
        double[][] dArray9 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException("a");
            dArray9 = null;
        }
        double d10 = dArray9[i2][2];
        double[][] dArray10 = this.b;
        if (this.b == null) {
            Intrinsics.throwUninitializedPropertyAccessException("b");
            dArray10 = null;
        }
        double d11 = dArray10[i2][2];
        double[][] dArray11 = this.c;
        if (this.c == null) {
            Intrinsics.throwUninitializedPropertyAccessException("c");
            dArray11 = null;
        }
        double d12 = dArray11[i2][2];
        double[][] dArray12 = this.d;
        if (this.d == null) {
            Intrinsics.throwUninitializedPropertyAccessException("d");
            dArray12 = null;
        }
        newPosition.setCoordinate(d5, d9, d10 + t2 * (d11 + t2 * (d12 + t2 * dArray12[i2][2])));
    }

    @Override
    @Nullable
    protected Coordinate getMax2(double time1, double time2) {
        if (time2 < this.getTimes()[0] || time1 > this.getTimes()[this.n]) {
            return null;
        }
        double tlow = Math.max(this.getTimes()[0], time1);
        double thigh = Math.min(this.getTimes()[this.n], time2);
        Coordinate result = this.check(null, tlow, true);
        result = this.check(result, thigh, true);
        int i2 = 0;
        int n = this.n;
        if (i2 <= n) {
            while (true) {
                double thightemp;
                double tlowtemp;
                double d;
                boolean bl = tlow <= (d = this.getTimes()[i2]) ? d <= thigh : false;
                if (bl) {
                    result = this.check(result, this.getTimes()[i2], true);
                }
                if (i2 != this.n && (tlowtemp = Math.max(tlow, this.getTimes()[i2])) < (thightemp = Math.min(thigh, this.getTimes()[i2 + 1]))) {
                    result = this.check(result, tlowtemp, true);
                    result = this.check(result, thightemp, true);
                    for (int index = 0; index < 3; ++index) {
                        double te;
                        double[][] dArray = this.d;
                        if (this.d == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("d");
                            dArray = null;
                        }
                        if (Math.abs(dArray[i2][index]) > 1.0E-6) {
                            double te2;
                            double k;
                            double[][] dArray2 = this.c;
                            if (this.c == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("c");
                                dArray2 = null;
                            }
                            double d2 = dArray2[i2][index];
                            double[][] dArray3 = this.c;
                            if (this.c == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("c");
                                dArray3 = null;
                            }
                            double d3 = d2 * dArray3[i2][index];
                            double d4 = 3;
                            double[][] dArray4 = this.b;
                            if (this.b == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("b");
                                dArray4 = null;
                            }
                            double d5 = d4 * dArray4[i2][index];
                            double[][] dArray5 = this.d;
                            if (this.d == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("d");
                                dArray5 = null;
                            }
                            if (!((k = d3 - d5 * dArray5[i2][index]) > 0.0)) continue;
                            double d6 = this.getTimes()[i2];
                            double[][] dArray6 = this.c;
                            if (this.c == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("c");
                                dArray6 = null;
                            }
                            double d7 = -dArray6[i2][index] - Math.sqrt(k);
                            double d8 = 3;
                            double[][] dArray7 = this.d;
                            if (this.d == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("d");
                                dArray7 = null;
                            }
                            boolean bl2 = tlowtemp <= (te2 = d6 + d7 / (d8 * dArray7[i2][index])) ? te2 <= thightemp : false;
                            if (!bl2) continue;
                            result = this.check(result, te2, true);
                            continue;
                        }
                        double[][] dArray8 = this.c;
                        if (this.c == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("c");
                            dArray8 = null;
                        }
                        if (!(dArray8[i2][index] < 0.0)) continue;
                        double d9 = this.getTimes()[i2];
                        double[][] dArray9 = this.b;
                        if (this.b == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("b");
                            dArray9 = null;
                        }
                        double d10 = dArray9[i2][index];
                        double d11 = 2;
                        double[][] dArray10 = this.c;
                        if (this.c == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("c");
                            dArray10 = null;
                        }
                        boolean bl3 = tlowtemp <= (te = d9 - d10 / (d11 * dArray10[i2][index])) ? te <= thightemp : false;
                        if (!bl3) continue;
                        result = this.check(result, te, true);
                    }
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return result;
    }

    @Override
    @Nullable
    protected Coordinate getMin2(double time1, double time2) {
        if (time2 < this.getTimes()[0] || time1 > this.getTimes()[this.n]) {
            return null;
        }
        double tlow = Math.max(this.getTimes()[0], time1);
        double thigh = Math.min(this.getTimes()[this.n], time2);
        Coordinate result = this.check(null, tlow, false);
        result = this.check(result, thigh, false);
        int i2 = 0;
        int n = this.n;
        if (i2 <= n) {
            while (true) {
                double thightemp;
                double tlowtemp;
                double d;
                boolean bl = tlow <= (d = this.getTimes()[i2]) ? d <= thigh : false;
                if (bl) {
                    result = this.check(result, this.getTimes()[i2], false);
                }
                if (i2 != this.n && (tlowtemp = Math.max(tlow, this.getTimes()[i2])) < (thightemp = Math.min(thigh, this.getTimes()[i2 + 1]))) {
                    result = this.check(result, tlowtemp, false);
                    result = this.check(result, thightemp, false);
                    for (int index = 0; index < 3; ++index) {
                        double te;
                        double[][] dArray = this.d;
                        if (this.d == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("d");
                            dArray = null;
                        }
                        if (Math.abs(dArray[i2][index]) > 1.0E-6) {
                            double te2;
                            double k;
                            double[][] dArray2 = this.c;
                            if (this.c == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("c");
                                dArray2 = null;
                            }
                            double d2 = dArray2[i2][index];
                            double[][] dArray3 = this.c;
                            if (this.c == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("c");
                                dArray3 = null;
                            }
                            double d3 = d2 * dArray3[i2][index];
                            double d4 = 3;
                            double[][] dArray4 = this.b;
                            if (this.b == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("b");
                                dArray4 = null;
                            }
                            double d5 = d4 * dArray4[i2][index];
                            double[][] dArray5 = this.d;
                            if (this.d == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("d");
                                dArray5 = null;
                            }
                            if (!((k = d3 - d5 * dArray5[i2][index]) > 0.0)) continue;
                            double d6 = this.getTimes()[i2];
                            double[][] dArray6 = this.c;
                            if (this.c == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("c");
                                dArray6 = null;
                            }
                            double d7 = -dArray6[i2][index] + Math.sqrt(k);
                            double d8 = 3;
                            double[][] dArray7 = this.d;
                            if (this.d == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("d");
                                dArray7 = null;
                            }
                            boolean bl2 = tlowtemp <= (te2 = d6 + d7 / (d8 * dArray7[i2][index])) ? te2 <= thightemp : false;
                            if (!bl2) continue;
                            result = this.check(result, te2, false);
                            continue;
                        }
                        double[][] dArray8 = this.c;
                        if (this.c == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("c");
                            dArray8 = null;
                        }
                        if (!(dArray8[i2][index] > 0.0)) continue;
                        double d9 = this.getTimes()[i2];
                        double[][] dArray9 = this.b;
                        if (this.b == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("b");
                            dArray9 = null;
                        }
                        double d10 = dArray9[i2][index];
                        double d11 = 2;
                        double[][] dArray10 = this.c;
                        if (this.c == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("c");
                            dArray10 = null;
                        }
                        boolean bl3 = tlowtemp <= (te = d9 - d10 / (d11 * dArray10[i2][index])) ? te <= thightemp : false;
                        if (!bl3) continue;
                        result = this.check(result, te, false);
                    }
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return result;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011J;\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011J8\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljugglinglab/curve/SplineCurve$Companion;", "", "<init>", "()V", "MINIMIZE_RMSACCEL", "", "CONTINUOUS_ACCEL", "MINIMIZE_RMSVEL", "findvelsEdgesKnown", "", "n", "t", "", "x", "", "Ljugglinglab/util/Coordinate;", "v", "(I[D[Ljugglinglab/util/Coordinate;[Ljugglinglab/util/Coordinate;)V", "findvelsEdgesUnknown", "tridag", "a", "b", "c", "r", "u", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        private final void findvelsEdgesKnown(int n, double[] t2, Coordinate[] x, Coordinate[] v) throws JuggleExceptionInternal {
            if (n < 2) {
                return;
            }
            int numcatches = 0;
            for (int i2 = 1; i2 < n; ++i2) {
                if (v[i2] == null) continue;
                ++numcatches;
            }
            int dim = 3 * (n - 1) + 2 * numcatches;
            int n2 = 0;
            double[][] dArrayArray = new double[dim][];
            while (n2 < dim) {
                int n3 = n2++;
                dArrayArray[n3] = new double[dim];
            }
            double[][] m = dArrayArray;
            double[] b = new double[dim];
            for (int axis = 0; axis < 3; ++axis) {
                Coordinate coordinate = v[0];
                Intrinsics.checkNotNull(coordinate);
                double v0 = coordinate.get(axis);
                Coordinate coordinate2 = v[n];
                Intrinsics.checkNotNull(coordinate2);
                double vn = coordinate2.get(axis);
                int n4 = n - 1;
                for (int i3 = 0; i3 < n4; ++i3) {
                    double offdiag1;
                    double xi0 = x[i3].get(axis);
                    double xi1 = x[i3 + 1].get(axis);
                    double xi2 = x[i3 + 2].get(axis);
                    int index = i3 + axis * (n - 1);
                    m[index][index] = (double)2 / t2[i3] + (double)2 / t2[i3 + 1];
                    double d = offdiag1 = i3 == n - 2 ? 0.0 : 1.0 / t2[i3 + 1];
                    if (index < 3 * (n - 1) - 1) {
                        m[index][index + 1] = offdiag1;
                        m[index + 1][index] = offdiag1;
                    }
                    b[index] = (double)3 * (xi2 - xi1) / (t2[i3 + 1] * t2[i3 + 1]) + (double)3 * (xi1 - xi0) / (t2[i3] * t2[i3]);
                    if (i3 == 0) {
                        b[index] = b[index] - v0 / t2[0];
                    }
                    if (i3 != n - 2) continue;
                    b[index] = b[index] - vn / t2[n - 1];
                }
            }
            int i4 = 0;
            int catchnum = 0;
            while (i4 < n - 1) {
                if (v[i4 + 1] == null) {
                    ++i4;
                    continue;
                }
                int index = 3 * (n - 1) + 2 * catchnum;
                Coordinate coordinate = v[i4 + 1];
                Intrinsics.checkNotNull(coordinate);
                double ci0 = coordinate.get(0);
                Coordinate coordinate3 = v[i4 + 1];
                Intrinsics.checkNotNull(coordinate3);
                double ci1 = coordinate3.get(1);
                Coordinate coordinate4 = v[i4 + 1];
                Intrinsics.checkNotNull(coordinate4);
                double ci2 = coordinate4.get(2);
                int largeaxis = Math.abs(ci1) >= Math.max(Math.abs(ci0), Math.abs(ci2)) ? 1 : (Math.abs(ci2) >= Math.max(Math.abs(ci0), Math.abs(ci1)) ? 2 : 0);
                switch (largeaxis) {
                    case 0: {
                        m[index][i4] = ci2;
                        m[i4][index] = ci2;
                        m[index + 1][i4] = ci1;
                        m[i4][index + 1] = ci1;
                        m[index + 1][i4 + (n - 1)] = -ci0;
                        m[i4 + (n - 1)][index + 1] = -ci0;
                        m[index][i4 + 2 * (n - 1)] = -ci0;
                        m[i4 + 2 * (n - 1)][index] = -ci0;
                        break;
                    }
                    case 1: {
                        m[index + 1][i4] = ci1;
                        m[i4][index + 1] = ci1;
                        m[index][i4 + (n - 1)] = ci2;
                        m[i4 + (n - 1)][index] = ci2;
                        m[index + 1][i4 + (n - 1)] = -ci0;
                        m[i4 + (n - 1)][index + 1] = -ci0;
                        m[index][i4 + 2 * (n - 1)] = -ci1;
                        m[i4 + 2 * (n - 1)][index] = -ci1;
                        break;
                    }
                    case 2: {
                        m[index + 1][i4] = ci2;
                        m[i4][index + 1] = ci2;
                        m[index][i4 + (n - 1)] = ci2;
                        m[i4 + (n - 1)][index] = ci2;
                        m[index][i4 + 2 * (n - 1)] = -ci1;
                        m[i4 + 2 * (n - 1)][index] = -ci1;
                        m[index + 1][i4 + 2 * (n - 1)] = -ci0;
                        m[i4 + 2 * (n - 1)][index + 1] = -ci0;
                    }
                }
                ++catchnum;
                ++i4;
            }
            try {
                DecompositionSolver solver = new LUDecomposition(new Array2DRowRealMatrix(m)).getSolver();
                RealVector solution = solver.solve(new ArrayRealVector(b));
                int n5 = n - 1;
                for (int i5 = 0; i5 < n5; ++i5) {
                    v[i5 + 1] = new Coordinate(solution.getEntry(i5), solution.getEntry(i5 + (n - 1)), solution.getEntry(i5 + 2 * (n - 1)));
                }
            }
            catch (SingularMatrixException singularMatrixException) {
                throw new JuggleExceptionInternal("Singular matrix in findvelsEdgesKnown()");
            }
        }

        private final void findvelsEdgesUnknown(int n, double[] t2, Coordinate[] x, Coordinate[] v) throws JuggleExceptionInternal {
            if (n < 1) {
                return;
            }
            double[] Adiag = new double[n];
            double[] Aoffd = new double[n];
            double Acorner = 0.0;
            double[] b = new double[n];
            for (int i2 = 0; i2 < n; ++i2) {
                v[i2] = new Coordinate(0.0, 0.0, 0.0, 7, null);
            }
            for (int axis = 0; axis < 3; ++axis) {
                double xn0 = x[n].get(axis);
                double xnm1 = x[n - 1].get(axis);
                for (int i3 = 0; i3 < n; ++i3) {
                    double xi0 = x[i3].get(axis);
                    double xi1 = x[i3 + 1].get(axis);
                    double xim1 = i3 == 0 ? 0.0 : x[i3 - 1].get(axis);
                    if (i3 == 0) {
                        Adiag[i3] = (double)2 / t2[n - 1] + (double)2 / t2[0];
                        Acorner = 1.0 / t2[n - 1];
                        b[i3] = (double)3 * (xi1 - xi0) / (t2[0] * t2[0]) + (double)3 * (xn0 - xnm1) / (t2[n - 1] * t2[n - 1]);
                    } else {
                        Adiag[i3] = (double)2 / t2[i3 - 1] + (double)2 / t2[i3];
                        b[i3] = (double)3 * (xi1 - xi0) / (t2[i3] * t2[i3]) + (double)3 * (xi0 - xim1) / (t2[i3 - 1] * t2[i3 - 1]);
                    }
                    Aoffd[i3] = 1.0 / t2[i3];
                }
                int xi0 = 0;
                double[] dArray = new double[n];
                while (xi0 < n) {
                    int xi1 = xi0++;
                    Coordinate coordinate = v[xi1];
                    Intrinsics.checkNotNull(coordinate);
                    dArray[xi1] = coordinate.get(axis);
                }
                double[] vel = dArray;
                this.tridag(Aoffd, Adiag, Aoffd, b, vel, n);
                if (n > 2) {
                    double[] z1 = new double[n];
                    b[0] = Acorner;
                    for (int i4 = 1; i4 < n; ++i4) {
                        b[i4] = 0.0;
                    }
                    this.tridag(Aoffd, Adiag, Aoffd, b, z1, n);
                    double[] z2 = new double[n];
                    b[n - 1] = Acorner;
                    int n2 = n - 1;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        b[i5] = 0.0;
                    }
                    this.tridag(Aoffd, Adiag, Aoffd, b, z2, n);
                    double H00 = 1.0 + z2[0];
                    double H01 = -z2[n - 1];
                    double H10 = -z1[0];
                    double H11 = 1.0 + z1[n - 1];
                    double det = H00 * H11 - H01 * H10;
                    double m0 = (H00 /= det) * vel[n - 1] + (H01 /= det) * vel[0];
                    double m1 = (H10 /= det) * vel[n - 1] + (H11 /= det) * vel[0];
                    for (int i6 = 0; i6 < n; ++i6) {
                        int n3 = i6;
                        vel[n3] = vel[n3] - (z1[i6] * m0 + z2[i6] * m1);
                    }
                }
                for (int i7 = 0; i7 < n; ++i7) {
                    Coordinate coordinate = v[i7];
                    Intrinsics.checkNotNull(coordinate);
                    coordinate.set(axis, vel[i7]);
                }
            }
            Coordinate coordinate = v[0];
            v[n] = coordinate != null ? Coordinate.copy$default(coordinate, 0.0, 0.0, 0.0, 7, null) : null;
        }

        private final void tridag(double[] a, double[] b, double[] c, double[] r, double[] u, int n) throws JuggleExceptionInternal {
            int j;
            if (b[0] == 0.0) {
                throw new JuggleExceptionInternal("Error 1 in tridag()");
            }
            double bet = b[0];
            double[] gam = new double[n];
            u[0] = r[0] / bet;
            for (j = 1; j < n; ++j) {
                gam[j] = c[j - 1] / bet;
                bet = b[j] - a[j - 1] * gam[j];
                if (bet == 0.0) {
                    throw new JuggleExceptionInternal("Error 2 in tridag()");
                }
                u[j] = (r[j] - a[j - 1] * u[j - 1]) / bet;
            }
            for (j = n - 1; 0 < j; --j) {
                int n2 = j - 1;
                u[n2] = u[n2] - gam[j] * u[j];
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

