/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.generator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jugglinglab.JugglingLab;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010\u0015\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u007f2\u00020\u0001:\u0001\u007fB\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010u\u001a\u00020[2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010vJ\b\u0010w\u001a\u00020xH\u0002J\u001b\u0010y\u001a\u00020x2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010z\u001a\u00020xH\u0002J\u0010\u0010{\u001a\u00020x2\u0006\u0010|\u001a\u00020[H\u0002J\u0019\u0010}\u001a\u00020x2\f\u0010~\u001a\b\u0012\u0004\u0012\u00020C0\u0003\u00a2\u0006\u0002\u0010GR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR\u001a\u0010\u0016\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\n\"\u0004\b\u0018\u0010\fR*\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R*\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\n\"\u0004\b&\u0010\fR\u001a\u0010'\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\n\"\u0004\b)\u0010\fR\u001a\u0010*\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\n\"\u0004\b,\u0010\fR\u001a\u0010-\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\n\"\u0004\b/\u0010\fR\u001a\u00100\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\n\"\u0004\b2\u0010\fR\u001a\u00103\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\n\"\u0004\b5\u0010\fR\u001a\u00106\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\n\"\u0004\b8\u0010\fR\u001a\u00109\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\n\"\u0004\b;\u0010\fR\u001a\u0010<\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\n\"\u0004\b>\u0010\fR\u001a\u0010?\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\n\"\u0004\bA\u0010\fR\"\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u0003X\u0086.\u00a2\u0006\u0010\n\u0002\u0010H\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001a\u0010I\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\n\"\u0004\bK\u0010\fR\u001a\u0010L\u001a\u00020CX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001a\u0010Q\u001a\u00020CX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010N\"\u0004\bS\u0010PR\"\u0010T\u001a\b\u0012\u0004\u0012\u00020C0\u0003X\u0086.\u00a2\u0006\u0010\n\u0002\u0010H\u001a\u0004\bU\u0010E\"\u0004\bV\u0010GR\u001a\u0010W\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010\n\"\u0004\bY\u0010\fR\u001a\u0010Z\u001a\u00020[X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u001a\u0010`\u001a\u00020[X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010]\"\u0004\bb\u0010_R\u001a\u0010c\u001a\u00020[X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010]\"\u0004\be\u0010_R\u001a\u0010f\u001a\u00020[X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010]\"\u0004\bh\u0010_R\u001a\u0010i\u001a\u00020[X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010]\"\u0004\bk\u0010_R\u001a\u0010l\u001a\u00020[X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010]\"\u0004\bn\u0010_R\u001a\u0010o\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010\n\"\u0004\bq\u0010\fR\u001a\u0010r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bs\u0010\n\"\u0004\bt\u0010\f\u00a8\u0006\u0080\u0001"}, d2={"Ljugglinglab/generator/SiteswapGeneratorConfig;", "", "args", "", "", "<init>", "([Ljava/lang/String;)V", "n", "", "getN", "()I", "setN", "(I)V", "jugglers", "getJugglers", "setJugglers", "ht", "getHt", "setHt", "lMin", "getLMin", "setLMin", "lMax", "getLMax", "setLMax", "exclude", "Ljava/util/ArrayList;", "Ljava/util/regex/Pattern;", "Lkotlin/collections/ArrayList;", "getExclude", "()Ljava/util/ArrayList;", "setExclude", "(Ljava/util/ArrayList;)V", "include", "getInclude", "setInclude", "numflag", "getNumflag", "setNumflag", "groundflag", "getGroundflag", "setGroundflag", "rotflag", "getRotflag", "setRotflag", "fullflag", "getFullflag", "setFullflag", "mpflag", "getMpflag", "setMpflag", "multiplex", "getMultiplex", "setMultiplex", "delaytime", "getDelaytime", "setDelaytime", "hands", "getHands", "setHands", "maxOccupancy", "getMaxOccupancy", "setMaxOccupancy", "leaderPerson", "getLeaderPerson", "setLeaderPerson", "rhythmRepunit", "", "getRhythmRepunit", "()[[I", "setRhythmRepunit", "([[I)V", "[[I", "rhythmPeriod", "getRhythmPeriod", "setRhythmPeriod", "holdthrow", "getHoldthrow", "()[I", "setHoldthrow", "([I)V", "personNumber", "getPersonNumber", "setPersonNumber", "groundState", "getGroundState", "setGroundState", "groundStateLength", "getGroundStateLength", "setGroundStateLength", "mpClusteredFlag", "", "getMpClusteredFlag", "()Z", "setMpClusteredFlag", "(Z)V", "lameFlag", "getLameFlag", "setLameFlag", "sequenceFlag", "getSequenceFlag", "setSequenceFlag", "connectedPatternsFlag", "getConnectedPatternsFlag", "setConnectedPatternsFlag", "symmetricPatternsFlag", "getSymmetricPatternsFlag", "setSymmetricPatternsFlag", "jugglerPermutationsFlag", "getJugglerPermutationsFlag", "setJugglerPermutationsFlag", "mode", "getMode", "setMode", "slotSize", "getSlotSize", "setSlotSize", "parseInputFlags", "([Ljava/lang/String;)Z", "configMode", "", "parseInputConfig", "findGround", "configMultiplexing", "trueMultiplex", "printState", "st", "Companion", "jugglinglab"})
public final class SiteswapGeneratorConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int n;
    private int jugglers;
    private int ht;
    private int lMin;
    private int lMax;
    @NotNull
    private ArrayList<Pattern> exclude;
    @NotNull
    private ArrayList<Pattern> include;
    private int numflag;
    private int groundflag;
    private int rotflag;
    private int fullflag;
    private int mpflag;
    private int multiplex;
    private int delaytime;
    private int hands;
    private int maxOccupancy;
    private int leaderPerson;
    public int[][] rhythmRepunit;
    private int rhythmPeriod;
    public int[] holdthrow;
    public int[] personNumber;
    public int[][] groundState;
    private int groundStateLength;
    private boolean mpClusteredFlag;
    private boolean lameFlag;
    private boolean sequenceFlag;
    private boolean connectedPatternsFlag;
    private boolean symmetricPatternsFlag;
    private boolean jugglerPermutationsFlag;
    private int mode;
    private int slotSize;
    public static final int ASYNC = 0;
    public static final int SYNC = 1;
    @NotNull
    private static final int[][] async_rhythm_repunit;
    @NotNull
    private static final int[][] sync_rhythm_repunit;

    public final int getN() {
        return this.n;
    }

    public final void setN(int n) {
        this.n = n;
    }

    public final int getJugglers() {
        return this.jugglers;
    }

    public final void setJugglers(int n) {
        this.jugglers = n;
    }

    public final int getHt() {
        return this.ht;
    }

    public final void setHt(int n) {
        this.ht = n;
    }

    public final int getLMin() {
        return this.lMin;
    }

    public final void setLMin(int n) {
        this.lMin = n;
    }

    public final int getLMax() {
        return this.lMax;
    }

    public final void setLMax(int n) {
        this.lMax = n;
    }

    @NotNull
    public final ArrayList<Pattern> getExclude() {
        return this.exclude;
    }

    public final void setExclude(@NotNull ArrayList<Pattern> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.exclude = arrayList;
    }

    @NotNull
    public final ArrayList<Pattern> getInclude() {
        return this.include;
    }

    public final void setInclude(@NotNull ArrayList<Pattern> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.include = arrayList;
    }

    public final int getNumflag() {
        return this.numflag;
    }

    public final void setNumflag(int n) {
        this.numflag = n;
    }

    public final int getGroundflag() {
        return this.groundflag;
    }

    public final void setGroundflag(int n) {
        this.groundflag = n;
    }

    public final int getRotflag() {
        return this.rotflag;
    }

    public final void setRotflag(int n) {
        this.rotflag = n;
    }

    public final int getFullflag() {
        return this.fullflag;
    }

    public final void setFullflag(int n) {
        this.fullflag = n;
    }

    public final int getMpflag() {
        return this.mpflag;
    }

    public final void setMpflag(int n) {
        this.mpflag = n;
    }

    public final int getMultiplex() {
        return this.multiplex;
    }

    public final void setMultiplex(int n) {
        this.multiplex = n;
    }

    public final int getDelaytime() {
        return this.delaytime;
    }

    public final void setDelaytime(int n) {
        this.delaytime = n;
    }

    public final int getHands() {
        return this.hands;
    }

    public final void setHands(int n) {
        this.hands = n;
    }

    public final int getMaxOccupancy() {
        return this.maxOccupancy;
    }

    public final void setMaxOccupancy(int n) {
        this.maxOccupancy = n;
    }

    public final int getLeaderPerson() {
        return this.leaderPerson;
    }

    public final void setLeaderPerson(int n) {
        this.leaderPerson = n;
    }

    @NotNull
    public final int[][] getRhythmRepunit() {
        if (this.rhythmRepunit != null) {
            return this.rhythmRepunit;
        }
        Intrinsics.throwUninitializedPropertyAccessException("rhythmRepunit");
        return null;
    }

    public final void setRhythmRepunit(@NotNull int[][] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<set-?>");
        this.rhythmRepunit = nArray;
    }

    public final int getRhythmPeriod() {
        return this.rhythmPeriod;
    }

    public final void setRhythmPeriod(int n) {
        this.rhythmPeriod = n;
    }

    @NotNull
    public final int[] getHoldthrow() {
        if (this.holdthrow != null) {
            return this.holdthrow;
        }
        Intrinsics.throwUninitializedPropertyAccessException("holdthrow");
        return null;
    }

    public final void setHoldthrow(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<set-?>");
        this.holdthrow = nArray;
    }

    @NotNull
    public final int[] getPersonNumber() {
        if (this.personNumber != null) {
            return this.personNumber;
        }
        Intrinsics.throwUninitializedPropertyAccessException("personNumber");
        return null;
    }

    public final void setPersonNumber(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<set-?>");
        this.personNumber = nArray;
    }

    @NotNull
    public final int[][] getGroundState() {
        if (this.groundState != null) {
            return this.groundState;
        }
        Intrinsics.throwUninitializedPropertyAccessException("groundState");
        return null;
    }

    public final void setGroundState(@NotNull int[][] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<set-?>");
        this.groundState = nArray;
    }

    public final int getGroundStateLength() {
        return this.groundStateLength;
    }

    public final void setGroundStateLength(int n) {
        this.groundStateLength = n;
    }

    public final boolean getMpClusteredFlag() {
        return this.mpClusteredFlag;
    }

    public final void setMpClusteredFlag(boolean bl) {
        this.mpClusteredFlag = bl;
    }

    public final boolean getLameFlag() {
        return this.lameFlag;
    }

    public final void setLameFlag(boolean bl) {
        this.lameFlag = bl;
    }

    public final boolean getSequenceFlag() {
        return this.sequenceFlag;
    }

    public final void setSequenceFlag(boolean bl) {
        this.sequenceFlag = bl;
    }

    public final boolean getConnectedPatternsFlag() {
        return this.connectedPatternsFlag;
    }

    public final void setConnectedPatternsFlag(boolean bl) {
        this.connectedPatternsFlag = bl;
    }

    public final boolean getSymmetricPatternsFlag() {
        return this.symmetricPatternsFlag;
    }

    public final void setSymmetricPatternsFlag(boolean bl) {
        this.symmetricPatternsFlag = bl;
    }

    public final boolean getJugglerPermutationsFlag() {
        return this.jugglerPermutationsFlag;
    }

    public final void setJugglerPermutationsFlag(boolean bl) {
        this.jugglerPermutationsFlag = bl;
    }

    public final int getMode() {
        return this.mode;
    }

    public final void setMode(int n) {
        this.mode = n;
    }

    public final int getSlotSize() {
        return this.slotSize;
    }

    public final void setSlotSize(int n) {
        this.slotSize = n;
    }

    public SiteswapGeneratorConfig(@NotNull String[] args) throws JuggleExceptionUser {
        Intrinsics.checkNotNullParameter(args, "args");
        this.jugglers = 1;
        this.exclude = new ArrayList();
        this.include = new ArrayList();
        this.fullflag = 1;
        this.mpflag = 1;
        this.multiplex = 1;
        this.leaderPerson = 1;
        this.mpClusteredFlag = true;
        this.sequenceFlag = true;
        if (args.length < 3) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_generator_insufficient_input"));
        }
        boolean trueMultiplex = this.parseInputFlags(args);
        this.configMode();
        this.parseInputConfig(args);
        this.findGround();
        this.configMultiplexing(trueMultiplex);
    }

    private final boolean parseInputFlags(String[] args) throws JuggleExceptionUser {
        boolean trueMultiplex = false;
        block60: for (int i2 = 3; i2 < args.length; ++i2) {
            switch (args[i2]) {
                case "-n": {
                    this.numflag = 1;
                    continue block60;
                }
                case "-no": {
                    this.numflag = 2;
                    continue block60;
                }
                case "-g": {
                    this.groundflag = 1;
                    continue block60;
                }
                case "-ng": {
                    this.groundflag = 2;
                    continue block60;
                }
                case "-f": {
                    this.fullflag = 0;
                    continue block60;
                }
                case "-prime": {
                    this.fullflag = 2;
                    continue block60;
                }
                case "-rot": {
                    this.rotflag = 1;
                    continue block60;
                }
                case "-jp": {
                    this.jugglerPermutationsFlag = true;
                    continue block60;
                }
                case "-lame": {
                    this.lameFlag = true;
                    continue block60;
                }
                case "-se": {
                    this.sequenceFlag = false;
                    continue block60;
                }
                case "-s": {
                    this.mode = 1;
                    continue block60;
                }
                case "-cp": {
                    this.connectedPatternsFlag = true;
                    continue block60;
                }
                case "-sym": {
                    this.symmetricPatternsFlag = true;
                    continue block60;
                }
                case "-mf": {
                    this.mpflag = 0;
                    continue block60;
                }
                case "-mc": {
                    this.mpClusteredFlag = false;
                    continue block60;
                }
                case "-mt": {
                    trueMultiplex = true;
                    continue block60;
                }
                case "-m": {
                    if (i2 >= args.length - 1 || args[i2 + 1].charAt(0) == '-') continue block60;
                    try {
                        this.multiplex = Integer.parseInt(args[i2 + 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                        String template = string;
                        String str = JugglingLab.INSTANCE.getGuistrings().getString("simultaneous_throws");
                        Object[] objectArray = new Object[]{str};
                        Object[] arguments = objectArray;
                        throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                    }
                    ++i2;
                    continue block60;
                }
                case "-j": {
                    if (i2 >= args.length - 1 || args[i2 + 1].charAt(0) == '-') continue block60;
                    try {
                        this.jugglers = Integer.parseInt(args[i2 + 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                        String template = string;
                        String str = JugglingLab.INSTANCE.getGuistrings().getString("Jugglers");
                        Object[] objectArray = new Object[]{str};
                        Object[] arguments = objectArray;
                        throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                    }
                    ++i2;
                    continue block60;
                }
                case "-d": {
                    if (i2 >= args.length - 1 || args[i2 + 1].charAt(0) == '-') continue block60;
                    try {
                        this.delaytime = Integer.parseInt(args[i2 + 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                        String template = string;
                        String str = JugglingLab.INSTANCE.getGuistrings().getString("Passing_communication_delay");
                        Object[] objectArray = new Object[]{str};
                        Object[] arguments = objectArray;
                        throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                    }
                    this.groundflag = 1;
                    ++i2;
                    continue block60;
                }
                case "-l": {
                    if (i2 >= args.length - 1 || args[i2 + 1].charAt(0) == '-') continue block60;
                    try {
                        this.leaderPerson = Integer.parseInt(args[i2 + 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                        String template = string;
                        String str = JugglingLab.INSTANCE.getGuistrings().getString("Error_passing_leader_number");
                        Object[] objectArray = new Object[]{str};
                        Object[] arguments = objectArray;
                        throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                    }
                    ++i2;
                    continue block60;
                }
                case "-x": {
                    Object re;
                    ++i2;
                    while (i2 < args.length && args[i2].charAt(0) != '-') {
                        try {
                            re = SiteswapGeneratorConfig.Companion.makeStandardRegex(args[i2]);
                            if (!StringsKt.contains$default((CharSequence)re, "^", false, 2, null)) {
                                re = ".*" + (String)re + ".*";
                            }
                            this.exclude.add(Pattern.compile((String)re));
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_excluded_throws"));
                        }
                        ++i2;
                    }
                    --i2;
                    continue block60;
                }
                case "-i": {
                    Object re;
                    ++i2;
                    while (i2 < args.length && args[i2].charAt(0) != '-') {
                        try {
                            re = SiteswapGeneratorConfig.Companion.makeStandardRegex(args[i2]);
                            if (!StringsKt.contains$default((CharSequence)re, "^", false, 2, null)) {
                                re = ".*" + (String)re;
                            }
                            if (!StringsKt.contains$default((CharSequence)re, "$", false, 2, null)) {
                                re = (String)re + ".*";
                            }
                            this.include.add(Pattern.compile((String)re));
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_included_throws"));
                        }
                        ++i2;
                    }
                    --i2;
                    continue block60;
                }
                default: {
                    String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_unrecognized_option");
                    Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                    String template = string;
                    Object[] objectArray = new Object[]{args[i2]};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                }
            }
        }
        return trueMultiplex;
    }

    private final void configMode() {
        switch (this.mode) {
            case 0: {
                int n = 0;
                int n2 = this.jugglers;
                int[][] nArrayArray = new int[n2][];
                SiteswapGeneratorConfig siteswapGeneratorConfig = this;
                while (n < n2) {
                    int n3 = n++;
                    nArrayArray[n3] = new int[1];
                }
                siteswapGeneratorConfig.setRhythmRepunit(nArrayArray);
                this.setHoldthrow(new int[this.jugglers]);
                this.setPersonNumber(new int[this.jugglers]);
                this.hands = this.jugglers;
                this.rhythmPeriod = 1;
                for (int i2 = 0; i2 < this.hands; ++i2) {
                    this.getRhythmRepunit()[i2][0] = async_rhythm_repunit[0][0];
                    this.getHoldthrow()[i2] = 2;
                    this.getPersonNumber()[i2] = i2 + 1;
                }
                break;
            }
            case 1: {
                int i2 = 0;
                int n = 2 * this.jugglers;
                int[][] nArrayArray = new int[n][];
                SiteswapGeneratorConfig siteswapGeneratorConfig = this;
                while (i2 < n) {
                    int n4 = i2++;
                    nArrayArray[n4] = new int[2];
                }
                siteswapGeneratorConfig.setRhythmRepunit(nArrayArray);
                this.setHoldthrow(new int[2 * this.jugglers]);
                this.setPersonNumber(new int[2 * this.jugglers]);
                this.hands = 2 * this.jugglers;
                this.rhythmPeriod = 2;
                for (i2 = 0; i2 < this.hands; ++i2) {
                    for (int j = 0; j < this.rhythmPeriod; ++j) {
                        this.getRhythmRepunit()[i2][j] = sync_rhythm_repunit[i2 % 2][j];
                    }
                    this.getHoldthrow()[i2] = 2;
                    this.getPersonNumber()[i2] = i2 / 2 + 1;
                }
                break;
            }
        }
    }

    private final void parseInputConfig(String[] args) throws JuggleExceptionUser {
        int n2;
        try {
            this.n = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException n2) {
            String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String template = string;
            String str = JugglingLab.INSTANCE.getGuistrings().getString("balls");
            Object[] objectArray = new Object[]{str};
            Object[] arguments = objectArray;
            throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
        }
        SiteswapGeneratorConfig siteswapGeneratorConfig = this;
        try {
            SiteswapGeneratorConfig siteswapGeneratorConfig2 = siteswapGeneratorConfig;
            n2 = Intrinsics.areEqual(args[1], "-") ? -1 : (new Regex("^[0-9]+$").matches(n2 = (CharSequence)args[1]) ? Integer.parseInt(args[1]) : Integer.parseInt(args[1], CharsKt.checkRadix(36)));
        }
        catch (NumberFormatException template) {
            SiteswapGeneratorConfig siteswapGeneratorConfig3 = siteswapGeneratorConfig;
            String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String template2 = string;
            String str = JugglingLab.INSTANCE.getGuistrings().getString("max._throw");
            Object[] objectArray = new Object[]{str};
            Object[] arguments = objectArray;
            throw new JuggleExceptionUser(MessageFormat.format(template2, Arrays.copyOf(arguments, arguments.length)));
        }
        siteswapGeneratorConfig2.ht = n2;
        try {
            if (Intrinsics.areEqual(args[2], "-")) {
                this.lMin = this.rhythmPeriod;
                this.lMax = -1;
            } else {
                int divider = StringsKt.indexOf$default((CharSequence)args[2], '-', 0, false, 6, null);
                if (divider == 0) {
                    this.lMin = this.rhythmPeriod;
                    String string = args[2].substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    this.lMax = Integer.parseInt(string);
                } else if (divider == args[2].length() - 1) {
                    String string = args[2].substring(0, divider);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    this.lMin = Integer.parseInt(string);
                    this.lMax = -1;
                } else if (divider > 0) {
                    String string = args[2].substring(0, divider);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    this.lMin = Integer.parseInt(string);
                    String string2 = args[2].substring(divider + 1);
                    Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                    this.lMax = Integer.parseInt(string2);
                } else {
                    this.lMin = this.lMax = Integer.parseInt(args[2]);
                }
            }
        }
        catch (NumberFormatException <unused var>2) {
            String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String template = string;
            String str = JugglingLab.INSTANCE.getGuistrings().getString("period");
            Object[] objectArray = new Object[]{str};
            Object[] arguments = objectArray;
            throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
        }
        if (this.n < 1) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_generator_too_few_balls"));
        }
        if (this.lMax == -1) {
            if (this.fullflag != 2) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_generator_must_be_prime_mode"));
            }
            if (this.ht == -1) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_generator_underspecified"));
            }
            this.lMax = JLFunc.jlBinomial(this.ht * this.hands, this.n);
            this.lMax -= this.lMax % this.rhythmPeriod;
        }
        if (this.ht == -1) {
            this.ht = this.n * this.lMax;
        }
        if (this.ht < 1) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_generator_height_too_small"));
        }
        if (this.lMin < 1 || this.lMax < 1 || this.lMin > this.lMax) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_generator_period_problem"));
        }
        if (this.jugglers > 1 && !this.jugglerPermutationsFlag && this.groundflag != 0) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_juggler_permutations"));
        }
        if (this.lMin % this.rhythmPeriod != 0 || this.lMax % this.rhythmPeriod != 0) {
            String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_period_multiple");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String template = string;
            Object[] objectArray = new Object[]{this.rhythmPeriod};
            Object[] arguments = objectArray;
            throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
        }
    }

    private final void findGround() {
        int j;
        int n;
        int ballsLeft = this.n;
        int i2 = 0;
        block0: while (true) {
            n = this.hands;
            for (j = 0; j < n; ++j) {
                if (this.getRhythmRepunit()[j][i2 % this.rhythmPeriod] != 0 && --ballsLeft == 0) break block0;
            }
            ++i2;
        }
        this.groundStateLength = Math.max(i2 + 1, this.ht);
        j = 0;
        n = this.hands;
        int[][] nArrayArray = new int[n][];
        SiteswapGeneratorConfig siteswapGeneratorConfig = this;
        while (j < n) {
            int n2 = j++;
            nArrayArray[n2] = new int[this.groundStateLength];
        }
        siteswapGeneratorConfig.setGroundState(nArrayArray);
        ballsLeft = this.n;
        i2 = 0;
        block3: while (true) {
            n = this.hands;
            for (j = 0; j < n; ++j) {
                if (this.getRhythmRepunit()[j][i2 % this.rhythmPeriod] == 0) continue;
                this.getGroundState()[j][i2] = 1;
                if (--ballsLeft == 0) break block3;
            }
            ++i2;
        }
    }

    private final void configMultiplexing(boolean trueMultiplex) {
        this.slotSize = Math.max(this.ht, this.lMax);
        this.slotSize += this.rhythmPeriod - this.slotSize % this.rhythmPeriod;
        int n = this.hands;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = this.rhythmPeriod;
            for (int j = 0; j < n2; ++j) {
                this.maxOccupancy = Math.max(this.maxOccupancy, this.getRhythmRepunit()[i2][j]);
            }
        }
        this.maxOccupancy *= this.multiplex;
        if (this.maxOccupancy == 1) {
            this.mpflag = 0;
        }
        if (trueMultiplex) {
            String includeRe = null;
            if (this.jugglers == 1) {
                if (this.mode == 0) {
                    includeRe = ".*\\[[^2]*\\].*";
                } else if (this.mode == 1) {
                    includeRe = ".*\\[([^2\\]]*2x)*[^2\\]]*\\].*";
                }
            } else if (this.mode == 0) {
                includeRe = ".*\\[([^2\\]]*(2p|.p2|2p.))*[^2\\]]*\\].*";
            } else if (this.mode == 1) {
                includeRe = ".*\\[([^2\\]]*(2p|.p2|2p.|2x|2xp|.xp2|2xp.))*[^2\\]]*\\].*";
            }
            if (includeRe != null) {
                this.include.add(Pattern.compile(includeRe));
            }
        }
    }

    public final void printState(@NotNull int[][] st) {
        int j;
        int n;
        int i2;
        Intrinsics.checkNotNullParameter(st, "st");
        int lastIndex = 0;
        int n2 = this.groundStateLength;
        for (i2 = 0; i2 < n2; ++i2) {
            n = this.hands;
            for (j = 0; j < n; ++j) {
                if (st[j][i2] == 0) continue;
                lastIndex = i2;
            }
        }
        i2 = 0;
        n2 = lastIndex;
        if (i2 <= n2) {
            while (true) {
                n = this.hands;
                for (j = 0; j < n; ++j) {
                    System.out.println((Object)("  s[" + j + "][" + i2 + "] = " + st[j][i2]));
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
    }

    static {
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[]{1};
        nArrayArray[0] = nArray;
        async_rhythm_repunit = nArrayArray;
        nArrayArray = new int[2][];
        nArray = new int[]{1, 0};
        nArrayArray[0] = nArray;
        nArray = new int[]{1, 0};
        nArrayArray[1] = nArray;
        sync_rhythm_repunit = nArrayArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000f"}, d2={"Ljugglinglab/generator/SiteswapGeneratorConfig$Companion;", "", "<init>", "()V", "ASYNC", "", "SYNC", "async_rhythm_repunit", "", "", "[[I", "sync_rhythm_repunit", "makeStandardRegex", "", "term", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        private final String makeStandardRegex(String term) {
            String string = Pattern.compile("\\\\\\[").matcher(term).replaceAll("@");
            Intrinsics.checkNotNullExpressionValue(string, "replaceAll(...)");
            String res = string;
            String string2 = Pattern.compile("\\[").matcher(res).replaceAll("\\\\[");
            Intrinsics.checkNotNullExpressionValue(string2, "replaceAll(...)");
            res = string2;
            String string3 = Pattern.compile("@").matcher(res).replaceAll("[");
            Intrinsics.checkNotNullExpressionValue(string3, "replaceAll(...)");
            res = string3;
            String string4 = Pattern.compile("\\\\]").matcher(res).replaceAll("@");
            Intrinsics.checkNotNullExpressionValue(string4, "replaceAll(...)");
            res = string4;
            String string5 = Pattern.compile("]").matcher(res).replaceAll("\\\\]");
            Intrinsics.checkNotNullExpressionValue(string5, "replaceAll(...)");
            res = string5;
            String string6 = Pattern.compile("@").matcher(res).replaceAll("]");
            Intrinsics.checkNotNullExpressionValue(string6, "replaceAll(...)");
            res = string6;
            String string7 = Pattern.compile("\\\\\\(").matcher(res).replaceAll("@");
            Intrinsics.checkNotNullExpressionValue(string7, "replaceAll(...)");
            res = string7;
            String string8 = Pattern.compile("\\(").matcher(res).replaceAll("\\\\(");
            Intrinsics.checkNotNullExpressionValue(string8, "replaceAll(...)");
            res = string8;
            String string9 = Pattern.compile("@").matcher(res).replaceAll("(");
            Intrinsics.checkNotNullExpressionValue(string9, "replaceAll(...)");
            res = string9;
            String string10 = Pattern.compile("\\\\\\)").matcher(res).replaceAll("@");
            Intrinsics.checkNotNullExpressionValue(string10, "replaceAll(...)");
            res = string10;
            String string11 = Pattern.compile("\\)").matcher(res).replaceAll("\\\\)");
            Intrinsics.checkNotNullExpressionValue(string11, "replaceAll(...)");
            res = string11;
            String string12 = Pattern.compile("@").matcher(res).replaceAll(")");
            Intrinsics.checkNotNullExpressionValue(string12, "replaceAll(...)");
            res = string12;
            String string13 = Pattern.compile("\\\\\\|").matcher(res).replaceAll("@");
            Intrinsics.checkNotNullExpressionValue(string13, "replaceAll(...)");
            res = string13;
            String string14 = Pattern.compile("\\|").matcher(res).replaceAll("\\\\|");
            Intrinsics.checkNotNullExpressionValue(string14, "replaceAll(...)");
            res = string14;
            String string15 = Pattern.compile("@").matcher(res).replaceAll("|");
            Intrinsics.checkNotNullExpressionValue(string15, "replaceAll(...)");
            res = string15;
            return res;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

