/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.util.Iterator;
import jugglinglab.jml.HandLink;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\"\u001a\u00020\u0005H\u0002J\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tJ\u0016\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tJ\u000e\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\tJ\u000e\u0010,\u001a\u00020&2\u0006\u0010+\u001a\u00020\tJ\b\u0010-\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00140\u00140\u0014X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001f\u00a8\u0006."}, d2={"Ljugglinglab/jml/EventImages;", "", "pat", "Ljugglinglab/jml/JMLPattern;", "ev", "Ljugglinglab/jml/JMLEvent;", "<init>", "(Ljugglinglab/jml/JMLPattern;Ljugglinglab/jml/JMLEvent;)V", "numjugglers", "", "numpaths", "looptime", "", "loopperm", "Ljugglinglab/util/Permutation;", "evjuggler", "evhand", "evtransitions", "evtime", "ea", "", "[[[Ljugglinglab/util/Permutation;", "numentries", "transitiontype", "", "currentloop", "currentj", "currenth", "currententry", "next", "getNext", "()Ljugglinglab/jml/JMLEvent;", "previous", "getPrevious", "makeEvent", "resetPosition", "", "hasJMLTransitionForHand", "", "jug", "han", "hasVDJMLTransitionForHand", "hasJMLTransitionForPath", "path", "hasVDJMLTransitionForPath", "calcarray", "jugglinglab"})
public final class EventImages {
    @NotNull
    private JMLPattern pat;
    @NotNull
    private JMLEvent ev;
    private int numjugglers;
    private int numpaths;
    private double looptime;
    @Nullable
    private Permutation loopperm;
    private int evjuggler;
    private int evhand;
    private int evtransitions;
    private double evtime;
    private Permutation[][][] ea;
    private int numentries;
    private int[] transitiontype;
    private int currentloop;
    private int currentj;
    private int currenth;
    private int currententry;

    public EventImages(@NotNull JMLPattern pat, @NotNull JMLEvent ev) {
        Intrinsics.checkNotNullParameter(pat, "pat");
        Intrinsics.checkNotNullParameter(ev, "ev");
        this.pat = pat;
        this.ev = ev;
        this.calcarray();
        this.resetPosition();
        this.ev.setDelay(0);
        this.ev.setDelayunits(this.numentries);
    }

    @NotNull
    public final JMLEvent getNext() {
        Permutation[][][] permutationArray;
        do {
            ++this.currenth;
            if (this.currenth == 2) {
                this.currenth = 0;
                ++this.currentj;
                if (this.currentj == this.numjugglers) {
                    this.currentj = 0;
                    ++this.currententry;
                    if (this.currententry == this.numentries) {
                        this.currententry = 0;
                        int n = this.currentloop;
                        this.currentloop = n + 1;
                    }
                }
            }
            permutationArray = this.ea;
            if (this.ea != null) continue;
            Intrinsics.throwUninitializedPropertyAccessException("ea");
            permutationArray = null;
        } while (permutationArray[this.currentj][this.currenth][this.currententry] == null);
        return this.makeEvent();
    }

    @NotNull
    public final JMLEvent getPrevious() {
        Permutation[][][] permutationArray;
        do {
            int n = this.currenth;
            this.currenth = n + -1;
            if (n == 0) {
                this.currenth = 1;
                n = this.currentj;
                this.currentj = n + -1;
                if (n == 0) {
                    this.currentj = this.numjugglers - 1;
                    n = this.currententry;
                    this.currententry = n + -1;
                    if (n == 0) {
                        this.currententry = this.numentries - 1;
                        this.currentloop += -1;
                    }
                }
            }
            permutationArray = this.ea;
            if (this.ea != null) continue;
            Intrinsics.throwUninitializedPropertyAccessException("ea");
            permutationArray = null;
        } while (permutationArray[this.currentj][this.currenth][this.currententry] == null);
        return this.makeEvent();
    }

    private final JMLEvent makeEvent() {
        JMLEvent newevent = this.ev.duplicate(this.currententry + this.numentries * this.currentloop, this.numentries);
        newevent.setHand(this.currentj + 1, this.currenth == 0 ? 1 : 2);
        if (this.currenth != this.evhand) {
            Coordinate c1 = newevent.getLocalCoordinate();
            c1.setX(-c1.getX());
            newevent.setLocalCoordinate(c1);
        }
        Permutation[][][] permutationArray = this.ea;
        if (this.ea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ea");
            permutationArray = null;
        }
        Permutation p = permutationArray[this.currentj][this.currenth][this.currententry];
        Permutation permutation = this.loopperm;
        Intrinsics.checkNotNull(permutation);
        Permutation lp = permutation;
        int pow = this.currentloop;
        if (pow < 0) {
            lp = lp.getInverse();
            pow = -pow;
        }
        while (pow > 0) {
            Permutation permutation2 = p;
            Intrinsics.checkNotNull(permutation2);
            p = permutation2.apply(lp);
            --pow;
        }
        int n = this.evtransitions;
        for (int i2 = 0; i2 < n; ++i2) {
            JMLTransition tr = newevent.getTransition(i2);
            int masterpath = this.ev.getTransition(i2).getPath();
            Permutation permutation3 = p;
            Intrinsics.checkNotNull(permutation3);
            tr.setPath(permutation3.getMapping(masterpath));
        }
        newevent.setPathPermFromMaster(p);
        double t2 = this.evtime + (double)this.currentloop * this.looptime + (double)this.currententry * (this.looptime / (double)this.numentries);
        newevent.setT(t2);
        return newevent;
    }

    public final void resetPosition() {
        this.currentloop = 0;
        this.currentj = this.evjuggler;
        this.currenth = this.evhand;
        this.currententry = 0;
    }

    public final boolean hasJMLTransitionForHand(int jug, int han) {
        int n = this.numentries;
        for (int i2 = 0; i2 < n; ++i2) {
            Permutation[][][] permutationArray = this.ea;
            if (this.ea == null) {
                Intrinsics.throwUninitializedPropertyAccessException("ea");
                permutationArray = null;
            }
            if (permutationArray[jug - 1][HandLink.Companion.index(han)][i2] == null) continue;
            return true;
        }
        return false;
    }

    public final boolean hasVDJMLTransitionForHand(int jug, int han) {
        int i2;
        for (i2 = 0; i2 < this.numentries; ++i2) {
            Permutation[][][] permutationArray = this.ea;
            if (this.ea == null) {
                Intrinsics.throwUninitializedPropertyAccessException("ea");
                permutationArray = null;
            }
            if (permutationArray[jug - 1][HandLink.Companion.index(han)][i2] != null) break;
        }
        if (i2 == this.numentries) {
            return false;
        }
        int n = this.evtransitions;
        for (int j = 0; j < n; ++j) {
            int[] nArray = this.transitiontype;
            if (this.transitiontype == null) {
                Intrinsics.throwUninitializedPropertyAccessException("transitiontype");
                nArray = null;
            }
            if (nArray[j] != 1) {
                int[] nArray2 = this.transitiontype;
                if (this.transitiontype == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("transitiontype");
                    nArray2 = null;
                }
                if (nArray2[j] != 3) continue;
            }
            return true;
        }
        return false;
    }

    public final boolean hasJMLTransitionForPath(int path) {
        Permutation permutation = this.loopperm;
        Intrinsics.checkNotNull(permutation);
        int[] cycle = permutation.getCycle(path);
        int n = this.evtransitions;
        for (int k = 0; k < n; ++k) {
            int transPath = this.ev.getTransition(k).getPath();
            int n2 = this.numjugglers;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.numentries;
                for (int j = 0; j < n3; ++j) {
                    for (int h = 0; h < 2; ++h) {
                        Permutation permtemp;
                        Permutation[][][] permutationArray = this.ea;
                        if (this.ea == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("ea");
                            permutationArray = null;
                        }
                        if ((permtemp = permutationArray[i2][h][j]) == null || !ArraysKt.contains(cycle, permtemp.getMapping(transPath))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public final boolean hasVDJMLTransitionForPath(int path) {
        Permutation permutation = this.loopperm;
        Intrinsics.checkNotNull(permutation);
        int[] cycle = permutation.getCycle(path);
        int n = this.evtransitions;
        for (int k = 0; k < n; ++k) {
            int[] nArray = this.transitiontype;
            if (this.transitiontype == null) {
                Intrinsics.throwUninitializedPropertyAccessException("transitiontype");
                nArray = null;
            }
            if (nArray[k] != 1) {
                int[] nArray2 = this.transitiontype;
                if (this.transitiontype == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("transitiontype");
                    nArray2 = null;
                }
                if (nArray2[k] != 3) continue;
            }
            int transPath = this.ev.getTransition(k).getPath();
            int n2 = this.numjugglers;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.numentries;
                for (int j = 0; j < n3; ++j) {
                    for (int h = 0; h < 2; ++h) {
                        Permutation permtemp;
                        Permutation[][][] permutationArray = this.ea;
                        if (this.ea == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("ea");
                            permutationArray = null;
                        }
                        if ((permtemp = permutationArray[i2][h][j]) == null || !ArraysKt.contains(cycle, permtemp.getMapping(transPath))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final void calcarray() throws JuggleExceptionUser {
        int n;
        int i2;
        this.numjugglers = this.pat.getNumberOfJugglers();
        this.numpaths = this.pat.getNumberOfPaths();
        this.looptime = this.pat.getLoopEndTime() - this.pat.getLoopStartTime();
        this.loopperm = this.pat.getPathPermutation();
        this.evjuggler = this.ev.getJuggler() - 1;
        this.evhand = HandLink.Companion.index(this.ev.getHand());
        this.evtransitions = this.ev.getNumberOfTransitions();
        this.evtime = this.ev.getT();
        int numsyms = this.pat.getSymmetries().size() - 1;
        JMLSymmetry[] sym = new JMLSymmetry[numsyms];
        int[] symperiod = new int[numsyms];
        int[] deltaentries = new int[numsyms];
        Permutation invdelayperm = null;
        this.numentries = 1;
        int index = 0;
        Iterator<JMLSymmetry> iterator2 = this.pat.getSymmetries().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<JMLSymmetry> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            JMLSymmetry temp;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            switch (temp.getSymType()) {
                case 1: {
                    Permutation permutation = temp.getPathPerm();
                    Intrinsics.checkNotNull(permutation);
                    invdelayperm = permutation.getInverse();
                    break;
                }
                case 2: {
                    sym[index] = temp;
                    Permutation permutation = temp.getJugglerPerm();
                    Intrinsics.checkNotNull(permutation);
                    symperiod[index] = permutation.getOrder();
                    deltaentries[index] = 0;
                    ++index;
                    break;
                }
                case 3: {
                    sym[index] = temp;
                    Permutation permutation = temp.getJugglerPerm();
                    Intrinsics.checkNotNull(permutation);
                    symperiod[index] = permutation.getOrder();
                    this.numentries = Permutation.Companion.lcm(this.numentries, symperiod[index]);
                    deltaentries[index] = -1;
                    ++index;
                }
            }
        }
        for (i2 = 0; i2 < numsyms; ++i2) {
            if (deltaentries[i2] != -1) continue;
            deltaentries[i2] = this.numentries / symperiod[i2];
        }
        int temp = this.numjugglers;
        Permutation[][][] permutationArrayArray = new Permutation[temp][][];
        EventImages eventImages = this;
        for (i2 = 0; i2 < temp; ++i2) {
            int n2 = i2;
            n = 0;
            Permutation[][] permutationArrayArray2 = new Permutation[2][];
            int n3 = n2;
            Permutation[][][] permutationArrayArray3 = permutationArrayArray;
            while (n < 2) {
                int n4 = n++;
                permutationArrayArray2[n4] = new Permutation[this.numentries];
            }
            permutationArrayArray3[n3] = permutationArrayArray2;
        }
        eventImages.ea = permutationArrayArray;
        this.transitiontype = new int[this.evtransitions];
        Permutation idperm = new Permutation(this.numpaths, false);
        this.ev.setPathPermFromMaster(idperm);
        Permutation[][][] permutationArray = this.ea;
        if (this.ea == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ea");
            permutationArray = null;
        }
        permutationArray[this.evjuggler][this.evhand][0] = idperm;
        int n5 = this.evtransitions;
        for (int i3 = 0; i3 < n5; ++i3) {
            JMLTransition tr = this.ev.getTransition(i3);
            int[] nArray = this.transitiontype;
            if (this.transitiontype == null) {
                Intrinsics.throwUninitializedPropertyAccessException("transitiontype");
                nArray = null;
            }
            nArray[i3] = tr.getTransType();
        }
        boolean changed = false;
        do {
            changed = false;
            for (int i4 = 0; i4 < numsyms; ++i4) {
                n = this.numjugglers;
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        int n6 = this.numentries;
                        for (int l = 0; l < n6; ++l) {
                            int newk;
                            JMLSymmetry jMLSymmetry = sym[i4];
                            Intrinsics.checkNotNull(jMLSymmetry);
                            Permutation permutation = jMLSymmetry.getJugglerPerm();
                            Intrinsics.checkNotNull(permutation);
                            int newj = permutation.getMapping(j + 1);
                            if (newj == 0) continue;
                            int n7 = newk = newj < 0 ? 1 - k : k;
                            if (newj < 0) {
                                newj = -newj;
                            }
                            --newj;
                            Permutation[][][] permutationArray2 = this.ea;
                            if (this.ea == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("ea");
                                permutationArray2 = null;
                            }
                            Permutation permutation2 = permutationArray2[j][k][l];
                            if (permutation2 == null) continue;
                            Permutation p = permutation2;
                            JMLSymmetry jMLSymmetry2 = sym[i4];
                            Intrinsics.checkNotNull(jMLSymmetry2);
                            p = p.apply(jMLSymmetry2.getPathPerm());
                            int newl = l + deltaentries[i4];
                            if (newl >= this.numentries) {
                                p = p.apply(invdelayperm);
                                newl -= this.numentries;
                            }
                            Permutation[][][] permutationArray3 = this.ea;
                            if (this.ea == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("ea");
                                permutationArray3 = null;
                            }
                            if (permutationArray3[newj][newk][newl] != null) {
                                Permutation[][][] permutationArray4 = this.ea;
                                if (this.ea == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("ea");
                                    permutationArray4 = null;
                                }
                                if (p.equals(permutationArray4[newj][newk][newl])) continue;
                                throw new JuggleExceptionUser("Symmetries inconsistent");
                            }
                            Permutation[][][] permutationArray5 = this.ea;
                            if (this.ea == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("ea");
                                permutationArray5 = null;
                            }
                            permutationArray5[newj][newk][newl] = p;
                            changed = true;
                        }
                    }
                }
            }
        } while (changed);
    }
}

