/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import jugglinglab.curve.Curve;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.VelocityRef;
import jugglinglab.util.Coordinate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010%\u001a\u00020&H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006("}, d2={"Ljugglinglab/jml/HandLink;", "", "juggler", "", "hand", "startEvent", "Ljugglinglab/jml/JMLEvent;", "endEvent", "<init>", "(IILjugglinglab/jml/JMLEvent;Ljugglinglab/jml/JMLEvent;)V", "getJuggler", "()I", "setJuggler", "(I)V", "getHand", "setHand", "getStartEvent", "()Ljugglinglab/jml/JMLEvent;", "setStartEvent", "(Ljugglinglab/jml/JMLEvent;)V", "getEndEvent", "setEndEvent", "startVelocityRef", "Ljugglinglab/jml/VelocityRef;", "getStartVelocityRef", "()Ljugglinglab/jml/VelocityRef;", "setStartVelocityRef", "(Ljugglinglab/jml/VelocityRef;)V", "endVelocityRef", "getEndVelocityRef", "setEndVelocityRef", "handCurve", "Ljugglinglab/curve/Curve;", "getHandCurve", "()Ljugglinglab/curve/Curve;", "setHandCurve", "(Ljugglinglab/curve/Curve;)V", "toString", "", "Companion", "jugglinglab"})
public final class HandLink {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int juggler;
    private int hand;
    @NotNull
    private JMLEvent startEvent;
    @NotNull
    private JMLEvent endEvent;
    @Nullable
    private VelocityRef startVelocityRef;
    @Nullable
    private VelocityRef endVelocityRef;
    @Nullable
    private Curve handCurve;
    public static final int NO_HAND = 0;
    public static final int LEFT_HAND = 1;
    public static final int RIGHT_HAND = 2;

    public HandLink(int juggler, int hand, @NotNull JMLEvent startEvent, @NotNull JMLEvent endEvent) {
        Intrinsics.checkNotNullParameter(startEvent, "startEvent");
        Intrinsics.checkNotNullParameter(endEvent, "endEvent");
        this.juggler = juggler;
        this.hand = hand;
        this.startEvent = startEvent;
        this.endEvent = endEvent;
    }

    public final int getJuggler() {
        return this.juggler;
    }

    public final void setJuggler(int n) {
        this.juggler = n;
    }

    public final int getHand() {
        return this.hand;
    }

    public final void setHand(int n) {
        this.hand = n;
    }

    @NotNull
    public final JMLEvent getStartEvent() {
        return this.startEvent;
    }

    public final void setStartEvent(@NotNull JMLEvent jMLEvent) {
        Intrinsics.checkNotNullParameter(jMLEvent, "<set-?>");
        this.startEvent = jMLEvent;
    }

    @NotNull
    public final JMLEvent getEndEvent() {
        return this.endEvent;
    }

    public final void setEndEvent(@NotNull JMLEvent jMLEvent) {
        Intrinsics.checkNotNullParameter(jMLEvent, "<set-?>");
        this.endEvent = jMLEvent;
    }

    @Nullable
    public final VelocityRef getStartVelocityRef() {
        return this.startVelocityRef;
    }

    public final void setStartVelocityRef(@Nullable VelocityRef velocityRef) {
        this.startVelocityRef = velocityRef;
    }

    @Nullable
    public final VelocityRef getEndVelocityRef() {
        return this.endVelocityRef;
    }

    public final void setEndVelocityRef(@Nullable VelocityRef velocityRef) {
        this.endVelocityRef = velocityRef;
    }

    @Nullable
    public final Curve getHandCurve() {
        return this.handCurve;
    }

    public final void setHandCurve(@Nullable Curve curve) {
        this.handCurve = curve;
    }

    @NotNull
    public String toString() {
        Coordinate vel;
        Coordinate start = this.startEvent.getGlobalCoordinate();
        Coordinate end = this.endEvent.getGlobalCoordinate();
        VelocityRef svr = this.startVelocityRef;
        VelocityRef evr = this.endVelocityRef;
        Curve hp = this.handCurve;
        StringBuilder sb = new StringBuilder();
        Coordinate coordinate = start;
        Intrinsics.checkNotNull(coordinate);
        sb.append("Link from (x=" + coordinate.getX() + ",y=" + start.getY() + ",z=" + start.getZ() + ",t=" + this.startEvent.getT() + ") ");
        Coordinate coordinate2 = end;
        Intrinsics.checkNotNull(coordinate2);
        sb.append("to (x=" + coordinate2.getX() + ",y=" + end.getY() + ",z=" + end.getZ() + ",t=" + this.endEvent.getT() + ")");
        if (svr != null) {
            vel = svr.getVelocity();
            sb.append("\n      start velocity (x=" + vel.getX() + ",y=" + vel.getY() + ",z=" + vel.getZ() + ")");
        }
        if (evr != null) {
            vel = evr.getVelocity();
            sb.append("\n      end velocity (x=" + vel.getX() + ",y=" + vel.getY() + ",z=" + vel.getZ() + ")");
        }
        if (hp != null) {
            Coordinate mincoord;
            Coordinate maxcoord = hp.getMax(this.startEvent.getT(), this.endEvent.getT());
            Coordinate coordinate3 = mincoord = hp.getMin(this.startEvent.getT(), this.endEvent.getT());
            Intrinsics.checkNotNull(coordinate3);
            sb.append("\n      minimum (x=" + coordinate3.getX() + ",y=" + mincoord.getY() + ",z=" + mincoord.getZ() + ")");
            Coordinate coordinate4 = maxcoord;
            Intrinsics.checkNotNull(coordinate4);
            v4 = sb.append("\n      maximum (x=" + coordinate4.getX() + ",y=" + maxcoord.getY() + ",z=" + maxcoord.getZ() + ")");
        } else {
            v4 = sb.append("\n      no handpath");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljugglinglab/jml/HandLink$Companion;", "", "<init>", "()V", "NO_HAND", "", "getNO_HAND$annotations", "LEFT_HAND", "RIGHT_HAND", "index", "handdescription", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getNO_HAND$annotations() {
        }

        public final int index(int handdescription) {
            return handdescription == 1 ? 0 : 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

