/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PathLink;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NJ\u0016\u0010K\u001a\u00020L2\u0006\u0010O\u001a\u00020\u000b2\u0006\u0010P\u001a\u00020\u000bJ\u000e\u0010S\u001a\u00020\u00122\u0006\u0010T\u001a\u00020\u000bJ\u000e\u0010U\u001a\u00020$2\u0006\u0010V\u001a\u00020\u0012J\u000e\u0010W\u001a\u00020\u00122\u0006\u0010T\u001a\u00020\u000bJ\u000e\u0010W\u001a\u00020$2\u0006\u0010V\u001a\u00020\u0012J\u000e\u0010\\\u001a\u00020$2\u0006\u0010]\u001a\u00020\u0000J\u000e\u0010^\u001a\u00020$2\u0006\u0010]\u001a\u00020\u0000J\u0018\u0010_\u001a\u0004\u0018\u00010\u00122\u0006\u0010`\u001a\u00020\u000b2\u0006\u0010a\u001a\u00020\u000bJ\u0016\u0010l\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bJ&\u0010o\u001a\u00020L2\u0006\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020N2\u0006\u0010s\u001a\u00020\u000b2\u0006\u0010t\u001a\u00020\u000bJ\u000e\u0010u\u001a\u00020L2\u0006\u0010v\u001a\u00020wJ\b\u0010x\u001a\u00020NH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0019R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010)\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u001c\u00101\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010+\"\u0004\b3\u0010-R\u0011\u00104\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b5\u0010+R\u0011\u00106\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010&R\u001e\u00107\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0007R\u001e\u00109\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0007R\u001e\u0010;\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0007R$\u0010?\u001a\u00020>2\u0006\u0010=\u001a\u00020>8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u000e\u0010D\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010H\u001a\u0004\u0018\u00010>2\b\u0010=\u001a\u0004\u0018\u00010>8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bI\u0010A\"\u0004\bJ\u0010CR\u0011\u0010Q\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010\u000eR\u0013\u0010X\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\bY\u0010+R\u0013\u0010Z\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b[\u0010+R\u0011\u0010b\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\bc\u0010&R\u0011\u0010d\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\be\u0010&R\u0011\u0010f\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\bg\u0010&R\u0011\u0010h\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\bi\u0010&R\u0011\u0010j\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\bk\u0010&R\u0011\u0010m\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bn\u0010\u000e\u00a8\u0006y"}, d2={"Ljugglinglab/jml/JMLEvent;", "", "<init>", "()V", "t", "", "getT", "()D", "setT", "(D)V", "value", "", "juggler", "getJuggler", "()I", "hand", "getHand", "Ljava/util/ArrayList;", "Ljugglinglab/jml/JMLTransition;", "transitions", "getTransitions", "()Ljava/util/ArrayList;", "delay", "getDelay", "setDelay", "(I)V", "delayunits", "getDelayunits", "setDelayunits", "pathPermFromMaster", "Ljugglinglab/util/Permutation;", "getPathPermFromMaster", "()Ljugglinglab/util/Permutation;", "setPathPermFromMaster", "(Ljugglinglab/util/Permutation;)V", "calcpos", "", "getCalcpos", "()Z", "setCalcpos", "(Z)V", "previous", "getPrevious", "()Ljugglinglab/jml/JMLEvent;", "setPrevious", "(Ljugglinglab/jml/JMLEvent;)V", "next", "getNext", "setNext", "masterEvent", "getMasterEvent", "setMasterEvent", "master", "getMaster", "isMaster", "x", "getX", "y", "getY", "z", "getZ", "c", "Ljugglinglab/util/Coordinate;", "localCoordinate", "getLocalCoordinate", "()Ljugglinglab/util/Coordinate;", "setLocalCoordinate", "(Ljugglinglab/util/Coordinate;)V", "gx", "gy", "gz", "globalvalid", "globalCoordinate", "getGlobalCoordinate", "setGlobalCoordinate", "setHand", "", "strhand", "", "j", "h", "numberOfTransitions", "getNumberOfTransitions", "getTransition", "index", "addTransition", "trans", "removeTransition", "previousForHand", "getPreviousForHand", "nextForHand", "getNextForHand", "isDelayOf", "ev2", "hasSameMasterAs", "getPathTransition", "path", "transType", "hasThrow", "getHasThrow", "hasThrowOrCatch", "getHasThrowOrCatch", "hasPassingThrow", "getHasPassingThrow", "hasPassingCatch", "getHasPassingCatch", "hasPassingTransition", "getHasPassingTransition", "duplicate", "hashCode", "getHashCode", "readJML", "current", "Ljugglinglab/jml/JMLNode;", "jmlvers", "njugglers", "npaths", "writeJML", "wr", "Ljava/io/PrintWriter;", "toString", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nJMLEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JMLEvent.kt\njugglinglab/jml/JMLEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n295#2,2:388\n1761#2,3:390\n1761#2,3:393\n1761#2,3:396\n1761#2,3:399\n1#3:402\n*S KotlinDebug\n*F\n+ 1 JMLEvent.kt\njugglinglab/jml/JMLEvent\n*L\n162#1:388,2\n168#1:390,3\n171#1:393,3\n186#1:396,3\n196#1:399,3\n*E\n"})
public final class JMLEvent {
    private double t;
    private int juggler;
    private int hand;
    @NotNull
    private ArrayList<JMLTransition> transitions = new ArrayList();
    private int delay;
    private int delayunits;
    @Nullable
    private Permutation pathPermFromMaster;
    private boolean calcpos;
    @Nullable
    private JMLEvent previous;
    @Nullable
    private JMLEvent next;
    @Nullable
    private JMLEvent masterEvent;
    private double x;
    private double y;
    private double z;
    private double gx;
    private double gy;
    private double gz;
    private boolean globalvalid;

    public final double getT() {
        return this.t;
    }

    public final void setT(double d) {
        this.t = d;
    }

    public final int getJuggler() {
        return this.juggler;
    }

    public final int getHand() {
        return this.hand;
    }

    @NotNull
    public final ArrayList<JMLTransition> getTransitions() {
        return this.transitions;
    }

    public final int getDelay() {
        return this.delay;
    }

    public final void setDelay(int n) {
        this.delay = n;
    }

    public final int getDelayunits() {
        return this.delayunits;
    }

    public final void setDelayunits(int n) {
        this.delayunits = n;
    }

    @Nullable
    public final Permutation getPathPermFromMaster() {
        return this.pathPermFromMaster;
    }

    public final void setPathPermFromMaster(@Nullable Permutation permutation) {
        this.pathPermFromMaster = permutation;
    }

    public final boolean getCalcpos() {
        return this.calcpos;
    }

    public final void setCalcpos(boolean bl) {
        this.calcpos = bl;
    }

    @Nullable
    public final JMLEvent getPrevious() {
        return this.previous;
    }

    public final void setPrevious(@Nullable JMLEvent jMLEvent) {
        this.previous = jMLEvent;
    }

    @Nullable
    public final JMLEvent getNext() {
        return this.next;
    }

    public final void setNext(@Nullable JMLEvent jMLEvent) {
        this.next = jMLEvent;
    }

    @Nullable
    public final JMLEvent getMasterEvent() {
        return this.masterEvent;
    }

    public final void setMasterEvent(@Nullable JMLEvent jMLEvent) {
        this.masterEvent = jMLEvent;
    }

    @NotNull
    public final JMLEvent getMaster() {
        JMLEvent jMLEvent = this.masterEvent;
        if (jMLEvent == null) {
            jMLEvent = this;
        }
        return jMLEvent;
    }

    public final boolean isMaster() {
        return this.masterEvent == null;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    @NotNull
    public final Coordinate getLocalCoordinate() {
        return new Coordinate(this.x, this.y, this.z);
    }

    public final void setLocalCoordinate(@NotNull Coordinate c) {
        Intrinsics.checkNotNullParameter(c, "c");
        this.x = c.getX();
        this.y = c.getY();
        this.z = c.getZ();
        this.globalvalid = false;
    }

    @Nullable
    public final Coordinate getGlobalCoordinate() {
        return this.globalvalid ? new Coordinate(this.gx, this.gy, this.gz) : null;
    }

    public final void setGlobalCoordinate(@Nullable Coordinate c) {
        Coordinate coordinate = c;
        Intrinsics.checkNotNull(coordinate);
        this.gx = coordinate.getX();
        this.gy = c.getY();
        this.gz = c.getZ();
        this.globalvalid = true;
    }

    public final void setHand(@NotNull String strhand) throws JuggleExceptionUser {
        Intrinsics.checkNotNullParameter(strhand, "strhand");
        int index = StringsKt.indexOf$default((CharSequence)strhand, ":", 0, false, 6, null);
        if (index == -1) {
            int n;
            this.juggler = 1;
            if (StringsKt.equals(strhand, "left", true)) {
                n = 1;
            } else if (StringsKt.equals(strhand, "right", true)) {
                n = 2;
            } else {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hand_name") + " '" + strhand + "'");
            }
            this.hand = n;
        } else {
            int n;
            this.juggler = Integer.parseInt(StringsKt.take(strhand, index));
            String string = strhand.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String substr = string;
            if (StringsKt.equals(substr, "left", true)) {
                n = 1;
            } else if (StringsKt.equals(substr, "right", true)) {
                n = 2;
            } else {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hand_name") + " '" + strhand + "'");
            }
            this.hand = n;
        }
    }

    public final void setHand(int j, int h) {
        this.juggler = j;
        this.hand = h;
    }

    public final int getNumberOfTransitions() {
        return this.transitions.size();
    }

    @NotNull
    public final JMLTransition getTransition(int index) {
        JMLTransition jMLTransition = this.transitions.get(index);
        Intrinsics.checkNotNullExpressionValue(jMLTransition, "get(...)");
        return jMLTransition;
    }

    public final boolean addTransition(@NotNull JMLTransition trans) {
        Intrinsics.checkNotNullParameter(trans, "trans");
        return this.transitions.add(trans);
    }

    @NotNull
    public final JMLTransition removeTransition(int index) {
        JMLTransition jMLTransition = this.transitions.remove(index);
        Intrinsics.checkNotNullExpressionValue(jMLTransition, "removeAt(...)");
        return jMLTransition;
    }

    public final boolean removeTransition(@NotNull JMLTransition trans) {
        Intrinsics.checkNotNullParameter(trans, "trans");
        return this.transitions.remove(trans);
    }

    @Nullable
    public final JMLEvent getPreviousForHand() {
        JMLEvent ev = this.previous;
        while (ev != null) {
            if (ev.juggler == this.juggler && ev.hand == this.hand) {
                return ev;
            }
            ev = ev.previous;
        }
        return null;
    }

    @Nullable
    public final JMLEvent getNextForHand() {
        JMLEvent ev = this.next;
        while (ev != null) {
            if (ev.juggler == this.juggler && ev.hand == this.hand) {
                return ev;
            }
            ev = ev.next;
        }
        return null;
    }

    public final boolean isDelayOf(@NotNull JMLEvent ev2) {
        Intrinsics.checkNotNullParameter(ev2, "ev2");
        if (!this.hasSameMasterAs(ev2)) {
            return false;
        }
        if (this.juggler != ev2.juggler || this.hand != ev2.hand) {
            return false;
        }
        int totaldelay = this.delay - ev2.delay;
        if (totaldelay < 0) {
            totaldelay = -totaldelay;
        }
        return totaldelay % this.delayunits == 0;
    }

    public final boolean hasSameMasterAs(@NotNull JMLEvent ev2) {
        Intrinsics.checkNotNullParameter(ev2, "ev2");
        JMLEvent mast1 = this.masterEvent == null ? this : this.masterEvent;
        JMLEvent mast2 = ev2.masterEvent == null ? ev2 : ev2.masterEvent;
        return mast1 == mast2;
    }

    @Nullable
    public final JMLTransition getPathTransition(int path, int transType) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.transitions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JMLTransition it = (JMLTransition)element$iv;
                boolean bl = false;
                if (!(it.getPath() == path && (transType == 6 || transType == it.getTransType()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean getHasThrow() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.transitions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JMLTransition it = (JMLTransition)element$iv;
                    boolean bl2 = false;
                    if (!(it.getTransType() == 1)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean getHasThrowOrCatch() {
        boolean bl;
        block6: {
            Iterable $this$any$iv = this.transitions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    JMLTransition it = (JMLTransition)element$iv;
                    boolean bl3 = false;
                    switch (it.getTransType()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            bl2 = true;
                            break;
                        }
                        default: {
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getHasPassingThrow() {
        boolean bl;
        Iterable $this$any$iv = this.transitions;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            JMLTransition tr = (JMLTransition)element$iv;
            boolean bl2 = false;
            if (tr.getTransType() == 1) {
                PathLink pathLink = tr.getOutgoingPathLink();
                Object object = pathLink;
                if (pathLink == null) return true;
                JMLEvent jMLEvent = ((PathLink)object).getEndEvent();
                object = jMLEvent;
                if (jMLEvent == null) return true;
                if (((JMLEvent)object).juggler != this.juggler) return true;
                boolean bl3 = true;
                if (!bl3) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getHasPassingCatch() {
        boolean bl;
        Iterable $this$any$iv = this.transitions;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            JMLTransition tr = (JMLTransition)element$iv;
            boolean bl2 = false;
            if (switch (tr.getTransType()) {
                case 2, 3, 4 -> true;
                default -> false;
            }) {
                PathLink pathLink = tr.getIncomingPathLink();
                Object object = pathLink;
                if (pathLink == null) return true;
                JMLEvent jMLEvent = ((PathLink)object).getStartEvent();
                object = jMLEvent;
                if (jMLEvent == null) return true;
                if (((JMLEvent)object).juggler != this.juggler) return true;
                boolean bl3 = true;
                if (!bl3) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public final boolean getHasPassingTransition() {
        return this.getHasPassingThrow() || this.getHasPassingCatch();
    }

    @NotNull
    public final JMLEvent duplicate(int delay, int delayunits) {
        JMLEvent dup = new JMLEvent();
        dup.setLocalCoordinate(this.getLocalCoordinate());
        dup.t = this.t;
        dup.setHand(this.juggler, this.hand);
        dup.delay = delay;
        dup.delayunits = delayunits;
        dup.calcpos = this.calcpos;
        Iterator<JMLTransition> iterator2 = this.transitions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<JMLTransition> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            JMLTransition tr;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            dup.addTransition(tr.copy());
        }
        dup.masterEvent = this.isMaster() ? this : this.masterEvent;
        return dup;
    }

    public final int getHashCode() {
        Coordinate c = this.getLocalCoordinate();
        String s = "<event x=\"" + JLFunc.jlToStringRounded(c.getX(), 4) + "\" y=\"" + JLFunc.jlToStringRounded(c.getY(), 4) + "\" z=\"" + JLFunc.jlToStringRounded(c.getZ(), 4) + "\" t=\"" + JLFunc.jlToStringRounded(this.t, 4) + "\" hand=\"" + this.juggler + ":" + (this.hand == 1 ? "left" : "right") + "\">";
        return s.hashCode();
    }

    public final void readJML(@NotNull JMLNode current, @NotNull String jmlvers, int njugglers, int npaths) throws JuggleExceptionUser {
        int i2;
        int n;
        Intrinsics.checkNotNullParameter(current, "current");
        Intrinsics.checkNotNullParameter(jmlvers, "jmlvers");
        JMLAttributes at = current.getAttributes();
        double tempx = 0.0;
        double tempy = 0.0;
        double tempz = 0.0;
        double tempt = 0.0;
        String handstr = null;
        try {
            n = at.getNumberOfAttributes();
            for (i2 = 0; i2 < n; ++i2) {
                if (StringsKt.equals(at.getAttributeName(i2), "x", true)) {
                    tempx = JLFunc.jlParseFiniteDouble(at.getAttributeValue(i2));
                    continue;
                }
                if (StringsKt.equals(at.getAttributeName(i2), "y", true)) {
                    tempy = JLFunc.jlParseFiniteDouble(at.getAttributeValue(i2));
                    continue;
                }
                if (StringsKt.equals(at.getAttributeName(i2), "z", true)) {
                    tempz = JLFunc.jlParseFiniteDouble(at.getAttributeValue(i2));
                    continue;
                }
                if (StringsKt.equals(at.getAttributeName(i2), "t", true)) {
                    tempt = JLFunc.jlParseFiniteDouble(at.getAttributeValue(i2));
                    continue;
                }
                if (!StringsKt.equals(at.getAttributeName(i2), "hand", true)) continue;
                handstr = at.getAttributeValue(i2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_event_coordinate"));
        }
        if (Intrinsics.areEqual(jmlvers, "1.0")) {
            double it = numberFormatException = tempz;
            boolean bl = false;
            tempz = tempy;
            tempy = numberFormatException;
        }
        this.setLocalCoordinate(new Coordinate(tempx, tempy, tempz));
        this.t = tempt;
        if (handstr == null) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_unspecified_hand"));
        }
        this.setHand(handstr);
        int numberFormatException = this.juggler;
        if (!(1 <= numberFormatException ? numberFormatException <= njugglers : false)) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_juggler_out_of_range"));
        }
        n = current.getNumberOfChildren();
        for (i2 = 0; i2 < n; ++i2) {
            JMLNode child = current.getChildNode(i2);
            String childNodeType = child.getNodeType();
            JMLAttributes childAt = child.getAttributes();
            String childPath = null;
            String childTranstype = null;
            String childMod = null;
            int n2 = childAt.getNumberOfAttributes();
            for (int j = 0; j < n2; ++j) {
                String value = childAt.getAttributeValue(j);
                if (StringsKt.equals(childAt.getAttributeName(j), "path", true)) {
                    childPath = value;
                    continue;
                }
                if (StringsKt.equals(childAt.getAttributeName(j), "type", true)) {
                    childTranstype = value;
                    continue;
                }
                if (!StringsKt.equals(childAt.getAttributeName(j), "mod", true)) continue;
                childMod = value;
            }
            if (childPath == null) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_no_path"));
            }
            int pnum = Integer.parseInt(childPath);
            if (!(1 <= pnum ? pnum <= npaths : false)) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_path_out_of_range"));
            }
            if (StringsKt.equals(childNodeType, "throw", true)) {
                this.addTransition(new JMLTransition(1, pnum, childTranstype, childMod));
            } else if (StringsKt.equals(childNodeType, "catch", true) && StringsKt.equals(childTranstype, "soft", true)) {
                this.addTransition(new JMLTransition(3, pnum, null, null));
            } else if (StringsKt.equals(childNodeType, "catch", true) && StringsKt.equals(childTranstype, "grab", true)) {
                this.addTransition(new JMLTransition(4, pnum, null, null));
            } else if (StringsKt.equals(childNodeType, "catch", true)) {
                this.addTransition(new JMLTransition(2, pnum, null, null));
            } else if (StringsKt.equals(childNodeType, "holding", true)) {
                this.addTransition(new JMLTransition(5, pnum, null, null));
            }
            if (child.getNumberOfChildren() == 0) continue;
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_event_subtag"));
        }
    }

    public final void writeJML(@NotNull PrintWriter wr) throws IOException {
        Intrinsics.checkNotNullParameter(wr, "wr");
        Coordinate c = this.getLocalCoordinate();
        wr.println("<event x=\"" + JLFunc.jlToStringRounded(c.getX(), 4) + "\" y=\"" + JLFunc.jlToStringRounded(c.getY(), 4) + "\" z=\"" + JLFunc.jlToStringRounded(c.getZ(), 4) + "\" t=\"" + JLFunc.jlToStringRounded(this.t, 4) + "\" hand=\"" + this.juggler + ":" + (this.hand == 1 ? "left" : "right") + "\">");
        Iterator<JMLTransition> iterator2 = this.transitions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<JMLTransition> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            JMLTransition tr;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            tr.writeJML(wr);
        }
        wr.println("</event>");
    }

    @NotNull
    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeJML(new PrintWriter(sw));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

