/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.swing.DefaultListModel;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLDefs;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 52\u00020\u0001:\u000245B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0006\u0010 \u001a\u00020!JJ\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001d2\b\u0010$\u001a\u0004\u0018\u00010\b2\b\u0010%\u001a\u0004\u0018\u00010\b2\b\u0010&\u001a\u0004\u0018\u00010\b2\b\u0010'\u001a\u0004\u0018\u00010\b2\b\u0010(\u001a\u0004\u0018\u00010\u00052\b\u0010)\u001a\u0004\u0018\u00010\u0005J\u0010\u0010*\u001a\u0004\u0018\u00010\u00192\u0006\u0010#\u001a\u00020\u001dJ\u0010\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010#\u001a\u00020\u001dJ\u0010\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010#\u001a\u00020\u001dJ\u000e\u0010/\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u00100\u001a\u00020!2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020!2\u0006\u00101\u001a\u000202R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR(\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\fR\"\u0010\u0015\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00066"}, d2={"Ljugglinglab/jml/JMLPatternList;", "", "<init>", "()V", "root", "Ljugglinglab/jml/JMLNode;", "(Ljugglinglab/jml/JMLNode;)V", "version", "", "getVersion", "()Ljava/lang/String;", "setVersion", "(Ljava/lang/String;)V", "loadingversion", "getLoadingversion", "setLoadingversion", "t", "title", "getTitle", "setTitle", "value", "info", "getInfo", "model", "Ljavax/swing/DefaultListModel;", "Ljugglinglab/jml/JMLPatternList$PatternRecord;", "getModel", "()Ljavax/swing/DefaultListModel;", "size", "", "getSize", "()I", "clearModel", "", "addLine", "row", "display", "animprefs", "notation", "anim", "patnode", "infonode", "getLine", "getPatternForLine", "Ljugglinglab/jml/JMLPattern;", "getAnimationPrefsForLine", "Ljugglinglab/core/AnimationPrefs;", "readJML", "writeJML", "wr", "Ljava/io/Writer;", "writeText", "PatternRecord", "Companion", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nJMLPatternList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JMLPatternList.kt\njugglinglab/jml/JMLPatternList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,386:1\n739#2,9:387\n37#3:396\n36#3,3:397\n*S KotlinDebug\n*F\n+ 1 JMLPatternList.kt\njugglinglab/jml/JMLPatternList\n*L\n94#1:387,9\n94#1:396\n94#1:397,3\n*E\n"})
public final class JMLPatternList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String version;
    @NotNull
    private String loadingversion;
    @Nullable
    private String title;
    @Nullable
    private String info;
    @NotNull
    private final DefaultListModel<PatternRecord> model;
    public static final boolean BLANK_AT_END = true;

    public JMLPatternList() {
        this.version = "3";
        this.loadingversion = "3";
        this.model = new DefaultListModel();
        this.clearModel();
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.version = string;
    }

    @NotNull
    public final String getLoadingversion() {
        return this.loadingversion;
    }

    public final void setLoadingversion(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.loadingversion = string;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String t2) {
        this.title = t2 == null || ((CharSequence)((Object)StringsKt.trim((CharSequence)t2)).toString()).length() == 0 ? null : ((Object)StringsKt.trim((CharSequence)t2)).toString();
    }

    @Nullable
    public final String getInfo() {
        return this.info;
    }

    @NotNull
    public final DefaultListModel<PatternRecord> getModel() {
        return this.model;
    }

    public final int getSize() {
        return this.model.size() - 1;
    }

    public JMLPatternList(@NotNull JMLNode root) throws JuggleExceptionUser {
        Intrinsics.checkNotNullParameter(root, "root");
        this();
        this.readJML(root);
    }

    public final void clearModel() {
        this.model.clear();
        this.model.addElement(new PatternRecord(" ", null, null, null, null, null, null));
    }

    /*
     * WARNING - void declaration
     */
    public final void addLine(int row, @Nullable String display, @Nullable String animprefs, @Nullable String notation, @Nullable String anim, @Nullable JMLNode patnode, @Nullable JMLNode infonode) {
        String string = display;
        if (string == null) {
            string = "";
        }
        String display2 = string;
        String string2 = animprefs;
        String animprefs2 = string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
        String string3 = notation;
        String notation2 = string3 != null ? ((Object)StringsKt.trim((CharSequence)string3)).toString() : null;
        String string4 = anim;
        String anim2 = string4 != null ? ((Object)StringsKt.trim((CharSequence)string4)).toString() : null;
        String info = null;
        ArrayList<String> tags = null;
        if (infonode != null) {
            info = infonode.getNodeValue();
            info = info != null && !StringsKt.isBlank(info) ? ((Object)StringsKt.trim((CharSequence)info)).toString() : null;
            String tagstr = infonode.getAttributes().getAttribute("tags");
            if (tagstr != null) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                tags = new ArrayList<String>();
                Object object = tagstr;
                Regex regex = new Regex(",");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                int n2 = stringArray.length;
                for (int j = 0; j < n2; ++j) {
                    Iterator iterator2;
                    String t2;
                    String t3 = t2 = stringArray[j];
                    t3 = ((Object)StringsKt.trim((CharSequence)t3)).toString();
                    boolean isNew = true;
                    Intrinsics.checkNotNullExpressionValue(tags.iterator(), "iterator(...)");
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                        String t22 = (String)e;
                        if (!StringsKt.equals(t22, t3, true)) continue;
                        isNew = false;
                        break;
                    }
                    if (!isNew) continue;
                    tags.add(t3);
                }
            }
        }
        PatternRecord rec = new PatternRecord(display2, animprefs2, notation2, anim2, patnode, info, tags);
        if (row < 0) {
            this.model.add(this.model.size() - 1, rec);
        } else {
            this.model.add(row, rec);
        }
    }

    @Nullable
    public final PatternRecord getLine(int row) {
        return (0 <= row ? row < this.getSize() : false) ? this.model.get(row) : null;
    }

    @Nullable
    public final JMLPattern getPatternForLine(int row) throws JuggleExceptionUser, JuggleExceptionInternal {
        PatternRecord rec = this.model.get(row);
        if (rec.getNotation() == null) {
            return null;
        }
        JMLPattern pat = null;
        if (StringsKt.equals(rec.getNotation(), "jml", true) && rec.getPatnode() != null) {
            JMLNode jMLNode = rec.getPatnode();
            Intrinsics.checkNotNull(jMLNode);
            pat = new JMLPattern(jMLNode, this.loadingversion);
        } else if (rec.getAnim() != null) {
            String string = rec.getNotation();
            Intrinsics.checkNotNull(string);
            String string2 = rec.getAnim();
            Intrinsics.checkNotNull(string2);
            pat = JMLPattern.Companion.fromBasePattern(string, string2);
            if (rec.getInfo() != null) {
                pat.setInfo(rec.getInfo());
            }
            if (rec.getTags() != null) {
                Iterator<String> iterator2 = rec.getTags().iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                Iterator<String> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    String tag;
                    Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                    pat.addTag(tag);
                }
            }
        } else {
            return null;
        }
        return pat;
    }

    @Nullable
    public final AnimationPrefs getAnimationPrefsForLine(int row) throws JuggleExceptionUser {
        PatternRecord rec = this.model.get(row);
        if (rec.getAnimprefs() == null) {
            return null;
        }
        AnimationPrefs ap = new AnimationPrefs();
        ParameterList params = new ParameterList(rec.getAnimprefs());
        ap.fromParameters(params);
        params.errorIfParametersLeft();
        return ap;
    }

    public final void readJML(@NotNull JMLNode root) throws JuggleExceptionUser {
        JMLNode listnode;
        Intrinsics.checkNotNullParameter(root, "root");
        if (!StringsKt.equals(root.getNodeType(), "jml", true)) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_missing_JML_tag"));
        }
        String vers = root.getAttributes().getAttribute("version");
        if (vers != null) {
            if (JLFunc.jlCompareVersions(vers, "3") > 0) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_JML_version"));
            }
            this.loadingversion = vers;
        }
        if (!StringsKt.equals((listnode = root.getChildNode(0)).getNodeType(), "patternlist", true)) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_missing_patternlist_tag"));
        }
        int linenumber = 0;
        int n = listnode.getNumberOfChildren();
        for (int i2 = 0; i2 < n; ++i2) {
            JMLNode child = listnode.getChildNode(i2);
            if (StringsKt.equals(child.getNodeType(), "title", true)) {
                String string = child.getNodeValue();
                Intrinsics.checkNotNull(string);
                this.setTitle(((Object)StringsKt.trim((CharSequence)string)).toString());
                continue;
            }
            if (StringsKt.equals(child.getNodeType(), "info", true)) {
                String string = child.getNodeValue();
                Intrinsics.checkNotNull(string);
                this.info = ((Object)StringsKt.trim((CharSequence)string)).toString();
                continue;
            }
            if (StringsKt.equals(child.getNodeType(), "line", true)) {
                ++linenumber;
                JMLAttributes attr = child.getAttributes();
                String display = attr.getAttribute("display");
                String animprefs = attr.getAttribute("animprefs");
                String notation = attr.getAttribute("notation");
                String anim = null;
                JMLNode patnode = null;
                JMLNode infonode = null;
                if (notation != null) {
                    if (StringsKt.equals(notation, "jml", true)) {
                        patnode = child.findNode("pattern");
                        if (patnode == null) {
                            String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_missing_pattern");
                            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                            String template = string;
                            Object[] objectArray = new Object[]{linenumber};
                            Object[] arguments = objectArray;
                            throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                        }
                        infonode = patnode.findNode("info");
                    } else {
                        String string = child.getNodeValue();
                        Intrinsics.checkNotNull(string);
                        anim = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        infonode = child.findNode("info");
                    }
                }
                this.addLine(-1, display, animprefs, notation, anim, patnode, infonode);
                continue;
            }
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_illegal_tag"));
        }
    }

    public final void writeJML(@NotNull Writer wr) throws IOException {
        int i2;
        boolean empty;
        Intrinsics.checkNotNullParameter(wr, "wr");
        PrintWriter write = new PrintWriter(wr);
        int n = JMLDefs.jmlprefix.length;
        for (int i3 = 0; i3 < n; ++i3) {
            write.println(JMLDefs.jmlprefix[i3]);
        }
        write.println("<jml version=\"" + JMLNode.Companion.xmlescape(this.version) + "\">");
        write.println("<patternlist>");
        if (this.title != null) {
            String string = this.title;
            Intrinsics.checkNotNull(string);
            if (!(((CharSequence)string).length() == 0)) {
                String string2 = this.title;
                Intrinsics.checkNotNull(string2);
                write.println("<title>" + JMLNode.Companion.xmlescape(string2) + "</title>");
            }
        }
        if (this.info != null) {
            String string = this.info;
            Intrinsics.checkNotNull(string);
            if (!(((CharSequence)string).length() == 0)) {
                String string3 = this.info;
                Intrinsics.checkNotNull(string3);
                write.println("<info>" + JMLNode.Companion.xmlescape(string3) + "</info>");
            }
        }
        boolean bl = empty = this.model.size() == 1;
        if (!empty) {
            write.println();
        }
        boolean previousLineWasAnimation = false;
        int n2 = this.model.size() - 1;
        for (i2 = 0; i2 < n2; ++i2) {
            boolean hasAnimation;
            block25: {
                String line;
                block21: {
                    block23: {
                        Object tagstr;
                        Object object;
                        PatternRecord rec;
                        block24: {
                            block22: {
                                rec = this.model.get(i2);
                                line = "<line display=\"" + JMLNode.Companion.xmlescape(((Object)StringsKt.trimEnd((CharSequence)rec.getDisplay())).toString()) + "\"";
                                hasAnimation = false;
                                if (rec.getNotation() != null) {
                                    String string;
                                    Intrinsics.checkNotNull(rec.getNotation());
                                    Locale locale = Locale.getDefault();
                                    Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                                    String string4 = string.toLowerCase(locale);
                                    Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                                    line = line + " notation=\"" + JMLNode.Companion.xmlescape(string4) + "\"";
                                    hasAnimation = true;
                                }
                                if (rec.getAnimprefs() != null) {
                                    String string = rec.getAnimprefs();
                                    Intrinsics.checkNotNull(string);
                                    line = line + " animprefs=\"" + JMLNode.Companion.xmlescape(string) + "\"";
                                    hasAnimation = true;
                                }
                                if (!hasAnimation) break block21;
                                line = line + ">";
                                if (i2 > 0) {
                                    write.println();
                                }
                                write.println(line);
                                if (rec.getNotation() == null || !StringsKt.equals(rec.getNotation(), "jml", true) || rec.getPatnode() == null) break block22;
                                JMLNode jMLNode = rec.getPatnode();
                                Intrinsics.checkNotNull(jMLNode);
                                jMLNode.writeNode(write, 0);
                                break block23;
                            }
                            if (rec.getAnim() == null) break block23;
                            String string = rec.getAnim();
                            Intrinsics.checkNotNull(string);
                            write.println(JMLNode.Companion.xmlescape(string));
                            if (rec.getInfo() != null) break block24;
                            if (rec.getTags() == null) break block23;
                            ArrayList<String> arrayList = rec.getTags();
                            Intrinsics.checkNotNull(arrayList);
                            if (arrayList.isEmpty()) break block23;
                        }
                        if ((object = rec.getTags()) == null || (object = CollectionsKt.joinToString$default((Iterable)object, ",", null, null, 0, null, null, 62, null)) == null) {
                            object = tagstr = "";
                        }
                        if (rec.getInfo() != null) {
                            if (((CharSequence)tagstr).length() == 0) {
                                String string = rec.getInfo();
                                Intrinsics.checkNotNull(string);
                                write.println("<info>" + JMLNode.Companion.xmlescape(string) + "</info>");
                            } else {
                                String string = JMLNode.Companion.xmlescape((String)tagstr);
                                String string5 = rec.getInfo();
                                Intrinsics.checkNotNull(string5);
                                write.println("<info tags=\"" + string + "\">" + JMLNode.Companion.xmlescape(string5) + "</info>");
                            }
                        } else {
                            write.println("<info tags=\"" + JMLNode.Companion.xmlescape((String)tagstr) + "\"/>");
                        }
                    }
                    write.println("</line>");
                    break block25;
                }
                line = line + "/>";
                if (previousLineWasAnimation && i2 > 0) {
                    write.println();
                }
                write.println(line);
            }
            previousLineWasAnimation = hasAnimation;
        }
        if (!empty) {
            write.println();
        }
        write.println("</patternlist>");
        write.println("</jml>");
        n2 = JMLDefs.jmlsuffix.length;
        for (i2 = 0; i2 < n2; ++i2) {
            write.println(JMLDefs.jmlsuffix[i2]);
        }
        write.flush();
    }

    public final void writeText(@NotNull Writer wr) throws IOException {
        Intrinsics.checkNotNullParameter(wr, "wr");
        PrintWriter write = new PrintWriter(wr);
        int n = this.model.size() - 1;
        for (int i2 = 0; i2 < n; ++i2) {
            PatternRecord rec = this.model.get(i2);
            write.println(rec.getDisplay());
        }
        write.flush();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljugglinglab/jml/JMLPatternList$Companion;", "", "<init>", "()V", "BLANK_AT_END", "", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b \u0018\u00002\u00020\u0001BS\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\f\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0012\"\u0004\b%\u0010\u0014R\"\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Ljugglinglab/jml/JMLPatternList$PatternRecord;", "", "dis", "", "ap", "not", "ani", "pat", "Ljugglinglab/jml/JMLNode;", "inf", "t", "Ljava/util/ArrayList;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljugglinglab/jml/JMLNode;Ljava/lang/String;Ljava/util/ArrayList;)V", "pr", "(Ljugglinglab/jml/JMLPatternList$PatternRecord;)V", "display", "getDisplay", "()Ljava/lang/String;", "setDisplay", "(Ljava/lang/String;)V", "animprefs", "getAnimprefs", "setAnimprefs", "notation", "getNotation", "setNotation", "anim", "getAnim", "setAnim", "patnode", "getPatnode", "()Ljugglinglab/jml/JMLNode;", "setPatnode", "(Ljugglinglab/jml/JMLNode;)V", "info", "getInfo", "setInfo", "tags", "getTags", "()Ljava/util/ArrayList;", "setTags", "(Ljava/util/ArrayList;)V", "jugglinglab"})
    public static final class PatternRecord {
        @NotNull
        private String display;
        @Nullable
        private String animprefs;
        @Nullable
        private String notation;
        @Nullable
        private String anim;
        @Nullable
        private JMLNode patnode;
        @Nullable
        private String info;
        @Nullable
        private ArrayList<String> tags;

        @NotNull
        public final String getDisplay() {
            return this.display;
        }

        public final void setDisplay(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.display = string;
        }

        @Nullable
        public final String getAnimprefs() {
            return this.animprefs;
        }

        public final void setAnimprefs(@Nullable String string) {
            this.animprefs = string;
        }

        @Nullable
        public final String getNotation() {
            return this.notation;
        }

        public final void setNotation(@Nullable String string) {
            this.notation = string;
        }

        @Nullable
        public final String getAnim() {
            return this.anim;
        }

        public final void setAnim(@Nullable String string) {
            this.anim = string;
        }

        @Nullable
        public final JMLNode getPatnode() {
            return this.patnode;
        }

        public final void setPatnode(@Nullable JMLNode jMLNode) {
            this.patnode = jMLNode;
        }

        @Nullable
        public final String getInfo() {
            return this.info;
        }

        public final void setInfo(@Nullable String string) {
            this.info = string;
        }

        @Nullable
        public final ArrayList<String> getTags() {
            return this.tags;
        }

        public final void setTags(@Nullable ArrayList<String> arrayList) {
            this.tags = arrayList;
        }

        public PatternRecord(@NotNull String dis, @Nullable String ap, @Nullable String not, @Nullable String ani, @Nullable JMLNode pat, @Nullable String inf, @Nullable ArrayList<String> t2) {
            Intrinsics.checkNotNullParameter(dis, "dis");
            this.display = dis;
            this.animprefs = ap;
            this.notation = not;
            this.anim = ani;
            this.patnode = pat;
            this.info = inf;
            this.tags = t2;
        }

        public PatternRecord(@NotNull PatternRecord pr) {
            Intrinsics.checkNotNullParameter(pr, "pr");
            this.display = pr.display;
            this.animprefs = pr.animprefs;
            this.notation = pr.notation;
            this.anim = pr.anim;
            this.patnode = pr.patnode;
            this.info = pr.info;
            if (pr.tags != null) {
                ArrayList<String> arrayList = this.tags = new ArrayList();
                Intrinsics.checkNotNull(arrayList);
                ArrayList<String> arrayList2 = pr.tags;
                Intrinsics.checkNotNull(arrayList2);
                arrayList.addAll((Collection<String>)arrayList2);
            } else {
                this.tags = null;
            }
        }
    }
}

