/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLNode;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001a\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0018\u00100\u001a\u00020+2\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010-J\u000e\u00104\u001a\u00020+2\u0006\u00105\u001a\u000206J\b\u00107\u001a\u00020-H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R$\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010.\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0019\u00a8\u00068"}, d2={"Ljugglinglab/jml/JMLPosition;", "", "<init>", "()V", "x", "", "getX", "()D", "setX", "(D)V", "y", "getY", "setY", "z", "getZ", "setZ", "t", "getT", "setT", "angle", "getAngle", "setAngle", "juggler", "", "getJuggler", "()I", "setJuggler", "(I)V", "previous", "getPrevious", "()Ljugglinglab/jml/JMLPosition;", "setPrevious", "(Ljugglinglab/jml/JMLPosition;)V", "next", "getNext", "setNext", "c", "Ljugglinglab/util/Coordinate;", "coordinate", "getCoordinate", "()Ljugglinglab/util/Coordinate;", "setCoordinate", "(Ljugglinglab/util/Coordinate;)V", "", "strjuggler", "", "hashCode", "getHashCode", "readJML", "current", "Ljugglinglab/jml/JMLNode;", "jmlvers", "writeJML", "wr", "Ljava/io/PrintWriter;", "toString", "jugglinglab"})
public final class JMLPosition {
    private double x;
    private double y;
    private double z;
    private double t;
    private double angle;
    private int juggler;
    @Nullable
    private JMLPosition previous;
    @Nullable
    private JMLPosition next;

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public final double getT() {
        return this.t;
    }

    public final void setT(double d) {
        this.t = d;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double d) {
        this.angle = d;
    }

    public final int getJuggler() {
        return this.juggler;
    }

    public final void setJuggler(int n) {
        this.juggler = n;
    }

    @Nullable
    public final JMLPosition getPrevious() {
        return this.previous;
    }

    public final void setPrevious(@Nullable JMLPosition jMLPosition) {
        this.previous = jMLPosition;
    }

    @Nullable
    public final JMLPosition getNext() {
        return this.next;
    }

    public final void setNext(@Nullable JMLPosition jMLPosition) {
        this.next = jMLPosition;
    }

    @NotNull
    public final Coordinate getCoordinate() {
        return new Coordinate(this.x, this.y, this.z);
    }

    public final void setCoordinate(@NotNull Coordinate c) {
        Intrinsics.checkNotNullParameter(c, "c");
        this.x = c.getX();
        this.y = c.getY();
        this.z = c.getZ();
    }

    public final void setJuggler(@NotNull String strjuggler) {
        Intrinsics.checkNotNullParameter(strjuggler, "strjuggler");
        this.juggler = Integer.parseInt(strjuggler);
    }

    public final int getHashCode() {
        return this.toString().hashCode();
    }

    public final void readJML(@NotNull JMLNode current, @Nullable String jmlvers) throws JuggleExceptionUser {
        Intrinsics.checkNotNullParameter(current, "current");
        JMLAttributes at = current.getAttributes();
        double tempx = 0.0;
        double tempy = 0.0;
        double tempz = 0.0;
        double tempt = 0.0;
        double tempangle = 0.0;
        String jugglerstr = "1";
        try {
            int n = at.getNumberOfAttributes();
            for (int i2 = 0; i2 < n; ++i2) {
                if (StringsKt.equals(at.getAttributeName(i2), "x", true)) {
                    tempx = JLFunc.jlParseFiniteDouble(at.getAttributeValue(i2));
                    continue;
                }
                if (StringsKt.equals(at.getAttributeName(i2), "y", true)) {
                    tempy = JLFunc.jlParseFiniteDouble(at.getAttributeValue(i2));
                    continue;
                }
                if (StringsKt.equals(at.getAttributeName(i2), "z", true)) {
                    tempz = JLFunc.jlParseFiniteDouble(at.getAttributeValue(i2));
                    continue;
                }
                if (StringsKt.equals(at.getAttributeName(i2), "t", true)) {
                    tempt = JLFunc.jlParseFiniteDouble(at.getAttributeValue(i2));
                    continue;
                }
                if (StringsKt.equals(at.getAttributeName(i2), "angle", true)) {
                    tempangle = JLFunc.jlParseFiniteDouble(at.getAttributeValue(i2));
                    continue;
                }
                if (!StringsKt.equals(at.getAttributeName(i2), "juggler", true)) continue;
                jugglerstr = at.getAttributeValue(i2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_position_coordinate"));
        }
        this.setCoordinate(new Coordinate(tempx, tempy, tempz));
        this.t = tempt;
        this.angle = tempangle;
        this.setJuggler(jugglerstr);
        if (current.getNumberOfChildren() != 0) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_position_subtag"));
        }
    }

    public final void writeJML(@NotNull PrintWriter wr) throws IOException {
        Intrinsics.checkNotNullParameter(wr, "wr");
        Coordinate c = this.getCoordinate();
        wr.println("<position x=\"" + JLFunc.jlToStringRounded(c.getX(), 4) + "\" y=\"" + JLFunc.jlToStringRounded(c.getY(), 4) + "\" z=\"" + JLFunc.jlToStringRounded(c.getZ(), 4) + "\" t=\"" + JLFunc.jlToStringRounded(this.t, 4) + "\" angle=\"" + JLFunc.jlToStringRounded(this.angle, 4) + "\" juggler=\"" + this.juggler + "\"/>");
    }

    @NotNull
    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeJML(new PrintWriter(sw));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

