/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLNode;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B=\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0002\u0010\rJ\u0006\u0010\u001d\u001a\u00020\u0005J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010\bJ(\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\b\u0010*\u001a\u0004\u0018\u00010\bJ\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\"\u0010\u0007\u001a\u0004\u0018\u00010\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\n\u001a\u0004\u0018\u00010\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006/"}, d2={"Ljugglinglab/jml/JMLSymmetry;", "", "<init>", "()V", "symType", "", "numJugglers", "jugglerPerm", "", "numPaths", "pathPerm", "delay", "", "(IILjava/lang/String;ILjava/lang/String;D)V", "value", "getSymType", "()I", "numberOfJugglers", "getNumberOfJugglers", "numberOfPaths", "getNumberOfPaths", "Ljugglinglab/util/Permutation;", "getJugglerPerm", "()Ljugglinglab/util/Permutation;", "getPathPerm", "getDelay", "()D", "setDelay", "(D)V", "getType", "setJugglerPerm", "", "nj", "jp", "setPathPerm", "np", "pp", "readJML", "current", "Ljugglinglab/jml/JMLNode;", "numjug", "numpat", "version", "writeJML", "wr", "Ljava/io/PrintWriter;", "Companion", "jugglinglab"})
public final class JMLSymmetry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int symType;
    private int numberOfJugglers;
    private int numberOfPaths;
    @Nullable
    private Permutation jugglerPerm;
    @Nullable
    private Permutation pathPerm;
    private double delay = -1.0;
    public static final int TYPE_DELAY = 1;
    public static final int TYPE_SWITCH = 2;
    public static final int TYPE_SWITCHDELAY = 3;

    public final int getSymType() {
        return this.symType;
    }

    public final int getNumberOfJugglers() {
        return this.numberOfJugglers;
    }

    public final int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    @Nullable
    public final Permutation getJugglerPerm() {
        return this.jugglerPerm;
    }

    @Nullable
    public final Permutation getPathPerm() {
        return this.pathPerm;
    }

    public final double getDelay() {
        return this.delay;
    }

    public final void setDelay(double d) {
        this.delay = d;
    }

    public JMLSymmetry() {
    }

    public JMLSymmetry(int symType, int numJugglers, @Nullable String jugglerPerm, int numPaths, @Nullable String pathPerm, double delay) {
        this.symType = symType;
        this.setJugglerPerm(numJugglers, jugglerPerm);
        this.setPathPerm(numPaths, pathPerm);
        this.delay = delay;
    }

    public final int getType() {
        return this.symType;
    }

    private final void setJugglerPerm(int nj, String jp) {
        this.numberOfJugglers = nj;
        this.jugglerPerm = jp == null ? new Permutation(nj, true) : new Permutation(nj, jp, true);
    }

    public final void setPathPerm(int np, @Nullable String pp) throws JuggleExceptionUser {
        this.numberOfPaths = np;
        this.pathPerm = pp == null ? new Permutation(np, false) : new Permutation(np, pp, false);
    }

    public final void readJML(@NotNull JMLNode current, int numjug, int numpat, @Nullable String version) throws JuggleExceptionUser {
        int n;
        Intrinsics.checkNotNullParameter(current, "current");
        JMLAttributes at = current.getAttributes();
        int symtypenum = 0;
        double delay = -1.0;
        String symType = at.getAttribute("type");
        String jugglerPerm = at.getAttribute("jperm");
        String pathPerm = at.getAttribute("pperm");
        String delayString = at.getAttribute("delay");
        if (delayString != null) {
            try {
                delay = JLFunc.jlParseFiniteDouble(delayString);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_symmetry_format"));
            }
        }
        if (symType == null) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_symmetry_notype"));
        }
        if (StringsKt.equals(symType, "delay", true)) {
            n = 1;
        } else if (StringsKt.equals(symType, "switch", true)) {
            n = 2;
        } else if (StringsKt.equals(symType, "switchdelay", true)) {
            n = 3;
        } else {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_symmetry_type"));
        }
        this.symType = symtypenum = n;
        this.setJugglerPerm(numjug, jugglerPerm);
        this.setPathPerm(numpat, pathPerm);
        this.delay = delay;
    }

    public final void writeJML(@NotNull PrintWriter wr) throws IOException {
        Intrinsics.checkNotNullParameter(wr, "wr");
        Object out = "<symmetry type=\"";
        switch (this.symType) {
            case 1: {
                Permutation permutation = this.pathPerm;
                Intrinsics.checkNotNull(permutation);
                out = (String)out + "delay\" pperm=\"" + permutation.toString(true) + "\" delay=\"" + JLFunc.jlToStringRounded(this.delay, 4) + "\"/>";
                break;
            }
            case 2: {
                Permutation permutation = this.jugglerPerm;
                Intrinsics.checkNotNull(permutation);
                String string = permutation.toString(true);
                Permutation permutation2 = this.pathPerm;
                Intrinsics.checkNotNull(permutation2);
                out = (String)out + "switch\" jperm=\"" + string + "\" pperm=\"" + permutation2.toString(true) + "\"/>";
                break;
            }
            case 3: {
                Permutation permutation = this.jugglerPerm;
                Intrinsics.checkNotNull(permutation);
                String string = permutation.toString(true);
                Permutation permutation3 = this.pathPerm;
                Intrinsics.checkNotNull(permutation3);
                out = (String)out + "switchdelay\" jperm=\"" + string + "\" pperm=\"" + permutation3.toString(true) + "\"/>";
            }
        }
        wr.println((String)out);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljugglinglab/jml/JMLSymmetry$Companion;", "", "<init>", "()V", "TYPE_DELAY", "", "TYPE_SWITCH", "TYPE_SWITCHDELAY", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

