/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import jugglinglab.jml.JMLEvent;
import jugglinglab.path.Path;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00162\b\u0010#\u001a\u0004\u0018\u00010\u0016J\u0016\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003J\b\u0010'\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u0004\u0018\u00010\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\nR\u001e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\n\u00a8\u0006("}, d2={"Ljugglinglab/jml/PathLink;", "", "pathNum", "", "startEvent", "Ljugglinglab/jml/JMLEvent;", "endEvent", "<init>", "(ILjugglinglab/jml/JMLEvent;Ljugglinglab/jml/JMLEvent;)V", "getPathNum", "()I", "getStartEvent", "()Ljugglinglab/jml/JMLEvent;", "getEndEvent", "value", "Ljugglinglab/path/Path;", "path", "getPath", "()Ljugglinglab/path/Path;", "", "isInHand", "()Z", "", "throwType", "getThrowType", "()Ljava/lang/String;", "throwMod", "getThrowMod", "holdingJuggler", "getHoldingJuggler", "holdingHand", "getHoldingHand", "setThrow", "", "pathType", "pathMod", "setInHand", "juggler", "hand", "toString", "jugglinglab"})
public final class PathLink {
    private final int pathNum;
    @NotNull
    private final JMLEvent startEvent;
    @NotNull
    private final JMLEvent endEvent;
    @Nullable
    private Path path;
    private boolean isInHand;
    @Nullable
    private String throwType;
    @Nullable
    private String throwMod;
    private int holdingJuggler;
    private int holdingHand;

    public PathLink(int pathNum, @NotNull JMLEvent startEvent, @NotNull JMLEvent endEvent) {
        Intrinsics.checkNotNullParameter(startEvent, "startEvent");
        Intrinsics.checkNotNullParameter(endEvent, "endEvent");
        this.pathNum = pathNum;
        this.startEvent = startEvent;
        this.endEvent = endEvent;
    }

    public final int getPathNum() {
        return this.pathNum;
    }

    @NotNull
    public final JMLEvent getStartEvent() {
        return this.startEvent;
    }

    @NotNull
    public final JMLEvent getEndEvent() {
        return this.endEvent;
    }

    @Nullable
    public final Path getPath() {
        return this.path;
    }

    public final boolean isInHand() {
        return this.isInHand;
    }

    @Nullable
    public final String getThrowType() {
        return this.throwType;
    }

    @Nullable
    public final String getThrowMod() {
        return this.throwMod;
    }

    public final int getHoldingJuggler() {
        return this.holdingJuggler;
    }

    public final int getHoldingHand() {
        return this.holdingHand;
    }

    public final void setThrow(@NotNull String pathType, @Nullable String pathMod) throws JuggleExceptionUser, JuggleExceptionInternal {
        Intrinsics.checkNotNullParameter(pathType, "pathType");
        Path newPath = Path.Companion.newPath(pathType);
        newPath.initPath(pathMod);
        Coordinate coordinate = this.startEvent.getGlobalCoordinate();
        Intrinsics.checkNotNull(coordinate);
        newPath.setStart(coordinate, this.startEvent.getT());
        Coordinate coordinate2 = this.endEvent.getGlobalCoordinate();
        Intrinsics.checkNotNull(coordinate2);
        newPath.setEnd(coordinate2, this.endEvent.getT());
        newPath.calcPath();
        this.path = newPath;
        this.throwType = pathType;
        this.throwMod = pathMod;
        this.isInHand = false;
    }

    public final void setInHand(int juggler, int hand) {
        this.isInHand = true;
        this.holdingJuggler = juggler;
        this.holdingHand = hand;
    }

    @NotNull
    public String toString() {
        Coordinate start = this.startEvent.getGlobalCoordinate();
        Coordinate end = this.endEvent.getGlobalCoordinate();
        StringBuilder sb = new StringBuilder();
        sb.append((String)(this.isInHand ? "In hand, " : "Not in hand (type=\"" + this.throwType + "\", mod=\"" + this.throwMod + "\"), "));
        if (start != null) {
            sb.append("from (x=" + start.getX() + ",y=" + start.getY() + ",z=" + start.getZ() + ",t=" + this.startEvent.getT() + ") ");
        }
        if (end != null) {
            sb.append("to (x=" + end.getX() + ",y=" + end.getY() + ",z=" + end.getZ() + ",t=" + this.endEvent.getT() + ")");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

