/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jugglinglab.JugglingLab;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00042345B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\tH\u0002JH\u0010\u0015\u001a\u00020\u001626\u0010\u0017\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a0\u0018j\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a`\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010\u001d\u001a\u00020\u001c2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J#\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010%J\u001b\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010$\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010'J\u00d3\u0001\u0010(\u001a\u00020)26\u0010\u0017\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a0\u0018j\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a`\u001a2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00190\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001a2\u0006\u0010*\u001a\u00020\u001c2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00052>\u00100\u001a:\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0018j\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\u001a0\u0018j\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0018j\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\u001a`\u001aH\u0002\u00a2\u0006\u0002\u00101R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Ljugglinglab/notation/HSS;", "", "<init>", "()V", "HSS_DWELL_DEFAULT", "", "processHSS", "Ljugglinglab/notation/HSS$ModParms;", "p", "", "h", "hld", "", "dwlmax", "hndspc", "dwl", "ossSyntax", "Ljugglinglab/notation/HSS$OssPatBnc;", "ss", "hssSyntax", "Ljugglinglab/notation/HSS$HssParms;", "ossPermTest", "", "os", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "op", "", "hssPermTest", "hs", "hp", "parseHandspec", "", "", "hspec", "nh", "(Ljava/lang/String;I)[[I", "defHandspec", "(I)[[I", "convertNotation", "Ljugglinglab/notation/HSS$PatParms;", "ho", "hm", "nj", "hldOpt", "dwlMaxOpt", "defDwl", "bncStr", "(Ljava/util/ArrayList;Ljava/util/ArrayList;I[[IIZZDLjava/util/ArrayList;)Ljugglinglab/notation/HSS$PatParms;", "OssPatBnc", "HssParms", "PatParms", "ModParms", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nHSS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HSS.kt\njugglinglab/notation/HSS\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,855:1\n1#2:856\n*E\n"})
public final class HSS {
    @NotNull
    public static final HSS INSTANCE = new HSS();
    private static final double HSS_DWELL_DEFAULT = 0.3;

    private HSS() {
    }

    @NotNull
    public final ModParms processHSS(@NotNull String p, @NotNull String h, boolean hld, boolean dwlmax, @Nullable String hndspc, double dwl) throws JuggleExceptionUser {
        Comparable comparable;
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(h, "h");
        OssPatBnc ossinfo = this.ossSyntax(p);
        ArrayList<ArrayList<Character>> ossPat = ossinfo.getObjPat();
        this.ossPermTest(ossPat, ossPat.size());
        HssParms hssinfo = this.hssSyntax(h);
        ArrayList<Character> hssPat = hssinfo.getPat();
        int hssOrb = this.hssPermTest(hssPat, hssPat.size());
        int[][] handmap = hndspc != null ? this.parseHandspec(hndspc, hssinfo.getHands()) : this.defHandspec(hssinfo.getHands());
        int n = 1;
        Object[] objectArray = (Object[])handmap;
        if (objectArray.length == 0) {
            comparable = null;
        } else {
            int[] it = (int[])objectArray[0];
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it[0]);
            int n2 = 1;
            int n3 = ArraysKt.getLastIndex(objectArray);
            if (n2 <= n3) {
                while (true) {
                    int[] it2 = (int[])objectArray[n2];
                    $i$a$-maxOfOrNull-HSS$processHSS$numJug$1 = false;
                    Comparable comparable3 = Integer.valueOf(it2[0]);
                    if (comparable2.compareTo(comparable3) < 0) {
                        comparable2 = comparable3;
                    }
                    if (n2 == n3) break;
                    ++n2;
                }
            }
            comparable = comparable2;
        }
        Integer n4 = (Integer)comparable;
        int n5 = n4 != null ? n4 : 1;
        int numJug = Math.max(n, n5);
        PatParms patinfo = this.convertNotation(ossPat, hssPat, hssOrb, handmap, numJug, hld, dwlmax, dwl, ossinfo.getBnc());
        if (patinfo.getNewPat() == null) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_no_pattern"));
        }
        String string = patinfo.getNewPat();
        Intrinsics.checkNotNull(string);
        return new ModParms(string, patinfo.getDwellBt());
    }

    private final OssPatBnc ossSyntax(String ss) throws JuggleExceptionUser {
        boolean muxThrow = false;
        boolean muxThrowFound = false;
        boolean minOneThrow = false;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        int throwSum = 0;
        int numBeats = 0;
        int subBeats = 0;
        int numObj = 0;
        ArrayList<ArrayList<Character>> oPat = new ArrayList<ArrayList<Character>>();
        ArrayList<ArrayList<String>> bncinfo = new ArrayList<ArrayList<String>>();
        int n = ss.length();
        for (int i2 = 0; i2 < n; ++i2) {
            CharSequence template;
            char c = ss.charAt(i2);
            if (muxThrow) {
                CharSequence charSequence = String.valueOf(c);
                if (new Regex("[0-9,a-z]").matches(charSequence)) {
                    minOneThrow = true;
                    muxThrowFound = true;
                    ((ArrayList)oPat.get(numBeats - 1)).add(subBeats, Character.valueOf(c));
                    bncinfo.get(numBeats - 1).add(subBeats, "null");
                    ++subBeats;
                    throwSum += Character.getNumericValue(c);
                    b1 = true;
                    b2 = false;
                    b3 = false;
                    continue;
                }
                if (c == ']') {
                    if (muxThrowFound) {
                        muxThrow = false;
                        muxThrowFound = false;
                        subBeats = 0;
                        b1 = false;
                        b2 = false;
                        b3 = false;
                        continue;
                    }
                    template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_object_syntax_error_at_pos");
                    Object[] objectArray = new Object[]{i2 + 1};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
                }
                if (Character.isWhitespace(c)) {
                    b1 = false;
                    b2 = false;
                    b3 = false;
                    continue;
                }
                if (c == 'B') {
                    if (b1) {
                        bncinfo.get(numBeats - 1).set(subBeats - 1, "B");
                        b1 = false;
                        b2 = true;
                        continue;
                    }
                    template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_object_syntax_error_at_pos");
                    Object[] objectArray = new Object[]{i2 + 1};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
                }
                if (c == 'F' || c == 'L') {
                    if (b2) {
                        bncinfo.get(numBeats - 1).set(subBeats - 1, "B" + c);
                        b2 = false;
                        continue;
                    }
                    if (b3) {
                        bncinfo.get(numBeats - 1).set(subBeats - 1, "BH" + c);
                        b3 = false;
                        continue;
                    }
                    template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_object_syntax_error_at_pos");
                    Object[] objectArray = new Object[]{i2 + 1};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
                }
                if (c == 'H') {
                    if (b2) {
                        bncinfo.get(numBeats - 1).set(subBeats - 1, "BH");
                        b2 = false;
                        b3 = true;
                        continue;
                    }
                    template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_object_syntax_error_at_pos");
                    Object[] objectArray = new Object[]{i2 + 1};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
                }
                template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_object_syntax_error_at_pos");
                Object[] objectArray = new Object[]{i2 + 1};
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
            }
            template = String.valueOf(c);
            if (new Regex("[0-9,a-z]").matches(template)) {
                minOneThrow = true;
                oPat.add(numBeats, new ArrayList());
                oPat.get(numBeats).add(subBeats, Character.valueOf(c));
                bncinfo.add(numBeats, new ArrayList());
                bncinfo.get(numBeats).add(subBeats, "null");
                ++numBeats;
                throwSum += Character.getNumericValue(c);
                b1 = true;
                b2 = false;
                b3 = false;
                continue;
            }
            if (c == '[') {
                muxThrow = true;
                oPat.add(numBeats, new ArrayList());
                bncinfo.add(numBeats, new ArrayList());
                ++numBeats;
                b1 = false;
                b2 = false;
                b3 = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                b1 = false;
                b2 = false;
                b3 = false;
                continue;
            }
            if (c == 'B') {
                if (b1) {
                    bncinfo.get(numBeats - 1).set(subBeats, "B");
                    b1 = false;
                    b2 = true;
                    continue;
                }
                template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_object_syntax_error_at_pos");
                Object[] objectArray = new Object[]{i2 + 1};
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
            }
            if (c == 'F' || c == 'L') {
                if (b2) {
                    bncinfo.get(numBeats - 1).set(subBeats, "B" + c);
                    b2 = false;
                    continue;
                }
                if (b3) {
                    bncinfo.get(numBeats - 1).set(subBeats, "BH" + c);
                    b3 = false;
                    continue;
                }
                template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_object_syntax_error_at_pos");
                Object[] objectArray = new Object[]{i2 + 1};
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
            }
            if (c == 'H') {
                if (b2) {
                    bncinfo.get(numBeats - 1).set(subBeats, "BH");
                    b2 = false;
                    b3 = true;
                    continue;
                }
                template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_object_syntax_error_at_pos");
                Object[] objectArray = new Object[]{i2 + 1};
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
            }
            template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_object_syntax_error_at_pos");
            Object[] objectArray = new Object[]{i2 + 1};
            Object[] arguments = objectArray;
            throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
        }
        if (!muxThrow && minOneThrow) {
            if (throwSum % numBeats != 0) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_bad_average_object"));
            }
        } else {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_syntax_error"));
        }
        numObj = throwSum / numBeats;
        Iterator iterator2 = bncinfo.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            ArrayList strings = (ArrayList)e;
            int n2 = ((Collection)strings).size();
            for (int j = 0; j < n2; ++j) {
                if (Intrinsics.areEqual(strings.get(j), "null")) {
                    strings.set(j, " ");
                    continue;
                }
                strings.set(j, strings.get(j) + " ");
            }
        }
        return new OssPatBnc(oPat, bncinfo);
    }

    private final HssParms hssSyntax(String ss) throws JuggleExceptionUser {
        int throwSum = 0;
        int numBeats = 0;
        int nHnds = 0;
        ArrayList<Character> hPat = new ArrayList<Character>();
        int n = ss.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = ss.charAt(i2);
            CharSequence charSequence = String.valueOf(c);
            if (new Regex("[0-9,a-z]").matches(charSequence)) {
                hPat.add(numBeats, Character.valueOf(c));
                ++numBeats;
                throwSum += Character.getNumericValue(c);
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_hand_syntax_error_at_pos");
            Object[] objectArray = new Object[]{i2 + 1};
            Object[] arguments = objectArray;
            throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
        }
        if (throwSum % numBeats != 0) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_bad_average_hand"));
        }
        nHnds = throwSum / numBeats;
        return new HssParms(hPat, nHnds);
    }

    private final void ossPermTest(ArrayList<ArrayList<Character>> os, int op) throws JuggleExceptionUser {
        int i2;
        ArrayList mods = new ArrayList();
        int modulo = 0;
        int[] cmp = new int[op];
        for (i2 = 0; i2 < op; ++i2) {
            mods.add(i2, new ArrayList());
            int n = ((Collection)os.get(i2)).size();
            for (int j = 0; j < n; ++j) {
                Character c = os.get(i2).get(j);
                Intrinsics.checkNotNullExpressionValue(c, "get(...)");
                modulo = (Character.getNumericValue(c.charValue()) + i2) % op;
                ((ArrayList)mods.get(i2)).add(j, modulo);
                int n2 = modulo;
                int n3 = cmp[n2];
                cmp[n2] = n3 + 1;
            }
        }
        for (i2 = 0; i2 < op; ++i2) {
            if (cmp[i2] == os.get(i2).size()) continue;
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_object_pattern_invalid"));
        }
    }

    private final int hssPermTest(ArrayList<Character> hs, int hp) throws JuggleExceptionUser {
        int n;
        int i2;
        int modulo = 0;
        int ho = 0;
        int[] mods = new int[hp];
        int[] cmp = new int[hp];
        int[] orb = new int[hp];
        boolean[] touched = new boolean[hp];
        for (i2 = 0; i2 < hp; ++i2) {
            Character c = hs.get(i2);
            Intrinsics.checkNotNullExpressionValue(c, "get(...)");
            mods[i2] = modulo = (Character.getNumericValue(c.charValue()) + i2) % hp;
            int n2 = modulo;
            n = cmp[n2];
            cmp[n2] = n + 1;
        }
        for (i2 = 0; i2 < hp; ++i2) {
            if (cmp[i2] == 1) continue;
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_hand_pattern_invalid"));
        }
        ho = 1;
        for (i2 = 0; i2 < hp; ++i2) {
            if (!touched[i2]) {
                Character c = hs.get(i2);
                Intrinsics.checkNotNullExpressionValue(c, "get(...)");
                orb[i2] = Character.getNumericValue(c.charValue());
                touched[i2] = true;
                int j = mods[i2];
                while (j != i2) {
                    n = i2;
                    int n3 = orb[n];
                    Character c2 = hs.get(j);
                    Intrinsics.checkNotNullExpressionValue(c2, "get(...)");
                    orb[n] = n3 + Character.getNumericValue(c2.charValue());
                    touched[j] = true;
                    j = mods[j];
                }
            }
            if (orb[i2] == ho || orb[i2] == 0) continue;
            ho = Permutation.Companion.lcm(orb[i2], ho);
        }
        return ho;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int[][] parseHandspec(String hspec, int nh) throws JuggleExceptionUser {
        int i2;
        int n = 0;
        int[][] nArrayArray = new int[nh][];
        while (n < nh) {
            int n2 = n++;
            nArrayArray[n2] = new int[2];
        }
        int[][] hmap = nArrayArray;
        boolean assignLeftHand = false;
        boolean assignRightHand = false;
        boolean jugglerActive = false;
        boolean pass = false;
        boolean handPresent = false;
        boolean numberFormStarted = false;
        boolean matchFound = false;
        int jugglerNumber = 0;
        Object buildHandNumber = null;
        int n3 = hspec.length();
        for (i2 = 0; i2 < n3; ++i2) {
            char c = hspec.charAt(i2);
            if (!jugglerActive) {
                if (c == '(') {
                    jugglerActive = true;
                    assignLeftHand = true;
                    numberFormStarted = true;
                    buildHandNumber = null;
                    pass = false;
                    handPresent = false;
                    ++jugglerNumber;
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_handspec_syntax_error_at_pos");
                Object[] objectArray = new Object[]{i2 + 1};
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
            }
            if (assignLeftHand) {
                block27: {
                    CharSequence template = String.valueOf(c);
                    if (new Regex("[0-9]").matches(template)) {
                        if (!numberFormStarted) {
                            template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_handspec_syntax_error_at_pos");
                            Object[] objectArray = new Object[]{i2 + 1};
                            Object[] arguments = objectArray;
                            throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
                        }
                        buildHandNumber = buildHandNumber == null ? String.valueOf(c) : "" + buildHandNumber + c;
                        continue;
                    }
                    if (Character.isWhitespace(c)) {
                        Object object = buildHandNumber;
                        boolean bl = object != null ? ((CharSequence)object).length() > 0 : false;
                        if (!bl) continue;
                        numberFormStarted = false;
                        continue;
                    }
                    if (c != ',') {
                        template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_handspec_syntax_error_at_pos");
                        Object[] objectArray = new Object[]{i2 + 1};
                        Object[] arguments = objectArray;
                        throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
                    }
                    assignLeftHand = false;
                    assignRightHand = true;
                    numberFormStarted = true;
                    if (buildHandNumber != null) {
                        if (Integer.parseInt((String)buildHandNumber) >= 1 && Integer.parseInt((String)buildHandNumber) <= nh) {
                            if (hmap[Integer.parseInt((String)buildHandNumber) - 1][0] != 0) {
                                template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_hand_assigned_more_than_once");
                                Object[] objectArray = new Object[]{Integer.parseInt((String)buildHandNumber)};
                                Object[] arguments = objectArray;
                                throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
                            }
                            hmap[Integer.parseInt((String)buildHandNumber) - 1][0] = jugglerNumber;
                            hmap[Integer.parseInt((String)buildHandNumber) - 1][1] = 0;
                            handPresent = true;
                            break block27;
                        } else {
                            template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_hand_number_out_of_range");
                            Object[] objectArray = new Object[]{Integer.parseInt((String)buildHandNumber)};
                            Object[] arguments = objectArray;
                            throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
                        }
                    }
                    handPresent = false;
                }
                buildHandNumber = null;
                continue;
            }
            if (!assignRightHand) continue;
            CharSequence template = String.valueOf(c);
            if (new Regex("[0-9]").matches(template)) {
                if (!numberFormStarted) {
                    template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_handspec_syntax_error_at_pos");
                    Object[] objectArray = new Object[]{i2 + 1};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
                }
                buildHandNumber = buildHandNumber == null ? String.valueOf(c) : (String)buildHandNumber + c;
                continue;
            }
            if (Character.isWhitespace(c)) {
                Object object = buildHandNumber;
                boolean bl = object != null ? ((CharSequence)object).length() > 0 : false;
                if (!bl) continue;
                numberFormStarted = false;
                continue;
            }
            if (c != ')') {
                template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_handspec_syntax_error_at_pos");
                Object[] objectArray = new Object[]{i2 + 1};
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser(MessageFormat.format((String)template, Arrays.copyOf(arguments, arguments.length)));
            }
            assignRightHand = false;
            jugglerActive = false;
            if (buildHandNumber != null) {
                int buildHandNumberInt = Integer.parseInt((String)buildHandNumber);
                if (!(1 <= buildHandNumberInt ? buildHandNumberInt <= nh : false)) {
                    String template2 = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_hand_number_out_of_range");
                    Object[] objectArray = new Object[]{Integer.parseInt((String)buildHandNumber)};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format(template2, Arrays.copyOf(arguments, arguments.length)));
                }
                hmap[buildHandNumberInt - 1][0] = jugglerNumber;
                hmap[buildHandNumberInt - 1][1] = 1;
            } else if (!handPresent) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_at_least_one_hand_per_juggler"));
            }
            buildHandNumber = null;
            pass = true;
        }
        if (jugglerNumber > nh) {
            String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_handspec_too_many_jugglers");
            Object[] c = new Object[]{nh};
            Object[] arguments = c;
            throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
        }
        if (!pass) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_handspec_syntax_error"));
        }
        i2 = 0;
        if (i2 < nh && hmap[i2][0] == 0) {
            String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_handspec_hand_missing");
            Object[] objectArray = new Object[]{i2 + 1};
            Object[] arguments = objectArray;
            throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
        }
        i2 = 0;
        while (i2 < nh) {
            if (hmap[i2][0] == 0) {
                String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_juggler_not_assigned_to_hand");
                Object[] objectArray = new Object[]{i2 + 1};
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
            }
            ++i2;
        }
        return hmap;
    }

    private final int[][] defHandspec(int nh) {
        int n = 0;
        int[][] nArrayArray = new int[nh][];
        while (n < nh) {
            int n2 = n++;
            nArrayArray[n2] = new int[2];
        }
        int[][] hmap = nArrayArray;
        int nJugs = nh % 2 == 0 ? nh / 2 : (nh + 1) / 2;
        for (int i2 = 0; i2 < nh; ++i2) {
            if (i2 < nJugs) {
                hmap[i2][0] = i2 + 1;
                hmap[i2][1] = 1;
                continue;
            }
            hmap[i2][0] = i2 + 1 - nJugs;
            hmap[i2][1] = 0;
        }
        return hmap;
    }

    private final PatParms convertNotation(ArrayList<ArrayList<Character>> os, ArrayList<Character> hs, int ho, int[][] hm, int nj, boolean hldOpt, boolean dwlMaxOpt, double defDwl, ArrayList<ArrayList<String>> bncStr) throws JuggleExceptionUser {
        int n;
        int j;
        int i2;
        int j2;
        int i3;
        int throwVal = 0;
        int currJug = 0;
        Object modPat = null;
        boolean flag = false;
        ArrayList iph = new ArrayList();
        int objPer = os.size();
        int hndPer = hs.size();
        int patPer = Permutation.Companion.lcm(objPer, ho);
        int[] ah = new int[patPer];
        boolean[] assignDone = new boolean[patPer];
        int n2 = 0;
        int[][] nArrayArray = new int[patPer][];
        while (n2 < patPer) {
            int n3 = n2++;
            nArrayArray[n3] = new int[2];
        }
        int[][] ji = nArrayArray;
        double[] dwlBts = new double[patPer];
        if (patPer > objPer) {
            for (int i4 = objPer; i4 < patPer; ++i4) {
                os.add(i4, os.get(i4 - objPer));
            }
        }
        if (patPer > objPer) {
            for (int i5 = objPer; i5 < patPer; ++i5) {
                bncStr.add(i5, bncStr.get(i5 - objPer));
            }
        }
        if (patPer > hndPer) {
            for (int i6 = hndPer; i6 < patPer; ++i6) {
                hs.add(i6, hs.get(i6 - hndPer));
            }
        }
        int currHand = 0;
        for (int i7 = 0; i7 < patPer; ++i7) {
            Character c = hs.get(i7);
            char c2 = '0';
            if (c != null && c.charValue() == c2) {
                int n4 = ((Collection)os.get(i7)).size();
                for (int j3 = 0; j3 < n4; ++j3) {
                    Character c3 = os.get(i7).get(j3);
                    char c4 = '0';
                    if (c3 != null && c3.charValue() == c4) continue;
                    String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hss_no_hand_to_throw_at_beat");
                    Object[] objectArray = new Object[]{i7 + 1};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                }
                ji[i7][0] = 0;
                ji[i7][1] = -1;
                assignDone[i7] = true;
                continue;
            }
            if (!assignDone[i7]) {
                ah[i7] = ++currHand;
                assignDone[i7] = true;
                Character c5 = hs.get(i7);
                Intrinsics.checkNotNullExpressionValue(c5, "get(...)");
                int next = (i7 + Character.getNumericValue(c5.charValue())) % patPer;
                while (next != i7) {
                    ah[next] = currHand;
                    assignDone[next] = true;
                    Character c6 = hs.get(next);
                    Intrinsics.checkNotNullExpressionValue(c6, "get(...)");
                    next = (next + Character.getNumericValue(c6.charValue())) % patPer;
                }
            }
            ji[i7][0] = hm[ah[i7] - 1][0];
            ji[i7][1] = hm[ah[i7] - 1][1];
        }
        flag = false;
        int[] mincaught = new int[patPer];
        int tgtIdx = 0;
        int curThrow = 0;
        for (i3 = 0; i3 < patPer; ++i3) {
            int n5 = ((Collection)os.get(i3)).size();
            for (j2 = 0; j2 < n5; ++j2) {
                Character c = os.get(i3).get(j2);
                Intrinsics.checkNotNullExpressionValue(c, "get(...)");
                curThrow = Character.getNumericValue(c.charValue());
                tgtIdx = (i3 + curThrow) % patPer;
                if (curThrow <= 0) continue;
                if (mincaught[tgtIdx] == 0) {
                    mincaught[tgtIdx] = curThrow;
                    continue;
                }
                if (curThrow >= mincaught[tgtIdx]) continue;
                mincaught[tgtIdx] = curThrow;
            }
        }
        if (!dwlMaxOpt) {
            for (i3 = 0; i3 < patPer; ++i3) {
                if (ji[i3][0] != ji[(i3 + 1) % patPer][0] || ji[i3][1] != ji[(i3 + 1) % patPer][1]) continue;
                flag = true;
                break;
            }
            for (i3 = 0; i3 < patPer; ++i3) {
                double d = dwlBts[i3] = flag ? 0.3 : defDwl;
                if (!(dwlBts[i3] >= (double)mincaught[i3])) continue;
                dwlBts[i3] = (double)mincaught[i3] - 0.7;
            }
        } else {
            for (i3 = 0; i3 < patPer; ++i3) {
                j2 = (i3 + 1) % patPer;
                int diff = 1;
                while (ji[i3][0] != ji[j2][0] || ji[i3][1] != ji[j2][1]) {
                    j2 = (j2 + 1) % patPer;
                    ++diff;
                }
                dwlBts[j2] = (double)diff - 0.7;
            }
            for (i3 = 0; i3 < patPer; ++i3) {
                if (dwlBts[i3] >= (double)mincaught[i3]) {
                    dwlBts[i3] = (double)mincaught[i3] - 0.7;
                    continue;
                }
                if (!(dwlBts[i3] <= 0.0)) continue;
                dwlBts[i3] = 0.3;
            }
        }
        boolean[] clash = new boolean[patPer];
        int clashcnt = 0;
        for (i2 = 0; i2 < patPer; ++i2) {
            for (j = 1; j < patPer; ++j) {
                if (!((dwlBts[(i2 + j) % patPer] - dwlBts[i2] - (double)j) % (double)patPer == 0.0)) continue;
                clash[(i2 + j) % patPer] = true;
                ++clashcnt;
            }
            while (clashcnt != 0) {
                for (int k = 0; k < patPer; ++k) {
                    if (!clash[k]) continue;
                    dwlBts[k] = dwlBts[k] + 0.3 / (double)clashcnt;
                    --clashcnt;
                    clash[k] = false;
                }
            }
        }
        for (i2 = 0; i2 < patPer; ++i2) {
            iph.add(i2, new ArrayList());
            n = ((Collection)os.get(i2)).size();
            for (j = 0; j < n; ++j) {
                ((ArrayList)iph.get(i2)).add(j, null);
                Character c = os.get(i2).get(j);
                Intrinsics.checkNotNullExpressionValue(c, "get(...)");
                throwVal = Character.getNumericValue(c.charValue());
                int sourceJug = ji[i2][0];
                int sourceHnd = ji[i2][1];
                int targetJug = ji[(i2 + throwVal) % patPer][0];
                int targetHnd = ji[(i2 + throwVal) % patPer][1];
                if (throwVal % 2 == 0 && sourceHnd != targetHnd) {
                    ((ArrayList)iph.get(i2)).set(j, "x");
                } else if (throwVal % 2 != 0 && sourceHnd == targetHnd) {
                    ((ArrayList)iph.get(i2)).set(j, "x");
                }
                if (sourceJug != targetJug) {
                    if (((ArrayList)iph.get(i2)).get(j) != "x") {
                        ((ArrayList)iph.get(i2)).set(j, "p" + targetJug);
                        continue;
                    }
                    ((ArrayList)iph.get(i2)).set(j, "xp" + targetJug);
                    continue;
                }
                if (!hldOpt) continue;
                Character c7 = hs.get(i2);
                Intrinsics.checkNotNullExpressionValue(c7, "get(...)");
                if (throwVal != Character.getNumericValue(c7.charValue())) continue;
                if (((ArrayList)iph.get(i2)).get(j) != "x") {
                    ((ArrayList)iph.get(i2)).set(j, "H");
                    continue;
                }
                ((ArrayList)iph.get(i2)).set(j, "xH");
            }
        }
        for (i2 = 0; i2 < patPer; ++i2) {
            n = ((Collection)bncStr.get(i2)).size();
            for (j = 0; j < n; ++j) {
                if (((ArrayList)iph.get(i2)).get(j) == null) {
                    ((ArrayList)iph.get(i2)).set(j, bncStr.get(i2).get(j));
                    continue;
                }
                ((ArrayList)iph.get(i2)).set(j, ((ArrayList)iph.get(i2)).get(j) + bncStr.get(i2).get(j));
            }
        }
        for (i2 = 0; i2 < patPer; ++i2) {
            for (currJug = 0; currJug < nj; ++currJug) {
                if (modPat == null) {
                    modPat = "<";
                } else if (currJug == 0) {
                    modPat = (String)modPat + "<";
                }
                if (ji[i2][1] == 0) {
                    modPat = (String)modPat + "(";
                    if (ji[i2][0] == currJug + 1) {
                        if (os.get(i2).size() > 1) {
                            modPat = (String)modPat + "[";
                            n = ((Collection)os.get(i2)).size();
                            for (j = 0; j < n; ++j) {
                                modPat = (String)modPat + os.get(i2).get(j);
                                if (((ArrayList)iph.get(i2)).get(j) == null) continue;
                                modPat = (String)modPat + ((ArrayList)iph.get(i2)).get(j);
                            }
                            modPat = (String)modPat + "]";
                        } else {
                            ArrayList<Character> arrayList = os.get(i2);
                            Intrinsics.checkNotNullExpressionValue(arrayList, "get(...)");
                            modPat = (String)modPat + CollectionsKt.first((List)arrayList);
                            Object e = iph.get(i2);
                            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                            if (CollectionsKt.first((List)e) != null) {
                                Object e2 = iph.get(i2);
                                Intrinsics.checkNotNullExpressionValue(e2, "get(...)");
                                modPat = (String)modPat + CollectionsKt.first((List)e2);
                            }
                        }
                        modPat = (String)modPat + ",0)!";
                    } else {
                        modPat = (String)modPat + "0,0)!";
                    }
                } else {
                    modPat = (String)modPat + "(0,";
                    if (ji[i2][0] == currJug + 1) {
                        if (os.get(i2).size() > 1) {
                            modPat = (String)modPat + "[";
                            n = ((Collection)os.get(i2)).size();
                            for (j = 0; j < n; ++j) {
                                modPat = (String)modPat + os.get(i2).get(j);
                                if (((ArrayList)iph.get(i2)).get(j) == null) continue;
                                modPat = (String)modPat + ((ArrayList)iph.get(i2)).get(j);
                            }
                            modPat = (String)modPat + "]";
                        } else {
                            ArrayList<Character> arrayList = os.get(i2);
                            Intrinsics.checkNotNullExpressionValue(arrayList, "get(...)");
                            modPat = (String)modPat + CollectionsKt.first((List)arrayList);
                            Object e = iph.get(i2);
                            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                            if (CollectionsKt.first((List)e) != null) {
                                Object e3 = iph.get(i2);
                                Intrinsics.checkNotNullExpressionValue(e3, "get(...)");
                                modPat = (String)modPat + CollectionsKt.first((List)e3);
                            }
                        }
                        modPat = (String)modPat + ")!";
                    } else {
                        modPat = (String)modPat + "0)!";
                    }
                }
                modPat = currJug == nj - 1 ? (String)modPat + ">" : (String)modPat + "|";
            }
        }
        return new PatParms((String)modPat, dwlBts);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B'\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR*\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ljugglinglab/notation/HSS$HssParms;", "", "pat", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "hands", "", "<init>", "(Ljava/util/ArrayList;I)V", "getPat", "()Ljava/util/ArrayList;", "setPat", "(Ljava/util/ArrayList;)V", "getHands", "()I", "setHands", "(I)V", "jugglinglab"})
    public static final class HssParms {
        @NotNull
        private ArrayList<Character> pat;
        private int hands;

        public HssParms(@NotNull ArrayList<Character> pat, int hands) {
            Intrinsics.checkNotNullParameter(pat, "pat");
            this.pat = pat;
            this.hands = hands;
        }

        @NotNull
        public final ArrayList<Character> getPat() {
            return this.pat;
        }

        public final void setPat(@NotNull ArrayList<Character> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
            this.pat = arrayList;
        }

        public final int getHands() {
            return this.hands;
        }

        public final void setHands(int n) {
            this.hands = n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ljugglinglab/notation/HSS$ModParms;", "", "convertedPattern", "", "dwellBeatsArray", "", "<init>", "(Ljava/lang/String;[D)V", "getConvertedPattern", "()Ljava/lang/String;", "setConvertedPattern", "(Ljava/lang/String;)V", "getDwellBeatsArray", "()[D", "setDwellBeatsArray", "([D)V", "jugglinglab"})
    public static final class ModParms {
        @NotNull
        private String convertedPattern;
        @NotNull
        private double[] dwellBeatsArray;

        public ModParms(@NotNull String convertedPattern, @NotNull double[] dwellBeatsArray) {
            Intrinsics.checkNotNullParameter(convertedPattern, "convertedPattern");
            Intrinsics.checkNotNullParameter(dwellBeatsArray, "dwellBeatsArray");
            this.convertedPattern = convertedPattern;
            this.dwellBeatsArray = dwellBeatsArray;
        }

        @NotNull
        public final String getConvertedPattern() {
            return this.convertedPattern;
        }

        public final void setConvertedPattern(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.convertedPattern = string;
        }

        @NotNull
        public final double[] getDwellBeatsArray() {
            return this.dwellBeatsArray;
        }

        public final void setDwellBeatsArray(@NotNull double[] dArray) {
            Intrinsics.checkNotNullParameter(dArray, "<set-?>");
            this.dwellBeatsArray = dArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u007f\u00126\u0010\u0002\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u00050\u0003j\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005`\u0005\u0012>\u0010\u0006\u001a:\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0003j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\u00050\u0003j\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0003j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\u0005`\u0005\u00a2\u0006\u0004\b\b\u0010\tRA\u0010\u0002\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u00050\u0003j\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bRI\u0010\u0006\u001a:\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0003j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\u00050\u0003j\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0003j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\u0005`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Ljugglinglab/notation/HSS$OssPatBnc;", "", "objPat", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "bnc", "", "<init>", "(Ljava/util/ArrayList;Ljava/util/ArrayList;)V", "getObjPat", "()Ljava/util/ArrayList;", "getBnc", "jugglinglab"})
    public static final class OssPatBnc {
        @NotNull
        private final ArrayList<ArrayList<Character>> objPat;
        @NotNull
        private final ArrayList<ArrayList<String>> bnc;

        public OssPatBnc(@NotNull ArrayList<ArrayList<Character>> objPat, @NotNull ArrayList<ArrayList<String>> bnc) {
            Intrinsics.checkNotNullParameter(objPat, "objPat");
            Intrinsics.checkNotNullParameter(bnc, "bnc");
            this.objPat = objPat;
            this.bnc = bnc;
        }

        @NotNull
        public final ArrayList<ArrayList<Character>> getObjPat() {
            return this.objPat;
        }

        @NotNull
        public final ArrayList<ArrayList<String>> getBnc() {
            return this.bnc;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ljugglinglab/notation/HSS$PatParms;", "", "newPat", "", "dwellBt", "", "<init>", "(Ljava/lang/String;[D)V", "getNewPat", "()Ljava/lang/String;", "setNewPat", "(Ljava/lang/String;)V", "getDwellBt", "()[D", "setDwellBt", "([D)V", "jugglinglab"})
    public static final class PatParms {
        @Nullable
        private String newPat;
        @NotNull
        private double[] dwellBt;

        public PatParms(@Nullable String newPat, @NotNull double[] dwellBt) {
            Intrinsics.checkNotNullParameter(dwellBt, "dwellBt");
            this.newPat = newPat;
            this.dwellBt = dwellBt;
        }

        @Nullable
        public final String getNewPat() {
            return this.newPat;
        }

        public final void setNewPat(@Nullable String string) {
            this.newPat = string;
        }

        @NotNull
        public final double[] getDwellBt() {
            return this.dwellBt;
        }

        public final void setDwellBt(@NotNull double[] dArray) {
            Intrinsics.checkNotNullParameter(dArray, "<set-?>");
            this.dwellBt = dArray;
        }
    }
}

