/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLPosition;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007J\u0016\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J \u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR$\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e0\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u001a"}, d2={"Ljugglinglab/notation/MHNBody;", "", "str", "", "<init>", "(Ljava/lang/String;)V", "value", "", "numberOfJugglers", "getNumberOfJugglers", "()I", "size", "", "coords", "", "[[I", "bodypath", "", "[[[[D", "getPeriod", "juggler", "getNumberOfPositions", "pos", "getPosition", "Ljugglinglab/jml/JMLPosition;", "index", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nMHNBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MHNBody.kt\njugglinglab/notation/MHNBody\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,123:1\n1563#2:124\n1634#2,3:125\n37#3:128\n36#3,3:129\n*S KotlinDebug\n*F\n+ 1 MHNBody.kt\njugglinglab/notation/MHNBody\n*L\n62#1:124\n62#1:125,3\n88#1:128\n88#1:129,3\n*E\n"})
public final class MHNBody {
    private int numberOfJugglers;
    @NotNull
    private int[] size;
    @NotNull
    private int[][] coords;
    @NotNull
    private double[][][][] bodypath;

    /*
     * WARNING - void declaration
     */
    public MHNBody(@NotNull String str) {
        int n;
        Intrinsics.checkNotNullParameter(str, "str");
        CharSequence charSequence = JLFunc.jlExpandRepeats(str);
        Object object = new Regex("[<>{}]");
        Object object2 = "";
        String cleanStr = ((Regex)object).replace(charSequence, (String)object2);
        object = cleanStr;
        object2 = new Regex("[|!]");
        int n2 = 0;
        List<String> jugglerStrings = ((Regex)object2).split((CharSequence)object, n2);
        this.numberOfJugglers = jugglerStrings.size();
        this.size = new int[this.numberOfJugglers];
        int n3 = 0;
        int n4 = this.numberOfJugglers;
        Object object3 = new int[n4][];
        Object object4 = this;
        while (n3 < n4) {
            n = n3++;
            object3[n] = new int[0];
        }
        ((MHNBody)object4).coords = object3;
        n3 = 0;
        n4 = this.numberOfJugglers;
        object3 = new double[n4][][][];
        object4 = this;
        while (n3 < n4) {
            n = n3++;
            object3[n] = (int[])new double[0][][];
        }
        ((MHNBody)object4).bodypath = (double[][][][])object3;
        Iterator iterator2 = ((Iterable)jugglerStrings).iterator();
        n4 = 0;
        while (iterator2.hasNext()) {
            int beatSize;
            int jugglerIndex = n4++;
            String jugglerStr = (String)iterator2.next();
            List<String> beatStrings = JLFunc.jlSplitOnCharOutsideParens(((Object)StringsKt.trim((CharSequence)jugglerStr)).toString(), '.');
            this.size[jugglerIndex] = beatSize = beatStrings.size();
            this.coords[jugglerIndex] = new int[beatSize];
            int n5 = 0;
            double[][][] dArrayArray = new double[beatSize][][];
            int n6 = jugglerIndex;
            object4 = this.bodypath;
            while (n5 < beatSize) {
                int n7 = n5++;
                dArrayArray[n7] = new double[0][];
            }
            object4[n6] = dArrayArray;
            Iterator iterator3 = ((Iterable)beatStrings).iterator();
            int n8 = 0;
            while (iterator3.hasNext()) {
                int beatIndex = n8++;
                String beatStr = (String)iterator3.next();
                List coordTokens = new ArrayList();
                int pos = 0;
                block12: while (pos < beatStr.length()) {
                    char ch = beatStr.charAt(pos);
                    switch (ch) {
                        case ' ': {
                            ++pos;
                            continue block12;
                        }
                        case '-': {
                            coordTokens.add(null);
                            ++pos;
                            continue block12;
                        }
                        case '(': {
                            int closeIndex = StringsKt.indexOf$default((CharSequence)beatStr, ')', pos + 1, false, 4, null);
                            if (closeIndex < 0) {
                                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_body_noparen"));
                            }
                            Intrinsics.checkNotNullExpressionValue(beatStr.substring(pos + 1, closeIndex), "substring(...)");
                            try {
                                void $this$mapTo$iv$iv;
                                String coordStr;
                                char[] cArray = new char[]{','};
                                Iterable $this$map$iv = StringsKt.split$default((CharSequence)coordStr, cArray, false, 0, 6, null);
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    String string = (String)item$iv$iv;
                                    object4 = destination$iv$iv;
                                    boolean bl = false;
                                    object4.add(JLFunc.jlParseFiniteDouble(((Object)StringsKt.trim((CharSequence)it)).toString()));
                                }
                                List parts = (List)destination$iv$iv;
                                Object object5 = new double[]{0.0, 0.0, 0.0, 100.0};
                                double[] coord = object5;
                                object5 = ((Iterable)parts).iterator();
                                int n9 = 0;
                                while (object5.hasNext()) {
                                    double partsVal;
                                    int partsIndex = n9++;
                                    coord[partsIndex] = partsVal = ((Number)object5.next()).doubleValue();
                                }
                                coordTokens.add(coord);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_body_coordinate"));
                            }
                            pos = closeIndex + 1;
                            continue block12;
                        }
                    }
                    String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_body_character");
                    Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                    String template = string;
                    Object[] objectArray = new Object[]{String.valueOf(ch)};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                }
                if (coordTokens.isEmpty()) {
                    this.coords[jugglerIndex][beatIndex] = 1;
                    double[][] ch = new double[][]{null};
                    this.bodypath[jugglerIndex][beatIndex] = ch;
                    continue;
                }
                this.coords[jugglerIndex][beatIndex] = coordTokens.size();
                Collection $this$toTypedArray$iv = coordTokens;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                this.bodypath[jugglerIndex][beatIndex] = (double[][])thisCollection$iv.toArray((T[])new double[0][]);
            }
        }
    }

    public final int getNumberOfJugglers() {
        return this.numberOfJugglers;
    }

    public final int getPeriod(int juggler) {
        int j = (juggler - 1) % this.numberOfJugglers;
        return this.size[j];
    }

    public final int getNumberOfPositions(int juggler, int pos) {
        int j = (juggler - 1) % this.numberOfJugglers;
        return this.coords[j][pos];
    }

    @Nullable
    public final JMLPosition getPosition(int juggler, int pos, int index) {
        if (pos >= this.getPeriod(juggler) || index >= this.getNumberOfPositions(juggler, pos)) {
            return null;
        }
        int j = (juggler - 1) % this.numberOfJugglers;
        if (this.bodypath[j][pos][index] == null) {
            return null;
        }
        JMLPosition result = new JMLPosition();
        result.setJuggler(juggler);
        double[] dArray = this.bodypath[j][pos][index];
        Intrinsics.checkNotNull(dArray);
        double d = dArray[1];
        double[] dArray2 = this.bodypath[j][pos][index];
        Intrinsics.checkNotNull(dArray2);
        double d2 = dArray2[2];
        double[] dArray3 = this.bodypath[j][pos][index];
        Intrinsics.checkNotNull(dArray3);
        result.setCoordinate(new Coordinate(d, d2, dArray3[3]));
        double[] dArray4 = this.bodypath[j][pos][index];
        Intrinsics.checkNotNull(dArray4);
        result.setAngle(dArray4[0]);
        return result;
    }
}

