/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jugglinglab.JugglingLab;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007J\u0016\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007J\u0016\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007J \u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR$\u0010\u0011\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000e0\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001c"}, d2={"Ljugglinglab/notation/MHNHands;", "", "str", "", "<init>", "(Ljava/lang/String;)V", "value", "", "numberOfJugglers", "getNumberOfJugglers", "()I", "size", "", "coords", "", "[[I", "catches", "handpath", "", "[[[[D", "getPeriod", "juggler", "getNumberOfCoordinates", "pos", "getCatchIndex", "getCoordinate", "Ljugglinglab/util/Coordinate;", "index", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nMHNHands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MHNHands.kt\njugglinglab/notation/MHNHands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,168:1\n1563#2:169\n1634#2,2:170\n1563#2:172\n1634#2,2:173\n1563#2:175\n1634#2,3:176\n1636#2:184\n1636#2:185\n1#3:179\n37#4:180\n36#4,3:181\n*S KotlinDebug\n*F\n+ 1 MHNHands.kt\njugglinglab/notation/MHNHands\n*L\n29#1:169\n29#1:170,2\n31#1:172\n31#1:173,2\n79#1:175\n79#1:176,3\n31#1:184\n29#1:185\n111#1:180\n111#1:181,3\n*E\n"})
public final class MHNHands {
    private int numberOfJugglers;
    @NotNull
    private int[] size;
    @NotNull
    private int[][] coords;
    @NotNull
    private int[][] catches;
    @NotNull
    private double[][][][] handpath;

    /*
     * WARNING - void declaration
     */
    public MHNHands(@NotNull String str) {
        Object object;
        int n;
        Object object2;
        int n2;
        Object object3;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(str, "str");
        CharSequence charSequence = JLFunc.jlExpandRepeats(str);
        Object object4 = new Regex("[<>{}]");
        Object object5 = "";
        String cleanStr = ((Regex)object4).replace(charSequence, (String)object5);
        object4 = cleanStr;
        object5 = new Regex("[|!]");
        int n3 = 0;
        List<String> jugglerStrings = ((Regex)object5).split((CharSequence)object4, n3);
        this.numberOfJugglers = jugglerStrings.size();
        Iterable $this$map$iv = jugglerStrings;
        boolean $i$f$map = false;
        Object object6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void jugglerStr;
            String string = (String)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            List<String> beatStrings = JLFunc.jlSplitOnCharOutsideParens(((Object)StringsKt.trim((CharSequence)jugglerStr)).toString(), '.');
            Iterable $this$map$iv2 = beatStrings;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                int finalCatchIndex;
                void beatStr;
                String string2 = (String)item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                List coordTokens = new ArrayList();
                int catchIndex = -1;
                boolean gotThrow = false;
                int pos = 0;
                block11: while (pos < beatStr.length()) {
                    Object parts;
                    char ch = beatStr.charAt(pos);
                    switch (ch) {
                        case ' ': {
                            ++pos;
                            continue block11;
                        }
                        case '-': {
                            coordTokens.add(null);
                            ++pos;
                            continue block11;
                        }
                        case 'T': 
                        case 't': {
                            if (!((Collection)coordTokens).isEmpty()) {
                                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hands_Tnotstart"));
                            }
                            if (gotThrow) {
                                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hands_toomanycoords"));
                            }
                            gotThrow = true;
                            ++pos;
                            continue block11;
                        }
                        case 'C': 
                        case 'c': {
                            if (coordTokens.isEmpty()) {
                                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hands_Catstart"));
                            }
                            if (catchIndex != -1) {
                                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hands_toomanycatches"));
                            }
                            catchIndex = coordTokens.size();
                            ++pos;
                            continue block11;
                        }
                        case '(': {
                            int closeIndex = StringsKt.indexOf$default((CharSequence)beatStr, ')', pos + 1, false, 4, null);
                            if (closeIndex < 0) {
                                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hands_noparen"));
                            }
                            Intrinsics.checkNotNullExpressionValue(beatStr.substring(pos + 1, closeIndex), "substring(...)");
                            try {
                                Object object7;
                                Object object8;
                                Double d;
                                int n4;
                                Object object9;
                                double[] coord;
                                Object object10;
                                void $this$mapTo$iv$iv3;
                                String coordStr;
                                char[] cArray = new char[]{','};
                                Iterable $this$map$iv3 = StringsKt.split$default((CharSequence)coordStr, cArray, false, 0, 6, null);
                                boolean $i$f$map3 = false;
                                Iterable iterable2 = $this$map$iv3;
                                Collection destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                                boolean $i$f$mapTo3 = false;
                                for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                                    void it;
                                    String string3 = (String)item$iv$iv3;
                                    object10 = destination$iv$iv32;
                                    boolean bl3 = false;
                                    object10.add(JLFunc.jlParseFiniteDouble(((Object)StringsKt.trim((CharSequence)it)).toString()));
                                }
                                parts = (List)destination$iv$iv32;
                                Object object11 = coord = new double[3];
                                int n5 = 0;
                                int n6 = 0;
                                Object object12 = parts;
                                if (n6 < object12.size()) {
                                    object9 = object12.get(n6);
                                } else {
                                    int destination$iv$iv32 = n6;
                                    n4 = n5;
                                    object10 = object11;
                                    boolean bl4 = false;
                                    d = 0.0;
                                    object11 = object10;
                                    n5 = n4;
                                    object9 = d;
                                }
                                object11[n5] = ((Number)object9).doubleValue();
                                Object object13 = coord;
                                int n7 = 2;
                                object12 = parts;
                                n6 = 1;
                                if (n6 < object12.size()) {
                                    object8 = object12.get(n6);
                                } else {
                                    int it = n6;
                                    n4 = n7;
                                    object10 = object13;
                                    boolean bl5 = false;
                                    d = 0.0;
                                    object13 = object10;
                                    n7 = n4;
                                    object8 = d;
                                }
                                object13[n7] = ((Number)object8).doubleValue();
                                Object object14 = coord;
                                int n8 = 1;
                                object12 = parts;
                                n6 = 2;
                                if (n6 < object12.size()) {
                                    object7 = object12.get(n6);
                                } else {
                                    int it = n6;
                                    n4 = n8;
                                    object10 = object14;
                                    boolean bl6 = false;
                                    d = 0.0;
                                    object14 = object10;
                                    n8 = n4;
                                    object7 = d;
                                }
                                object14[n8] = ((Number)object7).doubleValue();
                                coordTokens.add(coord);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hands_coordinate"));
                            }
                            pos = closeIndex + 1;
                            continue block11;
                        }
                    }
                    String string4 = JugglingLab.INSTANCE.getErrorstrings().getString("Error_hands_character");
                    Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
                    String template = string4;
                    parts = new Object[]{String.valueOf(ch)};
                    Object[] arguments = parts;
                    throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                }
                if (coordTokens.size() < 2) {
                    throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hands_toofewcoords"));
                }
                if (coordTokens.get(0) == null) {
                    throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hands_nothrow"));
                }
                int n9 = finalCatchIndex = catchIndex != -1 ? catchIndex : coordTokens.size() - 1;
                if (coordTokens.get(finalCatchIndex) == null) {
                    throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_hands_nocatch"));
                }
                Collection $this$toTypedArray$iv = coordTokens;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                collection.add(new Triple<Integer, Integer, T[]>(coordTokens.size(), finalCatchIndex, thisCollection$iv.toArray((T[])new double[0][])));
            }
            object3.add((List)destination$iv$iv2);
        }
        List jugglerData = (List)destination$iv$iv;
        int n10 = 0;
        n3 = this.numberOfJugglers;
        object6 = new int[n3];
        object3 = this;
        while (n10 < n3) {
            int n11 = n10++;
            object6[n11] = ((List)jugglerData.get(n11)).size();
        }
        ((MHNHands)object3).size = (int[])object6;
        n3 = this.numberOfJugglers;
        object6 = new int[n3][];
        object3 = this;
        for (n10 = 0; n10 < n3; ++n10) {
            int n12 = n10;
            n2 = 0;
            int n13 = ((List)jugglerData.get(n12)).size();
            object2 = new int[n13];
            n = n12;
            object = object6;
            while (n2 < n13) {
                int n14 = n2++;
                object2[n14] = ((Number)((Triple)((List)jugglerData.get(n12)).get(n14)).getFirst()).intValue();
            }
            object[n] = object2;
        }
        ((MHNHands)object3).coords = (int[][])object6;
        n3 = this.numberOfJugglers;
        object6 = new int[n3][];
        object3 = this;
        for (n10 = 0; n10 < n3; ++n10) {
            int n15 = n10;
            n2 = 0;
            int n16 = ((List)jugglerData.get(n15)).size();
            object2 = new int[n16];
            n = n15;
            object = object6;
            while (n2 < n16) {
                int n17 = n2++;
                object2[n17] = ((Number)((Triple)((List)jugglerData.get(n15)).get(n17)).getSecond()).intValue();
            }
            object[n] = object2;
        }
        ((MHNHands)object3).catches = (int[][])object6;
        n3 = this.numberOfJugglers;
        object6 = new double[n3][][][];
        object3 = this;
        for (n10 = 0; n10 < n3; ++n10) {
            int n18 = n10;
            n2 = 0;
            int n19 = ((List)jugglerData.get(n18)).size();
            object2 = new double[n19][][];
            n = n18;
            object = object6;
            while (n2 < n19) {
                int n20 = n2++;
                object2[n20] = (int)((Triple)((List)jugglerData.get(n18)).get(n20)).getThird();
            }
            object[n] = object2;
        }
        ((MHNHands)object3).handpath = (double[][][][])object6;
    }

    public final int getNumberOfJugglers() {
        return this.numberOfJugglers;
    }

    public final int getPeriod(int juggler) {
        int j = (juggler - 1) % this.numberOfJugglers;
        return this.size[j];
    }

    public final int getNumberOfCoordinates(int juggler, int pos) {
        int j = (juggler - 1) % this.numberOfJugglers;
        return this.coords[j][pos];
    }

    public final int getCatchIndex(int juggler, int pos) {
        int j = (juggler - 1) % this.numberOfJugglers;
        return this.catches[j][pos];
    }

    @Nullable
    public final Coordinate getCoordinate(int juggler, int pos, int index) {
        if (pos >= this.getPeriod(juggler) || index >= this.getNumberOfCoordinates(juggler, pos)) {
            return null;
        }
        int j = (juggler - 1) % this.numberOfJugglers;
        if (this.handpath[j][pos][index] == null) {
            return null;
        }
        double[] dArray = this.handpath[j][pos][index];
        Intrinsics.checkNotNull(dArray);
        double d = dArray[0];
        double[] dArray2 = this.handpath[j][pos][index];
        Intrinsics.checkNotNull(dArray2);
        double d2 = dArray2[1];
        double[] dArray3 = this.handpath[j][pos][index];
        Intrinsics.checkNotNull(dArray3);
        return new Coordinate(d, d2, dArray3[2]);
    }
}

