/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import jugglinglab.JugglingLab;
import jugglinglab.notation.HSS;
import jugglinglab.notation.MHNBody;
import jugglinglab.notation.MHNHands;
import jugglinglab.notation.MHNPattern;
import jugglinglab.notation.MHNSymmetry;
import jugglinglab.notation.MHNThrow;
import jugglinglab.notation.ssparser.ParseException;
import jugglinglab.notation.ssparser.SiteswapParser;
import jugglinglab.notation.ssparser.SiteswapTreeItem;
import jugglinglab.notation.ssparser.TokenMgrError;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import jugglinglab.util.Permutation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0016H\u0002J\b\u0010!\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Ljugglinglab/notation/SiteswapPattern;", "Ljugglinglab/notation/MHNPattern;", "<init>", "()V", "oddperiod", "", "value", "hasHandsSpecifier", "getHasHandsSpecifier", "()Z", "rightOnEven", "", "notationName", "", "getNotationName", "()Ljava/lang/String;", "fromString", "config", "fromParameters", "pl", "Ljugglinglab/util/ParameterList;", "norepPeriod", "", "getNorepPeriod", "()I", "parseSiteswapNotation", "", "doFirstPass", "sti", "Ljugglinglab/notation/ssparser/SiteswapTreeItem;", "doSecondPass", "switchhands", "beatoffset", "resolveModifiers", "jugglinglab"})
public final class SiteswapPattern
extends MHNPattern {
    private boolean oddperiod;
    private boolean hasHandsSpecifier;
    private boolean[] rightOnEven;
    @NotNull
    private final String notationName;

    public SiteswapPattern() {
        this.notationName = "Siteswap";
    }

    public final boolean getHasHandsSpecifier() {
        return this.hasHandsSpecifier;
    }

    @Override
    @NotNull
    public String getNotationName() {
        return this.notationName;
    }

    @Override
    @NotNull
    public SiteswapPattern fromString(@NotNull String config) throws JuggleExceptionUser, JuggleExceptionInternal {
        Intrinsics.checkNotNullParameter(config, "config");
        Object conf = config;
        if (StringsKt.indexOf$default((CharSequence)conf, '=', 0, false, 6, null) == -1) {
            conf = "pattern=" + (String)conf;
        }
        ParameterList pl = new ParameterList((String)conf);
        this.fromParameters(pl);
        pl.errorIfParametersLeft();
        return this;
    }

    @Override
    @NotNull
    public SiteswapPattern fromParameters(@NotNull ParameterList pl) throws JuggleExceptionUser, JuggleExceptionInternal {
        Intrinsics.checkNotNullParameter(pl, "pl");
        super.fromParameters(pl);
        if (this.getHss() != null) {
            String string = this.getPattern();
            Intrinsics.checkNotNull(string);
            String string2 = this.getHss();
            Intrinsics.checkNotNull(string2);
            HSS.ModParms modinfo = HSS.INSTANCE.processHSS(string, string2, this.getHold(), this.getDwellmax(), this.getHandspec(), this.getDwell());
            this.setPattern(modinfo.getConvertedPattern());
            this.setDwellarray(modinfo.getDwellBeatsArray());
        }
        this.parseSiteswapNotation();
        if (this.getHands() != null || this.getBodies() != null) {
            int n;
            int i2;
            int n2;
            int i3;
            int patperiod = this.getNorepPeriod();
            int handperiod = 1;
            if (this.getHands() != null && (i3 = 1) <= (n2 = this.getNumberOfJugglers())) {
                while (true) {
                    MHNHands mHNHands = this.getHands();
                    Intrinsics.checkNotNull(mHNHands);
                    handperiod = Permutation.Companion.lcm(handperiod, mHNHands.getPeriod(i3));
                    if (i3 == n2) break;
                    ++i3;
                }
            }
            int bodyperiod = 1;
            if (this.getBodies() != null && (i2 = 1) <= (n = this.getNumberOfJugglers())) {
                while (true) {
                    MHNBody mHNBody = this.getBodies();
                    Intrinsics.checkNotNull(mHNBody);
                    bodyperiod = Permutation.Companion.lcm(bodyperiod, mHNBody.getPeriod(i2));
                    if (i2 == n) break;
                    ++i2;
                }
            }
            int totalperiod = patperiod;
            totalperiod = Permutation.Companion.lcm(totalperiod, handperiod);
            if ((totalperiod = Permutation.Companion.lcm(totalperiod, bodyperiod)) != patperiod) {
                int repeats = totalperiod / patperiod;
                this.setPattern("(" + this.getPattern() + "^" + repeats + ")");
                this.parseSiteswapNotation();
            }
        }
        super.buildJugglingMatrix();
        return this;
    }

    private final int getNorepPeriod() {
        return this.oddperiod ? this.getPeriod() / 2 : this.getPeriod();
    }

    private final void parseSiteswapNotation() throws JuggleExceptionUser, JuggleExceptionInternal {
        int n;
        this.setSymmetries(new ArrayList<MHNSymmetry>());
        SiteswapTreeItem tree = null;
        try {
            tree = SiteswapParser.parsePattern(this.getPattern());
        }
        catch (ParseException pe) {
            if (pe.currentToken == null) {
                String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_pattern_parsing");
                Object[] objectArray = new Object[]{pe.getMessage()};
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
            }
            String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_pattern_syntax");
            String problem = pe.currentToken.next.image;
            Object[] objectArray = new Object[]{problem, pe.currentToken.next.beginColumn};
            Object[] arguments = objectArray;
            throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
        }
        catch (TokenMgrError tme) {
            String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_pattern_syntax");
            String problem = String.valueOf((char)tme.curChar);
            Object[] objectArray = new Object[]{problem, tme.errorColumn};
            Object[] arguments = objectArray;
            throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
        }
        this.setNumberOfJugglers(tree.jugglers);
        this.setMaxOccupancy(0);
        this.setMaxThrow(0);
        int tme = 0;
        int template = this.getNumberOfJugglers();
        Object object = new boolean[template];
        SiteswapPattern siteswapPattern = this;
        while (tme < template) {
            n = tme++;
            object[n] = true;
        }
        siteswapPattern.rightOnEven = object;
        tree.beatnum = 0;
        Intrinsics.checkNotNull(tree);
        this.doFirstPass(tree);
        if (!tree.switchrepeat && tree.vanilla_async && tree.beats % 2 == 1) {
            tree.switchrepeat = true;
            tree.beats *= 2;
            tree.throw_sum *= 2;
            this.oddperiod = true;
        }
        this.setPeriod(tree.beats);
        if (tree.throw_sum % tree.beats != 0) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_siteswap_bad_average"));
        }
        this.setNumberOfPaths(tree.throw_sum / tree.beats);
        this.setIndexes(this.getMaxThrow() + this.getPeriod() + 1);
        template = this.getNumberOfJugglers();
        object = new MHNThrow[template][][][];
        siteswapPattern = this;
        for (tme = 0; tme < template; ++tme) {
            n = tme;
            MHNThrow[][][] mHNThrowArrayArray = new MHNThrow[2][][];
            int n2 = n;
            Object object2 = object;
            for (int j = 0; j < 2; ++j) {
                int n3 = j;
                int n4 = 0;
                int n5 = this.getIndexes();
                MHNThrow[][] mHNThrowArrayArray2 = new MHNThrow[n5][];
                int n6 = n3;
                MHNThrow[][][] mHNThrowArrayArray3 = mHNThrowArrayArray;
                while (n4 < n5) {
                    int n7 = n4++;
                    mHNThrowArrayArray2[n7] = new MHNThrow[this.getMaxOccupancy()];
                }
                mHNThrowArrayArray3[n6] = mHNThrowArrayArray2;
            }
            object2[n2] = mHNThrowArrayArray;
        }
        siteswapPattern.setTh((MHNThrow[][][][])object);
        this.doSecondPass(tree, false, 0);
        this.resolveModifiers();
        this.addSymmetry(new MHNSymmetry(1, this.getNumberOfJugglers(), null, this.getPeriod()));
        if (tree.switchrepeat) {
            StringBuilder sb = new StringBuilder();
            int i2 = 1;
            int n8 = this.getNumberOfJugglers();
            if (i2 <= n8) {
                while (true) {
                    sb.append("(").append(i2).append(",").append(i2).append("*)");
                    if (i2 == n8) break;
                    ++i2;
                }
            }
            this.addSymmetry(new MHNSymmetry(3, this.getNumberOfJugglers(), sb.toString(), this.getPeriod() / 2));
        }
        if (this.getBodies() != null) {
            MHNBody mHNBody = this.getBodies();
            Intrinsics.checkNotNull(mHNBody);
            if (mHNBody.getNumberOfJugglers() < this.getNumberOfJugglers()) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_jugglers_body"));
            }
        }
    }

    private final void doFirstPass(SiteswapTreeItem sti) throws JuggleExceptionInternal {
        SiteswapTreeItem child = null;
        sti.throw_sum = 0;
        sti.vanilla_async = true;
        switch (sti.type) {
            case 1: {
                sti.beats = 0;
                for (int i2 = 0; i2 < sti.getNumberOfChildren(); ++i2) {
                    Intrinsics.checkNotNullExpressionValue(sti.getChild(i2), "getChild(...)");
                    child.beatnum = sti.beatnum + sti.beats;
                    this.doFirstPass(child);
                    sti.beats += child.beats;
                    sti.throw_sum += child.throw_sum;
                    sti.vanilla_async &= child.vanilla_async;
                }
                if (!sti.switchrepeat) break;
                sti.beats *= 2;
                sti.throw_sum *= 2;
                break;
            }
            case 2: {
                SiteswapTreeItem siteswapTreeItem = sti.getChild(0);
                Intrinsics.checkNotNullExpressionValue(siteswapTreeItem, "getChild(...)");
                child = siteswapTreeItem;
                if (sti.getNumberOfChildren() > 1) {
                    sti.removeChildren();
                    sti.addChild(child);
                }
                child.beatnum = sti.beatnum;
                this.doFirstPass(child);
                for (int i3 = 1; i3 < sti.repeats; ++i3) {
                    Object object = child.clone();
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type jugglinglab.notation.ssparser.SiteswapTreeItem");
                    SiteswapTreeItem child2 = (SiteswapTreeItem)object;
                    sti.addChild(child2);
                    child2.beatnum = sti.beatnum + i3 * child.beats;
                    this.doFirstPass(child2);
                }
                sti.beats = child.beats * sti.repeats;
                sti.throw_sum = child.throw_sum * sti.repeats;
                sti.vanilla_async &= child.vanilla_async;
                break;
            }
            case 3: {
                for (int i4 = 0; i4 < sti.getNumberOfChildren(); ++i4) {
                    Intrinsics.checkNotNullExpressionValue(sti.getChild(i4), "getChild(...)");
                    child.beatnum = sti.beatnum + child.seq_beatnum;
                    this.doFirstPass(child);
                    sti.throw_sum += child.throw_sum;
                    sti.vanilla_async &= child.vanilla_async;
                }
                break;
            }
            case 4: {
                for (int i5 = 0; i5 < sti.getNumberOfChildren(); ++i5) {
                    Intrinsics.checkNotNullExpressionValue(sti.getChild(i5), "getChild(...)");
                    child.beatnum = sti.beatnum;
                    this.doFirstPass(child);
                    child.left = i5 == 0;
                    child.sync_throw = true;
                    sti.throw_sum += child.throw_sum;
                }
                sti.vanilla_async = false;
                break;
            }
            case 5: {
                for (int i6 = 0; i6 < sti.getNumberOfChildren(); ++i6) {
                    Intrinsics.checkNotNullExpressionValue(sti.getChild(i6), "getChild(...)");
                    child.beatnum = sti.beatnum;
                    this.doFirstPass(child);
                    sti.throw_sum += child.value;
                    sti.vanilla_async &= child.vanilla_async;
                }
                if (sti.beatnum % 2 == 0) {
                    boolean[] blArray = this.rightOnEven;
                    if (this.rightOnEven == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("rightOnEven");
                        blArray = null;
                    }
                    sti.left = !blArray[sti.source_juggler - 1];
                } else {
                    boolean[] blArray = this.rightOnEven;
                    if (this.rightOnEven == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("rightOnEven");
                        blArray = null;
                    }
                    sti.left = blArray[sti.source_juggler - 1];
                }
                if (sti.getNumberOfChildren() <= this.getMaxOccupancy()) break;
                this.setMaxOccupancy(sti.getNumberOfChildren());
                break;
            }
            case 6: {
                if (sti.value > this.getMaxThrow()) {
                    this.setMaxThrow(sti.value);
                }
                sti.vanilla_async = !sti.x;
                break;
            }
            case 7: 
            case 8: {
                for (int i7 = 0; i7 < sti.getNumberOfChildren(); ++i7) {
                    Intrinsics.checkNotNullExpressionValue(sti.getChild(i7), "getChild(...)");
                    child.beatnum = sti.beatnum;
                    this.doFirstPass(child);
                    sti.throw_sum += child.throw_sum;
                    sti.vanilla_async &= child.vanilla_async;
                }
                break;
            }
            case 9: {
                for (int i8 = 0; i8 < sti.getNumberOfChildren(); ++i8) {
                    Intrinsics.checkNotNullExpressionValue(sti.getChild(i8), "getChild(...)");
                    child.beatnum = sti.beatnum + child.seq_beatnum;
                    this.doFirstPass(child);
                    sti.throw_sum += child.throw_sum;
                    sti.vanilla_async &= child.vanilla_async;
                }
                break;
            }
            case 10: {
                for (int i9 = 0; i9 < sti.getNumberOfChildren(); ++i9) {
                    Intrinsics.checkNotNullExpressionValue(sti.getChild(i9), "getChild(...)");
                    child.beatnum = sti.beatnum;
                    this.doFirstPass(child);
                    child.left = i9 == 0;
                    child.sync_throw = true;
                    sti.throw_sum += child.throw_sum;
                }
                sti.vanilla_async = false;
                break;
            }
            case 11: {
                for (int i10 = 0; i10 < sti.getNumberOfChildren(); ++i10) {
                    Intrinsics.checkNotNullExpressionValue(sti.getChild(i10), "getChild(...)");
                    child.beatnum = sti.beatnum;
                    this.doFirstPass(child);
                    sti.throw_sum += child.value;
                    sti.vanilla_async &= child.vanilla_async;
                }
                if (sti.beatnum % 2 == 0) {
                    boolean[] blArray = this.rightOnEven;
                    if (this.rightOnEven == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("rightOnEven");
                        blArray = null;
                    }
                    sti.left = !blArray[sti.source_juggler - 1];
                } else {
                    boolean[] blArray = this.rightOnEven;
                    if (this.rightOnEven == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("rightOnEven");
                        blArray = null;
                    }
                    sti.left = blArray[sti.source_juggler - 1];
                }
                if (sti.getNumberOfChildren() <= this.getMaxOccupancy()) break;
                this.setMaxOccupancy(sti.getNumberOfChildren());
                break;
            }
            case 12: {
                if (sti.value > this.getMaxThrow()) {
                    this.setMaxThrow(sti.value);
                }
                sti.vanilla_async = !sti.x;
                break;
            }
            case 13: {
                if (sti.transition != null) {
                    sti.transition.beatnum = sti.beatnum;
                    SiteswapTreeItem siteswapTreeItem = sti.transition;
                    Intrinsics.checkNotNullExpressionValue(siteswapTreeItem, "transition");
                    this.doFirstPass(siteswapTreeItem);
                    sti.throw_sum = sti.transition.throw_sum;
                    sti.vanilla_async = sti.transition.vanilla_async;
                    sti.beats = sti.transition.beats;
                    break;
                }
                throw new JuggleExceptionInternal("Wildcard not resolved");
            }
            case 14: {
                if (sti.beatnum % 2 == 0) {
                    boolean[] blArray = this.rightOnEven;
                    if (this.rightOnEven == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("rightOnEven");
                        blArray = null;
                    }
                    blArray[sti.source_juggler - 1] = !sti.spec_left;
                } else {
                    boolean[] blArray = this.rightOnEven;
                    if (this.rightOnEven == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("rightOnEven");
                        blArray = null;
                    }
                    blArray[sti.source_juggler - 1] = sti.spec_left;
                }
                sti.throw_sum = 0;
                if (sti.beatnum > 0) {
                    sti.vanilla_async = false;
                }
                this.hasHandsSpecifier = true;
            }
        }
    }

    private final void doSecondPass(SiteswapTreeItem sti, boolean switchhands, int beatoffset) {
        SiteswapTreeItem child = null;
        switch (sti.type) {
            case 1: {
                for (int i2 = 0; i2 < sti.getNumberOfChildren(); ++i2) {
                    Intrinsics.checkNotNullExpressionValue(sti.getChild(i2), "getChild(...)");
                    this.doSecondPass(child, switchhands, beatoffset);
                }
                if (!sti.switchrepeat) break;
                for (int i3 = 0; i3 < sti.getNumberOfChildren(); ++i3) {
                    Intrinsics.checkNotNullExpressionValue(sti.getChild(i3), "getChild(...)");
                    this.doSecondPass(child, !switchhands, beatoffset + sti.beats / 2);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                for (int i4 = 0; i4 < sti.getNumberOfChildren(); ++i4) {
                    Intrinsics.checkNotNullExpressionValue(sti.getChild(i4), "getChild(...)");
                    this.doSecondPass(child, switchhands, beatoffset);
                }
                break;
            }
            case 5: 
            case 11: {
                for (int index = sti.beatnum + beatoffset; index < this.getIndexes(); index += this.getPeriod()) {
                    for (int i5 = 0; i5 < sti.getNumberOfChildren(); ++i5) {
                        int destJuggler;
                        String mod;
                        int destHand;
                        Intrinsics.checkNotNullExpressionValue(sti.getChild(i5), "getChild(...)");
                        int sourceHand = switchhands ? (sti.left ? 0 : 1) : (sti.left ? 1 : 0);
                        int n = destHand = child.value % 2 == 0 ? sourceHand : 1 - sourceHand;
                        if (child.x) {
                            destHand = 1 - destHand;
                        }
                        if ((mod = child.mod) == null) {
                            mod = "T";
                            if (child.source_juggler == child.dest_juggler && sourceHand == destHand) {
                                if (child.value <= 1) {
                                    mod = "H";
                                } else if (child.value == 2) {
                                    mod = "?";
                                }
                            }
                        }
                        if ((destJuggler = child.dest_juggler) > this.getNumberOfJugglers()) {
                            destJuggler = 1 + (destJuggler - 1) % this.getNumberOfJugglers();
                        }
                        MHNThrow t2 = new MHNThrow(child.source_juggler, sourceHand, index, i5, destJuggler, destHand, index + child.value, -1, mod);
                        if (this.getHands() != null) {
                            int idx = index;
                            if (sti.sync_throw && sourceHand == 0) {
                                ++idx;
                            }
                            MHNHands mHNHands = this.getHands();
                            Intrinsics.checkNotNull(mHNHands);
                            t2.setHandsindex(idx %= mHNHands.getPeriod(child.source_juggler));
                        }
                        this.getTh()[child.source_juggler - 1][sourceHand][index][i5] = t2;
                    }
                }
                break;
            }
        }
    }

    private final void resolveModifiers() {
        int n = this.getIndexes();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = this.getNumberOfJugglers();
            for (int j = 0; j < n2; ++j) {
                for (int h = 0; h < 2; ++h) {
                    int n3 = this.getMaxOccupancy();
                    for (int slot = 0; slot < n3; ++slot) {
                        MHNThrow mhnt;
                        if (this.getTh()[j][h][i2][slot] == null || !Intrinsics.areEqual(mhnt.getMod(), "?")) continue;
                        boolean doHold = true;
                        if (i2 + 1 < this.getIndexes()) {
                            int n4 = this.getMaxOccupancy();
                            for (int slot2 = 0; slot2 < n4; ++slot2) {
                                MHNThrow mhnt2 = this.getTh()[j][h][i2 + 1][slot2];
                                if (mhnt2 == null || mhnt2.getTargetindex() == i2 + 1) continue;
                                doHold = false;
                                break;
                            }
                        }
                        mhnt.setMod(doHold ? "H" : "T");
                    }
                }
            }
        }
    }
}

