/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.optimizer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PathLink;
import jugglinglab.optimizer.LinearEquation;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\bJ\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010,\u001a\u00020+R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\n\"\u0004\b\"\u0010\fR \u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0011\"\u0004\b&\u0010\u0013\u00a8\u0006."}, d2={"Ljugglinglab/optimizer/MarginEquations;", "", "<init>", "()V", "pat", "Ljugglinglab/jml/JMLPattern;", "(Ljugglinglab/jml/JMLPattern;)V", "varsNum", "", "getVarsNum", "()I", "setVarsNum", "(I)V", "varsEvents", "", "Ljugglinglab/jml/JMLEvent;", "getVarsEvents", "()Ljava/util/List;", "setVarsEvents", "(Ljava/util/List;)V", "varsValues", "", "getVarsValues", "()[D", "setVarsValues", "([D)V", "varsMin", "getVarsMin", "setVarsMin", "varsMax", "getVarsMax", "setVarsMax", "marginsNum", "getMarginsNum", "setMarginsNum", "marginsEqs", "Ljugglinglab/optimizer/LinearEquation;", "getMarginsEqs", "setMarginsEqs", "getMargin", "", "eqn", "findeqs", "", "sort", "Companion", "jugglinglab"})
public final class MarginEquations {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int varsNum;
    public List<JMLEvent> varsEvents;
    public double[] varsValues;
    public double[] varsMin;
    public double[] varsMax;
    private int marginsNum;
    public List<LinearEquation> marginsEqs;
    public static final double EPSILON = 1.0E-6;

    public MarginEquations() {
    }

    public final int getVarsNum() {
        return this.varsNum;
    }

    public final void setVarsNum(int n) {
        this.varsNum = n;
    }

    @NotNull
    public final List<JMLEvent> getVarsEvents() {
        List<JMLEvent> list = this.varsEvents;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("varsEvents");
        return null;
    }

    public final void setVarsEvents(@NotNull List<JMLEvent> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.varsEvents = list;
    }

    @NotNull
    public final double[] getVarsValues() {
        if (this.varsValues != null) {
            return this.varsValues;
        }
        Intrinsics.throwUninitializedPropertyAccessException("varsValues");
        return null;
    }

    public final void setVarsValues(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter(dArray, "<set-?>");
        this.varsValues = dArray;
    }

    @NotNull
    public final double[] getVarsMin() {
        if (this.varsMin != null) {
            return this.varsMin;
        }
        Intrinsics.throwUninitializedPropertyAccessException("varsMin");
        return null;
    }

    public final void setVarsMin(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter(dArray, "<set-?>");
        this.varsMin = dArray;
    }

    @NotNull
    public final double[] getVarsMax() {
        if (this.varsMax != null) {
            return this.varsMax;
        }
        Intrinsics.throwUninitializedPropertyAccessException("varsMax");
        return null;
    }

    public final void setVarsMax(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter(dArray, "<set-?>");
        this.varsMax = dArray;
    }

    public final int getMarginsNum() {
        return this.marginsNum;
    }

    public final void setMarginsNum(int n) {
        this.marginsNum = n;
    }

    @NotNull
    public final List<LinearEquation> getMarginsEqs() {
        List<LinearEquation> list = this.marginsEqs;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("marginsEqs");
        return null;
    }

    public final void setMarginsEqs(@NotNull List<LinearEquation> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.marginsEqs = list;
    }

    public MarginEquations(@NotNull JMLPattern pat) {
        Intrinsics.checkNotNullParameter(pat, "pat");
        this();
        this.findeqs(pat);
    }

    public final double getMargin(int eqn) {
        double m = 0.0;
        int n = this.varsNum;
        for (int i2 = 0; i2 < n; ++i2) {
            m += this.getMarginsEqs().get(eqn).coef(i2) * this.getVarsValues()[i2];
        }
        return Math.abs(m) + this.getMarginsEqs().get(eqn).constant();
    }

    private final void findeqs(JMLPattern pat) throws JuggleExceptionInternal, JuggleExceptionUser {
        Iterator<JMLSymmetry> pl;
        Object pl2;
        JMLEvent ev;
        if (pat.getNumberOfJugglers() > 1) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_optimizer_no_passing"));
        }
        if (pat.isBouncePattern()) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_optimizer_no_bouncing"));
        }
        pat.layoutPattern();
        JMLEvent events = pat.getEventList();
        ArrayList<ArrayList<PathLink>> pathlinks = pat.getPathLinks();
        ArrayList<JMLEvent> variableEvents = new ArrayList<JMLEvent>();
        double maxValue = 0.0;
        double g = 980.0;
        block10: for (ev = events; ev != null; ev = ev.getNext()) {
            Iterator<JMLTransition> iterator2;
            if (!ev.isMaster()) continue;
            Intrinsics.checkNotNullExpressionValue(ev.getTransitions().iterator(), "iterator(...)");
            block11: while (iterator2.hasNext()) {
                JMLTransition tr;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                int type = tr.getTransType();
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        String gparam;
                        ++this.varsNum;
                        variableEvents.add(ev);
                        Coordinate coord = ev.getLocalCoordinate();
                        if (Math.abs(coord.getX()) > maxValue) {
                            maxValue = Math.abs(coord.getX());
                        }
                        if (type != 1 || (gparam = ((ParameterList)(pl2 = new ParameterList(tr.getMod()))).getParameter("g")) == null) continue block10;
                        try {
                            g = JLFunc.jlParseFiniteDouble(gparam);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block10;
                    }
                    default: {
                        continue block11;
                    }
                }
            }
        }
        this.setVarsEvents(new ArrayList(this.varsNum));
        this.setVarsValues(new double[this.varsNum]);
        this.setVarsMin(new double[this.varsNum]);
        this.setVarsMax(new double[this.varsNum]);
        int n = this.varsNum;
        for (int i2 = 0; i2 < n; ++i2) {
            int gparam;
            ev = (JMLEvent)variableEvents.get(i2);
            Coordinate coord = ev.getLocalCoordinate();
            int type = ev.getTransition(0).getTransType();
            this.getVarsEvents().add(ev);
            this.getVarsValues()[i2] = coord.getX();
            if (this.getVarsValues()[i2] > 0.0) {
                this.getVarsMin()[i2] = 0.1 * maxValue;
                this.getVarsMax()[i2] = maxValue;
                if (type != 1) continue;
                pl2 = this.getVarsMax();
                gparam = i2;
                pl2[gparam] = pl2[gparam] * 0.9;
                continue;
            }
            this.getVarsMin()[i2] = -maxValue;
            this.getVarsMax()[i2] = -0.1 * maxValue;
            if (type != 1) continue;
            pl2 = this.getVarsMin();
            gparam = i2;
            pl2[gparam] = pl2[gparam] * 0.9;
        }
        double propradius = 0.0;
        int type = pat.getNumberOfProps();
        for (int i3 = 0; i3 < type; ++i3) {
            Prop prop = pat.getProp(i3 + 1);
            Intrinsics.checkNotNull(prop);
            double thisprop = 0.5 * prop.getWidth();
            if (!(thisprop > propradius)) continue;
            propradius = thisprop;
        }
        int masterplNum = 0;
        List masterpl = new ArrayList();
        Iterator<ArrayList<PathLink>> iterator3 = pathlinks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
        Iterator<ArrayList<PathLink>> thisprop = iterator3;
        while (thisprop.hasNext()) {
            Iterator<PathLink> iterator4;
            ArrayList<PathLink> pathlink;
            Intrinsics.checkNotNullExpressionValue(thisprop.next(), "next(...)");
            Intrinsics.checkNotNullExpressionValue(pathlink.iterator(), "iterator(...)");
            while (iterator4.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
                if (((PathLink)((Object)pl)).isInHand() || !((PathLink)((Object)pl)).getStartEvent().isMaster()) continue;
                ++masterplNum;
                masterpl.add(pl);
            }
        }
        double symDelay = -1.0;
        boolean symSwitchdelay = false;
        Iterator<JMLSymmetry> iterator5 = pat.getSymmetries().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator5, "iterator(...)");
        pl = iterator5;
        block16: while (pl.hasNext()) {
            JMLSymmetry sym;
            Intrinsics.checkNotNullExpressionValue(pl.next(), "next(...)");
            switch (sym.getType()) {
                case 1: {
                    symDelay = sym.getDelay();
                    continue block16;
                }
                case 3: {
                    symSwitchdelay = true;
                    continue block16;
                }
                case 2: {
                    throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_no_optimize_switch"));
                }
            }
        }
        ArrayList<double[]> eqns = new ArrayList<double[]>();
        int n2 = masterplNum;
        for (int i4 = 0; i4 < n2; ++i4) {
            int n3 = masterplNum;
            for (int j = 0; j < n3; ++j) {
                PathLink mpl1 = (PathLink)masterpl.get(i4);
                PathLink mpl2 = (PathLink)masterpl.get(j);
                double mpl1Start = mpl1.getStartEvent().getT();
                double mpl1End = mpl1.getEndEvent().getT();
                double mpl2Start = mpl2.getStartEvent().getT();
                double mpl2End = mpl2.getEndEvent().getT();
                double delay = 0.0;
                boolean invertMpl2 = false;
                do {
                    boolean canCollide = true;
                    if (delay == 0.0 && mpl1.getStartEvent() == mpl2.getStartEvent()) {
                        canCollide = false;
                    }
                    if (mpl1Start > mpl2Start + delay) {
                        canCollide = false;
                    } else if (mpl1Start == mpl2Start + delay) {
                        if (mpl1End > mpl2End + delay) {
                            canCollide = false;
                        } else if (mpl1End == mpl2End + delay) {
                            if (mpl1.getStartEvent().getJuggler() > mpl2.getStartEvent().getJuggler()) {
                                canCollide = false;
                            } else if (mpl1.getStartEvent().getJuggler() == mpl2.getStartEvent().getJuggler() && mpl1.getStartEvent().getHand() == 1) {
                                canCollide = false;
                            }
                        }
                    }
                    double tsame = -1.0;
                    double tsameDenom = mpl2Start + mpl2End + (double)2 * delay - (mpl1Start + mpl1End);
                    if (tsameDenom == 0.0) {
                        canCollide = false;
                    }
                    if (canCollide) {
                        tsame = ((mpl2Start + delay) * (mpl2End + delay) - mpl1Start * mpl1End) / tsameDenom;
                        if (!(mpl1Start <= tsame ? tsame <= mpl1End : false) || tsame < mpl2Start + delay || tsame > mpl2End + delay) {
                            canCollide = false;
                        }
                    }
                    if (canCollide) {
                        double[] coefs = new double[this.varsNum + 1];
                        double tC1 = mpl1End;
                        double tT1 = mpl1Start;
                        double vY1 = 0.5 * g * (tC1 - tT1);
                        double tC2 = mpl2End + delay;
                        double tT2 = mpl2Start + delay;
                        double vY2 = 0.5 * g * (tC2 - tT2);
                        double denom = vY1 * (tsame - tT1) + vY2 * (tsame - tT2);
                        if (denom > 1.0E-6) {
                            int k;
                            double coefT1 = (tC1 - tsame) / ((tC1 - tT1) * (denom *= Math.PI / 180));
                            double coefC1 = (tsame - tT1) / ((tC1 - tT1) * denom);
                            double coefT2 = -(tC2 - tsame) / ((tC2 - tT2) * denom);
                            double coefC2 = -(tsame - tT2) / ((tC2 - tT2) * denom);
                            double coef0 = (double)-2 * propradius / denom;
                            int t1Varnum = 0;
                            int c1Varnum = 0;
                            int t2Varnum = 0;
                            int c2Varnum = 0;
                            JMLEvent mplev = mpl1.getStartEvent();
                            if (!mplev.isMaster()) {
                                if (mplev.getHand() != mplev.getMaster().getHand()) {
                                    coefT1 = -coefT1;
                                }
                                mplev = mplev.getMaster();
                            }
                            t1Varnum = variableEvents.indexOf(mplev);
                            mplev = mpl1.getEndEvent();
                            if (!mplev.isMaster()) {
                                if (mplev.getHand() != mplev.getMaster().getHand()) {
                                    coefC1 = -coefC1;
                                }
                                mplev = mplev.getMaster();
                            }
                            c1Varnum = variableEvents.indexOf(mplev);
                            mplev = mpl2.getStartEvent();
                            if (!mplev.isMaster()) {
                                if (mplev.getHand() != mplev.getMaster().getHand()) {
                                    coefT2 = -coefT2;
                                }
                                mplev = mplev.getMaster();
                            }
                            t2Varnum = variableEvents.indexOf(mplev);
                            mplev = mpl2.getEndEvent();
                            if (!mplev.isMaster()) {
                                if (mplev.getHand() != mplev.getMaster().getHand()) {
                                    coefC2 = -coefC2;
                                }
                                mplev = mplev.getMaster();
                            }
                            c2Varnum = variableEvents.indexOf(mplev);
                            if (t1Varnum < 0 || c1Varnum < 0 || t2Varnum < 0 || c2Varnum < 0) {
                                throw new JuggleExceptionInternal("Could not find master event in variableEvents");
                            }
                            if (invertMpl2) {
                                coefT2 = -coefT2;
                                coefC2 = -coefC2;
                            }
                            coefs[t1Varnum] = coefs[t1Varnum] + coefT1;
                            coefs[c1Varnum] = coefs[c1Varnum] + coefC1;
                            coefs[t2Varnum] = coefs[t2Varnum] + coefT2;
                            coefs[c2Varnum] = coefs[c2Varnum] + coefC2;
                            coefs[this.varsNum] = coef0;
                            double dist = 0.0;
                            int n4 = this.varsNum;
                            for (k = 0; k < n4; ++k) {
                                dist += coefs[k] * this.getVarsValues()[k];
                            }
                            if (dist < 0.0) {
                                n4 = this.varsNum;
                                for (k = 0; k < n4; ++k) {
                                    if (coefs[k] == 0.0) continue;
                                    coefs[k] = -coefs[k];
                                }
                            }
                            eqns.add(coefs);
                            ++this.marginsNum;
                        }
                    }
                    if (symSwitchdelay) {
                        delay += 0.5 * symDelay;
                        invertMpl2 = !invertMpl2;
                        continue;
                    }
                    delay += symDelay;
                } while (mpl1End > mpl2Start + delay);
            }
        }
        boolean origRow = true;
        for (int i5 = 1; i5 < this.marginsNum; ++i5) {
            boolean dupoverall = false;
            Object e = eqns.get(i5);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            double[] rowi = (double[])e;
            for (int j = 0; !dupoverall && j < i5; ++j) {
                Object e2 = eqns.get(j);
                Intrinsics.checkNotNullExpressionValue(e2, "get(...)");
                double[] rowj = (double[])e2;
                boolean duprow = true;
                int k = 0;
                int n5 = this.varsNum;
                if (k <= n5) {
                    while (true) {
                        if (rowi[k] < rowj[k] - 1.0E-6 || rowi[k] > rowj[k] + 1.0E-6) {
                            duprow = false;
                            break;
                        }
                        if (k == n5) break;
                        ++k;
                    }
                }
                dupoverall = duprow;
            }
            if (!dupoverall) continue;
            eqns.remove(i5);
            --i5;
            this.marginsNum += -1;
        }
        this.setMarginsEqs(new ArrayList(this.marginsNum));
        int n6 = this.marginsNum;
        for (int i6 = 0; i6 < n6; ++i6) {
            LinearEquation le = new LinearEquation(this.varsNum);
            Object e = eqns.get(i6);
            Intrinsics.checkNotNullExpressionValue(e, "get(...)");
            le.setCoefficients((double[])e);
            this.getMarginsEqs().add(le);
        }
        this.sort();
    }

    public final void sort() {
        Comparator<LinearEquation> comp2 = new Comparator<LinearEquation>(this){
            final /* synthetic */ MarginEquations this$0;
            {
                this.this$0 = $receiver;
            }

            public int compare(LinearEquation eq1, LinearEquation eq2) {
                Intrinsics.checkNotNullParameter(eq1, "eq1");
                Intrinsics.checkNotNullParameter(eq2, "eq2");
                if (eq1.getDone() && !eq2.getDone()) {
                    return -1;
                }
                if (!eq1.getDone() && eq2.getDone()) {
                    return 1;
                }
                double m1 = eq1.constant();
                double m2 = eq2.constant();
                int n = this.this$0.getVarsNum();
                for (int i2 = 0; i2 < n; ++i2) {
                    m1 += eq1.coef(i2) * this.this$0.getVarsValues()[i2];
                    m2 += eq2.coef(i2) * this.this$0.getVarsValues()[i2];
                }
                if (m1 < m2) {
                    return -1;
                }
                if (m1 > m2) {
                    return 1;
                }
                return 0;
            }

            public boolean equals(Object other) {
                return false;
            }
        };
        CollectionsKt.sortWith(this.getMarginsEqs(), (Comparator)comp2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljugglinglab/optimizer/MarginEquations$Companion;", "", "<init>", "()V", "EPSILON", "", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

