/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.optimizer;

import com.google.ortools.linearsolver.MPConstraint;
import com.google.ortools.linearsolver.MPObjective;
import com.google.ortools.linearsolver.MPSolver;
import com.google.ortools.linearsolver.MPVariable;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.optimizer.MarginEquations;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljugglinglab/optimizer/Optimizer;", "", "pat", "Ljugglinglab/jml/JMLPattern;", "<init>", "(Ljugglinglab/jml/JMLPattern;)V", "getPat", "()Ljugglinglab/jml/JMLPattern;", "me", "Ljugglinglab/optimizer/MarginEquations;", "pinned", "", "runMILP", "", "markFinished", "", "doOptimizationMILP", "updatePattern", "Companion", "jugglinglab"})
public final class Optimizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JMLPattern pat;
    @NotNull
    private final MarginEquations me;
    @NotNull
    private final boolean[] pinned;
    private static final double EPSILON = 1.0E-7;
    private static final double INFINITY = Double.POSITIVE_INFINITY;
    private static boolean _optimizerLoaded;
    private static boolean _optimizerAvailable;

    private Optimizer(JMLPattern pat) {
        this.pat = pat;
        this.me = new MarginEquations(this.pat);
        this.pinned = this.me.getMarginsNum() > 0 ? new boolean[this.me.getVarsNum()] : new boolean[]{};
    }

    @NotNull
    public final JMLPattern getPat() {
        return this.pat;
    }

    private final boolean runMILP() {
        MPSolver solver = new MPSolver("JugglingLab", MPSolver.OptimizationProblemType.CBC_MIXED_INTEGER_PROGRAMMING);
        MPVariable[] x = new MPVariable[this.me.getVarsNum()];
        int n = this.me.getVarsNum();
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.pinned[i2]) continue;
            x[i2] = solver.makeNumVar(this.me.getVarsMin()[i2], this.me.getVarsMax()[i2], "x" + i2);
        }
        MPVariable[] z = new MPVariable[this.me.getMarginsNum()];
        int n2 = this.me.getMarginsNum();
        for (int i3 = 0; i3 < n2; ++i3) {
            if (this.me.getMarginsEqs().get(i3).getDone()) continue;
            z[i3] = solver.makeBoolVar("z" + i3);
        }
        MPVariable err = solver.makeNumVar(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, "err");
        MPConstraint[] c = new MPConstraint[this.me.getMarginsNum() * 2];
        int n3 = this.me.getMarginsNum();
        for (int i4 = 0; i4 < n3; ++i4) {
            double coef;
            int j;
            if (this.me.getMarginsEqs().get(i4).getDone()) continue;
            double maxAx = 0.0;
            double minAx = 0.0;
            int n4 = this.me.getVarsNum();
            for (int j2 = 0; j2 < n4; ++j2) {
                double coef2 = this.me.getMarginsEqs().get(i4).coef(j2);
                if (coef2 > 0.0) {
                    maxAx += coef2 * this.me.getVarsMax()[j2];
                    minAx += coef2 * this.me.getVarsMin()[j2];
                    continue;
                }
                maxAx += coef2 * this.me.getVarsMin()[j2];
                minAx += coef2 * this.me.getVarsMax()[j2];
            }
            double bound = (double)2 * Math.max(Math.abs(maxAx), Math.abs(minAx)) + 1.0;
            double rhs = this.me.getMarginsEqs().get(i4).constant();
            int n5 = this.me.getVarsNum();
            for (j = 0; j < n5; ++j) {
                if (!this.pinned[j]) continue;
                rhs += this.me.getMarginsEqs().get(i4).coef(j) * this.me.getVarsValues()[j];
            }
            c[2 * i4] = solver.makeConstraint(Double.NEGATIVE_INFINITY, rhs, "c" + i4 + "a");
            MPConstraint mPConstraint = c[2 * i4];
            Intrinsics.checkNotNull(mPConstraint);
            mPConstraint.setCoefficient(err, 1.0);
            MPConstraint mPConstraint2 = c[2 * i4];
            Intrinsics.checkNotNull(mPConstraint2);
            mPConstraint2.setCoefficient(z[i4], -bound);
            n5 = this.me.getVarsNum();
            for (j = 0; j < n5; ++j) {
                if (this.pinned[j] || (coef = this.me.getMarginsEqs().get(i4).coef(j)) == 0.0) continue;
                MPConstraint mPConstraint3 = c[2 * i4];
                Intrinsics.checkNotNull(mPConstraint3);
                mPConstraint3.setCoefficient(x[j], -coef);
            }
            rhs = this.me.getMarginsEqs().get(i4).constant() + bound;
            n5 = this.me.getVarsNum();
            for (j = 0; j < n5; ++j) {
                if (!this.pinned[j]) continue;
                rhs -= this.me.getMarginsEqs().get(i4).coef(j) * this.me.getVarsValues()[j];
            }
            c[2 * i4 + 1] = solver.makeConstraint(Double.NEGATIVE_INFINITY, rhs, "c" + i4 + "b");
            MPConstraint mPConstraint4 = c[2 * i4 + 1];
            Intrinsics.checkNotNull(mPConstraint4);
            mPConstraint4.setCoefficient(err, 1.0);
            MPConstraint mPConstraint5 = c[2 * i4 + 1];
            Intrinsics.checkNotNull(mPConstraint5);
            mPConstraint5.setCoefficient(z[i4], bound);
            n5 = this.me.getVarsNum();
            for (j = 0; j < n5; ++j) {
                if (this.pinned[j] || (coef = this.me.getMarginsEqs().get(i4).coef(j)) == 0.0) continue;
                MPConstraint mPConstraint6 = c[2 * i4 + 1];
                Intrinsics.checkNotNull(mPConstraint6);
                mPConstraint6.setCoefficient(x[j], coef);
            }
        }
        MPObjective objective = solver.objective();
        objective.setCoefficient(err, 1.0);
        objective.setMaximization();
        MPSolver.ResultStatus resultStatus = solver.solve();
        if (resultStatus != MPSolver.ResultStatus.OPTIMAL) {
            return false;
        }
        int n6 = this.me.getVarsNum();
        for (int i5 = 0; i5 < n6; ++i5) {
            if (this.pinned[i5]) continue;
            double[] dArray = this.me.getVarsValues();
            MPVariable mPVariable = x[i5];
            Intrinsics.checkNotNull(mPVariable);
            dArray[i5] = mPVariable.solutionValue();
        }
        return true;
    }

    private final void markFinished() {
        int i2;
        double minmargin = Double.POSITIVE_INFINITY;
        int n = this.me.getMarginsNum();
        for (i2 = 0; i2 < n; ++i2) {
            if (this.me.getMarginsEqs().get(i2).getDone() || !(this.me.getMargin(i2) < minmargin)) continue;
            minmargin = this.me.getMargin(i2);
        }
        n = this.me.getMarginsNum();
        for (i2 = 0; i2 < n; ++i2) {
            if (this.me.getMarginsEqs().get(i2).getDone()) continue;
            double mar = this.me.getMargin(i2);
            double diff = mar - minmargin;
            if (diff < -1.0E-7 || diff > 1.0E-7) continue;
            int n2 = this.me.getVarsNum();
            for (int j = 0; j < n2; ++j) {
                double cj = this.me.getMarginsEqs().get(i2).coef(j);
                if (this.pinned[j] || !(cj > 1.0E-7) && !(cj < -1.0E-7)) continue;
                this.pinned[j] = true;
            }
        }
        n = this.me.getMarginsNum();
        for (int row = 0; row < n; ++row) {
            if (this.me.getMarginsEqs().get(row).getDone()) continue;
            boolean eqndone = true;
            int n3 = this.me.getVarsNum();
            for (int i3 = 0; i3 < n3; ++i3) {
                double ci = this.me.getMarginsEqs().get(row).coef(i3);
                if (this.pinned[i3] || !(ci > 1.0E-7) && !(ci < -1.0E-7)) continue;
                eqndone = false;
                break;
            }
            if (!eqndone) continue;
            this.me.getMarginsEqs().get(row).setDone(true);
        }
    }

    private final boolean doOptimizationMILP() {
        int stage = 1;
        while (true) {
            boolean optimal;
            if (!(optimal = this.runMILP())) {
                return false;
            }
            this.markFinished();
            boolean done = true;
            int n = this.me.getMarginsNum();
            for (int i2 = 0; i2 < n; ++i2) {
                if (this.me.getMarginsEqs().get(i2).getDone()) continue;
                done = false;
                break;
            }
            if (done) break;
            ++stage;
        }
        return true;
    }

    private final void updatePattern() {
        int n = this.me.getVarsNum();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!this.pinned[i2]) continue;
            JMLEvent ev = this.me.getVarsEvents().get(i2);
            double newx = (double)MathKt.roundToInt(this.me.getVarsValues()[i2] * 100.0) / 100.0;
            Coordinate coord = ev.getLocalCoordinate();
            coord.setX(newx);
            ev.setLocalCoordinate(coord);
        }
        this.pat.setNeedsLayout();
    }

    @JvmStatic
    public static final boolean optimizerAvailable() {
        return Companion.optimizerAvailable();
    }

    @JvmStatic
    private static final void loadOptimizer() {
        Optimizer.Companion.loadOptimizer();
    }

    @JvmStatic
    @NotNull
    public static final JMLPattern optimize(@NotNull JMLPattern pat) throws JuggleExceptionInternal, JuggleExceptionUser {
        return Companion.optimize(pat);
    }

    public /* synthetic */ Optimizer(JMLPattern pat, DefaultConstructorMarker $constructor_marker) {
        this(pat);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\bH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljugglinglab/optimizer/Optimizer$Companion;", "", "<init>", "()V", "EPSILON", "", "INFINITY", "_optimizerLoaded", "", "_optimizerAvailable", "optimizerAvailable", "loadOptimizer", "", "optimize", "Ljugglinglab/jml/JMLPattern;", "pat", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean optimizerAvailable() {
            this.loadOptimizer();
            return _optimizerAvailable;
        }

        @JvmStatic
        private final void loadOptimizer() {
            block3: {
                if (_optimizerLoaded) {
                    return;
                }
                _optimizerLoaded = true;
                try {
                    System.loadLibrary("jniortools");
                    _optimizerAvailable = true;
                }
                catch (UnsatisfiedLinkError e) {
                    if (!JugglingLab.INSTANCE.isLinux()) break block3;
                    System.out.println(e);
                }
            }
        }

        @JvmStatic
        @NotNull
        public final JMLPattern optimize(@NotNull JMLPattern pat) throws JuggleExceptionInternal, JuggleExceptionUser {
            Intrinsics.checkNotNullParameter(pat, "pat");
            if (!this.optimizerAvailable()) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_optimizer_unavailable"));
            }
            Optimizer opt = new Optimizer(pat, null);
            if (opt.me.getMarginsNum() > 0) {
                boolean success = opt.doOptimizationMILP();
                if (success) {
                    opt.updatePattern();
                } else {
                    throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_optimizer_failed"));
                }
            }
            return pat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

