/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.path;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import jugglinglab.JugglingLab;
import jugglinglab.path.Path;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0018\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 =2\u00020\u0001:\u0001=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016J(\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0018\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u000200H\u0016J\u001a\u00108\u001a\u0004\u0018\u0001002\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0014J\u001a\u0010;\u001a\u0004\u0018\u0001002\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0014J\u0016\u0010<\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\u001bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00102\u00a8\u0006>"}, d2={"Ljugglinglab/path/BouncePath;", "Ljugglinglab/path/Path;", "<init>", "()V", "bx", "", "cx", "by", "cy", "az", "", "bz", "cz", "endtime", "bounces", "", "forced", "", "hyper", "bounceplane", "bouncefrac", "g", "bouncefracsqrt", "numbounces", "initPath", "", "st", "", "calcPath", "solveBounceEquation", "n", "duration", "root", "liftcatch", "", "type", "getType", "()Ljava/lang/String;", "minDuration", "getMinDuration", "()D", "isFeasibleDuration", "parameterDescriptors", "", "Ljugglinglab/util/ParameterDescriptor;", "getParameterDescriptors", "()Ljava/util/List;", "startVelocity", "Ljugglinglab/util/Coordinate;", "getStartVelocity", "()Ljugglinglab/util/Coordinate;", "endVelocity", "getEndVelocity", "getCoordinate", "time", "newPosition", "getMax2", "time1", "time2", "getMin2", "getBounceVolume", "Companion", "jugglinglab"})
public final class BouncePath
extends Path {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double bx;
    private double cx;
    private double by;
    private double cy;
    private double[] az;
    private double[] bz;
    private double[] cz;
    private double[] endtime;
    private int bounces = 1;
    private boolean forced;
    private boolean hyper;
    private double bounceplane;
    private double bouncefrac = 0.9;
    private double g = 980.0;
    private double bouncefracsqrt;
    private int numbounces;
    @NotNull
    private final String type;
    public static final int BOUNCES_DEF = 1;
    public static final boolean FORCED_DEF = false;
    public static final boolean HYPER_DEF = false;
    public static final double BOUNCEPLANE_DEF = 0.0;
    public static final double BOUNCEFRAC_DEF = 0.9;
    public static final double G_DEF = 980.0;

    public BouncePath() {
        this.type = "Bounce";
    }

    @Override
    public void initPath(@Nullable String st) throws JuggleExceptionUser {
        int bounces = 1;
        boolean forced = false;
        boolean hyper = false;
        double bounceplane = 0.0;
        double bouncefrac = 0.9;
        double g = 980.0;
        ParameterList pl = new ParameterList(st);
        int n = pl.getNumberOfParameters();
        for (int i2 = 0; i2 < n; ++i2) {
            String pname = pl.getParameterName(i2);
            String pvalue = pl.getParameterValue(i2);
            if (StringsKt.equals(pname, "bounces", true)) {
                try {
                    bounces = Integer.parseInt(pvalue);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                    Object[] objectArray = new Object[]{"bounces"};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                }
            }
            if (StringsKt.equals(pname, "forced", true)) {
                forced = Boolean.parseBoolean(pvalue);
                continue;
            }
            if (StringsKt.equals(pname, "hyper", true)) {
                hyper = Boolean.parseBoolean(pvalue);
                continue;
            }
            if (StringsKt.equals(pname, "bounceplane", true)) {
                try {
                    bounceplane = JLFunc.jlParseFiniteDouble(pvalue);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                    Object[] objectArray = new Object[]{"bounceplane"};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                }
            }
            if (StringsKt.equals(pname, "bouncefrac", true)) {
                try {
                    bouncefrac = JLFunc.jlParseFiniteDouble(pvalue);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                    Object[] objectArray = new Object[]{"bouncefrac"};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                }
            }
            if (StringsKt.equals(pname, "g", true)) {
                try {
                    g = JLFunc.jlParseFiniteDouble(pvalue);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                    Object[] objectArray = new Object[]{"g"};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                }
            }
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_path_badmod") + ": '" + pname + "'");
        }
        this.bounces = bounces;
        this.forced = forced;
        this.hyper = hyper;
        this.bounceplane = bounceplane;
        this.bouncefrac = bouncefrac;
        try {
            this.bouncefracsqrt = Math.sqrt(bouncefrac);
        }
        catch (ArithmeticException arithmeticException) {
            this.bouncefracsqrt = 1.0;
        }
        this.g = g;
        this.az = new double[bounces + 1];
        this.bz = new double[bounces + 1];
        this.cz = new double[bounces + 1];
        this.endtime = new double[bounces + 1];
        int i3 = 0;
        n = bounces;
        if (i3 <= n) {
            while (true) {
                double[] dArray = this.az;
                if (this.az == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("az");
                    dArray = null;
                }
                dArray[i3] = -0.5 * g;
                if (i3 == n) break;
                ++i3;
            }
        }
    }

    @Override
    public void calcPath() throws JuggleExceptionInternal {
        Coordinate start = this.getStartCoord();
        Coordinate end = this.getEndCoord();
        if (start == null || end == null) {
            return;
        }
        for (int n = this.bounces; 0 < n; --n) {
            double d;
            int i2;
            double[] root = new double[4];
            boolean[] liftcatch = new boolean[4];
            int numroots = this.solveBounceEquation(n, this.getDuration(), root, liftcatch);
            if (numroots == 0) continue;
            boolean choseroot = false;
            double v0 = root[0];
            for (i2 = 0; i2 < numroots; ++i2) {
                if (this.forced ^ root[i2] < 0.0 || this.hyper ^ liftcatch[i2] ^ this.forced) continue;
                v0 = root[i2];
                choseroot = true;
                break;
            }
            if (!choseroot) {
                for (i2 = 0; i2 < numroots; ++i2) {
                    if (this.forced ^ root[i2] < 0.0) continue;
                    v0 = root[i2];
                    choseroot = true;
                    break;
                }
            }
            if (!choseroot) {
                for (i2 = 0; i2 < numroots; ++i2) {
                    if (this.hyper ^ liftcatch[i2] ^ root[i2] < 0.0) continue;
                    v0 = root[i2];
                    break;
                }
            }
            this.numbounces = n;
            double[] dArray = this.bz;
            if (this.bz == null) {
                Intrinsics.throwUninitializedPropertyAccessException("bz");
                dArray = null;
            }
            dArray[0] = v0;
            double[] dArray2 = this.cz;
            if (this.cz == null) {
                Intrinsics.throwUninitializedPropertyAccessException("cz");
                dArray2 = null;
            }
            dArray2[0] = start.getZ();
            double[] dArray3 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray3 = null;
            }
            double[] dArray4 = this.az;
            if (this.az == null) {
                Intrinsics.throwUninitializedPropertyAccessException("az");
                dArray4 = null;
            }
            if (dArray4[0] < 0.0) {
                double d2 = -v0;
                double d3 = 4;
                double[] dArray5 = this.az;
                if (this.az == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("az");
                    dArray5 = null;
                }
                double d4 = d3 * dArray5[0];
                double[] dArray6 = this.cz;
                if (this.cz == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("cz");
                    dArray6 = null;
                }
                double d5 = d2 - Math.sqrt(v0 * v0 - d4 * (dArray6[0] - this.bounceplane));
                double d6 = 2;
                double[] dArray7 = this.az;
                if (this.az == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("az");
                    dArray7 = null;
                }
                d = d5 / (d6 * dArray7[0]);
            } else {
                double d7 = -v0;
                double d8 = 4;
                double[] dArray8 = this.az;
                if (this.az == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("az");
                    dArray8 = null;
                }
                double d9 = d8 * dArray8[0];
                double[] dArray9 = this.cz;
                if (this.cz == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("cz");
                    dArray9 = null;
                }
                double d10 = d7 + Math.sqrt(v0 * v0 - d9 * (dArray9[0] - this.bounceplane));
                double d11 = 2;
                double[] dArray10 = this.az;
                if (this.az == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("az");
                    dArray10 = null;
                }
                d = d10 / (d11 * dArray10[0]);
            }
            dArray3[0] = d;
            double d12 = -v0;
            double d13 = 2;
            double[] dArray11 = this.az;
            if (this.az == null) {
                Intrinsics.throwUninitializedPropertyAccessException("az");
                dArray11 = null;
            }
            double d14 = d13 * dArray11[0];
            double[] dArray12 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray12 = null;
            }
            double vrebound = (d12 - d14 * dArray12[0]) * this.bouncefracsqrt;
            int i3 = 1;
            if (i3 <= n) {
                while (true) {
                    double[] dArray13 = this.bz;
                    if (this.bz == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("bz");
                        dArray13 = null;
                    }
                    double d15 = 2;
                    double[] dArray14 = this.az;
                    if (this.az == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("az");
                        dArray14 = null;
                    }
                    double d16 = d15 * dArray14[i3];
                    double[] dArray15 = this.endtime;
                    if (this.endtime == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("endtime");
                        dArray15 = null;
                    }
                    dArray13[i3] = vrebound - d16 * dArray15[i3 - 1];
                    double[] dArray16 = this.cz;
                    if (this.cz == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("cz");
                        dArray16 = null;
                    }
                    double[] dArray17 = this.az;
                    if (this.az == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("az");
                        dArray17 = null;
                    }
                    double d17 = dArray17[i3];
                    double[] dArray18 = this.endtime;
                    if (this.endtime == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("endtime");
                        dArray18 = null;
                    }
                    double d18 = d17 * dArray18[i3 - 1];
                    double[] dArray19 = this.endtime;
                    if (this.endtime == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("endtime");
                        dArray19 = null;
                    }
                    double d19 = this.bounceplane - d18 * dArray19[i3 - 1];
                    double[] dArray20 = this.bz;
                    if (this.bz == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("bz");
                        dArray20 = null;
                    }
                    double d20 = dArray20[i3];
                    double[] dArray21 = this.endtime;
                    if (this.endtime == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("endtime");
                        dArray21 = null;
                    }
                    dArray16[i3] = d19 - d20 * dArray21[i3 - 1];
                    double[] dArray22 = this.endtime;
                    if (this.endtime == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("endtime");
                        dArray22 = null;
                    }
                    double[] dArray23 = this.endtime;
                    if (this.endtime == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("endtime");
                        dArray23 = null;
                    }
                    double d21 = dArray23[i3 - 1];
                    double[] dArray24 = this.az;
                    if (this.az == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("az");
                        dArray24 = null;
                    }
                    dArray22[i3] = d21 - vrebound / dArray24[i3];
                    vrebound *= this.bouncefracsqrt;
                    if (i3 == n) break;
                    ++i3;
                }
            }
            double[] dArray25 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray25 = null;
            }
            dArray25[n] = this.getDuration();
            this.cx = start.getX();
            this.bx = (end.getX() - start.getX()) / this.getDuration();
            this.cy = start.getY();
            this.by = (end.getY() - start.getY()) / this.getDuration();
            return;
        }
        throw new JuggleExceptionInternal("No root found in BouncePath");
    }

    private final int solveBounceEquation(int n, double duration, double[] root, boolean[] liftcatch) {
        double f1 = 0.0;
        f1 = 1.0;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            f1 *= this.bouncefracsqrt;
        }
        double k = this.bouncefracsqrt == 1.0 ? (double)2 * (double)n : 1.0 + f1 + (double)2 * this.bouncefracsqrt * (1.0 - f1 / this.bouncefracsqrt) / (1.0 - this.bouncefracsqrt);
        double d = (double)2 * this.g;
        Coordinate coordinate = this.getStartCoord();
        Intrinsics.checkNotNull(coordinate);
        double u = d * (coordinate.getZ() - this.bounceplane);
        double d2 = (double)2 * this.g;
        Coordinate coordinate2 = this.getEndCoord();
        Intrinsics.checkNotNull(coordinate2);
        double l = d2 * (coordinate2.getZ() - this.bounceplane);
        double f2 = f1 * f1;
        double c = u - l / f2;
        double kk = k * k;
        double gt = this.g * duration;
        double[] coef = new double[5];
        coef[4] = 1.0 + kk * kk + f2 * f2 - (double)2 * kk - (double)2 * f2 - (double)2 * kk * f2;
        coef[3] = (double)-4 * gt + (double)4 * f2 * gt + (double)4 * kk * gt;
        coef[2] = (double)6 * gt * gt + (double)2 * kk * kk * u + (double)2 * f2 * f2 * c - (double)2 * f2 * c - (double)2 * f2 * gt * gt - (double)2 * kk * gt * gt - (double)2 * kk * u - (double)2 * kk * f2 * c - (double)2 * kk * f2 * u;
        coef[1] = (double)-4 * gt * gt * gt + (double)4 * f2 * gt * c + (double)4 * kk * gt * u;
        coef[0] = gt * gt * gt * gt + kk * kk * u * u + f2 * f2 * c * c - (double)2 * gt * gt * f2 * c - (double)2 * kk * gt * gt * u - (double)2 * kk * f2 * u * c;
        double[] realroot = new double[4];
        int numrealroots = 0;
        if (n > 1) {
            i = 0;
            while (i < 4) {
                var24_20 = i++;
                coef[var24_20] = coef[var24_20] / coef[4];
            }
            numrealroots = BouncePath.Companion.findRealRootsPolynomial(coef, 4, realroot);
        } else {
            i = 0;
            while (i < 3) {
                var24_20 = i++;
                coef[var24_20] = coef[var24_20] / coef[3];
            }
            numrealroots = BouncePath.Companion.findRealRootsPolynomial(coef, 3, realroot);
        }
        int numroots = 0;
        for (int i2 = 0; i2 < numrealroots; ++i2) {
            double v0 = realroot[i2];
            if (!(v0 * v0 + c >= 0.0)) continue;
            root[numroots] = v0;
            liftcatch[numroots] = gt - v0 - k * Math.sqrt(v0 * v0 + u) > 0.0;
            ++numroots;
        }
        return numroots;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    public double getMinDuration() {
        if (this.bounces == 1 && this.hyper && this.forced) {
            return 0.0;
        }
        double dlower = 0.0;
        double dupper = 1.0;
        while (!this.isFeasibleDuration(dupper)) {
            dlower = dupper;
            dupper *= 2.0;
        }
        while (dupper - dlower > 1.0E-4) {
            double davg = 0.5 * (dlower + dupper);
            if (this.isFeasibleDuration(davg)) {
                dupper = davg;
                continue;
            }
            dlower = davg;
        }
        return dupper;
    }

    private final boolean isFeasibleDuration(double duration) {
        double[] root = new double[4];
        boolean[] liftcatch = new boolean[4];
        int numroots = this.solveBounceEquation(this.bounces, duration, root, liftcatch);
        for (int i2 = 0; i2 < numroots; ++i2) {
            if (this.forced ^ root[i2] < 0.0 || this.hyper ^ liftcatch[i2] ^ this.forced) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<ParameterDescriptor> getParameterDescriptors() {
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{new ParameterDescriptor("bounces", 4, null, 1, this.bounces), new ParameterDescriptor("forced", 1, null, false, this.forced), new ParameterDescriptor("hyper", 1, null, false, this.hyper), new ParameterDescriptor("bounceplane", 2, null, 0.0, this.bounceplane), new ParameterDescriptor("bouncefrac", 2, null, 0.9, this.bouncefrac), new ParameterDescriptor("g", 2, null, 980.0, this.g)};
        return CollectionsKt.listOf(parameterDescriptorArray);
    }

    @Override
    @NotNull
    public Coordinate getStartVelocity() {
        double[] dArray = this.bz;
        if (this.bz == null) {
            Intrinsics.throwUninitializedPropertyAccessException("bz");
            dArray = null;
        }
        return new Coordinate(this.bx, this.by, dArray[0]);
    }

    @Override
    @NotNull
    public Coordinate getEndVelocity() {
        double[] dArray = this.bz;
        if (this.bz == null) {
            Intrinsics.throwUninitializedPropertyAccessException("bz");
            dArray = null;
        }
        double d = dArray[this.numbounces];
        double d2 = 2;
        double[] dArray2 = this.az;
        if (this.az == null) {
            Intrinsics.throwUninitializedPropertyAccessException("az");
            dArray2 = null;
        }
        return new Coordinate(this.bx, this.by, d + d2 * dArray2[this.numbounces] * (this.getEndTime() - this.getStartTime()));
    }

    @Override
    public void getCoordinate(double time, @NotNull Coordinate newPosition) {
        Intrinsics.checkNotNullParameter(newPosition, "newPosition");
        double d = this.getStartTime();
        boolean bl = time <= this.getEndTime() ? d <= time : false;
        if (bl) {
            double t2 = time - this.getStartTime();
            double zpos = 0.0;
            int i2 = 0;
            int n = this.numbounces;
            if (i2 <= n) {
                while (true) {
                    double[] dArray = this.endtime;
                    if (this.endtime == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("endtime");
                        dArray = null;
                    }
                    if (t2 < dArray[i2] || i2 == this.numbounces) {
                        double[] dArray2 = this.cz;
                        if (this.cz == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("cz");
                            dArray2 = null;
                        }
                        double d2 = dArray2[i2];
                        double[] dArray3 = this.bz;
                        if (this.bz == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("bz");
                            dArray3 = null;
                        }
                        double d3 = dArray3[i2];
                        double[] dArray4 = this.az;
                        if (this.az == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("az");
                            dArray4 = null;
                        }
                        zpos = d2 + t2 * (d3 + dArray4[i2] * t2);
                        break;
                    }
                    if (i2 == n) break;
                    ++i2;
                }
            }
            newPosition.setCoordinate(this.cx + this.bx * t2, this.cy + this.by * t2, zpos);
        }
    }

    @Override
    @Nullable
    protected Coordinate getMax2(double time1, double time2) {
        double d;
        double te;
        double tlow = Math.max(this.getStartTime(), time1);
        double thigh = Math.min(this.getEndTime(), time2);
        Coordinate result = this.check(null, tlow, true);
        result = this.check(result, thigh, true);
        double[] dArray = this.az;
        if (this.az == null) {
            Intrinsics.throwUninitializedPropertyAccessException("az");
            dArray = null;
        }
        if (dArray[0] < 0.0) {
            double[] dArray2 = this.bz;
            if (this.bz == null) {
                Intrinsics.throwUninitializedPropertyAccessException("bz");
                dArray2 = null;
            }
            double d2 = -dArray2[0];
            double d3 = 2;
            double[] dArray3 = this.az;
            if (this.az == null) {
                Intrinsics.throwUninitializedPropertyAccessException("az");
                dArray3 = null;
            }
            if (tlow < (te = d2 / (d3 * dArray3[0]) + this.getStartTime())) {
                double d4 = this.getStartTime();
                double[] dArray4 = this.endtime;
                if (this.endtime == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("endtime");
                    dArray4 = null;
                }
                if (te < Math.min(thigh, d = d4 + dArray4[0])) {
                    result = this.check(result, te, true);
                }
            }
        }
        double[] dArray5 = this.az;
        if (this.az == null) {
            Intrinsics.throwUninitializedPropertyAccessException("az");
            dArray5 = null;
        }
        if (dArray5[this.numbounces] < 0.0) {
            double[] dArray6 = this.bz;
            if (this.bz == null) {
                Intrinsics.throwUninitializedPropertyAccessException("bz");
                dArray6 = null;
            }
            double d5 = -dArray6[this.numbounces];
            double d6 = 2;
            double[] dArray7 = this.az;
            if (this.az == null) {
                Intrinsics.throwUninitializedPropertyAccessException("az");
                dArray7 = null;
            }
            te = d5 / (d6 * dArray7[this.numbounces]) + this.getStartTime();
            double d7 = this.getStartTime();
            double[] dArray8 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray8 = null;
            }
            if (Math.max(tlow, d = d7 + dArray8[this.numbounces - 1]) < te && te < thigh) {
                result = this.check(result, te, true);
            }
        }
        double d8 = this.getStartTime();
        double[] dArray9 = this.endtime;
        if (this.endtime == null) {
            Intrinsics.throwUninitializedPropertyAccessException("endtime");
            dArray9 = null;
        }
        if (tlow < d8 + dArray9[0]) {
            double d9 = this.getStartTime();
            double[] dArray10 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray10 = null;
            }
            if (d9 + dArray10[0] < thigh) {
                double d10 = this.getStartTime();
                double[] dArray11 = this.endtime;
                if (this.endtime == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("endtime");
                    dArray11 = null;
                }
                result = this.check(result, d10 + dArray11[0], true);
            }
        }
        int n = this.numbounces;
        for (int i2 = 1; i2 < n; ++i2) {
            double[] dArray12 = this.az;
            if (this.az == null) {
                Intrinsics.throwUninitializedPropertyAccessException("az");
                dArray12 = null;
            }
            if (dArray12[i2] < 0.0) {
                double d11;
                double[] dArray13 = this.bz;
                if (this.bz == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("bz");
                    dArray13 = null;
                }
                double d12 = -dArray13[i2];
                double d13 = 2;
                double[] dArray14 = this.az;
                if (this.az == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("az");
                    dArray14 = null;
                }
                double te2 = d12 / (d13 * dArray14[i2]) + this.getStartTime();
                double d14 = this.getStartTime();
                double[] dArray15 = this.endtime;
                if (this.endtime == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("endtime");
                    dArray15 = null;
                }
                if (Math.max(tlow, d11 = d14 + dArray15[i2 - 1]) < te2) {
                    double d15 = this.getStartTime();
                    double[] dArray16 = this.endtime;
                    if (this.endtime == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("endtime");
                        dArray16 = null;
                    }
                    if (te2 < Math.min(thigh, d11 = d15 + dArray16[i2])) {
                        result = this.check(result, te2, true);
                    }
                }
            }
            double d16 = this.getStartTime();
            double[] dArray17 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray17 = null;
            }
            if (!(tlow < d16 + dArray17[i2])) continue;
            double d17 = this.getStartTime();
            double[] dArray18 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray18 = null;
            }
            if (!(d17 + dArray18[i2] < thigh)) continue;
            double d18 = this.getStartTime();
            double[] dArray19 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray19 = null;
            }
            result = this.check(result, d18 + dArray19[i2], true);
        }
        return result;
    }

    @Override
    @Nullable
    protected Coordinate getMin2(double time1, double time2) {
        double d;
        double te;
        double tlow = Math.max(this.getStartTime(), time1);
        double thigh = Math.min(this.getEndTime(), time2);
        Coordinate result = this.check(null, tlow, false);
        result = this.check(result, thigh, false);
        double[] dArray = this.az;
        if (this.az == null) {
            Intrinsics.throwUninitializedPropertyAccessException("az");
            dArray = null;
        }
        if (dArray[0] > 0.0) {
            double[] dArray2 = this.bz;
            if (this.bz == null) {
                Intrinsics.throwUninitializedPropertyAccessException("bz");
                dArray2 = null;
            }
            double d2 = -dArray2[0];
            double d3 = 2;
            double[] dArray3 = this.az;
            if (this.az == null) {
                Intrinsics.throwUninitializedPropertyAccessException("az");
                dArray3 = null;
            }
            if (tlow < (te = d2 / (d3 * dArray3[0]) + this.getStartTime())) {
                double d4 = this.getStartTime();
                double[] dArray4 = this.endtime;
                if (this.endtime == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("endtime");
                    dArray4 = null;
                }
                if (te < Math.min(thigh, d = d4 + dArray4[0])) {
                    result = this.check(result, te, false);
                }
            }
        }
        double[] dArray5 = this.az;
        if (this.az == null) {
            Intrinsics.throwUninitializedPropertyAccessException("az");
            dArray5 = null;
        }
        if (dArray5[this.numbounces] > 0.0) {
            double[] dArray6 = this.bz;
            if (this.bz == null) {
                Intrinsics.throwUninitializedPropertyAccessException("bz");
                dArray6 = null;
            }
            double d5 = -dArray6[this.numbounces];
            double d6 = 2;
            double[] dArray7 = this.az;
            if (this.az == null) {
                Intrinsics.throwUninitializedPropertyAccessException("az");
                dArray7 = null;
            }
            te = d5 / (d6 * dArray7[this.numbounces]) + this.getStartTime();
            double d7 = this.getStartTime();
            double[] dArray8 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray8 = null;
            }
            if (Math.max(tlow, d = d7 + dArray8[this.numbounces - 1]) < te && te < thigh) {
                result = this.check(result, te, false);
            }
        }
        double d8 = this.getStartTime();
        double[] dArray9 = this.endtime;
        if (this.endtime == null) {
            Intrinsics.throwUninitializedPropertyAccessException("endtime");
            dArray9 = null;
        }
        if (tlow < d8 + dArray9[0]) {
            double d9 = this.getStartTime();
            double[] dArray10 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray10 = null;
            }
            if (d9 + dArray10[0] < thigh) {
                double d10 = this.getStartTime();
                double[] dArray11 = this.endtime;
                if (this.endtime == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("endtime");
                    dArray11 = null;
                }
                result = this.check(result, d10 + dArray11[0], false);
            }
        }
        int n = this.numbounces;
        for (int i2 = 1; i2 < n; ++i2) {
            double[] dArray12 = this.az;
            if (this.az == null) {
                Intrinsics.throwUninitializedPropertyAccessException("az");
                dArray12 = null;
            }
            if (dArray12[i2] > 0.0) {
                double d11;
                double[] dArray13 = this.bz;
                if (this.bz == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("bz");
                    dArray13 = null;
                }
                double d12 = -dArray13[i2];
                double d13 = 2;
                double[] dArray14 = this.az;
                if (this.az == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("az");
                    dArray14 = null;
                }
                double te2 = d12 / (d13 * dArray14[i2]) + this.getStartTime();
                double d14 = this.getStartTime();
                double[] dArray15 = this.endtime;
                if (this.endtime == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("endtime");
                    dArray15 = null;
                }
                if (Math.max(tlow, d11 = d14 + dArray15[i2 - 1]) < te2) {
                    double d15 = this.getStartTime();
                    double[] dArray16 = this.endtime;
                    if (this.endtime == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("endtime");
                        dArray16 = null;
                    }
                    if (te2 < Math.min(thigh, d11 = d15 + dArray16[i2])) {
                        result = this.check(result, te2, false);
                    }
                }
            }
            double d16 = this.getStartTime();
            double[] dArray17 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray17 = null;
            }
            if (!(tlow < d16 + dArray17[i2])) continue;
            double d17 = this.getStartTime();
            double[] dArray18 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray18 = null;
            }
            if (!(d17 + dArray18[i2] < thigh)) continue;
            double d18 = this.getStartTime();
            double[] dArray19 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray19 = null;
            }
            result = this.check(result, d18 + dArray19[i2], false);
        }
        return result;
    }

    public final double getBounceVolume(double time1, double time2) {
        if (time2 < this.getStartTime() || time1 > this.getEndTime()) {
            return 0.0;
        }
        double t1 = time1 - this.getStartTime();
        double t2 = time2 - this.getStartTime();
        int n = this.numbounces;
        for (int i2 = 0; i2 < n; ++i2) {
            double[] dArray = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray = null;
            }
            if (!(t1 < dArray[i2])) continue;
            double[] dArray2 = this.endtime;
            if (this.endtime == null) {
                Intrinsics.throwUninitializedPropertyAccessException("endtime");
                dArray2 = null;
            }
            return t2 > dArray2[i2] ? 1.0 : 0.0;
        }
        return 0.0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\nH\u0002J(\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J(\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljugglinglab/path/BouncePath$Companion;", "", "<init>", "()V", "BOUNCES_DEF", "", "FORCED_DEF", "", "HYPER_DEF", "BOUNCEPLANE_DEF", "", "BOUNCEFRAC_DEF", "G_DEF", "evalPolynomial", "coef", "", "degree", "x", "bracketOpenInterval", "endpoint", "pinf", "findRoot", "xlow", "xhigh", "findRealRootsPolynomial", "result", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        private final double evalPolynomial(double[] coef, int degree, double x) {
            double result = coef[0];
            double term = x;
            for (int i2 = 1; i2 < degree; ++i2) {
                result += coef[i2] * term;
                term *= x;
            }
            return result + term;
        }

        private final double bracketOpenInterval(double[] coef, int degree, double endpoint, boolean pinf) {
            boolean endpointpositive = this.evalPolynomial(coef, degree, endpoint) > 0.0;
            double result = endpoint;
            double adder = pinf ? 1.0 : -1.0;
            while (this.evalPolynomial(coef, degree, result += (adder *= 2.0)) > 0.0 == endpointpositive) {
            }
            return result;
        }

        private final double findRoot(double[] coef, int degree, double xlow, double xhigh) {
            double xlow2 = xlow;
            double xhigh2 = xhigh;
            double val1 = this.evalPolynomial(coef, degree, xlow2);
            double val2 = this.evalPolynomial(coef, degree, xhigh2);
            double valtemp = 0.0;
            double t2 = 0.0;
            if (val1 * val2 > 0.0) {
                return 0.5 * (xlow2 + xhigh2);
            }
            while (Math.abs(xlow2 - xhigh2) > 1.0E-6) {
                t2 = 0.5 * (xlow2 + xhigh2);
                valtemp = this.evalPolynomial(coef, degree, t2);
                if (valtemp * val1 > 0.0) {
                    xlow2 = t2;
                    val1 = valtemp;
                    continue;
                }
                xhigh2 = t2;
            }
            return xlow2;
        }

        private final int findRealRootsPolynomial(double[] coef, int degree, double[] result) {
            switch (degree) {
                case 0: {
                    return 0;
                }
                case 1: {
                    result[0] = -coef[0];
                    return 1;
                }
                case 2: {
                    double disc = coef[1] * coef[1] - 4.0 * coef[0];
                    if (disc < 0.0) {
                        return 0;
                    }
                    if (disc == 0.0) {
                        result[0] = -0.5 * coef[1];
                        return 1;
                    }
                    double t2 = Math.sqrt(disc);
                    result[0] = -0.5 * (coef[1] + t2);
                    result[1] = -0.5 * (coef[1] - t2);
                    return 2;
                }
                case 3: {
                    double q = coef[2] * coef[2] / 9.0 - coef[1] / 3.0;
                    double r = coef[2] * coef[2] * coef[2] / 27.0 - coef[1] * coef[2] / 6.0 + coef[0] / 2.0;
                    double disc = r * r - q * q * q;
                    if (disc > 0.0) {
                        double k = Math.pow(Math.sqrt(disc) + Math.abs(r), 0.3333333333333333);
                        result[0] = (r > 0.0 ? -(k + q / k) : k + q / k) - coef[2] / 3.0;
                        return 1;
                    }
                    double theta = Math.acos(r / Math.sqrt(q * q * q)) / 3.0;
                    double k = -2.0 * Math.sqrt(q);
                    double p = 2.0943951023931953;
                    result[0] = k * Math.cos(theta) - coef[2] / 3.0;
                    result[1] = k * Math.cos(theta + p) - coef[2] / 3.0;
                    result[2] = k * Math.cos(theta + 2.0 * p) - coef[2] / 3.0;
                    return 3;
                }
            }
            double[] dcoef = new double[degree - 1];
            double[] extremum = new double[degree - 1];
            int n = degree - 1;
            for (int i2 = 0; i2 < n; ++i2) {
                dcoef[i2] = (double)(i2 + 1) * coef[i2 + 1] / (double)degree;
            }
            int numextrema = this.findRealRootsPolynomial(dcoef, degree - 1, extremum);
            boolean pinfpositive = true;
            boolean minfpositive = degree % 2 == 0;
            int numroots = 0;
            if (numextrema == 0) {
                double endpoint2;
                boolean zeropositive;
                boolean bl = zeropositive = coef[0] > 0.0;
                if (zeropositive != pinfpositive) {
                    endpoint2 = this.bracketOpenInterval(coef, degree, 0.0, true);
                    result[numroots++] = this.findRoot(coef, degree, 0.0, endpoint2);
                }
                if (zeropositive != minfpositive) {
                    endpoint2 = this.bracketOpenInterval(coef, degree, 0.0, false);
                    result[numroots++] = this.findRoot(coef, degree, endpoint2, 0.0);
                }
                return numroots;
            }
            for (int i3 = 0; i3 < numextrema; ++i3) {
                for (int j = i3; j < numextrema; ++j) {
                    if (!(extremum[i3] > extremum[j])) continue;
                    double temp = extremum[i3];
                    extremum[i3] = extremum[j];
                    extremum[j] = temp;
                }
            }
            boolean[] extremumpositive = new boolean[numextrema];
            for (int i4 = 0; i4 < numextrema; ++i4) {
                extremumpositive[i4] = this.evalPolynomial(coef, degree, extremum[i4]) > 0.0;
            }
            if (minfpositive != extremumpositive[0]) {
                double endpoint2 = this.bracketOpenInterval(coef, degree, extremum[0], false);
                result[numroots++] = this.findRoot(coef, degree, endpoint2, extremum[0]);
            }
            int n2 = numextrema - 1;
            for (int i5 = 0; i5 < n2; ++i5) {
                if (extremumpositive[i5] == extremumpositive[i5 + 1]) continue;
                result[numroots++] = this.findRoot(coef, degree, extremum[i5], extremum[i5 + 1]);
            }
            if (pinfpositive != extremumpositive[numextrema - 1]) {
                double endpoint2 = this.bracketOpenInterval(coef, degree, extremum[numextrema - 1], true);
                result[numroots++] = this.findRoot(coef, degree, extremum[numextrema - 1], endpoint2);
            }
            return numroots;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

