/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.path;

import java.util.List;
import jugglinglab.path.BouncePath;
import jugglinglab.path.TossPath;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 @2\u00020\u0001:\u0001@B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000bJ\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000bJ\u0012\u0010\u001b\u001a\u00020\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH&J\b\u0010\u001e\u001a\u00020\u0017H&J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000bJ\u0018\u00101\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u0005H&J\u001a\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u000bH$J\u001a\u00106\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u000bH$J\u0018\u00108\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u000bJ\u0018\u0010:\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u000bJ\"\u0010;\u001a\u00020\u00052\b\u0010<\u001a\u0004\u0018\u00010\u00052\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020?H\u0004R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u0012\u0010!\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\rR\u0012\u0010&\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\rR\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0012\u0010-\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0007R\u0012\u0010/\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0007R\u0013\u00107\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0007R\u0013\u00109\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0007\u00a8\u0006A"}, d2={"Ljugglinglab/path/Path;", "", "<init>", "()V", "startCoord", "Ljugglinglab/util/Coordinate;", "getStartCoord", "()Ljugglinglab/util/Coordinate;", "setStartCoord", "(Ljugglinglab/util/Coordinate;)V", "startTime", "", "getStartTime", "()D", "setStartTime", "(D)V", "endCoord", "getEndCoord", "setEndCoord", "endTime", "getEndTime", "setEndTime", "setStart", "", "position", "time", "setEnd", "initPath", "st", "", "calcPath", "translateTime", "deltat", "type", "getType", "()Ljava/lang/String;", "duration", "getDuration", "minDuration", "getMinDuration", "parameterDescriptors", "", "Ljugglinglab/util/ParameterDescriptor;", "getParameterDescriptors", "()Ljava/util/List;", "startVelocity", "getStartVelocity", "endVelocity", "getEndVelocity", "getCoordinate", "newPosition", "getMax2", "time1", "time2", "getMin2", "max", "getMax", "min", "getMin", "check", "result", "t", "findmax", "", "Companion", "jugglinglab"})
public abstract class Path {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Coordinate startCoord;
    private double startTime;
    @Nullable
    private Coordinate endCoord;
    private double endTime;
    @JvmField
    @NotNull
    public static final String[] builtinPaths;

    @Nullable
    protected final Coordinate getStartCoord() {
        return this.startCoord;
    }

    protected final void setStartCoord(@Nullable Coordinate coordinate) {
        this.startCoord = coordinate;
    }

    protected final double getStartTime() {
        return this.startTime;
    }

    protected final void setStartTime(double d) {
        this.startTime = d;
    }

    @Nullable
    protected final Coordinate getEndCoord() {
        return this.endCoord;
    }

    protected final void setEndCoord(@Nullable Coordinate coordinate) {
        this.endCoord = coordinate;
    }

    protected final double getEndTime() {
        return this.endTime;
    }

    protected final void setEndTime(double d) {
        this.endTime = d;
    }

    public final void setStart(@NotNull Coordinate position, double time) {
        Intrinsics.checkNotNullParameter(position, "position");
        this.startCoord = position;
        this.startTime = time;
    }

    public final void setEnd(@NotNull Coordinate position, double time) {
        Intrinsics.checkNotNullParameter(position, "position");
        this.endCoord = position;
        this.endTime = time;
    }

    public abstract void initPath(@Nullable String var1) throws JuggleExceptionUser;

    public abstract void calcPath() throws JuggleExceptionInternal;

    public final void translateTime(double deltat) {
        this.startTime += deltat;
        this.endTime += deltat;
    }

    @NotNull
    public abstract String getType();

    public final double getDuration() {
        return this.endTime - this.startTime;
    }

    public abstract double getMinDuration();

    @NotNull
    public abstract List<ParameterDescriptor> getParameterDescriptors();

    @NotNull
    public abstract Coordinate getStartVelocity();

    @NotNull
    public abstract Coordinate getEndVelocity();

    public abstract void getCoordinate(double var1, @NotNull Coordinate var3);

    @Nullable
    protected abstract Coordinate getMax2(double var1, double var3);

    @Nullable
    protected abstract Coordinate getMin2(double var1, double var3);

    @Nullable
    public final Coordinate getMax() {
        return this.getMax2(this.startTime, this.endTime);
    }

    @Nullable
    public final Coordinate getMin() {
        return this.getMin2(this.startTime, this.endTime);
    }

    @Nullable
    public final Coordinate getMax(double time1, double time2) {
        if (time2 < this.startTime || time1 > this.endTime) {
            return null;
        }
        return this.getMax2(time1, time2);
    }

    @Nullable
    public final Coordinate getMin(double time1, double time2) {
        if (time2 < this.startTime || time1 > this.endTime) {
            return null;
        }
        return this.getMin2(time1, time2);
    }

    @NotNull
    protected final Coordinate check(@Nullable Coordinate result, double t2, boolean findmax) {
        Coordinate res;
        Coordinate loc = new Coordinate(0.0, 0.0, 0.0);
        this.getCoordinate(t2, loc);
        Coordinate coordinate = res = result == null ? loc : (findmax ? Coordinate.Companion.max(result, loc) : Coordinate.Companion.min(result, loc));
        Intrinsics.checkNotNull(coordinate);
        return coordinate;
    }

    @JvmStatic
    @NotNull
    public static final Path newPath(@NotNull String type) throws JuggleExceptionUser {
        return Companion.newPath(type);
    }

    static {
        String[] stringArray = new String[]{"Toss", "Bounce"};
        builtinPaths = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0007R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ljugglinglab/path/Path$Companion;", "", "<init>", "()V", "builtinPaths", "", "", "[Ljava/lang/String;", "newPath", "Ljugglinglab/path/Path;", "type", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Path newPath(@NotNull String type) throws JuggleExceptionUser {
            Intrinsics.checkNotNullParameter(type, "type");
            if (StringsKt.equals(type, "toss", true)) {
                return new TossPath();
            }
            if (StringsKt.equals(type, "bounce", true)) {
                return new BouncePath();
            }
            throw new JuggleExceptionUser("Path type '" + type + "' not recognized");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

