/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.path;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import jugglinglab.JugglingLab;
import jugglinglab.path.Path;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u001eH\u0016J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0014J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 \u00a8\u0006+"}, d2={"Ljugglinglab/path/TossPath;", "Ljugglinglab/path/Path;", "<init>", "()V", "bx", "", "cx", "by", "cy", "az", "bz", "cz", "g", "initPath", "", "st", "", "calcPath", "type", "getType", "()Ljava/lang/String;", "minDuration", "getMinDuration", "()D", "parameterDescriptors", "", "Ljugglinglab/util/ParameterDescriptor;", "getParameterDescriptors", "()Ljava/util/List;", "startVelocity", "Ljugglinglab/util/Coordinate;", "getStartVelocity", "()Ljugglinglab/util/Coordinate;", "endVelocity", "getEndVelocity", "getCoordinate", "time", "newPosition", "getMax2", "time1", "time2", "getMin2", "Companion", "jugglinglab"})
public final class TossPath
extends Path {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double bx;
    private double cx;
    private double by;
    private double cy;
    private double az;
    private double bz;
    private double cz;
    private double g = 980.0;
    @NotNull
    private final String type;
    private final double minDuration;
    public static final double G_DEF = 980.0;

    public TossPath() {
        this.type = "Toss";
    }

    @Override
    public void initPath(@Nullable String st) throws JuggleExceptionUser {
        double g = 980.0;
        ParameterList pl = new ParameterList(st);
        int n = pl.getNumberOfParameters();
        for (int i2 = 0; i2 < n; ++i2) {
            String pname = pl.getParameterName(i2);
            String pvalue = pl.getParameterValue(i2);
            if (StringsKt.equals(pname, "g", true)) {
                try {
                    g = JLFunc.jlParseFiniteDouble(pvalue);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                    Object[] objectArray = new Object[]{"g"};
                    Object[] arguments = objectArray;
                    throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                }
            }
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_path_badmod") + ": '" + pname + "'");
        }
        this.g = g;
        this.az = -0.5 * g;
    }

    @Override
    public void calcPath() throws JuggleExceptionInternal {
        Coordinate start = this.getStartCoord();
        Coordinate end = this.getEndCoord();
        if (start == null || end == null) {
            throw new JuggleExceptionInternal("Error in parabolic path: endpoints not set");
        }
        double t2 = this.getDuration();
        this.cx = start.getX();
        this.bx = (end.getX() - start.getX()) / t2;
        this.cy = start.getY();
        this.by = (end.getY() - start.getY()) / t2;
        this.cz = start.getZ();
        this.bz = (end.getZ() - start.getZ()) / t2 - this.az * t2;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    public double getMinDuration() {
        return this.minDuration;
    }

    @Override
    @NotNull
    public List<ParameterDescriptor> getParameterDescriptors() {
        return CollectionsKt.listOf(new ParameterDescriptor("g", 2, null, 980.0, this.g));
    }

    @Override
    @NotNull
    public Coordinate getStartVelocity() {
        return new Coordinate(this.bx, this.by, this.bz);
    }

    @Override
    @NotNull
    public Coordinate getEndVelocity() {
        return new Coordinate(this.bx, this.by, this.bz + (double)2 * this.az * this.getDuration());
    }

    @Override
    public void getCoordinate(double time, @NotNull Coordinate newPosition) {
        Intrinsics.checkNotNullParameter(newPosition, "newPosition");
        double d = this.getStartTime();
        boolean bl = time <= this.getEndTime() ? d <= time : false;
        if (bl) {
            double t2 = time - this.getStartTime();
            newPosition.setCoordinate(this.cx + this.bx * t2, this.cy + this.by * t2, this.cz + t2 * (this.bz + this.az * t2));
        }
    }

    @Override
    @NotNull
    protected Coordinate getMax2(double time1, double time2) {
        double te;
        double tlow = Math.max(this.getStartTime(), time1);
        double thigh = Math.min(this.getEndTime(), time2);
        Coordinate result = this.check(null, tlow, true);
        result = this.check(result, thigh, true);
        if (this.az < 0.0 && tlow < (te = -this.bz / ((double)2 * this.az) + this.getStartTime()) && te < thigh) {
            result = this.check(result, te, true);
        }
        return result;
    }

    @Override
    @NotNull
    protected Coordinate getMin2(double time1, double time2) {
        double te;
        double tlow = Math.max(this.getStartTime(), time1);
        double thigh = Math.min(this.getEndTime(), time2);
        Coordinate result = this.check(null, tlow, false);
        result = this.check(result, thigh, false);
        if (this.az > 0.0 && tlow < (te = -this.by / ((double)2 * this.az) + this.getStartTime()) && te < thigh) {
            result = this.check(result, te, false);
        }
        return result;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljugglinglab/path/TossPath$Companion;", "", "<init>", "()V", "G_DEF", "", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

