/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import jugglinglab.JugglingLab;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0006\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0014H\u0014J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010\u00102\u0006\u0010&\u001a\u00020\u0005H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010\u00102\u0006\u0010&\u001a\u00020\u0005H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u00102\u0006\u0010&\u001a\u00020\u0005H\u0016J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Ljugglinglab/prop/BallProp;", "Ljugglinglab/prop/Prop;", "<init>", "()V", "diam", "", "color", "Ljava/awt/Color;", "colornum", "", "highlight", "", "ballimage", "Ljava/awt/image/BufferedImage;", "lastzoom", "size", "Ljava/awt/Dimension;", "center", "grip", "type", "", "getType", "()Ljava/lang/String;", "isColorable", "()Z", "getEditorColor", "getParameterDescriptors", "", "Ljugglinglab/util/ParameterDescriptor;", "init", "", "st", "getMax", "Ljugglinglab/util/Coordinate;", "getMin", "getWidth", "getProp2DImage", "Ljava/awt/Image;", "zoom", "camangle", "", "getProp2DSize", "getProp2DCenter", "getProp2DGrip", "recalc2D", "Companion", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nBallProp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BallProp.kt\njugglinglab/prop/BallProp\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,277:1\n1#2:278\n106#3:279\n78#3,22:280\n106#3:302\n78#3,22:303\n106#3:325\n78#3,22:326\n106#3:348\n78#3,22:349\n106#3:371\n78#3,22:372\n*S KotlinDebug\n*F\n+ 1 BallProp.kt\njugglinglab/prop/BallProp\n*L\n110#1:279\n110#1:280,22\n112#1:302\n112#1:303,22\n114#1:325\n114#1:326,22\n117#1:348\n117#1:349,22\n147#1:371\n147#1:372,22\n*E\n"})
public final class BallProp
extends Prop {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double diam = 10.0;
    @NotNull
    private Color color = COLOR_DEF;
    private int colornum = 9;
    private boolean highlight;
    @Nullable
    private BufferedImage ballimage;
    private double lastzoom;
    @Nullable
    private Dimension size;
    @Nullable
    private Dimension center;
    @Nullable
    private Dimension grip;
    @NotNull
    private final String type;
    private final boolean isColorable;
    @NotNull
    private static final Color COLOR_DEF;
    private static final int COLORNUM_DEF = 9;
    private static final double DIAM_DEF = 10.0;
    private static final boolean HIGHLIGHT_DEF = false;

    public BallProp() {
        this.type = "Ball";
        this.isColorable = true;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isColorable() {
        return this.isColorable;
    }

    @Override
    @NotNull
    public Color getEditorColor() {
        return this.color;
    }

    @Override
    @NotNull
    public List<ParameterDescriptor> getParameterDescriptors() {
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{new ParameterDescriptor("color", 3, Prop.Companion.getCOLOR_NAMES(), Prop.Companion.getCOLOR_NAMES().get(9), Prop.Companion.getCOLOR_NAMES().get(this.colornum)), new ParameterDescriptor("diam", 2, null, 10.0, this.diam), new ParameterDescriptor("highlight", 1, null, false, this.highlight)};
        return CollectionsKt.listOf(parameterDescriptorArray);
    }

    @Override
    protected void init(@Nullable String st) throws JuggleExceptionUser {
        String highlightstr;
        String diamstr;
        if (st == null) {
            return;
        }
        ParameterList pl = new ParameterList(st);
        String colorstr = pl.getParameter("color");
        if (colorstr != null) {
            Object st2;
            Color temp = null;
            if (StringsKt.indexOf$default((CharSequence)colorstr, ',', 0, false, 6, null) == -1) {
                int n = ((Collection)Prop.Companion.getCOLOR_NAMES()).size();
                for (int i2 = 0; i2 < n; ++i2) {
                    if (!StringsKt.equals(Prop.Companion.getCOLOR_NAMES().get(i2), colorstr, true)) continue;
                    temp = Prop.Companion.getCOLOR_VALS().get(i2);
                    this.colornum = i2;
                    break;
                }
            } else {
                int it;
                int n;
                Object str = colorstr;
                int pos = 0;
                while (true) {
                    String string = str;
                    Intrinsics.checkNotNull(string);
                    it = n = StringsKt.indexOf$default((CharSequence)string, '{', 0, false, 6, null);
                    boolean bl = false;
                    pos = it;
                    if (n < 0) break;
                    String string2 = StringsKt.take((String)str, pos);
                    String string3 = ((String)str).substring(pos + 1);
                    Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                    str = string2 + string3;
                }
                while (true) {
                    String string = str;
                    Intrinsics.checkNotNull(string);
                    it = n = StringsKt.indexOf$default((CharSequence)string, '}', 0, false, 6, null);
                    boolean bl = false;
                    pos = it;
                    if (n < 0) break;
                    String string4 = StringsKt.take((String)str, pos);
                    String string5 = ((String)str).substring(pos + 1);
                    Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                    str = string4 + string5;
                }
                st2 = new StringTokenizer((String)str, ",", false);
                int tokens = ((StringTokenizer)st2).countTokens();
                switch (tokens) {
                    case 3: 
                    case 4: {
                        int red = 0;
                        int green = 0;
                        int blue = 0;
                        int alpha = 255;
                        String token = null;
                        try {
                            boolean match$iv$iv;
                            char it2;
                            int index$iv$iv;
                            String string = ((StringTokenizer)st2).nextToken();
                            Intrinsics.checkNotNullExpressionValue(string, "nextToken(...)");
                            String $this$trim$iv = string;
                            boolean $i$f$trim = false;
                            CharSequence $this$trim$iv$iv = $this$trim$iv;
                            boolean $i$f$trim2 = false;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl2 = match$iv$iv = Intrinsics.compare(it2, 32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            token = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            red = Integer.parseInt(token);
                            String string6 = ((StringTokenizer)st2).nextToken();
                            Intrinsics.checkNotNullExpressionValue(string6, "nextToken(...)");
                            $this$trim$iv = string6;
                            $i$f$trim = false;
                            $this$trim$iv$iv = $this$trim$iv;
                            $i$f$trim2 = false;
                            startIndex$iv$iv = 0;
                            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl3 = match$iv$iv = Intrinsics.compare(it2, 32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            token = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            green = Integer.parseInt(token);
                            String string7 = ((StringTokenizer)st2).nextToken();
                            Intrinsics.checkNotNullExpressionValue(string7, "nextToken(...)");
                            $this$trim$iv = string7;
                            $i$f$trim = false;
                            $this$trim$iv$iv = $this$trim$iv;
                            $i$f$trim2 = false;
                            startIndex$iv$iv = 0;
                            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl4 = match$iv$iv = Intrinsics.compare(it2, 32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            token = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            blue = Integer.parseInt(token);
                            if (tokens == 4) {
                                String string8 = ((StringTokenizer)st2).nextToken();
                                Intrinsics.checkNotNullExpressionValue(string8, "nextToken(...)");
                                $this$trim$iv = string8;
                                $i$f$trim = false;
                                $this$trim$iv$iv = $this$trim$iv;
                                $i$f$trim2 = false;
                                startIndex$iv$iv = 0;
                                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl5 = match$iv$iv = Intrinsics.compare(it2, 32) <= 0;
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                token = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                                alpha = Integer.parseInt(token);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                            String template = string;
                            Object[] objectArray = new Object[]{token};
                            Object[] arguments = objectArray;
                            throw new JuggleExceptionUser("Ball prop color: " + MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                        }
                        temp = new Color(red, green, blue, alpha);
                        break;
                    }
                    default: {
                        throw new JuggleExceptionUser("Ball prop color: " + JugglingLab.INSTANCE.getErrorstrings().getString("Error_token_count"));
                    }
                }
            }
            if (temp != null) {
                this.color = temp;
            } else {
                String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_prop_color");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String template = string;
                st2 = new Object[]{colorstr};
                Object[] arguments = st2;
                throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
            }
        }
        if ((diamstr = pl.getParameter("diam")) != null) {
            try {
                double temp;
                String $this$trim$iv = diamstr;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim3 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl6 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!((temp = JLFunc.jlParseFiniteDouble(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) > 0.0)) {
                    throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_prop_diameter"));
                }
                this.diam = temp;
            }
            catch (NumberFormatException numberFormatException) {
                String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String template = string;
                Object[] objectArray = new Object[]{"diam"};
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser("Ball prop diameter: " + MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
            }
        }
        if ((highlightstr = pl.getParameter("highlight")) != null) {
            this.highlight = Boolean.parseBoolean(highlightstr);
        }
    }

    @Override
    @NotNull
    public Coordinate getMax() {
        return new Coordinate(this.diam / (double)2, 0.0, this.diam / (double)2);
    }

    @Override
    @NotNull
    public Coordinate getMin() {
        return new Coordinate(-this.diam / (double)2, 0.0, -this.diam / (double)2);
    }

    @Override
    public double getWidth() {
        return this.diam;
    }

    @Override
    @Nullable
    public Image getProp2DImage(double zoom, @NotNull double[] camangle) {
        Intrinsics.checkNotNullParameter(camangle, "camangle");
        if (this.ballimage == null || !(zoom == this.lastzoom)) {
            this.recalc2D(zoom);
        }
        return this.ballimage;
    }

    @Override
    @Nullable
    public Dimension getProp2DSize(double zoom) {
        if (this.size == null || !(zoom == this.lastzoom)) {
            this.recalc2D(zoom);
        }
        return this.size;
    }

    @Override
    @Nullable
    public Dimension getProp2DCenter(double zoom) {
        if (this.center == null || !(zoom == this.lastzoom)) {
            this.recalc2D(zoom);
        }
        return this.center;
    }

    @Override
    @Nullable
    public Dimension getProp2DGrip(double zoom) {
        if (this.grip == null || !(zoom == this.lastzoom)) {
            this.recalc2D(zoom);
        }
        return this.grip;
    }

    private final void recalc2D(double zoom) {
        int ballPixelSize = (int)(0.5 + zoom * this.diam);
        ballPixelSize = Math.max(ballPixelSize, 1);
        BufferedImage bufferedImage = this.ballimage = new BufferedImage(ballPixelSize + 1, ballPixelSize + 1, 3);
        Intrinsics.checkNotNull(bufferedImage);
        Graphics2D ballg = bufferedImage.createGraphics();
        if (this.highlight) {
            int i2;
            float highlightOvals = (float)ballPixelSize / 1.2f;
            float[] rgb = new float[]{(float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, (float)this.color.getAlpha() / 255.0f};
            for (i2 = 0; i2 < 3; ++i2) {
                rgb[i2] = rgb[i2] / 2.5f;
            }
            ballg.setColor(new Color(rgb[0], rgb[1], rgb[2], rgb[3]));
            ballg.fillOval(0, 0, ballPixelSize, ballPixelSize);
            i2 = 0;
            while ((float)i2 < highlightOvals) {
                for (int j = 0; j < 3; ++j) {
                    rgb[j] = Math.min(rgb[j] + 1.0f / highlightOvals, 1.0f);
                }
                ballg.setColor(new Color(rgb[0], rgb[1], rgb[2], rgb[3]));
                ballg.fillOval((int)((double)i2 / 1.1), (int)((double)i2 / 2.5), ballPixelSize - (int)((double)i2 * 1.3), ballPixelSize - (int)((double)i2 * 1.3));
                ++i2;
            }
        } else {
            ballg.setColor(this.color);
            ballg.fillOval(0, 0, ballPixelSize, ballPixelSize);
        }
        this.size = new Dimension(ballPixelSize, ballPixelSize);
        this.center = new Dimension(ballPixelSize / 2, ballPixelSize / 2);
        this.grip = new Dimension(ballPixelSize / 2, ballPixelSize / 2);
        this.lastzoom = zoom;
    }

    static {
        Color color = Color.red;
        Intrinsics.checkNotNullExpressionValue(color, "red");
        COLOR_DEF = color;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljugglinglab/prop/BallProp$Companion;", "", "<init>", "()V", "COLOR_DEF", "Ljava/awt/Color;", "COLORNUM_DEF", "", "DIAM_DEF", "", "HIGHLIGHT_DEF", "", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

