/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import jugglinglab.JugglingLab;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\u0012\u0010!\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010\u0016H\u0014J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020\nH\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\nH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001b\u00a8\u0006/"}, d2={"Ljugglinglab/prop/ImageProp;", "Ljugglinglab/prop/Prop;", "<init>", "()V", "url", "Ljava/net/URL;", "image", "Ljava/awt/image/BufferedImage;", "scaledImage", "width", "", "height", "size", "Ljava/awt/Dimension;", "center", "grip", "lastZoom", "loadImage", "", "rescaleImage", "zoom", "type", "", "getType", "()Ljava/lang/String;", "isColorable", "", "()Z", "getEditorColor", "Ljava/awt/Color;", "getParameterDescriptors", "", "Ljugglinglab/util/ParameterDescriptor;", "init", "st", "getProp2DImage", "Ljava/awt/Image;", "camangle", "", "getMax", "Ljugglinglab/util/Coordinate;", "getMin", "getWidth", "getProp2DSize", "getProp2DCenter", "getProp2DGrip", "Companion", "jugglinglab"})
public final class ImageProp
extends Prop {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private URL url;
    @Nullable
    private BufferedImage image;
    @Nullable
    private BufferedImage scaledImage;
    private double width;
    private double height;
    @Nullable
    private Dimension size;
    @Nullable
    private Dimension center;
    @Nullable
    private Dimension grip;
    private double lastZoom;
    @NotNull
    private final String type;
    private final boolean isColorable;
    private static final double WIDTH_DEF = 10.0;
    @Nullable
    private static URL imageUrlDefault = ImageProp.class.getResource("/ball.png");

    public ImageProp() {
        URL uRL = imageUrlDefault;
        if (uRL == null) {
            throw new JuggleExceptionUser("ImageProp error: Default image not set");
        }
        this.url = uRL;
        this.loadImage();
        this.rescaleImage(1.0);
        this.type = "Image";
    }

    private final void loadImage() throws JuggleExceptionUser {
        try {
            MediaTracker mt2 = new MediaTracker(new Component(){});
            this.image = ImageIO.read(this.url);
            mt2.addImage(this.image, 0);
            try {
                mt2.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (mt2.isErrorAny()) {
                this.image = null;
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_bad_file"));
            }
            BufferedImage bufferedImage = this.image;
            Intrinsics.checkNotNull(bufferedImage);
            double d = bufferedImage.getHeight();
            BufferedImage bufferedImage2 = this.image;
            Intrinsics.checkNotNull(bufferedImage2);
            double aspectRatio = d / (double)bufferedImage2.getWidth();
            this.width = 10.0;
            this.height = 10.0 * aspectRatio;
        }
        catch (IOException iOException) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_bad_file"));
        }
        catch (SecurityException securityException) {
            throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_security_restriction"));
        }
    }

    private final void rescaleImage(double zoom) {
        int imagePixelWidth = Math.max((int)(0.5 + zoom * this.width), 1);
        int imagePixelHeight = Math.max((int)(0.5 + zoom * this.height), 1);
        this.size = new Dimension(imagePixelWidth, imagePixelHeight);
        this.center = new Dimension(imagePixelWidth / 2, imagePixelHeight / 2);
        int offsetx = imagePixelWidth / 2;
        int offsety = imagePixelHeight;
        this.grip = new Dimension(offsetx, offsety);
        this.lastZoom = zoom;
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull(bufferedImage);
        BufferedImage bufferedImage2 = this.scaledImage = new BufferedImage(imagePixelWidth, imagePixelHeight, bufferedImage.getType());
        Intrinsics.checkNotNull(bufferedImage2);
        Graphics2D g = bufferedImage2.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        Image image = this.image;
        BufferedImage bufferedImage3 = this.image;
        Intrinsics.checkNotNull(bufferedImage3);
        int n = bufferedImage3.getWidth();
        BufferedImage bufferedImage4 = this.image;
        Intrinsics.checkNotNull(bufferedImage4);
        g.drawImage(image, 0, 0, imagePixelWidth, imagePixelHeight, 0, 0, n, bufferedImage4.getHeight(), null);
        g.dispose();
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isColorable() {
        return this.isColorable;
    }

    @Override
    @NotNull
    public Color getEditorColor() {
        Color color = Color.white;
        Intrinsics.checkNotNullExpressionValue(color, "white");
        return color;
    }

    @Override
    @NotNull
    public List<ParameterDescriptor> getParameterDescriptors() {
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{new ParameterDescriptor("image", 5, null, imageUrlDefault, this.url), new ParameterDescriptor("width", 2, null, 10.0, this.width)};
        return CollectionsKt.listOf(parameterDescriptorArray);
    }

    @Override
    protected void init(@Nullable String st) throws JuggleExceptionUser {
        String widthstr;
        if (st == null) {
            return;
        }
        ParameterList pl = new ParameterList(st);
        String sourcestr = pl.getParameter("image");
        if (sourcestr != null) {
            try {
                this.url = new URI(sourcestr).toURL();
                this.loadImage();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_malformed_URL"));
            }
            catch (MalformedURLException malformedURLException) {
                throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_malformed_URL"));
            }
        }
        if ((widthstr = pl.getParameter("width")) != null) {
            try {
                double temp = JLFunc.jlParseFiniteDouble(widthstr);
                if (!(temp > 0.0)) {
                    throw new NumberFormatException();
                }
                this.width = temp;
                BufferedImage bufferedImage = this.image;
                Intrinsics.checkNotNull(bufferedImage);
                double d = bufferedImage.getHeight(null);
                BufferedImage bufferedImage2 = this.image;
                Intrinsics.checkNotNull(bufferedImage2);
                double aspectRatio = d / (double)bufferedImage2.getWidth(null);
                this.height = this.width * aspectRatio;
            }
            catch (NumberFormatException numberFormatException) {
                String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String template = string;
                Object[] objectArray = new Object[]{"width"};
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
            }
        }
    }

    @Override
    @Nullable
    public Image getProp2DImage(double zoom, @NotNull double[] camangle) {
        Intrinsics.checkNotNullParameter(camangle, "camangle");
        if (!(zoom == this.lastZoom)) {
            this.rescaleImage(zoom);
        }
        return this.scaledImage;
    }

    @Override
    @NotNull
    public Coordinate getMax() {
        return new Coordinate(this.width / (double)2, 0.0, this.width);
    }

    @Override
    @NotNull
    public Coordinate getMin() {
        return new Coordinate(-this.width / (double)2, 0.0, 0.0);
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    @Nullable
    public Dimension getProp2DSize(double zoom) {
        if (this.size == null || !(zoom == this.lastZoom)) {
            this.rescaleImage(zoom);
        }
        return this.size;
    }

    @Override
    @Nullable
    public Dimension getProp2DCenter(double zoom) {
        if (this.center == null || !(zoom == this.lastZoom)) {
            this.rescaleImage(zoom);
        }
        return this.center;
    }

    @Override
    @Nullable
    public Dimension getProp2DGrip(double zoom) {
        if (this.grip == null || !(zoom == this.lastZoom)) {
            this.rescaleImage(zoom);
        }
        return this.grip;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljugglinglab/prop/ImageProp$Companion;", "", "<init>", "()V", "WIDTH_DEF", "", "imageUrlDefault", "Ljava/net/URL;", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

