/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import jugglinglab.JugglingLab;
import jugglinglab.prop.BallProp;
import jugglinglab.prop.ImageProp;
import jugglinglab.prop.RingProp;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0012\u001a\u00020\u0013H&J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H&J\u0012\u0010\u0017\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005H$J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H&J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0019H&J\b\u0010\u001b\u001a\u00020\u001cH&J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H&J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020\u001cH&J\u0012\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020\u001cH&J\u0012\u0010%\u001a\u0004\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020\u001cH&R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\r\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006'"}, d2={"Ljugglinglab/prop/Prop;", "", "<init>", "()V", "initString", "", "getInitString", "()Ljava/lang/String;", "setInitString", "(Ljava/lang/String;)V", "initProp", "", "st", "type", "getType", "isColorable", "", "()Z", "getEditorColor", "Ljava/awt/Color;", "getParameterDescriptors", "", "Ljugglinglab/util/ParameterDescriptor;", "init", "getMax", "Ljugglinglab/util/Coordinate;", "getMin", "getWidth", "", "getProp2DImage", "Ljava/awt/Image;", "zoom", "camangle", "", "getProp2DSize", "Ljava/awt/Dimension;", "getProp2DCenter", "getProp2DGrip", "Companion", "jugglinglab"})
public abstract class Prop {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String initString;
    @JvmField
    @NotNull
    public static final List<String> builtinProps;
    @NotNull
    private static final List<String> COLOR_NAMES;
    @NotNull
    private static final List<Color> COLOR_VALS;
    @NotNull
    private static final List<String> COLOR_MIXED;

    @Nullable
    protected final String getInitString() {
        return this.initString;
    }

    protected final void setInitString(@Nullable String string) {
        this.initString = string;
    }

    public final void initProp(@Nullable String st) throws JuggleExceptionUser {
        this.initString = st;
        this.init(st);
    }

    @NotNull
    public abstract String getType();

    public abstract boolean isColorable();

    @NotNull
    public abstract Color getEditorColor();

    @NotNull
    public abstract List<ParameterDescriptor> getParameterDescriptors();

    protected abstract void init(@Nullable String var1) throws JuggleExceptionUser;

    @Nullable
    public abstract Coordinate getMax();

    @Nullable
    public abstract Coordinate getMin();

    public abstract double getWidth();

    @Nullable
    public abstract Image getProp2DImage(double var1, @NotNull double[] var3);

    @Nullable
    public abstract Dimension getProp2DSize(double var1);

    @Nullable
    public abstract Dimension getProp2DCenter(double var1);

    @Nullable
    public abstract Dimension getProp2DGrip(double var1);

    @JvmStatic
    @NotNull
    public static final Prop newProp(@NotNull String type) throws JuggleExceptionUser {
        return Companion.newProp(type);
    }

    static {
        Object[] objectArray = new String[]{"Ball", "Image", "Ring"};
        builtinProps = CollectionsKt.listOf(objectArray);
        objectArray = new String[]{"transparent", "black", "blue", "cyan", "gray", "green", "magenta", "orange", "pink", "red", "white", "yellow"};
        COLOR_NAMES = CollectionsKt.listOf(objectArray);
        objectArray = new Color[12];
        objectArray[0] = new Color(0, 0, 0, 0);
        Intrinsics.checkNotNullExpressionValue(Color.black, "black");
        Intrinsics.checkNotNullExpressionValue(Color.blue, "blue");
        Intrinsics.checkNotNullExpressionValue(Color.cyan, "cyan");
        Intrinsics.checkNotNullExpressionValue(Color.gray, "gray");
        Intrinsics.checkNotNullExpressionValue(Color.green, "green");
        Intrinsics.checkNotNullExpressionValue(Color.magenta, "magenta");
        Intrinsics.checkNotNullExpressionValue(Color.orange, "orange");
        Intrinsics.checkNotNullExpressionValue(Color.pink, "pink");
        Intrinsics.checkNotNullExpressionValue(Color.red, "red");
        Intrinsics.checkNotNullExpressionValue(Color.white, "white");
        Intrinsics.checkNotNullExpressionValue(Color.yellow, "yellow");
        COLOR_VALS = CollectionsKt.listOf(objectArray);
        objectArray = new String[]{"red", "green", "blue", "yellow", "cyan", "magenta", "orange", "pink", "gray", "black"};
        COLOR_MIXED = CollectionsKt.listOf(objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0012"}, d2={"Ljugglinglab/prop/Prop$Companion;", "", "<init>", "()V", "builtinProps", "", "", "newProp", "Ljugglinglab/prop/Prop;", "type", "COLOR_NAMES", "getCOLOR_NAMES", "()Ljava/util/List;", "COLOR_VALS", "Ljava/awt/Color;", "getCOLOR_VALS", "COLOR_MIXED", "getCOLOR_MIXED", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Prop newProp(@NotNull String type) throws JuggleExceptionUser {
            Intrinsics.checkNotNullParameter(type, "type");
            if (StringsKt.equals(type, "ball", true)) {
                return new BallProp();
            }
            if (StringsKt.equals(type, "image", true)) {
                return new ImageProp();
            }
            if (StringsKt.equals(type, "ring", true)) {
                return new RingProp();
            }
            String template = JugglingLab.INSTANCE.getErrorstrings().getString("Error_prop_type");
            Object[] objectArray = new Object[]{type};
            Object[] arguments = objectArray;
            throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
        }

        @NotNull
        public final List<String> getCOLOR_NAMES() {
            return COLOR_NAMES;
        }

        @NotNull
        public final List<Color> getCOLOR_VALS() {
            return COLOR_VALS;
        }

        @NotNull
        public final List<String> getCOLOR_MIXED() {
            return COLOR_MIXED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

