/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import jugglinglab.JugglingLab;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 12\u00020\u0001:\u00011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001e\u001a\u00020\bH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0018H\u0014J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020\u0005H\u0016J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u000fH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010\u00112\u0006\u0010+\u001a\u00020\u0005H\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010\u00112\u0006\u0010+\u001a\u00020\u0005H\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010\u00112\u0006\u0010+\u001a\u00020\u0005H\u0016J\u0018\u00100\u001a\u00020#2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001d\u00a8\u00062"}, d2={"Ljugglinglab/prop/RingProp;", "Ljugglinglab/prop/Prop;", "<init>", "()V", "outsideDiam", "", "insideDiam", "color", "Ljava/awt/Color;", "colornum", "", "image", "Ljava/awt/image/BufferedImage;", "lastzoom", "lastcamangle", "", "size", "Ljava/awt/Dimension;", "center", "grip", "px", "", "py", "type", "", "getType", "()Ljava/lang/String;", "isColorable", "", "()Z", "getEditorColor", "getParameterDescriptors", "", "Ljugglinglab/util/ParameterDescriptor;", "init", "", "st", "getMax", "Ljugglinglab/util/Coordinate;", "getMin", "getWidth", "getProp2DImage", "Ljava/awt/Image;", "zoom", "camangle", "getProp2DSize", "getProp2DCenter", "getProp2DGrip", "redrawImage", "Companion", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nRingProp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RingProp.kt\njugglinglab/prop/RingProp\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,336:1\n1#2:337\n106#3:338\n78#3,22:339\n106#3:361\n78#3,22:362\n106#3:384\n78#3,22:385\n106#3:407\n78#3,22:408\n*S KotlinDebug\n*F\n+ 1 RingProp.kt\njugglinglab/prop/RingProp\n*L\n114#1:338\n114#1:339,22\n116#1:361\n116#1:362,22\n118#1:384\n118#1:385,22\n121#1:407\n121#1:408,22\n*E\n"})
public final class RingProp
extends Prop {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double outsideDiam = 25.0;
    private double insideDiam = 20.0;
    @NotNull
    private Color color = COLOR_DEF;
    private int colornum = 9;
    @Nullable
    private BufferedImage image;
    private double lastzoom;
    @NotNull
    private double[] lastcamangle;
    @Nullable
    private Dimension size;
    @Nullable
    private Dimension center;
    @Nullable
    private Dimension grip;
    private int[] px;
    private int[] py;
    @NotNull
    private final String type;
    private final boolean isColorable;
    @NotNull
    private static final Color COLOR_DEF;
    private static final int COLORNUM_DEF = 9;
    private static final double OUTSIDE_DIAM_DEF = 25.0;
    private static final double INSIDE_DIAM_DEF = 20.0;
    private static final int POLYSIDES = 200;

    public RingProp() {
        double[] dArray = new double[]{0.0, 0.0};
        this.lastcamangle = dArray;
        this.type = "Ring";
        this.isColorable = true;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isColorable() {
        return this.isColorable;
    }

    @Override
    @NotNull
    public Color getEditorColor() {
        return this.color;
    }

    @Override
    @NotNull
    public List<ParameterDescriptor> getParameterDescriptors() {
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{new ParameterDescriptor("color", 3, Prop.Companion.getCOLOR_NAMES(), Prop.Companion.getCOLOR_NAMES().get(9), Prop.Companion.getCOLOR_NAMES().get(this.colornum)), new ParameterDescriptor("outside", 2, null, 25.0, this.outsideDiam), new ParameterDescriptor("inside", 2, null, 20.0, this.insideDiam)};
        return CollectionsKt.listOf(parameterDescriptorArray);
    }

    @Override
    protected void init(@Nullable String st) throws JuggleExceptionUser {
        String insidestr;
        String outsidestr;
        this.px = new int[200];
        this.py = new int[200];
        if (st == null) {
            return;
        }
        ParameterList pl = new ParameterList(st);
        String colorstr = pl.getParameter("color");
        if (colorstr != null) {
            Object st2;
            Color temp = null;
            if (StringsKt.indexOf$default((CharSequence)colorstr, ',', 0, false, 6, null) == -1) {
                int n = ((Collection)Prop.Companion.getCOLOR_NAMES()).size();
                for (int i2 = 0; i2 < n; ++i2) {
                    if (!StringsKt.equals(Prop.Companion.getCOLOR_NAMES().get(i2), colorstr, true)) continue;
                    temp = Prop.Companion.getCOLOR_VALS().get(i2);
                    this.colornum = i2;
                    break;
                }
            } else {
                int it;
                int n;
                Object str = colorstr;
                int pos = 0;
                while (true) {
                    String string = str;
                    Intrinsics.checkNotNull(string);
                    it = n = StringsKt.indexOf$default((CharSequence)string, '{', 0, false, 6, null);
                    boolean bl = false;
                    pos = it;
                    if (n < 0) break;
                    String string2 = StringsKt.take((String)str, pos);
                    String string3 = ((String)str).substring(pos + 1);
                    Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                    str = string2 + string3;
                }
                while (true) {
                    String string = str;
                    Intrinsics.checkNotNull(string);
                    it = n = StringsKt.indexOf$default((CharSequence)string, '}', 0, false, 6, null);
                    boolean bl = false;
                    pos = it;
                    if (n < 0) break;
                    String string4 = StringsKt.take((String)str, pos);
                    String string5 = ((String)str).substring(pos + 1);
                    Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                    str = string4 + string5;
                }
                st2 = new StringTokenizer((String)str, ",", false);
                int tokens = ((StringTokenizer)st2).countTokens();
                switch (tokens) {
                    case 3: 
                    case 4: {
                        int red = 0;
                        int green = 0;
                        int blue = 0;
                        int alpha = 255;
                        String token = null;
                        try {
                            boolean match$iv$iv;
                            char it2;
                            int index$iv$iv;
                            String string = ((StringTokenizer)st2).nextToken();
                            Intrinsics.checkNotNullExpressionValue(string, "nextToken(...)");
                            String $this$trim$iv = string;
                            boolean $i$f$trim = false;
                            CharSequence $this$trim$iv$iv = $this$trim$iv;
                            boolean $i$f$trim2 = false;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl2 = match$iv$iv = Intrinsics.compare(it2, 32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            token = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            red = Integer.parseInt(token);
                            String string6 = ((StringTokenizer)st2).nextToken();
                            Intrinsics.checkNotNullExpressionValue(string6, "nextToken(...)");
                            $this$trim$iv = string6;
                            $i$f$trim = false;
                            $this$trim$iv$iv = $this$trim$iv;
                            $i$f$trim2 = false;
                            startIndex$iv$iv = 0;
                            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl3 = match$iv$iv = Intrinsics.compare(it2, 32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            token = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            green = Integer.parseInt(token);
                            String string7 = ((StringTokenizer)st2).nextToken();
                            Intrinsics.checkNotNullExpressionValue(string7, "nextToken(...)");
                            $this$trim$iv = string7;
                            $i$f$trim = false;
                            $this$trim$iv$iv = $this$trim$iv;
                            $i$f$trim2 = false;
                            startIndex$iv$iv = 0;
                            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl4 = match$iv$iv = Intrinsics.compare(it2, 32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            token = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            blue = Integer.parseInt(token);
                            if (tokens == 4) {
                                String string8 = ((StringTokenizer)st2).nextToken();
                                Intrinsics.checkNotNullExpressionValue(string8, "nextToken(...)");
                                $this$trim$iv = string8;
                                $i$f$trim = false;
                                $this$trim$iv$iv = $this$trim$iv;
                                $i$f$trim2 = false;
                                startIndex$iv$iv = 0;
                                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl5 = match$iv$iv = Intrinsics.compare(it2, 32) <= 0;
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                token = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                                alpha = Integer.parseInt(token);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                            String template = string;
                            Object[] objectArray = new Object[]{token};
                            Object[] arguments = objectArray;
                            throw new JuggleExceptionUser("Ring prop color: " + MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
                        }
                        temp = new Color(red, green, blue, alpha);
                        break;
                    }
                    default: {
                        throw new JuggleExceptionUser("Ring prop color: " + JugglingLab.INSTANCE.getErrorstrings().getString("Error_token_count"));
                    }
                }
            }
            if (temp != null) {
                this.color = temp;
            } else {
                String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_prop_color");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String template = string;
                st2 = new Object[]{colorstr};
                Object[] arguments = st2;
                throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
            }
        }
        if ((outsidestr = pl.getParameter("outside")) != null) {
            try {
                double temp = JLFunc.jlParseFiniteDouble(outsidestr);
                if (!(temp > 0.0)) {
                    throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_prop_diameter"));
                }
                this.outsideDiam = temp;
            }
            catch (NumberFormatException numberFormatException) {
                String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String template = string;
                Object[] tokens = new Object[]{"diam"};
                Object[] arguments = tokens;
                throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
            }
        }
        if ((insidestr = pl.getParameter("inside")) != null) {
            try {
                double temp = JLFunc.jlParseFiniteDouble(insidestr);
                if (!(temp > 0.0)) {
                    throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_prop_diameter"));
                }
                this.insideDiam = temp;
            }
            catch (NumberFormatException numberFormatException) {
                String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_number_format");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String template = string;
                Object[] objectArray = new Object[]{"diam"};
                Object[] arguments = objectArray;
                throw new JuggleExceptionUser(MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)));
            }
        }
    }

    @Override
    @NotNull
    public Coordinate getMax() {
        return new Coordinate(this.outsideDiam / (double)2, 0.0, this.outsideDiam / (double)2);
    }

    @Override
    @NotNull
    public Coordinate getMin() {
        return new Coordinate(-this.outsideDiam / (double)2, 0.0, -this.outsideDiam / (double)2);
    }

    @Override
    public double getWidth() {
        return 0.05 * this.outsideDiam;
    }

    @Override
    @Nullable
    public Image getProp2DImage(double zoom, @NotNull double[] camangle) {
        Intrinsics.checkNotNullParameter(camangle, "camangle");
        if (!(this.image != null && zoom == this.lastzoom && camangle[0] == this.lastcamangle[0] && camangle[1] == this.lastcamangle[1])) {
            this.redrawImage(zoom, camangle);
        }
        return this.image;
    }

    @Override
    @Nullable
    public Dimension getProp2DSize(double zoom) {
        if (this.size == null || !(zoom == this.lastzoom)) {
            this.redrawImage(zoom, this.lastcamangle);
        }
        return this.size;
    }

    @Override
    @Nullable
    public Dimension getProp2DCenter(double zoom) {
        if (this.center == null || !(zoom == this.lastzoom)) {
            this.redrawImage(zoom, this.lastcamangle);
        }
        return this.center;
    }

    @Override
    @Nullable
    public Dimension getProp2DGrip(double zoom) {
        if (this.grip == null || !(zoom == this.lastzoom)) {
            this.redrawImage(zoom, this.lastcamangle);
        }
        return this.grip;
    }

    private final void redrawImage(double zoom, double[] camangle) {
        double d;
        double term1;
        double angle;
        int insideHeight;
        int outsidePixelDiam = (int)(0.5 + zoom * this.outsideDiam);
        int insidePixelDiam = (int)(0.5 + zoom * this.insideDiam);
        double c0 = Math.cos(camangle[0]);
        double s0 = Math.sin(camangle[0]);
        double s1 = Math.sin(camangle[1]);
        int width = Math.max(2, (int)((double)outsidePixelDiam * Math.abs(s0 * s1)));
        int height = Math.max(2, outsidePixelDiam);
        int insideWidth = (int)((double)insidePixelDiam * Math.abs(s0 * s1));
        if (insideWidth == width) {
            insideWidth -= 2;
        }
        if ((insideHeight = insidePixelDiam) == height) {
            insideHeight -= 2;
        }
        double d2 = angle = (term1 = Math.sqrt(c0 * c0 / (1.0 - s0 * s0 * s1 * s1))) < 1.0 ? Math.acos(term1) : 0.0;
        if (c0 * s0 > 0.0) {
            angle = -angle;
        }
        double sa = Math.sin(angle);
        double ca = Math.cos(angle);
        int pxmin = 0;
        int pxmax = 0;
        int pymin = 0;
        int pymax = 0;
        for (int i2 = 0; i2 < 200; ++i2) {
            block40: {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    double theta = (double)i2 * (double)2 * Math.PI / 200.0;
                                    double x = (double)width * Math.cos(theta) * 0.5;
                                    double y = (double)height * Math.sin(theta) * 0.5;
                                    int[] nArray = this.px;
                                    if (this.px == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException("px");
                                        nArray = null;
                                    }
                                    nArray[i2] = (int)(ca * x - sa * y + 0.5);
                                    int[] nArray2 = this.py;
                                    if (this.py == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException("py");
                                        nArray2 = null;
                                    }
                                    nArray2[i2] = (int)(ca * y + sa * x + 0.5);
                                    if (i2 == 0) break block35;
                                    int[] nArray3 = this.px;
                                    if (this.px == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException("px");
                                        nArray3 = null;
                                    }
                                    if (nArray3[i2] >= pxmin) break block36;
                                }
                                int[] nArray = this.px;
                                if (this.px == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("px");
                                    nArray = null;
                                }
                                pxmin = nArray[i2];
                            }
                            if (i2 == 0) break block37;
                            int[] nArray = this.px;
                            if (this.px == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("px");
                                nArray = null;
                            }
                            if (nArray[i2] <= pxmax) break block38;
                        }
                        int[] nArray = this.px;
                        if (this.px == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("px");
                            nArray = null;
                        }
                        pxmax = nArray[i2];
                    }
                    if (i2 == 0) break block39;
                    int[] nArray = this.py;
                    if (this.py == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("py");
                        nArray = null;
                    }
                    if (nArray[i2] >= pymin) break block40;
                }
                int[] nArray = this.py;
                if (this.py == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("py");
                    nArray = null;
                }
                pymin = nArray[i2];
            }
            if (i2 != 0) {
                int[] nArray = this.py;
                if (this.py == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("py");
                    nArray = null;
                }
                if (nArray[i2] <= pymax) continue;
            }
            int[] nArray = this.py;
            if (this.py == null) {
                Intrinsics.throwUninitializedPropertyAccessException("py");
                nArray = null;
            }
            pymax = nArray[i2];
        }
        int bbwidth = pxmax - pxmin + 1;
        int bbheight = pymax - pymin + 1;
        this.size = new Dimension(bbwidth, bbheight);
        BufferedImage bufferedImage = this.image = new BufferedImage(bbwidth, bbheight, 3);
        Intrinsics.checkNotNull(bufferedImage);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(this.color);
        int i3 = 0;
        while (i3 < 200) {
            int[] nArray = this.px;
            if (this.px == null) {
                Intrinsics.throwUninitializedPropertyAccessException("px");
                nArray = null;
            }
            int[] nArray4 = nArray;
            int n = i3;
            nArray4[n] = nArray4[n] - pxmin;
            int[] nArray5 = this.py;
            if (this.py == null) {
                Intrinsics.throwUninitializedPropertyAccessException("py");
                nArray5 = null;
            }
            nArray4 = nArray5;
            n = i3++;
            nArray4[n] = nArray4[n] - pymin;
        }
        int[] nArray = this.px;
        if (this.px == null) {
            Intrinsics.throwUninitializedPropertyAccessException("px");
            nArray = null;
        }
        int[] nArray6 = this.py;
        if (this.py == null) {
            Intrinsics.throwUninitializedPropertyAccessException("py");
            nArray6 = null;
        }
        g.fillPolygon(nArray, nArray6, 200);
        g.setComposite(AlphaComposite.Src);
        g.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        for (i3 = 0; i3 < 200; ++i3) {
            double theta = (double)i3 * 2.0 * Math.PI / 200.0;
            double x = (double)insideWidth * Math.cos(theta) * 0.5;
            double y = (double)insideHeight * Math.sin(theta) * 0.5;
            int[] nArray7 = this.px;
            if (this.px == null) {
                Intrinsics.throwUninitializedPropertyAccessException("px");
                nArray7 = null;
            }
            nArray7[i3] = (int)(ca * x - sa * y + 0.5) - pxmin;
            int[] nArray8 = this.py;
            if (this.py == null) {
                Intrinsics.throwUninitializedPropertyAccessException("py");
                nArray8 = null;
            }
            nArray8[i3] = (int)(ca * y + sa * x + 0.5) - pymin;
        }
        int[] nArray9 = this.px;
        if (this.px == null) {
            Intrinsics.throwUninitializedPropertyAccessException("px");
            nArray9 = null;
        }
        int[] nArray10 = this.py;
        if (this.py == null) {
            Intrinsics.throwUninitializedPropertyAccessException("py");
            nArray10 = null;
        }
        g.fillPolygon(nArray9, nArray10, 200);
        this.center = new Dimension(bbwidth / 2, bbheight / 2);
        int gripx = s0 < 0.0 ? bbwidth - 1 : 0;
        double bbw = sa * sa + ca * ca * Math.abs(s0 * s1);
        double dsq = s0 * s0 * s1 * s1 * ca * ca + sa * sa - bbw * bbw;
        double d3 = d = dsq > 0.0 ? Math.sqrt(dsq) : 0.0;
        if (c0 > 0.0) {
            d = -d;
        }
        int gripy = (int)((double)outsidePixelDiam * d) + bbheight / 2;
        this.grip = new Dimension(gripx, gripy);
        this.lastzoom = zoom;
        double[] dArray = new double[]{camangle[0], camangle[1]};
        this.lastcamangle = dArray;
    }

    static {
        Color color = Color.red;
        Intrinsics.checkNotNullExpressionValue(color, "red");
        COLOR_DEF = color;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljugglinglab/prop/RingProp$Companion;", "", "<init>", "()V", "COLOR_DEF", "Ljava/awt/Color;", "COLORNUM_DEF", "", "OUTSIDE_DIAM_DEF", "", "INSIDE_DIAM_DEF", "POLYSIDES", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

