/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.renderer;

import jugglinglab.renderer.JLMatrix;
import jugglinglab.util.Coordinate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\bJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u001a"}, d2={"Ljugglinglab/renderer/JLVector;", "", "<init>", "()V", "xpos", "", "ypos", "zpos", "(DDD)V", "x", "getX", "()D", "setX", "(D)V", "y", "getY", "setY", "z", "getZ", "setZ", "length", "getLength", "transform", "m", "Ljugglinglab/renderer/JLMatrix;", "Companion", "jugglinglab"})
public final class JLVector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;
    private double z;

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public JLVector() {
    }

    public JLVector(double xpos, double ypos, double zpos) {
        this.x = xpos;
        this.y = ypos;
        this.z = zpos;
    }

    public final double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @NotNull
    public final JLVector transform(@NotNull JLMatrix m) {
        Intrinsics.checkNotNullParameter(m, "m");
        double newx = this.x * m.getM00() + this.y * m.getM01() + this.z * m.getM02() + m.getM03();
        double newy = this.x * m.getM10() + this.y * m.getM11() + this.z * m.getM12() + m.getM13();
        double newz = this.x * m.getM20() + this.y * m.getM21() + this.z * m.getM22() + m.getM23();
        return new JLVector(newx, newy, newz);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"Ljugglinglab/renderer/JLVector$Companion;", "", "<init>", "()V", "add", "Ljugglinglab/renderer/JLVector;", "a", "b", "sub", "scale", "f", "", "fromCoordinate", "c", "Ljugglinglab/util/Coordinate;", "result", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JLVector add(@NotNull JLVector a, @NotNull JLVector b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return new JLVector(a.getX() + b.getX(), a.getY() + b.getY(), a.getZ() + b.getZ());
        }

        @NotNull
        public final JLVector sub(@NotNull JLVector a, @NotNull JLVector b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return new JLVector(a.getX() - b.getX(), a.getY() - b.getY(), a.getZ() - b.getZ());
        }

        @NotNull
        public final JLVector scale(double f, @NotNull JLVector a) {
            Intrinsics.checkNotNullParameter(a, "a");
            return new JLVector(f * a.getX(), f * a.getY(), f * a.getZ());
        }

        @NotNull
        public final JLVector fromCoordinate(@NotNull Coordinate c, @NotNull JLVector result) {
            Intrinsics.checkNotNullParameter(c, "c");
            Intrinsics.checkNotNullParameter(result, "result");
            result.setX(c.getX());
            result.setY(c.getZ());
            result.setZ(c.getY());
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

