/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.renderer;

import jugglinglab.jml.JMLPattern;
import jugglinglab.renderer.JLVector;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0014\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f0\u001f\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ljugglinglab/renderer/Juggler;", "", "<init>", "()V", "SHOULDER_HW", "", "SHOULDER_H", "WAIST_HW", "WAIST_H", "HAND_OUT", "HAND_IN", "HEAD_HW", "HEAD_H", "NECK_H", "SHOULDER_Y", "PATTERN_Y", "UPPER_LENGTH", "LOWER_LENGTH", "LOWER_GAP_WRIST", "LOWER_GAP_ELBOW", "LOWER_HAND_HEIGHT", "UPPER_GAP_ELBOW", "UPPER_GAP_SHOULDER", "LOWER_TOTAL", "UPPER_TOTAL", "findJugglerCoordinates", "", "pat", "Ljugglinglab/jml/JMLPattern;", "time", "result", "", "Ljugglinglab/renderer/JLVector;", "(Ljugglinglab/jml/JMLPattern;D[[Ljugglinglab/renderer/JLVector;)V", "jugglinglab"})
public final class Juggler {
    @NotNull
    public static final Juggler INSTANCE = new Juggler();
    public static final double SHOULDER_HW = 23.0;
    public static final double SHOULDER_H = 40.0;
    public static final double WAIST_HW = 17.0;
    public static final double WAIST_H = -5.0;
    public static final double HAND_OUT = 5.0;
    public static final double HAND_IN = 5.0;
    public static final double HEAD_HW = 10.0;
    public static final double HEAD_H = 26.0;
    public static final double NECK_H = 5.0;
    public static final double SHOULDER_Y = 0.0;
    public static final double PATTERN_Y = 30.0;
    public static final double UPPER_LENGTH = 41.0;
    public static final double LOWER_LENGTH = 40.0;
    public static final double LOWER_GAP_WRIST = 1.0;
    public static final double LOWER_GAP_ELBOW = 0.0;
    public static final double LOWER_HAND_HEIGHT = 0.0;
    public static final double UPPER_GAP_ELBOW = 0.0;
    public static final double UPPER_GAP_SHOULDER = 0.0;
    public static final double LOWER_TOTAL = 41.0;
    public static final double UPPER_TOTAL = 41.0;

    private Juggler() {
    }

    public final void findJugglerCoordinates(@NotNull JMLPattern pat, double time, @NotNull JLVector[][] result) throws JuggleExceptionInternal {
        Intrinsics.checkNotNullParameter(pat, "pat");
        Intrinsics.checkNotNullParameter(result, "result");
        int juggler = 1;
        int n = pat.getNumberOfJugglers();
        if (juggler <= n) {
            while (true) {
                Coordinate coord0 = new Coordinate(0.0, 0.0, 0.0, 7, null);
                Coordinate coord1 = new Coordinate(0.0, 0.0, 0.0, 7, null);
                Coordinate coord2 = new Coordinate(0.0, 0.0, 0.0, 7, null);
                pat.getHandCoordinate(juggler, 1, time, coord0);
                pat.getHandCoordinate(juggler, 2, time, coord1);
                JLVector lefthand = new JLVector(coord0.getX(), coord0.getZ() + 0.0, coord0.getY());
                JLVector righthand = new JLVector(coord1.getX(), coord1.getZ() + 0.0, coord1.getY());
                pat.getJugglerPosition(juggler, time, coord2);
                double angle = Math.toRadians(pat.getJugglerAngle(juggler, time));
                double s = Math.sin(angle);
                double c = Math.cos(angle);
                JLVector leftshoulder = new JLVector(coord2.getX() - 23.0 * c - 0.0 * s, coord2.getZ() + 40.0, coord2.getY() - 23.0 * s + 0.0 * c);
                JLVector rightshoulder = new JLVector(coord2.getX() + 23.0 * c - 0.0 * s, coord2.getZ() + 40.0, coord2.getY() + 23.0 * s + 0.0 * c);
                JLVector leftwaist = new JLVector(coord2.getX() - 17.0 * c - 0.0 * s, coord2.getZ() + -5.0, coord2.getY() - 17.0 * s + 0.0 * c);
                JLVector rightwaist = new JLVector(coord2.getX() + 17.0 * c - 0.0 * s, coord2.getZ() + -5.0, coord2.getY() + 17.0 * s + 0.0 * c);
                JLVector leftheadbottom = new JLVector(coord2.getX() - 10.0 * c - 0.0 * s, coord2.getZ() + 40.0 + 5.0, coord2.getY() - 10.0 * s + 0.0 * c);
                JLVector leftheadtop = new JLVector(coord2.getX() - 10.0 * c - 0.0 * s, coord2.getZ() + 40.0 + 5.0 + 26.0, coord2.getY() - 10.0 * s + 0.0 * c);
                JLVector rightheadbottom = new JLVector(coord2.getX() + 10.0 * c - 0.0 * s, coord2.getZ() + 40.0 + 5.0, coord2.getY() + 10.0 * s + 0.0 * c);
                JLVector rightheadtop = new JLVector(coord2.getX() + 10.0 * c - 0.0 * s, coord2.getZ() + 40.0 + 5.0 + 26.0, coord2.getY() + 10.0 * s + 0.0 * c);
                double L = 41.0;
                double U = 41.0;
                JLVector deltaL = JLVector.Companion.sub(lefthand, leftshoulder);
                double D = deltaL.getLength();
                JLVector leftelbow = null;
                if (D <= L + U) {
                    double Lr = Math.sqrt((4.0 * U * U * L * L - (U * U + L * L - D * D) * (U * U + L * L - D * D)) / (4.0 * D * D));
                    if (Double.isNaN(Lr)) {
                        throw new JuggleExceptionInternal("NaN in renderer 1");
                    }
                    double factor = Math.sqrt(U * U - Lr * Lr) / D;
                    if (Double.isNaN(factor)) {
                        throw new JuggleExceptionInternal("NaN in renderer 2");
                    }
                    JLVector Lxsc = JLVector.Companion.scale(factor, deltaL);
                    double Lalpha = Math.asin(deltaL.getY() / D);
                    if (Double.isNaN(Lalpha)) {
                        throw new JuggleExceptionInternal("NaN in renderer 3");
                    }
                    factor = 1.0 + Lr * Math.tan(Lalpha) / (factor * D);
                    leftelbow = new JLVector(leftshoulder.getX() + Lxsc.getX() * factor, leftshoulder.getY() + Lxsc.getY() - Lr * Math.cos(Lalpha), leftshoulder.getZ() + Lxsc.getZ() * factor);
                }
                JLVector deltaR = JLVector.Companion.sub(righthand, rightshoulder);
                D = deltaR.getLength();
                JLVector rightelbow = null;
                if (D <= L + U) {
                    double Rr = Math.sqrt((4.0 * U * U * L * L - (U * U + L * L - D * D) * (U * U + L * L - D * D)) / (4.0 * D * D));
                    if (Double.isNaN(Rr)) {
                        throw new JuggleExceptionInternal("NaN in renderer 4");
                    }
                    double factor = Math.sqrt(U * U - Rr * Rr) / D;
                    if (Double.isNaN(factor)) {
                        throw new JuggleExceptionInternal("NaN in renderer 5");
                    }
                    JLVector Rxsc = JLVector.Companion.scale(factor, deltaR);
                    double Ralpha = Math.asin(deltaR.getY() / D);
                    if (Double.isNaN(Ralpha)) {
                        throw new JuggleExceptionInternal("NaN in renderer 6");
                    }
                    factor = 1.0 + Rr * Math.tan(Ralpha) / (factor * D);
                    rightelbow = new JLVector(rightshoulder.getX() + Rxsc.getX() * factor, rightshoulder.getY() + Rxsc.getY() - Rr * Math.cos(Ralpha), rightshoulder.getZ() + Rxsc.getZ() * factor);
                }
                result[juggler - 1][0] = lefthand;
                result[juggler - 1][1] = righthand;
                result[juggler - 1][2] = leftshoulder;
                result[juggler - 1][3] = rightshoulder;
                result[juggler - 1][4] = leftelbow;
                result[juggler - 1][5] = rightelbow;
                result[juggler - 1][6] = leftwaist;
                result[juggler - 1][7] = rightwaist;
                result[juggler - 1][8] = leftheadbottom;
                result[juggler - 1][9] = leftheadtop;
                result[juggler - 1][10] = rightheadbottom;
                result[juggler - 1][11] = rightheadtop;
                if (juggler == n) break;
                ++juggler;
            }
        }
    }
}

