/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jugglinglab.jml.JMLPattern;
import jugglinglab.prop.Prop;
import jugglinglab.renderer.JLMatrix;
import jugglinglab.renderer.JLVector;
import jugglinglab.renderer.Juggler;
import jugglinglab.renderer.Renderer;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 T2\u00020\u0001:\u0002STB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010,\u001a\u00020\u0005H\u0016J(\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020'2\u0006\u00102\u001a\u00020'H\u0016J\b\u00103\u001a\u00020\u0014H\u0016J\u0010\u00104\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u00105\u001a\u00020+H\u0002J\u0010\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020'H\u0016J\u0010\u0010<\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020\u0007H\u0002J\u0018\u0010?\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0007H\u0002J \u0010A\u001a\u00020'2\u0006\u0010=\u001a\u00020'2\u0006\u0010B\u001a\u00020\r2\u0006\u0010C\u001a\u00020\rH\u0016J*\u0010D\u001a\u00020+2\u0006\u0010E\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u001d2\b\u0010G\u001a\u0004\u0018\u00010\u001d2\u0006\u0010H\u001a\u00020IH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070$0$X\u0082.\u00a2\u0006\u0004\n\u0002\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00107\u001a\u00020\t2\u0006\u00106\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0014\u0010J\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0014\u0010M\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010LR\u0014\u0010O\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010LR\u0014\u0010Q\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010L\u00a8\u0006U"}, d2={"Ljugglinglab/renderer/Renderer2D;", "Ljugglinglab/renderer/Renderer;", "<init>", "()V", "background", "Ljava/awt/Color;", "cameracenter", "Ljugglinglab/renderer/JLVector;", "cameraangle", "", "m", "Ljugglinglab/renderer/JLMatrix;", "width", "", "height", "viewport", "Ljava/awt/Rectangle;", "pat", "Ljugglinglab/jml/JMLPattern;", "zoom", "", "zoomOrig", "zoomfactor", "originx", "originz", "polysides", "headcos", "headsin", "headx", "", "heady", "obj", "", "Ljugglinglab/renderer/Renderer2D$DrawObject2D;", "obj2", "jugglervec", "", "[[Ljugglinglab/renderer/JLVector;", "tempc", "Ljugglinglab/util/Coordinate;", "tempv1", "tempv2", "setPattern", "", "getBackground", "initDisplay", "dim", "Ljava/awt/Dimension;", "border", "overallmax", "overallmin", "getZoomLevel", "setZoomLevel", "calculateCameraMatrix", "camangle", "cameraAngle", "getCameraAngle", "()[D", "setCameraAngle", "([D)V", "getXY", "coord", "vec", "getXYZ", "result", "getScreenTranslatedCoordinate", "dx", "dy", "drawFrame", "time", "pnum", "hideJugglers", "g", "Ljava/awt/Graphics;", "handWindowMax", "getHandWindowMax", "()Ljugglinglab/util/Coordinate;", "handWindowMin", "getHandWindowMin", "jugglerWindowMax", "getJugglerWindowMax", "jugglerWindowMin", "getJugglerWindowMin", "DrawObject2D", "Companion", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nRenderer2D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Renderer2D.kt\njugglinglab/renderer/Renderer2D\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,823:1\n1#2:824\n*E\n"})
public final class Renderer2D
extends Renderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Color background;
    @Nullable
    private JLVector cameracenter;
    @NotNull
    private double[] cameraangle;
    @NotNull
    private JLMatrix m;
    private int width;
    private int height;
    @Nullable
    private Rectangle viewport;
    private JMLPattern pat;
    private double zoom;
    private double zoomOrig;
    private double zoomfactor;
    private int originx;
    private int originz;
    private int polysides;
    @NotNull
    private double[] headcos;
    @NotNull
    private double[] headsin;
    @NotNull
    private int[] headx;
    @NotNull
    private int[] heady;
    private List<DrawObject2D> obj;
    private List<DrawObject2D> obj2;
    private JLVector[][] jugglervec;
    @NotNull
    private Coordinate tempc;
    @NotNull
    private JLVector tempv1;
    @NotNull
    private JLVector tempv2;
    public static final int RENDER_POINT_FIELD = 0;
    public static final int RENDER_WIRE_FRAME = 1;
    public static final int RENDER_FLAT_SOLID = 2;
    public static final boolean ORIGINAL_ZOOM = true;

    public Renderer2D() {
        Color color = Color.white;
        Intrinsics.checkNotNullExpressionValue(color, "white");
        this.background = color;
        this.cameraangle = new double[2];
        this.m = new JLMatrix();
        this.zoomfactor = 1.0;
        this.polysides = 40;
        this.headcos = new double[this.polysides];
        this.headsin = new double[this.polysides];
        this.headx = new int[this.polysides];
        this.heady = new int[this.polysides];
        this.tempc = new Coordinate(0.0, 0.0, 0.0, 7, null);
        this.tempv1 = new JLVector();
        this.tempv2 = new JLVector();
        int n = this.polysides;
        for (int i2 = 0; i2 < n; ++i2) {
            this.headcos[i2] = Math.cos((double)i2 * 2.0 * Math.PI / (double)this.polysides);
            this.headsin[i2] = Math.sin((double)i2 * 2.0 * Math.PI / (double)this.polysides);
        }
    }

    @Override
    public void setPattern(@NotNull JMLPattern pat) {
        ArrayList<DrawObject2D> arrayList;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(pat, "pat");
        this.pat = pat;
        int maxobjects = 5 * pat.getNumberOfJugglers() + pat.getNumberOfPaths() + 18;
        Renderer2D renderer2D = this;
        ArrayList<DrawObject2D> arrayList2 = new ArrayList<DrawObject2D>(maxobjects);
        int n3 = 0;
        while (n3 < maxobjects) {
            n = n2 = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(new DrawObject2D(maxobjects));
        }
        renderer2D.obj = arrayList2;
        renderer2D = this;
        arrayList2 = new ArrayList(maxobjects);
        n3 = 0;
        while (n3 < maxobjects) {
            int it = n2 = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(new DrawObject2D(maxobjects));
        }
        renderer2D.obj2 = arrayList2;
        int n4 = 0;
        n3 = pat.getNumberOfJugglers();
        JLVector[][] jLVectorArrayArray = new JLVector[n3][];
        renderer2D = this;
        while (n4 < n3) {
            n = n4++;
            jLVectorArrayArray[n] = new JLVector[12];
        }
        renderer2D.jugglervec = jLVectorArrayArray;
    }

    @Override
    @NotNull
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void initDisplay(@NotNull Dimension dim, int border, @NotNull Coordinate overallmax, @NotNull Coordinate overallmin) {
        Intrinsics.checkNotNullParameter(dim, "dim");
        Intrinsics.checkNotNullParameter(overallmax, "overallmax");
        Intrinsics.checkNotNullParameter(overallmin, "overallmin");
        this.width = dim.width;
        this.height = dim.height;
        this.viewport = new Rectangle(border, border, this.width - 2 * border, this.height - 2 * border);
        Coordinate adjustedMax = new Coordinate(overallmax.getX(), overallmax.getY(), overallmax.getZ());
        Coordinate adjustedMin = new Coordinate(overallmin.getX(), overallmin.getY(), overallmin.getZ());
        JMLPattern jMLPattern = this.pat;
        if (jMLPattern == null) {
            Intrinsics.throwUninitializedPropertyAccessException("pat");
            jMLPattern = null;
        }
        if (jMLPattern.getNumberOfJugglers() == 1) {
            adjustedMin.setZ(adjustedMin.getZ() - 0.3 * Math.max(Math.abs(adjustedMin.getY()), Math.abs(adjustedMax.getY())));
            adjustedMax.setZ(adjustedMax.getZ() + 5.0);
        } else {
            double tempx = Math.max(Math.abs(adjustedMin.getX()), Math.abs(adjustedMax.getX()));
            double tempy = Math.max(Math.abs(adjustedMin.getY()), Math.abs(adjustedMax.getY()));
            adjustedMin.setZ(adjustedMin.getZ() - 0.4 * Math.max(tempx, tempy));
            adjustedMax.setZ(adjustedMax.getZ() + 0.4 * Math.max(tempx, tempy));
        }
        double maxabsx = Math.max(Math.abs(adjustedMin.getX()), Math.abs(adjustedMax.getX()));
        adjustedMin.setX(-maxabsx);
        adjustedMax.setX(maxabsx);
        Rectangle rectangle = this.viewport;
        Intrinsics.checkNotNull(rectangle);
        double d = (double)rectangle.width / (adjustedMax.getX() - adjustedMin.getX());
        Rectangle rectangle2 = this.viewport;
        Intrinsics.checkNotNull(rectangle2);
        this.zoomOrig = Math.min(d, (double)rectangle2.height / (adjustedMax.getZ() - adjustedMin.getZ()));
        this.cameracenter = new JLVector(0.5 * (adjustedMax.getX() + adjustedMin.getX()), 0.5 * (adjustedMax.getZ() + adjustedMin.getZ()), 0.5 * (adjustedMax.getY() + adjustedMin.getY()));
        this.setZoomLevel(this.getZoomLevel());
    }

    @Override
    public double getZoomLevel() {
        return this.zoomfactor;
    }

    @Override
    public void setZoomLevel(double zoomfactor) {
        this.zoomfactor = zoomfactor;
        this.zoom = this.zoomOrig * zoomfactor;
        Rectangle rectangle = this.viewport;
        Intrinsics.checkNotNull(rectangle);
        int n = rectangle.x;
        Rectangle rectangle2 = this.viewport;
        Intrinsics.checkNotNull(rectangle2);
        double d = 0.5 * (double)rectangle2.width;
        JLVector jLVector = this.cameracenter;
        Intrinsics.checkNotNull(jLVector);
        this.originx = n + MathKt.roundToInt(d - this.zoom * jLVector.getX());
        Rectangle rectangle3 = this.viewport;
        Intrinsics.checkNotNull(rectangle3);
        int n2 = rectangle3.y;
        Rectangle rectangle4 = this.viewport;
        Intrinsics.checkNotNull(rectangle4);
        double d2 = 0.5 * (double)rectangle4.height;
        JLVector jLVector2 = this.cameracenter;
        Intrinsics.checkNotNull(jLVector2);
        this.originz = n2 + MathKt.roundToInt(d2 + this.zoom * jLVector2.getY());
        this.calculateCameraMatrix();
    }

    private final void calculateCameraMatrix() {
        JLVector jLVector = this.cameracenter;
        Intrinsics.checkNotNull(jLVector);
        double d = -jLVector.getX();
        JLVector jLVector2 = this.cameracenter;
        Intrinsics.checkNotNull(jLVector2);
        double d2 = -jLVector2.getY();
        JLVector jLVector3 = this.cameracenter;
        Intrinsics.checkNotNull(jLVector3);
        this.m = JLMatrix.Companion.shiftMatrix(d, d2, -jLVector3.getZ());
        this.m.transform(JLMatrix.Companion.rotateMatrix(0.0, Math.PI - this.cameraangle[0], 0.0));
        this.m.transform(JLMatrix.Companion.rotateMatrix(1.5707963267948966 - this.cameraangle[1], 0.0, 0.0));
        JLVector jLVector4 = this.cameracenter;
        Intrinsics.checkNotNull(jLVector4);
        double d3 = jLVector4.getX();
        JLVector jLVector5 = this.cameracenter;
        Intrinsics.checkNotNull(jLVector5);
        double d4 = jLVector5.getY();
        JLVector jLVector6 = this.cameracenter;
        Intrinsics.checkNotNull(jLVector6);
        this.m.transform(JLMatrix.Companion.shiftMatrix(d3, d4, jLVector6.getZ()));
        this.m.transform(JLMatrix.Companion.scaleMatrix(1.0, -1.0, 1.0));
        this.m.transform(JLMatrix.Companion.scaleMatrix(this.zoom));
        this.m.transform(JLMatrix.Companion.shiftMatrix(this.originx, this.originz, 0.0));
    }

    @Override
    @NotNull
    public double[] getCameraAngle() {
        double[] ca = new double[]{this.cameraangle[0], this.cameraangle[1]};
        return ca;
    }

    @Override
    public void setCameraAngle(@NotNull double[] camangle) {
        Intrinsics.checkNotNullParameter(camangle, "camangle");
        this.cameraangle[0] = camangle[0];
        this.cameraangle[1] = camangle[1];
        if (this.cameracenter == null) {
            return;
        }
        this.calculateCameraMatrix();
    }

    @Override
    @NotNull
    public int[] getXY(@NotNull Coordinate coord) {
        Intrinsics.checkNotNullParameter(coord, "coord");
        return this.getXY(new JLVector(coord.getX(), coord.getZ(), coord.getY()));
    }

    private final int[] getXY(JLVector vec) {
        JLVector v = vec.transform(this.m);
        int[] val = new int[]{MathKt.roundToInt(v.getX()), MathKt.roundToInt(v.getY())};
        return val;
    }

    private final JLVector getXYZ(JLVector vec, JLVector result) {
        result.setX(vec.getX() * this.m.getM00() + vec.getY() * this.m.getM01() + vec.getZ() * this.m.getM02() + this.m.getM03());
        result.setY(vec.getX() * this.m.getM10() + vec.getY() * this.m.getM11() + vec.getZ() * this.m.getM12() + this.m.getM13());
        result.setZ(vec.getX() * this.m.getM20() + vec.getY() * this.m.getM21() + vec.getZ() * this.m.getM22() + this.m.getM23());
        return result;
    }

    @Override
    @NotNull
    public Coordinate getScreenTranslatedCoordinate(@NotNull Coordinate coord, int dx, int dy) {
        Intrinsics.checkNotNullParameter(coord, "coord");
        JLVector v = new JLVector(coord.getX(), coord.getZ(), coord.getY());
        JLVector s = v.transform(this.m);
        JLVector news = JLVector.Companion.add(s, new JLVector(dx, dy, 0.0));
        JLVector newv = news.transform(this.m.inverse());
        return new Coordinate(newv.getX(), newv.getZ(), newv.getY());
    }

    @Override
    public void drawFrame(double time, @NotNull int[] pnum, @Nullable int[] hideJugglers, @NotNull Graphics g) throws JuggleExceptionInternal {
        int i2;
        int n;
        int xmax;
        int x;
        int i3;
        int index;
        int numobjects;
        block168: {
            JMLPattern jMLPattern;
            int width;
            int y;
            int x2;
            int n2;
            Intrinsics.checkNotNullParameter(pnum, "pnum");
            Intrinsics.checkNotNullParameter(g, "g");
            JMLPattern jMLPattern2 = this.pat;
            if (jMLPattern2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("pat");
                jMLPattern2 = null;
            }
            int n3 = 5 * jMLPattern2.getNumberOfJugglers();
            JMLPattern jMLPattern3 = this.pat;
            if (jMLPattern3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("pat");
                jMLPattern3 = null;
            }
            numobjects = n3 + jMLPattern3.getNumberOfPaths() + 18;
            int n4 = numobjects;
            for (int i4 = 0; i4 < n4; ++i4) {
                List<DrawObject2D> list = this.obj;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("obj");
                    list = null;
                }
                list.get(i4).getCovering().clear();
            }
            index = 0;
            double propmin = 0.0;
            i3 = 1;
            JMLPattern jMLPattern4 = this.pat;
            if (jMLPattern4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("pat");
                jMLPattern4 = null;
            }
            if (i3 <= (n2 = jMLPattern4.getNumberOfPaths())) {
                while (true) {
                    Prop pr;
                    List<DrawObject2D> list;
                    if ((list = this.obj) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list = null;
                    }
                    list.get(index).setType(1);
                    List<DrawObject2D> list2 = this.obj;
                    if (list2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list2 = null;
                    }
                    list2.get(index).setNumber(i3);
                    JMLPattern jMLPattern5 = this.pat;
                    if (jMLPattern5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("pat");
                        jMLPattern5 = null;
                    }
                    jMLPattern5.getPathCoordinate(i3, time, this.tempc);
                    if (!this.tempc.isValid()) {
                        this.tempc.setCoordinate(0.0, 0.0, 0.0);
                    }
                    JLVector jLVector = JLVector.Companion.fromCoordinate(this.tempc, this.tempv1);
                    List<DrawObject2D> list3 = this.obj;
                    if (list3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list3 = null;
                    }
                    this.getXYZ(jLVector, list3.get(index).getCoord().get(0));
                    List<DrawObject2D> list4 = this.obj;
                    if (list4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list4 = null;
                    }
                    x2 = MathKt.roundToInt(list4.get(index).getCoord().get(0).getX());
                    List<DrawObject2D> list5 = this.obj;
                    if (list5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list5 = null;
                    }
                    y = MathKt.roundToInt(list5.get(index).getCoord().get(0).getY());
                    JMLPattern jMLPattern6 = this.pat;
                    if (jMLPattern6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("pat");
                        jMLPattern6 = null;
                    }
                    Prop prop = pr = jMLPattern6.getProp(pnum[i3 - 1]);
                    Intrinsics.checkNotNull(prop);
                    if (prop.getProp2DImage(this.zoom, this.cameraangle) != null) {
                        Dimension center = pr.getProp2DCenter(this.zoom);
                        Dimension size = pr.getProp2DSize(this.zoom);
                        List<DrawObject2D> list6 = this.obj;
                        if (list6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list6 = null;
                        }
                        Rectangle rectangle = list6.get(index).getBoundingbox();
                        Dimension dimension = center;
                        Intrinsics.checkNotNull(dimension);
                        rectangle.x = x2 - dimension.width;
                        List<DrawObject2D> list7 = this.obj;
                        if (list7 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list7 = null;
                        }
                        list7.get((int)index).getBoundingbox().y = y - center.height;
                        List<DrawObject2D> list8 = this.obj;
                        if (list8 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list8 = null;
                        }
                        Rectangle rectangle2 = list8.get(index).getBoundingbox();
                        Dimension dimension2 = size;
                        Intrinsics.checkNotNull(dimension2);
                        rectangle2.width = dimension2.width;
                        List<DrawObject2D> list9 = this.obj;
                        if (list9 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list9 = null;
                        }
                        list9.get((int)index).getBoundingbox().height = size.height;
                    }
                    Coordinate coordinate = pr.getMin();
                    Intrinsics.checkNotNull(coordinate);
                    propmin = Math.min(propmin, coordinate.getZ());
                    ++index;
                    if (i3 == n2) break;
                    ++i3;
                }
            }
            if (this.getShowground()) {
                for (i3 = 0; i3 < 18; ++i3) {
                    List<DrawObject2D> list = this.obj;
                    if (list == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list = null;
                    }
                    list.get(index).setType(3);
                    List<DrawObject2D> list10 = this.obj;
                    if (list10 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list10 = null;
                    }
                    list10.get(index).setNumber(0);
                    if (i3 < 9) {
                        this.tempv1.setX(-50.0 + 100.0 * (double)i3 / 8.0);
                        this.tempv1.setZ(-50.0);
                        this.tempv2.setX(this.tempv1.getX());
                        this.tempv2.setZ(50.0);
                    } else {
                        this.tempv1.setX(-50.0);
                        this.tempv1.setZ(-50.0 + 100.0 * (double)(i3 - 9) / 8.0);
                        this.tempv2.setX(50.0);
                        this.tempv2.setZ(this.tempv1.getZ());
                    }
                    this.tempv2.setY(propmin);
                    this.tempv1.setY(this.tempv2.getY());
                    List<DrawObject2D> list11 = this.obj;
                    if (list11 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list11 = null;
                    }
                    this.getXYZ(this.tempv1, list11.get(index).getCoord().get(0));
                    List<DrawObject2D> list12 = this.obj;
                    if (list12 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list12 = null;
                    }
                    this.getXYZ(this.tempv2, list12.get(index).getCoord().get(1));
                    List<DrawObject2D> list13 = this.obj;
                    if (list13 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list13 = null;
                    }
                    x2 = MathKt.roundToInt(list13.get(index).getCoord().get(0).getX());
                    List<DrawObject2D> list14 = this.obj;
                    if (list14 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list14 = null;
                    }
                    y = MathKt.roundToInt(list14.get(index).getCoord().get(1).getX());
                    x = Math.min(x2, y);
                    List<DrawObject2D> list15 = this.obj;
                    if (list15 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list15 = null;
                    }
                    y = MathKt.roundToInt(list15.get(index).getCoord().get(0).getY());
                    List<DrawObject2D> list16 = this.obj;
                    if (list16 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list16 = null;
                    }
                    int pr = MathKt.roundToInt(list16.get(index).getCoord().get(1).getY());
                    int y2 = Math.min(y, pr);
                    List<DrawObject2D> list17 = this.obj;
                    if (list17 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list17 = null;
                    }
                    int n5 = MathKt.roundToInt(list17.get(index).getCoord().get(0).getX());
                    List<DrawObject2D> list18 = this.obj;
                    if (list18 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list18 = null;
                    }
                    width = Math.abs(n5 - MathKt.roundToInt(list18.get(index).getCoord().get(1).getX())) + 1;
                    List<DrawObject2D> list19 = this.obj;
                    if (list19 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list19 = null;
                    }
                    int n6 = MathKt.roundToInt(list19.get(index).getCoord().get(0).getY());
                    List<DrawObject2D> list20 = this.obj;
                    if (list20 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list20 = null;
                    }
                    int height = Math.abs(n6 - MathKt.roundToInt(list20.get(index).getCoord().get(1).getY())) + 1;
                    List<DrawObject2D> list21 = this.obj;
                    if (list21 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list21 = null;
                    }
                    list21.get((int)index).getBoundingbox().x = x;
                    List<DrawObject2D> list22 = this.obj;
                    if (list22 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list22 = null;
                    }
                    list22.get((int)index).getBoundingbox().y = y2;
                    List<DrawObject2D> list23 = this.obj;
                    if (list23 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list23 = null;
                    }
                    list23.get((int)index).getBoundingbox().width = width;
                    List<DrawObject2D> list24 = this.obj;
                    if (list24 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list24 = null;
                    }
                    list24.get((int)index).getBoundingbox().height = height;
                    ++index;
                }
            }
            if ((jMLPattern = this.pat) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("pat");
                jMLPattern = null;
            }
            JLVector[][] jLVectorArray = this.jugglervec;
            if (this.jugglervec == null) {
                Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                jLVectorArray = null;
            }
            Juggler.INSTANCE.findJugglerCoordinates(jMLPattern, time, jLVectorArray);
            i3 = 1;
            JMLPattern jMLPattern7 = this.pat;
            if (jMLPattern7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("pat");
                jMLPattern7 = null;
            }
            if (i3 > (x = jMLPattern7.getNumberOfJugglers())) break block168;
            while (true) {
                block170: {
                    int y3;
                    int x3;
                    int j;
                    List<DrawObject2D> list;
                    block169: {
                        if (hideJugglers == null) break block169;
                        boolean hide = false;
                        int height = hideJugglers.length;
                        for (width = 0; width < height; ++width) {
                            int hideJuggler = hideJugglers[width];
                            if (hideJuggler != i3) continue;
                            hide = true;
                            break;
                        }
                        if (hide) break block170;
                    }
                    if ((list = this.obj) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list = null;
                    }
                    list.get(index).setType(2);
                    List<DrawObject2D> list25 = this.obj;
                    if (list25 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list25 = null;
                    }
                    list25.get(index).setNumber(i3);
                    JLVector[][] jLVectorArray2 = this.jugglervec;
                    if (this.jugglervec == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                        jLVectorArray2 = null;
                    }
                    JLVector jLVector = jLVectorArray2[i3 - 1][2];
                    Intrinsics.checkNotNull(jLVector);
                    List<DrawObject2D> list26 = this.obj;
                    if (list26 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list26 = null;
                    }
                    this.getXYZ(jLVector, list26.get(index).getCoord().get(0));
                    JLVector[][] jLVectorArray3 = this.jugglervec;
                    if (this.jugglervec == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                        jLVectorArray3 = null;
                    }
                    JLVector jLVector2 = jLVectorArray3[i3 - 1][3];
                    Intrinsics.checkNotNull(jLVector2);
                    List<DrawObject2D> list27 = this.obj;
                    if (list27 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list27 = null;
                    }
                    this.getXYZ(jLVector2, list27.get(index).getCoord().get(1));
                    JLVector[][] jLVectorArray4 = this.jugglervec;
                    if (this.jugglervec == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                        jLVectorArray4 = null;
                    }
                    JLVector jLVector3 = jLVectorArray4[i3 - 1][7];
                    Intrinsics.checkNotNull(jLVector3);
                    List<DrawObject2D> list28 = this.obj;
                    if (list28 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list28 = null;
                    }
                    this.getXYZ(jLVector3, list28.get(index).getCoord().get(2));
                    JLVector[][] jLVectorArray5 = this.jugglervec;
                    if (this.jugglervec == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                        jLVectorArray5 = null;
                    }
                    JLVector jLVector4 = jLVectorArray5[i3 - 1][6];
                    Intrinsics.checkNotNull(jLVector4);
                    List<DrawObject2D> list29 = this.obj;
                    if (list29 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list29 = null;
                    }
                    this.getXYZ(jLVector4, list29.get(index).getCoord().get(3));
                    JLVector[][] jLVectorArray6 = this.jugglervec;
                    if (this.jugglervec == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                        jLVectorArray6 = null;
                    }
                    JLVector jLVector5 = jLVectorArray6[i3 - 1][8];
                    Intrinsics.checkNotNull(jLVector5);
                    List<DrawObject2D> list30 = this.obj;
                    if (list30 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list30 = null;
                    }
                    this.getXYZ(jLVector5, list30.get(index).getCoord().get(4));
                    JLVector[][] jLVectorArray7 = this.jugglervec;
                    if (this.jugglervec == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                        jLVectorArray7 = null;
                    }
                    JLVector jLVector6 = jLVectorArray7[i3 - 1][9];
                    Intrinsics.checkNotNull(jLVector6);
                    List<DrawObject2D> list31 = this.obj;
                    if (list31 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list31 = null;
                    }
                    this.getXYZ(jLVector6, list31.get(index).getCoord().get(5));
                    JLVector[][] jLVectorArray8 = this.jugglervec;
                    if (this.jugglervec == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                        jLVectorArray8 = null;
                    }
                    JLVector jLVector7 = jLVectorArray8[i3 - 1][10];
                    Intrinsics.checkNotNull(jLVector7);
                    List<DrawObject2D> list32 = this.obj;
                    if (list32 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list32 = null;
                    }
                    this.getXYZ(jLVector7, list32.get(index).getCoord().get(6));
                    JLVector[][] jLVectorArray9 = this.jugglervec;
                    if (this.jugglervec == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                        jLVectorArray9 = null;
                    }
                    JLVector jLVector8 = jLVectorArray9[i3 - 1][11];
                    Intrinsics.checkNotNull(jLVector8);
                    List<DrawObject2D> list33 = this.obj;
                    if (list33 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list33 = null;
                    }
                    this.getXYZ(jLVector8, list33.get(index).getCoord().get(7));
                    int xmin = 0;
                    xmax = 0;
                    int ymin = 0;
                    int ymax = 0;
                    List<DrawObject2D> list34 = this.obj;
                    if (list34 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list34 = null;
                    }
                    xmin = xmax = MathKt.roundToInt(list34.get(index).getCoord().get(0).getX());
                    List<DrawObject2D> list35 = this.obj;
                    if (list35 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list35 = null;
                    }
                    ymin = ymax = MathKt.roundToInt(list35.get(index).getCoord().get(0).getY());
                    for (j = 1; j < 8; ++j) {
                        List<DrawObject2D> list36 = this.obj;
                        if (list36 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list36 = null;
                        }
                        x3 = MathKt.roundToInt(list36.get(index).getCoord().get(j).getX());
                        List<DrawObject2D> list37 = this.obj;
                        if (list37 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list37 = null;
                        }
                        y3 = MathKt.roundToInt(list37.get(index).getCoord().get(j).getY());
                        if (x3 < xmin) {
                            xmin = x3;
                        }
                        if (x3 > xmax) {
                            xmax = x3;
                        }
                        if (y3 < ymin) {
                            ymin = y3;
                        }
                        if (y3 <= ymax) continue;
                        ymax = y3;
                    }
                    List<DrawObject2D> list38 = this.obj;
                    if (list38 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list38 = null;
                    }
                    list38.get((int)index).getBoundingbox().x = xmin + 1;
                    List<DrawObject2D> list39 = this.obj;
                    if (list39 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list39 = null;
                    }
                    list39.get((int)index).getBoundingbox().y = ymin + 1;
                    List<DrawObject2D> list40 = this.obj;
                    if (list40 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list40 = null;
                    }
                    list40.get((int)index).getBoundingbox().width = xmax - xmin - 1;
                    List<DrawObject2D> list41 = this.obj;
                    if (list41 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list41 = null;
                    }
                    list41.get((int)index).getBoundingbox().height = ymax - ymin - 1;
                    ++index;
                    for (j = 0; j < 2; ++j) {
                        int n7;
                        int height;
                        int width2;
                        JLVector[][] jLVectorArray10 = this.jugglervec;
                        if (this.jugglervec == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                            jLVectorArray10 = null;
                        }
                        if (jLVectorArray10[i3 - 1][4 + j] == null) {
                            List<DrawObject2D> list42 = this.obj;
                            if (list42 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list42 = null;
                            }
                            list42.get(index).setType(3);
                            List<DrawObject2D> list43 = this.obj;
                            if (list43 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list43 = null;
                            }
                            list43.get(index).setNumber(i3);
                            JLVector[][] jLVectorArray11 = this.jugglervec;
                            if (this.jugglervec == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                                jLVectorArray11 = null;
                            }
                            JLVector jLVector9 = jLVectorArray11[i3 - 1][2 + j];
                            Intrinsics.checkNotNull(jLVector9);
                            List<DrawObject2D> list44 = this.obj;
                            if (list44 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list44 = null;
                            }
                            this.getXYZ(jLVector9, list44.get(index).getCoord().get(0));
                            JLVector[][] jLVectorArray12 = this.jugglervec;
                            if (this.jugglervec == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                                jLVectorArray12 = null;
                            }
                            JLVector jLVector10 = jLVectorArray12[i3 - 1][j];
                            Intrinsics.checkNotNull(jLVector10);
                            List<DrawObject2D> list45 = this.obj;
                            if (list45 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list45 = null;
                            }
                            this.getXYZ(jLVector10, list45.get(index).getCoord().get(1));
                            List<DrawObject2D> list46 = this.obj;
                            if (list46 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list46 = null;
                            }
                            y3 = MathKt.roundToInt(list46.get(index).getCoord().get(0).getX());
                            List<DrawObject2D> list47 = this.obj;
                            if (list47 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list47 = null;
                            }
                            int n8 = MathKt.roundToInt(list47.get(index).getCoord().get(1).getX());
                            x3 = Math.min(y3, n8);
                            List<DrawObject2D> list48 = this.obj;
                            if (list48 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list48 = null;
                            }
                            n8 = MathKt.roundToInt(list48.get(index).getCoord().get(0).getY());
                            List<DrawObject2D> list49 = this.obj;
                            if (list49 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list49 = null;
                            }
                            int n9 = MathKt.roundToInt(list49.get(index).getCoord().get(1).getY());
                            y3 = Math.min(n8, n9);
                            List<DrawObject2D> list50 = this.obj;
                            if (list50 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list50 = null;
                            }
                            int n10 = MathKt.roundToInt(list50.get(index).getCoord().get(0).getX());
                            List<DrawObject2D> list51 = this.obj;
                            if (list51 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list51 = null;
                            }
                            width2 = Math.abs(n10 - MathKt.roundToInt(list51.get(index).getCoord().get(1).getX())) + 1;
                            List<DrawObject2D> list52 = this.obj;
                            if (list52 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list52 = null;
                            }
                            int n11 = MathKt.roundToInt(list52.get(index).getCoord().get(0).getY());
                            List<DrawObject2D> list53 = this.obj;
                            if (list53 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list53 = null;
                            }
                            height = Math.abs(n11 - MathKt.roundToInt(list53.get(index).getCoord().get(1).getY())) + 1;
                            List<DrawObject2D> list54 = this.obj;
                            if (list54 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list54 = null;
                            }
                            list54.get((int)index).getBoundingbox().x = x3;
                            List<DrawObject2D> list55 = this.obj;
                            if (list55 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list55 = null;
                            }
                            list55.get((int)index).getBoundingbox().y = y3;
                            List<DrawObject2D> list56 = this.obj;
                            if (list56 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list56 = null;
                            }
                            list56.get((int)index).getBoundingbox().width = width2;
                            List<DrawObject2D> list57 = this.obj;
                            if (list57 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("obj");
                                list57 = null;
                            }
                            list57.get((int)index).getBoundingbox().height = height;
                            n7 = index++;
                            continue;
                        }
                        List<DrawObject2D> list58 = this.obj;
                        if (list58 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list58 = null;
                        }
                        list58.get(index).setType(3);
                        List<DrawObject2D> list59 = this.obj;
                        if (list59 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list59 = null;
                        }
                        list59.get(index).setNumber(i3);
                        JLVector[][] jLVectorArray13 = this.jugglervec;
                        if (this.jugglervec == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                            jLVectorArray13 = null;
                        }
                        JLVector jLVector11 = jLVectorArray13[i3 - 1][2 + j];
                        Intrinsics.checkNotNull(jLVector11);
                        List<DrawObject2D> list60 = this.obj;
                        if (list60 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list60 = null;
                        }
                        this.getXYZ(jLVector11, list60.get(index).getCoord().get(0));
                        JLVector[][] jLVectorArray14 = this.jugglervec;
                        if (this.jugglervec == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                            jLVectorArray14 = null;
                        }
                        JLVector jLVector12 = jLVectorArray14[i3 - 1][4 + j];
                        Intrinsics.checkNotNull(jLVector12);
                        List<DrawObject2D> list61 = this.obj;
                        if (list61 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list61 = null;
                        }
                        this.getXYZ(jLVector12, list61.get(index).getCoord().get(1));
                        List<DrawObject2D> list62 = this.obj;
                        if (list62 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list62 = null;
                        }
                        y3 = MathKt.roundToInt(list62.get(index).getCoord().get(0).getX());
                        List<DrawObject2D> list63 = this.obj;
                        if (list63 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list63 = null;
                        }
                        width2 = MathKt.roundToInt(list63.get(index).getCoord().get(1).getX());
                        x3 = Math.min(y3, width2);
                        List<DrawObject2D> list64 = this.obj;
                        if (list64 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list64 = null;
                        }
                        width2 = MathKt.roundToInt(list64.get(index).getCoord().get(0).getY());
                        List<DrawObject2D> list65 = this.obj;
                        if (list65 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list65 = null;
                        }
                        height = MathKt.roundToInt(list65.get(index).getCoord().get(1).getY());
                        y3 = Math.min(width2, height);
                        List<DrawObject2D> list66 = this.obj;
                        if (list66 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list66 = null;
                        }
                        int n12 = MathKt.roundToInt(list66.get(index).getCoord().get(0).getX());
                        List<DrawObject2D> list67 = this.obj;
                        if (list67 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list67 = null;
                        }
                        width2 = Math.abs(n12 - MathKt.roundToInt(list67.get(index).getCoord().get(1).getX())) + 1;
                        List<DrawObject2D> list68 = this.obj;
                        if (list68 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list68 = null;
                        }
                        int n13 = MathKt.roundToInt(list68.get(index).getCoord().get(0).getY());
                        List<DrawObject2D> list69 = this.obj;
                        if (list69 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list69 = null;
                        }
                        height = Math.abs(n13 - MathKt.roundToInt(list69.get(index).getCoord().get(1).getY())) + 1;
                        List<DrawObject2D> list70 = this.obj;
                        if (list70 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list70 = null;
                        }
                        list70.get((int)index).getBoundingbox().x = x3;
                        List<DrawObject2D> list71 = this.obj;
                        if (list71 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list71 = null;
                        }
                        list71.get((int)index).getBoundingbox().y = y3;
                        List<DrawObject2D> list72 = this.obj;
                        if (list72 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list72 = null;
                        }
                        list72.get((int)index).getBoundingbox().width = width2;
                        List<DrawObject2D> list73 = this.obj;
                        if (list73 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list73 = null;
                        }
                        list73.get((int)index).getBoundingbox().height = height;
                        ++index;
                        List<DrawObject2D> list74 = this.obj;
                        if (list74 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list74 = null;
                        }
                        list74.get(index).setType(3);
                        List<DrawObject2D> list75 = this.obj;
                        if (list75 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list75 = null;
                        }
                        list75.get(index).setNumber(i3);
                        JLVector[][] jLVectorArray15 = this.jugglervec;
                        if (this.jugglervec == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                            jLVectorArray15 = null;
                        }
                        JLVector jLVector13 = jLVectorArray15[i3 - 1][4 + j];
                        Intrinsics.checkNotNull(jLVector13);
                        List<DrawObject2D> list76 = this.obj;
                        if (list76 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list76 = null;
                        }
                        this.getXYZ(jLVector13, list76.get(index).getCoord().get(0));
                        JLVector[][] jLVectorArray16 = this.jugglervec;
                        if (this.jugglervec == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("jugglervec");
                            jLVectorArray16 = null;
                        }
                        JLVector jLVector14 = jLVectorArray16[i3 - 1][j];
                        Intrinsics.checkNotNull(jLVector14);
                        List<DrawObject2D> list77 = this.obj;
                        if (list77 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list77 = null;
                        }
                        this.getXYZ(jLVector14, list77.get(index).getCoord().get(1));
                        List<DrawObject2D> list78 = this.obj;
                        if (list78 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list78 = null;
                        }
                        int n14 = MathKt.roundToInt(list78.get(index).getCoord().get(0).getX());
                        List<DrawObject2D> list79 = this.obj;
                        if (list79 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list79 = null;
                        }
                        int n15 = MathKt.roundToInt(list79.get(index).getCoord().get(1).getX());
                        x3 = Math.min(n14, n15);
                        List<DrawObject2D> list80 = this.obj;
                        if (list80 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list80 = null;
                        }
                        n14 = MathKt.roundToInt(list80.get(index).getCoord().get(0).getY());
                        List<DrawObject2D> list81 = this.obj;
                        if (list81 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list81 = null;
                        }
                        n15 = MathKt.roundToInt(list81.get(index).getCoord().get(1).getY());
                        y3 = Math.min(n14, n15);
                        List<DrawObject2D> list82 = this.obj;
                        if (list82 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list82 = null;
                        }
                        int n16 = MathKt.roundToInt(list82.get(index).getCoord().get(0).getX());
                        List<DrawObject2D> list83 = this.obj;
                        if (list83 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list83 = null;
                        }
                        width2 = Math.abs(n16 - MathKt.roundToInt(list83.get(index).getCoord().get(1).getX())) + 1;
                        List<DrawObject2D> list84 = this.obj;
                        if (list84 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list84 = null;
                        }
                        int n17 = MathKt.roundToInt(list84.get(index).getCoord().get(0).getY());
                        List<DrawObject2D> list85 = this.obj;
                        if (list85 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list85 = null;
                        }
                        height = Math.abs(n17 - MathKt.roundToInt(list85.get(index).getCoord().get(1).getY())) + 1;
                        List<DrawObject2D> list86 = this.obj;
                        if (list86 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list86 = null;
                        }
                        list86.get((int)index).getBoundingbox().x = x3;
                        List<DrawObject2D> list87 = this.obj;
                        if (list87 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list87 = null;
                        }
                        list87.get((int)index).getBoundingbox().y = y3;
                        List<DrawObject2D> list88 = this.obj;
                        if (list88 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list88 = null;
                        }
                        list88.get((int)index).getBoundingbox().width = width2;
                        List<DrawObject2D> list89 = this.obj;
                        if (list89 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("obj");
                            list89 = null;
                        }
                        list89.get((int)index).getBoundingbox().height = height;
                        n7 = index++;
                    }
                }
                if (i3 == x) break;
                ++i3;
            }
        }
        numobjects = index;
        x = numobjects;
        for (i3 = 0; i3 < x; ++i3) {
            xmax = numobjects;
            for (int j = 0; j < xmax; ++j) {
                List<DrawObject2D> list;
                if (j == i3) continue;
                List<DrawObject2D> list90 = this.obj;
                if (list90 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("obj");
                    list90 = null;
                }
                if ((list = this.obj) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("obj");
                    list = null;
                }
                if (!list90.get(i3).isCovering(list.get(j))) continue;
                List<DrawObject2D> list91 = this.obj;
                if (list91 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("obj");
                    list91 = null;
                }
                List<DrawObject2D> list92 = list91.get(i3).getCovering();
                List<DrawObject2D> list93 = this.obj;
                if (list93 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("obj");
                    list93 = null;
                }
                list92.add(list93.get(j));
            }
            List<DrawObject2D> list = this.obj;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException("obj");
                list = null;
            }
            list.get(i3).setDrawn(false);
        }
        index = 0;
        boolean changed = true;
        while (changed) {
            changed = false;
            n = numobjects;
            for (i2 = 0; i2 < n; ++i2) {
                List<DrawObject2D> list;
                List<DrawObject2D> list94 = this.obj;
                if (list94 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("obj");
                    list94 = null;
                }
                if (list94.get(i2).getDrawn()) continue;
                boolean candraw = true;
                int j = 0;
                List<DrawObject2D> list95 = this.obj;
                if (list95 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("obj");
                    list95 = null;
                }
                int ymax = ((Collection)list95.get(i2).getCovering()).size();
                while (j < ymax) {
                    DrawObject2D temp;
                    List<DrawObject2D> list96 = this.obj;
                    if (list96 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("obj");
                        list96 = null;
                    }
                    if (!(temp = list96.get(i2).getCovering().get(j)).getDrawn()) {
                        candraw = false;
                        break;
                    }
                    ++j;
                }
                if (!candraw) continue;
                List<DrawObject2D> list97 = this.obj2;
                if (list97 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("obj2");
                    list97 = null;
                }
                if ((list = this.obj) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("obj");
                    list = null;
                }
                list97.set(index, list.get(i2));
                List<DrawObject2D> list98 = this.obj;
                if (list98 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("obj");
                    list98 = null;
                }
                list98.get(i2).setDrawn(true);
                ++index;
                changed = true;
            }
        }
        n = numobjects;
        for (i2 = 0; i2 < n; ++i2) {
            List<DrawObject2D> list;
            List<DrawObject2D> list99 = this.obj;
            if (list99 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("obj");
                list99 = null;
            }
            if (list99.get(i2).getDrawn()) continue;
            List<DrawObject2D> list100 = this.obj2;
            if (list100 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("obj2");
                list100 = null;
            }
            if ((list = this.obj) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("obj");
                list = null;
            }
            list100.set(index, list.get(i2));
            List<DrawObject2D> list101 = this.obj;
            if (list101 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("obj");
                list101 = null;
            }
            list101.get(i2).setDrawn(true);
            ++index;
        }
        n = numobjects;
        block18: for (i2 = 0; i2 < n; ++i2) {
            List<DrawObject2D> list = this.obj2;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException("obj2");
                list = null;
            }
            DrawObject2D ob = list.get(i2);
            switch (ob.getType()) {
                case 1: {
                    Dimension grip;
                    JMLPattern jMLPattern = this.pat;
                    if (jMLPattern == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("pat");
                        jMLPattern = null;
                    }
                    Prop pr = jMLPattern.getProp(pnum[ob.getNumber() - 1]);
                    int x4 = MathKt.roundToInt(ob.getCoord().get(0).getX());
                    int y = MathKt.roundToInt(ob.getCoord().get(0).getY());
                    Prop prop = pr;
                    Intrinsics.checkNotNull(prop);
                    Image propimage = prop.getProp2DImage(this.zoom, this.cameraangle);
                    if (propimage == null) continue block18;
                    Dimension dimension = grip = pr.getProp2DGrip(this.zoom);
                    Intrinsics.checkNotNull(dimension);
                    g.drawImage(propimage, x4 - dimension.width, y - grip.height, null);
                    continue block18;
                }
                case 2: {
                    int[] bodyx = new int[4];
                    int[] bodyy = new int[4];
                    for (int j = 0; j < 4; ++j) {
                        bodyx[j] = MathKt.roundToInt(ob.getCoord().get(j).getX());
                        bodyy[j] = MathKt.roundToInt(ob.getCoord().get(j).getY());
                    }
                    g.setColor(this.background);
                    g.fillPolygon(bodyx, bodyy, 4);
                    g.setColor(Color.black);
                    g.drawPolygon(bodyx, bodyy, 4);
                    double LheadBx = ob.getCoord().get(4).getX();
                    double LheadBy = ob.getCoord().get(4).getY();
                    double LheadTy = ob.getCoord().get(5).getY();
                    double RheadBx = ob.getCoord().get(6).getX();
                    double RheadBy = ob.getCoord().get(6).getY();
                    if (Math.abs(RheadBx - LheadBx) > 2.0) {
                        int n18 = this.polysides;
                        for (int j = 0; j < n18; ++j) {
                            this.headx[j] = MathKt.roundToInt(0.5 * (LheadBx + RheadBx + this.headcos[j] * (RheadBx - LheadBx)));
                            this.heady[j] = MathKt.roundToInt(0.5 * (LheadBy + LheadTy + this.headsin[j] * (LheadBy - LheadTy)) + ((double)this.headx[j] - LheadBx) * (RheadBy - LheadBy) / (RheadBx - LheadBx));
                        }
                        g.setColor(this.background);
                        g.fillPolygon(this.headx, this.heady, this.polysides);
                        g.setColor(Color.black);
                        g.drawPolygon(this.headx, this.heady, this.polysides);
                        continue block18;
                    }
                    double h = Math.sqrt((LheadBy - LheadTy) * (LheadBy - LheadTy) + (RheadBy - LheadBy) * (RheadBy - LheadBy));
                    int headx = MathKt.roundToInt(0.5 * (LheadBx + RheadBx));
                    int heady1 = MathKt.roundToInt(0.5 * (LheadTy + RheadBy + h));
                    int heady2 = MathKt.roundToInt(0.5 * (LheadTy + RheadBy - h));
                    g.setColor(Color.black);
                    g.drawLine(headx, heady1, headx, heady2);
                    continue block18;
                }
                case 3: {
                    g.setColor(Color.black);
                    int x1 = MathKt.roundToInt(ob.getCoord().get(0).getX());
                    int y1 = MathKt.roundToInt(ob.getCoord().get(0).getY());
                    int x2 = MathKt.roundToInt(ob.getCoord().get(1).getX());
                    int y2 = MathKt.roundToInt(ob.getCoord().get(1).getY());
                    g.drawLine(x1, y1, x2, y2);
                }
            }
        }
    }

    @Override
    @NotNull
    public Coordinate getHandWindowMax() {
        return new Coordinate(5.0, 0.0, 1.0);
    }

    @Override
    @NotNull
    public Coordinate getHandWindowMin() {
        return new Coordinate(-5.0, 0.0, -1.0);
    }

    @Override
    @NotNull
    public Coordinate getJugglerWindowMax() {
        int n;
        JMLPattern jMLPattern = this.pat;
        if (jMLPattern == null) {
            Intrinsics.throwUninitializedPropertyAccessException("pat");
            jMLPattern = null;
        }
        Coordinate max = jMLPattern.getJugglerMax(1);
        int i2 = 2;
        JMLPattern jMLPattern2 = this.pat;
        if (jMLPattern2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("pat");
            jMLPattern2 = null;
        }
        if (i2 <= (n = jMLPattern2.getNumberOfJugglers())) {
            while (true) {
                JMLPattern jMLPattern3;
                if ((jMLPattern3 = this.pat) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("pat");
                    jMLPattern3 = null;
                }
                max = Coordinate.Companion.max(max, jMLPattern3.getJugglerMax(i2));
                if (i2 == n) break;
                ++i2;
            }
        }
        Coordinate coordinate = max = Coordinate.Companion.add(max, new Coordinate(23.0, 23.0, 71.0));
        Intrinsics.checkNotNull(coordinate);
        return coordinate;
    }

    @Override
    @NotNull
    public Coordinate getJugglerWindowMin() {
        int n;
        JMLPattern jMLPattern = this.pat;
        if (jMLPattern == null) {
            Intrinsics.throwUninitializedPropertyAccessException("pat");
            jMLPattern = null;
        }
        Coordinate min = jMLPattern.getJugglerMin(1);
        int i2 = 2;
        JMLPattern jMLPattern2 = this.pat;
        if (jMLPattern2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("pat");
            jMLPattern2 = null;
        }
        if (i2 <= (n = jMLPattern2.getNumberOfJugglers())) {
            while (true) {
                JMLPattern jMLPattern3;
                if ((jMLPattern3 = this.pat) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("pat");
                    jMLPattern3 = null;
                }
                min = Coordinate.Companion.min(min, jMLPattern3.getJugglerMin(i2));
                if (i2 == n) break;
                ++i2;
            }
        }
        Coordinate coordinate = min = Coordinate.Companion.add(min, new Coordinate(-23.0, -23.0, 0.0));
        Intrinsics.checkNotNull(coordinate);
        return coordinate;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljugglinglab/renderer/Renderer2D$Companion;", "", "<init>", "()V", "RENDER_POINT_FIELD", "", "RENDER_WIRE_FRAME", "RENDER_FLAT_SOLID", "ORIGINAL_ZOOM", "", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0015\u0018\u0000 22\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u0000J\u0018\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000H\u0002J&\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\u0005R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00063"}, d2={"Ljugglinglab/renderer/Renderer2D$DrawObject2D;", "", "numobjects", "", "<init>", "(I)V", "type", "getType", "()I", "setType", "number", "getNumber", "setNumber", "coord", "", "Ljugglinglab/renderer/JLVector;", "getCoord", "()Ljava/util/List;", "setCoord", "(Ljava/util/List;)V", "boundingbox", "Ljava/awt/Rectangle;", "getBoundingbox", "()Ljava/awt/Rectangle;", "setBoundingbox", "(Ljava/awt/Rectangle;)V", "covering", "getCovering", "setCovering", "drawn", "", "getDrawn", "()Z", "setDrawn", "(Z)V", "tempv", "getTempv", "()Ljugglinglab/renderer/JLVector;", "setTempv", "(Ljugglinglab/renderer/JLVector;)V", "isCovering", "obj", "isBoxCoveringLine", "box", "line", "vectorProduct", "v1", "v2", "v3", "result", "Companion", "jugglinglab"})
    @SourceDebugExtension(value={"SMAP\nRenderer2D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Renderer2D.kt\njugglinglab/renderer/Renderer2D$DrawObject2D\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,823:1\n1#2:824\n*E\n"})
    public static final class DrawObject2D {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int type;
        private int number;
        @NotNull
        private List<JLVector> coord;
        @NotNull
        private Rectangle boundingbox;
        @NotNull
        private List<DrawObject2D> covering;
        private boolean drawn;
        @NotNull
        private JLVector tempv;
        public static final int TYPE_PROP = 1;
        public static final int TYPE_BODY = 2;
        public static final int TYPE_LINE = 3;
        private static final double SLOP = 3.0;

        public DrawObject2D(int numobjects) {
            int n = 8;
            DrawObject2D drawObject2D = this;
            ArrayList<JLVector> arrayList = new ArrayList<JLVector>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<JLVector> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(new JLVector());
            }
            drawObject2D.coord = arrayList;
            this.boundingbox = new Rectangle();
            this.covering = new ArrayList(numobjects);
            this.tempv = new JLVector();
        }

        public final int getType() {
            return this.type;
        }

        public final void setType(int n) {
            this.type = n;
        }

        public final int getNumber() {
            return this.number;
        }

        public final void setNumber(int n) {
            this.number = n;
        }

        @NotNull
        public final List<JLVector> getCoord() {
            return this.coord;
        }

        public final void setCoord(@NotNull List<JLVector> list) {
            Intrinsics.checkNotNullParameter(list, "<set-?>");
            this.coord = list;
        }

        @NotNull
        public final Rectangle getBoundingbox() {
            return this.boundingbox;
        }

        public final void setBoundingbox(@NotNull Rectangle rectangle) {
            Intrinsics.checkNotNullParameter(rectangle, "<set-?>");
            this.boundingbox = rectangle;
        }

        @NotNull
        public final List<DrawObject2D> getCovering() {
            return this.covering;
        }

        public final void setCovering(@NotNull List<DrawObject2D> list) {
            Intrinsics.checkNotNullParameter(list, "<set-?>");
            this.covering = list;
        }

        public final boolean getDrawn() {
            return this.drawn;
        }

        public final void setDrawn(boolean bl) {
            this.drawn = bl;
        }

        @NotNull
        public final JLVector getTempv() {
            return this.tempv;
        }

        public final void setTempv(@NotNull JLVector jLVector) {
            Intrinsics.checkNotNullParameter(jLVector, "<set-?>");
            this.tempv = jLVector;
        }

        public final boolean isCovering(@NotNull DrawObject2D obj) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            if (!this.boundingbox.intersects(obj.boundingbox)) {
                return false;
            }
            switch (this.type) {
                case 1: {
                    switch (obj.type) {
                        case 1: {
                            return this.coord.get(0).getZ() < obj.coord.get(0).getZ();
                        }
                        case 2: {
                            this.vectorProduct(obj.coord.get(0), obj.coord.get(1), obj.coord.get(2), this.tempv);
                            if (this.tempv.getZ() == 0.0) {
                                return false;
                            }
                            double z = obj.coord.get(0).getZ() - (this.tempv.getX() * (this.coord.get(0).getX() - obj.coord.get(0).getX()) + this.tempv.getY() * (this.coord.get(0).getY() - obj.coord.get(0).getY())) / this.tempv.getZ();
                            return this.coord.get(0).getZ() < z;
                        }
                        case 3: {
                            return this.isBoxCoveringLine(this, obj) == 1;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (obj.type) {
                        case 1: {
                            this.vectorProduct(this.coord.get(0), this.coord.get(1), this.coord.get(2), this.tempv);
                            if (this.tempv.getZ() == 0.0) {
                                return false;
                            }
                            double z = this.coord.get(0).getZ() - (this.tempv.getX() * (obj.coord.get(0).getX() - this.coord.get(0).getX()) + this.tempv.getY() * (obj.coord.get(0).getY() - this.coord.get(0).getY())) / this.tempv.getZ();
                            return z < obj.coord.get(0).getZ();
                        }
                        case 2: {
                            double d = 0.0;
                            for (int i2 = 0; i2 < 4; ++i2) {
                                d += this.coord.get(i2).getZ() - obj.coord.get(i2).getZ();
                            }
                            return d < 0.0;
                        }
                        case 3: {
                            return this.isBoxCoveringLine(this, obj) == 1;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (obj.type) {
                        case 1: 
                        case 2: {
                            return this.isBoxCoveringLine(obj, this) == -1;
                        }
                        case 3: {
                            return false;
                        }
                    }
                }
            }
            return false;
        }

        private final int isBoxCoveringLine(DrawObject2D box, DrawObject2D line) {
            double zl;
            int i2;
            double zb;
            double y;
            if (box.type == 2) {
                this.vectorProduct(box.coord.get(0), box.coord.get(1), box.coord.get(2), this.tempv);
            } else {
                this.tempv.setX(0.0);
                this.tempv.setY(0.0);
                this.tempv.setZ(1.0);
            }
            if (this.tempv.getZ() == 0.0) {
                return 0;
            }
            boolean endinbb = false;
            for (int i3 = 0; i3 < 2; ++i3) {
                double x = line.coord.get(i3).getX();
                if (!box.boundingbox.contains((int)(x + 0.5), (int)((y = line.coord.get(i3).getY()) + 0.5))) continue;
                zb = box.coord.get(0).getZ() - (this.tempv.getX() * (x - box.coord.get(0).getX()) + this.tempv.getY() * (y - box.coord.get(0).getY())) / this.tempv.getZ();
                if (line.coord.get(i3).getZ() < zb - 3.0) {
                    return -1;
                }
                endinbb = true;
            }
            if (endinbb) {
                return 1;
            }
            boolean intersection = false;
            for (i2 = 0; i2 < 2; ++i2) {
                int x;
                int n = x = i2 == 0 ? box.boundingbox.x : box.boundingbox.x + box.boundingbox.width - 1;
                if ((double)x < Math.min(line.coord.get(0).getX(), line.coord.get(1).getX()) || (double)x > Math.max(line.coord.get(0).getX(), line.coord.get(1).getX()) || line.coord.get(1).getX() == line.coord.get(0).getX() || (y = line.coord.get(0).getY() + (line.coord.get(1).getY() - line.coord.get(0).getY()) * ((double)x - line.coord.get(0).getX()) / (line.coord.get(1).getX() - line.coord.get(0).getX())) < (double)box.boundingbox.y || y > (double)(box.boundingbox.y + box.boundingbox.height - 1)) continue;
                intersection = true;
                zb = box.coord.get(0).getZ() - (this.tempv.getX() * ((double)x - box.coord.get(0).getX()) + this.tempv.getY() * (y - box.coord.get(0).getY())) / this.tempv.getZ();
                zl = line.coord.get(0).getZ() + (line.coord.get(1).getZ() - line.coord.get(0).getZ()) * ((double)x - line.coord.get(0).getX()) / (line.coord.get(1).getX() - line.coord.get(0).getX());
                if (!(zl < zb - 3.0)) continue;
                return -1;
            }
            for (i2 = 0; i2 < 2; ++i2) {
                double x;
                int y2;
                int n = y2 = i2 == 0 ? box.boundingbox.y : box.boundingbox.y + box.boundingbox.height - 1;
                if ((double)y2 < Math.min(line.coord.get(0).getY(), line.coord.get(1).getY()) || (double)y2 > Math.max(line.coord.get(0).getY(), line.coord.get(1).getY()) || line.coord.get(1).getY() == line.coord.get(0).getY() || (x = line.coord.get(0).getX() + (line.coord.get(1).getX() - line.coord.get(0).getX()) * ((double)y2 - line.coord.get(0).getY()) / (line.coord.get(1).getY() - line.coord.get(0).getY())) < (double)box.boundingbox.x || x > (double)(box.boundingbox.x + box.boundingbox.width - 1)) continue;
                intersection = true;
                zb = box.coord.get(0).getZ() - (this.tempv.getX() * (x - box.coord.get(0).getX()) + this.tempv.getY() * ((double)y2 - box.coord.get(0).getY())) / this.tempv.getZ();
                zl = line.coord.get(0).getZ() + (line.coord.get(1).getZ() - line.coord.get(0).getZ()) * (x - line.coord.get(0).getX()) / (line.coord.get(1).getX() - line.coord.get(0).getX());
                if (!(zl < zb - 3.0)) continue;
                return -1;
            }
            return intersection ? 1 : 0;
        }

        @NotNull
        public final JLVector vectorProduct(@NotNull JLVector v1, @NotNull JLVector v2, @NotNull JLVector v3, @NotNull JLVector result) {
            Intrinsics.checkNotNullParameter(v1, "v1");
            Intrinsics.checkNotNullParameter(v2, "v2");
            Intrinsics.checkNotNullParameter(v3, "v3");
            Intrinsics.checkNotNullParameter(result, "result");
            double ax = v2.getX() - v1.getX();
            double ay = v2.getY() - v1.getY();
            double az = v2.getZ() - v1.getZ();
            double bx = v3.getX() - v1.getX();
            double by = v3.getY() - v1.getY();
            double bz = v3.getZ() - v1.getZ();
            result.setX(ay * bz - by * az);
            result.setY(az * bx - bz * ax);
            result.setZ(ax * by - bx * ay);
            return result;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljugglinglab/renderer/Renderer2D$DrawObject2D$Companion;", "", "<init>", "()V", "TYPE_PROP", "", "TYPE_BODY", "TYPE_LINE", "SLOP", "", "jugglinglab"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

