/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.core.ApplicationWindow;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljugglinglab/util/Connection;", "Ljava/lang/Thread;", "client", "Ljava/net/Socket;", "<init>", "(Ljava/net/Socket;)V", "getClient", "()Ljava/net/Socket;", "setClient", "inReader", "Ljava/io/BufferedReader;", "outStream", "Ljava/io/PrintStream;", "run", "", "jugglinglab"})
public final class Connection
extends Thread {
    @NotNull
    private Socket client;
    @Nullable
    private BufferedReader inReader;
    @Nullable
    private PrintStream outStream;

    public Connection(@NotNull Socket client) {
        Intrinsics.checkNotNullParameter(client, "client");
        this.client = client;
        try {
            this.inReader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            this.outStream = new PrintStream(this.client.getOutputStream());
            this.start();
        }
        catch (IOException ioe) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ErrorDialog.INSTANCE.handleFatalException(ioe);
        }
    }

    @NotNull
    public final Socket getClient() {
        return this.client;
    }

    public final void setClient(@NotNull Socket socket) {
        Intrinsics.checkNotNullParameter(socket, "<set-?>");
        this.client = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                String string;
                BufferedReader bufferedReader = this.inReader;
                Intrinsics.checkNotNull(bufferedReader);
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    return;
                }
                String line = string;
                if (StringsKt.startsWith$default(line, "open ", false, 2, null)) {
                    String filepath;
                    Intrinsics.checkNotNullExpressionValue(line.substring(5), "substring(...)");
                    File file = new File(filepath);
                    PrintStream printStream = this.outStream;
                    Intrinsics.checkNotNull(printStream);
                    printStream.println("opening " + filepath);
                    SwingUtilities.invokeLater(() -> Connection.run$lambda$0(file));
                    continue;
                }
                if (StringsKt.startsWith$default(line, "identify", false, 2, null)) {
                    PrintStream printStream = this.outStream;
                    Intrinsics.checkNotNull(printStream);
                    printStream.println("Juggling Lab version 1.6.7");
                    continue;
                }
                if (StringsKt.startsWith$default(line, "done", false, 2, null)) {
                    PrintStream printStream = this.outStream;
                    Intrinsics.checkNotNull(printStream);
                    printStream.println("goodbye");
                    return;
                }
                PrintStream printStream = this.outStream;
                Intrinsics.checkNotNull(printStream);
                printStream.println(line);
                continue;
                break;
            }
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static final void run$lambda$0(File $file) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_REQUEST_FOREGROUND)) {
            Desktop.getDesktop().requestForeground(true);
        }
        try {
            ApplicationWindow.Companion.openJMLFile($file);
        }
        catch (JuggleExceptionUser jeu) {
            String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_reading_file");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String template = string;
            Object[] objectArray = new Object[]{$file.getName()};
            Object[] arguments = objectArray;
            String msg = MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)) + ":\n" + jeu.getMessage();
            ErrorDialog.INSTANCE.handleUserException(null, msg);
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.INSTANCE.handleFatalException(jei);
        }
    }
}

