/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import jugglinglab.util.JLFunc;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J\u0011\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002J\u0019\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003H\u0086\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019\u00a8\u0006$"}, d2={"Ljugglinglab/util/Coordinate;", "", "x", "", "y", "z", "<init>", "(DDD)V", "getX", "()D", "setX", "(D)V", "getY", "setY", "getZ", "setZ", "setCoordinate", "", "get", "index", "", "set", "value", "isValid", "", "()Z", "toString", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "Companion", "jugglinglab"})
public final class Coordinate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;
    private double z;

    public Coordinate(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public /* synthetic */ Coordinate(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        this(d, d2, d3);
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public final void setCoordinate(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final double get(int index) {
        return switch (index) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> throw new IndexOutOfBoundsException("Invalid Coordinate index: " + index);
        };
    }

    public final void set(int index, double value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid Coordinate index: " + index);
            }
        }
    }

    public final boolean isValid() {
        return !Double.isNaN(this.x) && !Double.isInfinite(this.x) && !Double.isNaN(this.y) && !Double.isInfinite(this.y) && !Double.isNaN(this.z) && !Double.isInfinite(this.z);
    }

    @NotNull
    public String toString() {
        return "(" + JLFunc.jlToStringRounded(this.x, 5) + ", " + JLFunc.jlToStringRounded(this.y, 5) + ", " + JLFunc.jlToStringRounded(this.z, 5) + ")";
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final Coordinate copy(double x, double y, double z) {
        return new Coordinate(x, y, z);
    }

    public static /* synthetic */ Coordinate copy$default(Coordinate coordinate, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = coordinate.x;
        }
        if ((n & 2) != 0) {
            d2 = coordinate.y;
        }
        if ((n & 4) != 0) {
            d3 = coordinate.z;
        }
        return coordinate.copy(d, d2, d3);
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Coordinate)) {
            return false;
        }
        Coordinate coordinate = (Coordinate)other;
        if (Double.compare(this.x, coordinate.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, coordinate.y) != 0) {
            return false;
        }
        return Double.compare(this.z, coordinate.z) == 0;
    }

    public Coordinate() {
        this(0.0, 0.0, 0.0, 7, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u001c\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u001c\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"Ljugglinglab/util/Coordinate$Companion;", "", "<init>", "()V", "max", "Ljugglinglab/util/Coordinate;", "coord1", "coord2", "min", "add", "sub", "truncate", "coord", "epsilon", "", "distance", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Coordinate max(@Nullable Coordinate coord1, @Nullable Coordinate coord2) {
            if (coord1 == null) {
                return coord2;
            }
            if (coord2 == null) {
                return coord1;
            }
            return new Coordinate(Math.max(coord1.getX(), coord2.getX()), Math.max(coord1.getY(), coord2.getY()), Math.max(coord1.getZ(), coord2.getZ()));
        }

        @Nullable
        public final Coordinate min(@Nullable Coordinate coord1, @Nullable Coordinate coord2) {
            if (coord1 == null) {
                return coord2;
            }
            if (coord2 == null) {
                return coord1;
            }
            return new Coordinate(Math.min(coord1.getX(), coord2.getX()), Math.min(coord1.getY(), coord2.getY()), Math.min(coord1.getZ(), coord2.getZ()));
        }

        @Nullable
        public final Coordinate add(@Nullable Coordinate coord1, @Nullable Coordinate coord2) {
            return coord1 == null ? coord2 : (coord2 == null ? coord1 : new Coordinate(coord1.getX() + coord2.getX(), coord1.getY() + coord2.getY(), coord1.getZ() + coord2.getZ()));
        }

        @Nullable
        public final Coordinate sub(@Nullable Coordinate coord1, @Nullable Coordinate coord2) {
            return coord1 == null ? coord2 : (coord2 == null ? coord1 : new Coordinate(coord1.getX() - coord2.getX(), coord1.getY() - coord2.getY(), coord1.getZ() - coord2.getZ()));
        }

        @NotNull
        public final Coordinate truncate(@NotNull Coordinate coord, double epsilon) {
            Intrinsics.checkNotNullParameter(coord, "coord");
            Coordinate result = Coordinate.copy$default(coord, 0.0, 0.0, 0.0, 7, null);
            if (Math.abs(result.getX()) < epsilon) {
                result.setX(0.0);
            }
            if (Math.abs(result.getY()) < epsilon) {
                result.setY(0.0);
            }
            if (Math.abs(result.getZ()) < epsilon) {
                result.setZ(0.0);
            }
            return result;
        }

        public final double distance(@NotNull Coordinate coord1, @NotNull Coordinate coord2) {
            Intrinsics.checkNotNullParameter(coord1, "coord1");
            Intrinsics.checkNotNullParameter(coord2, "coord2");
            Coordinate coordinate = this.sub(coord1, coord2);
            Intrinsics.checkNotNull(coordinate);
            Coordinate dc = coordinate;
            return Math.sqrt(dc.getX() * dc.getX() + dc.getY() * dc.getY() + dc.getZ() * dc.getZ());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

