/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0012\u0010\n\u001a\u00020\u00052\n\u0010\u000b\u001a\u00060\fj\u0002`\rJ\u0014\u0010\u000e\u001a\u00020\u00052\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002\u00a8\u0006\u000f"}, d2={"Ljugglinglab/util/ErrorDialog;", "", "<init>", "()V", "handleUserException", "", "parent", "Ljava/awt/Component;", "msg", "", "handleFatalException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "showInternalErrorWindow", "jugglinglab"})
public final class ErrorDialog {
    @NotNull
    public static final ErrorDialog INSTANCE = new ErrorDialog();

    private ErrorDialog() {
    }

    public final void handleUserException(@Nullable Component parent, @Nullable String msg) {
        SwingUtilities.invokeLater(() -> ErrorDialog.handleUserException$lambda$0(parent, msg));
    }

    public final void handleFatalException(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter(e, "e");
        SwingUtilities.invokeLater(() -> ErrorDialog.handleFatalException$lambda$1(e));
    }

    private final void showInternalErrorWindow(Exception e) {
        JMLPattern pat;
        String exmsg1 = JugglingLab.INSTANCE.getErrorstrings().getString("Error_internal_part1");
        String exmsg2 = JugglingLab.INSTANCE.getErrorstrings().getString("Error_internal_part2");
        String exmsg3 = JugglingLab.INSTANCE.getErrorstrings().getString("Error_internal_part3");
        String exmsg4 = JugglingLab.INSTANCE.getErrorstrings().getString("Error_internal_part4");
        String exmsg5 = JugglingLab.INSTANCE.getErrorstrings().getString("Error_internal_part5");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        sw.write(JugglingLab.INSTANCE.getErrorstrings().getString("Error_internal_msg_part1") + "\n\n");
        sw.write(JugglingLab.INSTANCE.getErrorstrings().getString("Error_internal_msg_part2") + "\n" + JugglingLab.INSTANCE.getErrorstrings().getString("Error_internal_msg_part3") + "\n\n");
        sw.write("Juggling Lab version: 1.6.7\n\n");
        e.printStackTrace(pw);
        if (e instanceof JuggleExceptionInternal && (pat = ((JuggleExceptionInternal)e).pat) != null) {
            sw.write("\nJML pattern:\n");
            sw.write(pat.toString());
        }
        sw.write("\n");
        JFrame exframe = new JFrame(JugglingLab.INSTANCE.getErrorstrings().getString("Error_internal_title"));
        exframe.setDefaultCloseOperation(0);
        JPanel exp = new JPanel();
        exp.setOpaque(true);
        GridBagLayout gb = new GridBagLayout();
        exp.setLayout(gb);
        JLabel text1 = new JLabel(exmsg1);
        text1.setFont(new Font("SansSerif", 1, 12));
        exp.add(text1);
        gb.setConstraints(text1, JLFunc.constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        JLabel text2 = new JLabel(exmsg2);
        text2.setFont(new Font("SansSerif", 0, 12));
        exp.add(text2);
        gb.setConstraints(text2, JLFunc.constraints(21, 0, 1, new Insets(10, 10, 0, 10)));
        JLabel text3 = new JLabel(exmsg3);
        text3.setFont(new Font("SansSerif", 0, 12));
        exp.add(text3);
        gb.setConstraints(text3, JLFunc.constraints(21, 0, 2, new Insets(0, 10, 0, 10)));
        JLabel text4 = new JLabel(exmsg4);
        text4.setFont(new Font("SansSerif", 0, 12));
        exp.add(text4);
        gb.setConstraints(text4, JLFunc.constraints(21, 0, 3, new Insets(0, 10, 0, 10)));
        JLabel text5 = new JLabel(exmsg5);
        text5.setFont(new Font("SansSerif", 1, 12));
        exp.add(text5);
        gb.setConstraints(text5, JLFunc.constraints(21, 0, 4, new Insets(10, 10, 10, 10)));
        JTextArea dumpta = new JTextArea();
        dumpta.setText(sw.toString());
        dumpta.setCaretPosition(0);
        JScrollPane jsp = new JScrollPane(dumpta);
        jsp.setPreferredSize(new Dimension(450, 300));
        exp.add(jsp);
        gb.setConstraints(jsp, JLFunc.constraints(10, 0, 5, new Insets(10, 10, 10, 10)));
        JPanel butp = new JPanel();
        butp.setLayout(new FlowLayout(3));
        JButton quitbutton = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("Quit"));
        quitbutton.addActionListener(ErrorDialog::showInternalErrorWindow$lambda$2);
        butp.add(quitbutton);
        JButton okbutton = new JButton(JugglingLab.INSTANCE.getGuistrings().getString("Continue"));
        okbutton.addActionListener(arg_0 -> ErrorDialog.showInternalErrorWindow$lambda$3(exframe, arg_0));
        butp.add(okbutton);
        exp.add(butp);
        gb.setConstraints(butp, JLFunc.constraints(22, 0, 6, new Insets(10, 10, 10, 10)));
        exframe.setContentPane(exp);
        Locale loc = Locale.getDefault();
        exframe.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        exframe.pack();
        exframe.setResizable(false);
        exframe.setLocationRelativeTo(null);
        exframe.setVisible(true);
    }

    private static final void handleUserException$lambda$0(Component $parent, String $msg) {
        JOptionPane.showMessageDialog($parent, $msg, "Error", 0);
    }

    private static final void handleFatalException$lambda$1(Exception $e) {
        INSTANCE.showInternalErrorWindow($e);
    }

    private static final void showInternalErrorWindow$lambda$2(ActionEvent actionEvent) {
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void showInternalErrorWindow$lambda$3(JFrame $exframe, ActionEvent actionEvent) {
        $exframe.setVisible(false);
        $exframe.dispose();
    }
}

