/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jugglinglab.JugglingLab;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005\u001a>\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0001\u001a\u0010\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0005\u001a\u0016\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0001\u001a\u001e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u0001\u001a(\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u00012\b\u00103\u001a\u0004\u0018\u000104\u001a\u000e\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u0005\u001a\u000e\u0010<\u001a\u00020\b2\u0006\u0010;\u001a\u00020\u0005\"\u001b\u0010 \u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#\"\u001b\u00105\u001a\u0002068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010%\u001a\u0004\b7\u00108\u00a8\u0006="}, d2={"jlBinomial", "", "a", "b", "jlExpandRepeats", "", "str", "addExpansionToBuffer", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "tryParseRepeat", "", "fromPos", "jlSplitOnCharOutsideParens", "", "input", "delimiter", "", "jlCompareVersions", "v1", "v2", "jlIsNearLine", "", "x", "y", "x1", "y1", "x2", "y2", "slop", "nf", "Ljava/text/NumberFormat;", "getNf", "()Ljava/text/NumberFormat;", "nf$delegate", "Lkotlin/Lazy;", "jlParseFiniteDouble", "", "s", "jlToStringRounded", "val", "digits", "constraints", "Ljava/awt/GridBagConstraints;", "location", "gridX", "gridY", "gridx", "gridy", "ins", "Ljava/awt/Insets;", "jfc", "Ljavax/swing/JFileChooser;", "getJfc", "()Ljavax/swing/JFileChooser;", "jfc$delegate", "jlSanitizeFilename", "fname", "jlErrorIfNotSanitized", "jugglinglab"})
@JvmName(name="JLFunc")
@SourceDebugExtension(value={"SMAP\nJLFunc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JLFunc.kt\njugglinglab/util/JLFunc\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,382:1\n774#2:383\n865#2,2:384\n739#2,9:386\n739#2,9:399\n37#3:395\n36#3,3:396\n37#3:408\n36#3,3:409\n*S KotlinDebug\n*F\n+ 1 JLFunc.kt\njugglinglab/util/JLFunc\n*L\n170#1:383\n170#1:384,2\n179#1:386,9\n181#1:399,9\n179#1:395\n179#1:396,3\n181#1:408\n181#1:409,3\n*E\n"})
public final class JLFunc {
    @NotNull
    private static final Lazy nf$delegate = LazyKt.lazy(JLFunc::nf_delegate$lambda$4);
    @NotNull
    private static final Lazy jfc$delegate = LazyKt.lazy(JLFunc::jfc_delegate$lambda$7);

    public static final int jlBinomial(int a, int b) {
        int result = 1;
        for (int i2 = 0; i2 < b; ++i2) {
            result *= a - i2;
            result /= i2 + 1;
        }
        return result;
    }

    @NotNull
    public static final String jlExpandRepeats(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        StringBuilder sb = new StringBuilder();
        JLFunc.addExpansionToBuffer(str, sb);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final void addExpansionToBuffer(String str, StringBuilder sb) {
        int pos = 0;
        while (pos < str.length()) {
            char ch = str.charAt(pos);
            if (ch == '(') {
                int[] result = JLFunc.tryParseRepeat(str, pos);
                if (result == null) {
                    sb.append(ch);
                    ++pos;
                    continue;
                }
                int repeatEnd = result[0];
                int repeats = result[1];
                int resumeStart = result[2];
                String string = str;
                int n = pos + 1;
                Intrinsics.checkNotNullExpressionValue(string.substring(n, repeatEnd), "substring(...)");
                int n2 = 0;
                while (n2 < repeats) {
                    String str2;
                    int it = n2++;
                    boolean bl = false;
                    JLFunc.addExpansionToBuffer(str2, sb);
                }
                pos = resumeStart;
                continue;
            }
            sb.append(ch);
            ++pos;
        }
    }

    private static final int[] tryParseRepeat(String str, int fromPos) {
        int depth = 0;
        int n = str.length();
        block4: for (int pos = fromPos; pos < n; ++pos) {
            char ch = str.charAt(pos);
            switch (ch) {
                case '(': {
                    ++depth;
                    continue block4;
                }
                case ')': {
                    if (--depth != 0) continue block4;
                    Pattern pat = Pattern.compile("^\\s*\\^\\s*(\\d+).*");
                    String string = str.substring(pos + 1);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    Matcher m = pat.matcher(string);
                    if (!m.matches()) {
                        return null;
                    }
                    int repeatEnd = pos;
                    String string2 = m.group(1);
                    Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                    int repeats = Integer.parseInt(string2);
                    int resumeStart = m.end(1) + pos + 1;
                    int[] result = new int[]{repeatEnd, repeats, resumeStart};
                    return result;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> jlSplitOnCharOutsideParens(@NotNull String input, char delimiter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(input, "input");
        if (((CharSequence)input).length() == 0) {
            return CollectionsKt.listOf("");
        }
        List result = new ArrayList();
        int parenLevel = 0;
        int lastSplit = 0;
        int n = ((CharSequence)input).length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = input.charAt(i2);
            if (c == '(') {
                ++parenLevel;
                continue;
            }
            if (c == ')') {
                --parenLevel;
                continue;
            }
            if (c != delimiter || parenLevel != 0) continue;
            String string = input.substring(lastSplit, i2);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            result.add(string);
            lastSplit = i2 + 1;
        }
        String string = input.substring(lastSplit);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        result.add(string);
        Iterable $this$filter$iv = result;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final int jlCompareVersions(@NotNull String v1, @NotNull String v2) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        List list2;
        Intrinsics.checkNotNullParameter(v1, "v1");
        Intrinsics.checkNotNullParameter(v2, "v2");
        CharSequence charSequence = v1;
        Regex regex = new Regex("\\.");
        int n = 0;
        List<String> $this$dropLastWhile$iv2 = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv2.isEmpty()) {
            ListIterator<String> iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
            while (iterator$iv.hasPrevious()) {
                String it = iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv2 = list2;
        boolean $i$f$toTypedArray22 = false;
        Object thisCollection$iv = $this$toTypedArray$iv2;
        String[] components1 = thisCollection$iv.toArray(new String[0]);
        Object $i$f$toTypedArray22 = v2;
        thisCollection$iv = new Regex("\\.");
        int it = 0;
        $i$f$toTypedArray22 = ((Regex)thisCollection$iv).split((CharSequence)$i$f$toTypedArray22, it);
        boolean $i$f$dropLastWhile2 = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it2 = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it2).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv2 = $this$toTypedArray$iv;
        String[] components2 = thisCollection$iv2.toArray(new String[0]);
        int length = Math.min(components1.length, components2.length);
        for (int i2 = 0; i2 < length; ++i2) {
            String string = components1[i2];
            Intrinsics.checkNotNull(string);
            int n2 = Integer.parseInt(string);
            String string2 = components2[i2];
            Intrinsics.checkNotNull(string2);
            int result = Intrinsics.compare(n2, Integer.parseInt(string2));
            if (result == 0) continue;
            return result;
        }
        return Intrinsics.compare(components1.length, components2.length);
    }

    public static final boolean jlIsNearLine(int x, int y, int x1, int y1, int x2, int y2, int slop) {
        if (x < Math.min(x1, x2) - slop || x > Math.max(x1, x2) + slop) {
            return false;
        }
        if (y < Math.min(y1, y2) - slop || y > Math.max(y1, y2) + slop) {
            return false;
        }
        double d = (x2 - x1) * (y - y1) - (x - x1) * (y2 - y1);
        return (int)(d = Math.abs(d) / Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1))) <= slop;
    }

    private static final NumberFormat getNf() {
        Lazy lazy = nf$delegate;
        Object t2 = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t2, "getValue(...)");
        return (NumberFormat)t2;
    }

    public static final double jlParseFiniteDouble(@Nullable String s) throws NumberFormatException {
        try {
            double x = JLFunc.getNf().parse(s).doubleValue();
            if (Math.abs(x) <= Double.MAX_VALUE) {
                return x;
            }
            throw new NumberFormatException("not a finite value");
        }
        catch (ParseException parseException) {
            throw new NumberFormatException();
        }
    }

    @NotNull
    public static final String jlToStringRounded(double val, int digits) {
        String fmt = StringsKt.take("###.##########", digits <= 0 ? 3 : 4 + Math.min(10, digits));
        DecimalFormat formatter = new DecimalFormat(fmt, new DecimalFormatSymbols(Locale.US));
        String result = formatter.format(val);
        if (Intrinsics.areEqual(result, "-0")) {
            result = "0";
        }
        String string = result;
        Intrinsics.checkNotNull(string);
        return string;
    }

    @NotNull
    public static final GridBagConstraints constraints(int location, int gridX, int gridY) {
        GridBagConstraints gridBagConstraints;
        GridBagConstraints $this$constraints_u24lambda_u245 = gridBagConstraints = new GridBagConstraints();
        boolean bl = false;
        $this$constraints_u24lambda_u245.anchor = location;
        $this$constraints_u24lambda_u245.fill = 0;
        $this$constraints_u24lambda_u245.gridwidth = 1;
        $this$constraints_u24lambda_u245.gridheight = 1;
        $this$constraints_u24lambda_u245.gridx = gridX;
        $this$constraints_u24lambda_u245.gridy = gridY;
        $this$constraints_u24lambda_u245.weighty = 0.0;
        $this$constraints_u24lambda_u245.weightx = 0.0;
        return gridBagConstraints;
    }

    @NotNull
    public static final GridBagConstraints constraints(int location, int gridx, int gridy, @Nullable Insets ins) {
        GridBagConstraints gridBagConstraints;
        GridBagConstraints $this$constraints_u24lambda_u246 = gridBagConstraints = JLFunc.constraints(location, gridx, gridy);
        boolean bl = false;
        Insets insets = ins;
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        $this$constraints_u24lambda_u246.insets = insets;
        return gridBagConstraints;
    }

    @NotNull
    public static final JFileChooser getJfc() {
        Lazy lazy = jfc$delegate;
        return (JFileChooser)lazy.getValue();
    }

    @NotNull
    public static final String jlSanitizeFilename(@NotNull String fname) {
        String extension;
        String base;
        Intrinsics.checkNotNullParameter(fname, "fname");
        int index = StringsKt.lastIndexOf$default((CharSequence)fname, ".", 0, false, 6, null);
        String string = base = index >= 0 ? StringsKt.take(fname, index) : fname;
        if (index >= 0) {
            String string2 = fname.substring(index);
            v2 = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        } else {
            v2 = extension = "";
        }
        if (JugglingLab.INSTANCE.isMacOS()) {
            CharSequence charSequence = base;
            Regex regex = new Regex("[:/]");
            String string3 = "";
            String b = regex.replace(charSequence, string3);
            while (StringsKt.startsWith$default(b, ".", false, 2, null) || StringsKt.startsWith$default(b, " ", false, 2, null)) {
                Intrinsics.checkNotNullExpressionValue(b.substring(1), "substring(...)");
            }
            if (((CharSequence)b).length() == 0) {
                b = "Pattern";
            }
            return b + extension;
        }
        if (JugglingLab.INSTANCE.isWindows()) {
            Regex regex = new Regex("[/?:*\"]");
            CharSequence charSequence = base;
            String string4 = "";
            String b = regex.replace(charSequence, string4);
            boolean forbidden = StringsKt.contains$default((CharSequence)b, ">", false, 2, null);
            forbidden = forbidden || StringsKt.contains$default((CharSequence)b, "<", false, 2, null);
            boolean bl = forbidden = forbidden || StringsKt.contains$default((CharSequence)b, "|", false, 2, null);
            if (forbidden || ((CharSequence)b).length() == 0) {
                b = "Pattern";
            }
            return b + extension;
        }
        if (JugglingLab.INSTANCE.isLinux()) {
            CharSequence charSequence = base;
            Regex regex = new Regex("/");
            String string5 = ":";
            String b = regex.replace(charSequence, string5);
            while (StringsKt.startsWith$default(b, ".", false, 2, null) || StringsKt.startsWith$default(b, " ", false, 2, null)) {
                Intrinsics.checkNotNullExpressionValue(b.substring(1), "substring(...)");
            }
            if (((CharSequence)b).length() == 0) {
                b = "Pattern";
            }
            return b + extension;
        }
        return fname;
    }

    public static final void jlErrorIfNotSanitized(@NotNull String fname) throws JuggleExceptionUser {
        Intrinsics.checkNotNullParameter(fname, "fname");
        if (Intrinsics.areEqual(fname, JLFunc.jlSanitizeFilename(fname))) {
            return;
        }
        throw new JuggleExceptionUser(JugglingLab.INSTANCE.getErrorstrings().getString("Error_saving_disallowed_character"));
    }

    private static final NumberFormat nf_delegate$lambda$4() {
        return NumberFormat.getInstance(Locale.US);
    }

    private static final jfc.2.1 jfc_delegate$lambda$7() {
        return new JFileChooser(){

            public void approveSelection() {
                File f = this.getSelectedFile();
                if (f.exists() && this.getDialogType() == 1) {
                    String template = JugglingLab.INSTANCE.getGuistrings().getString("JFC_File_exists_message");
                    Object[] objectArray = new Object[]{f.getName()};
                    Object[] arguments = objectArray;
                    String msg = MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length));
                    String title = JugglingLab.INSTANCE.getGuistrings().getString("JFC_File_exists_title");
                    int result = JOptionPane.showConfirmDialog(this, msg, title, 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case -1: 
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                try {
                    Preferences.userRoot().node("Juggling Lab").put("base_dir", f.getParent());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.approveSelection();
            }
        };
    }
}

