/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.core.ApplicationWindow;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Ljugglinglab/util/OpenFilesServerMMF;", "Ljava/lang/Thread;", "<init>", "()V", "run", "", "Companion", "jugglinglab"})
public final class OpenFilesServerMMF
extends Thread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static Thread serverThread;
    @NotNull
    private static String ipcFilename;
    public static final int BUFFER_LENGTH = 1024;

    public OpenFilesServerMMF() {
        serverThread = this;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File fipc = new File(ipcFilename);
        AbstractInterruptibleChannel chan = null;
        try {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
            chan = FileChannel.open(fipc.toPath(), openOptionArray);
            MappedByteBuffer bToserver = ((FileChannel)chan).map(FileChannel.MapMode.READ_WRITE, 0L, 1024L);
            CharBuffer bufToserver = bToserver.asCharBuffer();
            MappedByteBuffer bFromserver = ((FileChannel)chan).map(FileChannel.MapMode.READ_WRITE, 1024L, 1024L);
            CharBuffer bufFromserver = bFromserver.asCharBuffer();
            String line = null;
            while (!Thread.interrupted()) {
                Intrinsics.checkNotNull(bufToserver);
                OpenFilesServerMMF.Companion.clearBuffer(bufToserver);
                while (!OpenFilesServerMMF.Companion.waitUntilMessage(bufToserver, 1000)) {
                }
                line = OpenFilesServerMMF.Companion.readMessage(bufToserver);
                if (StringsKt.startsWith$default(line, "open ", false, 2, null)) {
                    String filepath;
                    Intrinsics.checkNotNullExpressionValue(line.substring(5), "substring(...)");
                    File file = new File(filepath);
                    Intrinsics.checkNotNull(bufFromserver);
                    OpenFilesServerMMF.Companion.writeMessage(bufFromserver, "opening " + filepath + "\u0000");
                    SwingUtilities.invokeLater(() -> OpenFilesServerMMF.run$lambda$0(file));
                    continue;
                }
                if (StringsKt.startsWith$default(line, "identify", false, 2, null)) {
                    Intrinsics.checkNotNull(bufFromserver);
                    OpenFilesServerMMF.Companion.writeMessage(bufFromserver, "Juggling Lab version 1.6.7\u0000");
                    continue;
                }
                if (StringsKt.startsWith$default(line, "done", false, 2, null)) {
                    Intrinsics.checkNotNull(bufFromserver);
                    OpenFilesServerMMF.Companion.writeMessage(bufFromserver, "goodbye\u0000");
                    continue;
                }
                Intrinsics.checkNotNull(bufFromserver);
                OpenFilesServerMMF.Companion.writeMessage(bufFromserver, line + "\u0000");
            }
        }
        catch (IOException ioe) {
            ErrorDialog.INSTANCE.handleFatalException(ioe);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            try {
                AbstractInterruptibleChannel abstractInterruptibleChannel = chan;
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                Files.delete(fipc.toPath());
            }
            catch (Exception e) {
            }
        }
    }

    private static final void run$lambda$0(File $file) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_REQUEST_FOREGROUND)) {
            Desktop.getDesktop().requestForeground(true);
        }
        try {
            ApplicationWindow.Companion.openJMLFile($file);
        }
        catch (JuggleExceptionUser jeu) {
            String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_reading_file");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            String template = string;
            Object[] objectArray = new Object[]{$file.getName()};
            Object[] arguments = objectArray;
            String msg = MessageFormat.format(template, Arrays.copyOf(arguments, arguments.length)) + ":\n" + jeu.getMessage();
            ErrorDialog.INSTANCE.handleUserException(null, msg);
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.INSTANCE.handleFatalException(jei);
        }
    }

    static {
        ipcFilename = System.getProperty("java.io.tmpdir") + File.separator + "JugglingLabTemp";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ljugglinglab/util/OpenFilesServerMMF$Companion;", "", "<init>", "()V", "serverThread", "Ljava/lang/Thread;", "getServerThread", "()Ljava/lang/Thread;", "setServerThread", "(Ljava/lang/Thread;)V", "ipcFilename", "", "getIpcFilename", "()Ljava/lang/String;", "setIpcFilename", "(Ljava/lang/String;)V", "BUFFER_LENGTH", "", "tryOpenFile", "", "f", "Ljava/io/File;", "cleanup", "", "clearBuffer", "cb", "Ljava/nio/CharBuffer;", "readMessage", "writeMessage", "str", "waitUntilMessage", "timeout", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Thread getServerThread() {
            return serverThread;
        }

        public final void setServerThread(@Nullable Thread thread2) {
            serverThread = thread2;
        }

        @NotNull
        public final String getIpcFilename() {
            return ipcFilename;
        }

        public final void setIpcFilename(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            ipcFilename = string;
        }

        public final boolean tryOpenFile(@Nullable File f) {
            File fipc = new File(this.getIpcFilename());
            if (!fipc.exists()) {
                return false;
            }
            try {
                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
                FileChannel chan = FileChannel.open(fipc.toPath(), openOptionArray);
                MappedByteBuffer bToserver = chan.map(FileChannel.MapMode.READ_WRITE, 0L, 1024L);
                CharBuffer bufToserver = bToserver.asCharBuffer();
                MappedByteBuffer bFromserver = chan.map(FileChannel.MapMode.READ_WRITE, 1024L, 1024L);
                CharBuffer bufFromserver = bFromserver.asCharBuffer();
                Intrinsics.checkNotNull(bufFromserver);
                this.clearBuffer(bufFromserver);
                Intrinsics.checkNotNull(bufToserver);
                this.writeMessage(bufToserver, "identify\u0000");
                if (!this.waitUntilMessage(bufFromserver, 200)) {
                    return false;
                }
                String line = this.readMessage(bufFromserver);
                if (!Intrinsics.areEqual(line, "Juggling Lab version 1.6.7")) {
                    return false;
                }
                this.clearBuffer(bufFromserver);
                this.writeMessage(bufToserver, "open " + f + "\u0000");
                if (!this.waitUntilMessage(bufFromserver, 500)) {
                    return false;
                }
                line = this.readMessage(bufFromserver);
                if (!StringsKt.startsWith$default(line, "opening ", false, 2, null)) {
                    return false;
                }
                this.writeMessage(bufToserver, "done\u0000");
                return true;
            }
            catch (IOException ioe) {
                ErrorDialog.INSTANCE.handleFatalException(ioe);
            }
            catch (InterruptedException ioe) {
                ErrorDialog.INSTANCE.handleFatalException(ioe);
            }
            return false;
        }

        public final void cleanup() {
            if (this.getServerThread() != null) {
                try {
                    Thread thread2 = this.getServerThread();
                    Intrinsics.checkNotNull(thread2);
                    thread2.interrupt();
                    Thread thread3 = this.getServerThread();
                    Intrinsics.checkNotNull(thread3);
                    thread3.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.setServerThread(null);
            }
        }

        private final void clearBuffer(CharBuffer cb) {
            cb.put(0, '\u0000');
        }

        private final String readMessage(CharBuffer cb) {
            char c;
            StringBuilder msgSb = new StringBuilder(1024);
            for (int i2 = 0; i2 < 1024 && (c = cb.get(i2)) != '\u0000'; ++i2) {
                msgSb.append(c);
            }
            String string = msgSb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        private final void writeMessage(CharBuffer cb, String str) {
            int n = str.length();
            for (int i2 = 1; i2 < n; ++i2) {
                cb.put(i2, str.charAt(i2));
            }
            cb.put(0, str.charAt(0));
        }

        private final boolean waitUntilMessage(CharBuffer cb, int timeout) throws InterruptedException {
            int tries = timeout / 20;
            int n = 0;
            while (n < tries) {
                int it = n++;
                boolean bl = false;
                if (cb.get(0) != '\u0000') {
                    return true;
                }
                Thread.sleep(20L);
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

